/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.tcrcore.events;

import com.github.L_Ender.cataclysm.init.ModBlocks;
import com.github.L_Ender.cataclysm.init.ModItems;
import com.hm.efn.gameasset.EFNSkills;
import com.obscuria.aquamirae.registry.AquamiraeItems;
import com.p1nero.cataclysm_dimension.worldgen.CataclysmDimensions;
import com.p1nero.dpr.gameassets.DPRSkills;
import com.p1nero.fast_tpa.network.PacketRelay;
import com.p1nero.tcrcore.TCRCoreMod;
import com.p1nero.tcrcore.capability.PlayerDataManager;
import com.p1nero.tcrcore.capability.TCRCapabilityProvider;
import com.p1nero.tcrcore.capability.TCRPlayer;
import com.p1nero.tcrcore.capability.TCRTaskManager;
import com.p1nero.tcrcore.datagen.TCRAdvancementData;
import com.p1nero.tcrcore.effect.TCREffects;
import com.p1nero.tcrcore.events.ItemEvents;
import com.p1nero.tcrcore.events.OverworldVillageTeleporter;
import com.p1nero.tcrcore.item.TCRItems;
import com.p1nero.tcrcore.network.TCRPacketHandler;
import com.p1nero.tcrcore.network.packet.clientbound.CSTipPacket;
import com.p1nero.tcrcore.network.packet.clientbound.PlayItemPickupParticlePacket;
import com.p1nero.tcrcore.network.packet.clientbound.PlayTitlePacket;
import com.p1nero.tcrcore.save_data.TCRDimSaveData;
import com.p1nero.tcrcore.utils.ItemUtil;
import com.p1nero.tcrcore.utils.WorldUtil;
import com.p1nero.tcrcore.worldgen.TCRDimensions;
import com.p1nero.tudigong.entity.XianQiEntity;
import com.p1nero.tudigong.item.TDGItems;
import com.yesman.epicskills.registry.entry.EpicSkillsItems;
import com.yesman.epicskills.registry.entry.EpicSkillsSkillTrees;
import com.yesman.epicskills.skilltree.SkillTree;
import com.yesman.epicskills.world.capability.SkillTreeProgression;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.genzyuro.uniqueaccessories.registry.UAItems;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.simple.SimpleChannel;
import net.p1nero.ss.gameassets.skills.SwordControllerSkills;
import org.merlin204.wraithon.util.PositionTeleporter;
import org.merlin204.wraithon.worldgen.WraithonDimensions;
import top.theillusivec4.curios.api.event.CurioEquipEvent;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

@Mod.EventBusSubscriber(modid="tcrcore")
public class PlayerEventListeners {
    public static final Set<Item> illegalItems = new HashSet<Item>();

    @SubscribeEvent
    public static void onPlayerAdvancementEarn(AdvancementEvent.AdvancementEarnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            String path = event.getAdvancement().m_138327_().m_135815_();
            String namespace = event.getAdvancement().m_138327_().m_135827_();
            if (namespace.equals("tcrcore")) {
                if (path.equals("vatansever")) {
                    player2.getCapability(SkillTreeProgression.SKILL_TREE_PROGRESSION).ifPresent(skillTreeProgression -> {
                        ResourceKey resourceKey = ResourceKey.m_135785_((ResourceKey)SkillTree.SKILL_TREE_REGISTRY_KEY, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"sword_soaring", (String)"sword_soaring_skills"));
                        skillTreeProgression.unlockTree(resourceKey, player2);
                        skillTreeProgression.unlockNode(resourceKey, SwordControllerSkills.RAIN_SWORD, player2);
                        skillTreeProgression.unlockNode(resourceKey, SwordControllerSkills.SCREEN_SWORD, player2);
                        skillTreeProgression.unlockNode(resourceKey, SwordControllerSkills.KILL_AURA_1, player2);
                        skillTreeProgression.unlockNode(resourceKey, SwordControllerSkills.KILL_AURA_2, player2);
                    });
                    player2.m_5661_((Component)TCRCoreMod.getInfo("unlock_new_skill", SwordControllerSkills.RAIN_SWORD.getDisplayName()), false);
                    player2.m_5661_((Component)TCRCoreMod.getInfo("unlock_new_skill", SwordControllerSkills.SCREEN_SWORD.getDisplayName()), false);
                    player2.m_5661_((Component)TCRCoreMod.getInfo("unlock_new_skill", SwordControllerSkills.KILL_AURA_1.getDisplayName()), false);
                    player2.m_5661_((Component)TCRCoreMod.getInfo("unlock_new_skill", SwordControllerSkills.KILL_AURA_2.getDisplayName()), false);
                }
                if (path.equals("kill_pillager") && !PlayerDataManager.pillagerKilled.get((Player)player2).booleanValue()) {
                    TCRTaskManager.KILL_PILLAGER.finish(player2);
                    TCRTaskManager.BACK_TO_KEEPER.start(player2);
                    PlayerDataManager.pillagerKilled.put((Player)player2, true);
                }
            }
            if (namespace.equals("minecraft") && path.equals("recipes/transportation/oak_boat")) {
                PacketRelay.sendToPlayer((SimpleChannel)TCRPacketHandler.INSTANCE, (Object)new PlayTitlePacket(4), (ServerPlayer)player2);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            TCRCapabilityProvider.syncPlayerDataToClient(serverPlayer);
            if (!PlayerDataManager.firstJoint.get((Player)serverPlayer).booleanValue()) {
                serverPlayer.m_9158_(TCRDimensions.SANCTUM_LEVEL_KEY, new BlockPos(WorldUtil.START_POS), 90.0f, true, false);
                ServerLevel targetLevel = serverPlayer.f_8924_.m_129880_(TCRDimensions.SANCTUM_LEVEL_KEY);
                serverPlayer = (ServerPlayer)serverPlayer.changeDimension(targetLevel, (ITeleporter)new PositionTeleporter(new BlockPos(WorldUtil.START_POS)));
                TCRAdvancementData.finishAdvancement("tcrcore", serverPlayer);
                ((GameRules.BooleanValue)serverPlayer.f_8924_.m_129900_().m_46170_(GameRules.f_46133_)).m_46246_(true, serverPlayer.f_8924_);
                ((GameRules.BooleanValue)serverPlayer.f_8924_.m_129900_().m_46170_(GameRules.f_46132_)).m_46246_(true, serverPlayer.f_8924_);
                ServerPlayer finalServerPlayer = serverPlayer;
                ResourceKey dpr = ResourceKey.m_135785_((ResourceKey)SkillTree.SKILL_TREE_REGISTRY_KEY, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"dodge_parry_reward", (String)"passive"));
                serverPlayer.getCapability(SkillTreeProgression.SKILL_TREE_PROGRESSION).ifPresent(skillTreeProgression -> {
                    skillTreeProgression.unlockNode(EpicSkillsSkillTrees.BATTLEBORN, EFNSkills.EFN_DODGE_ROLL, finalServerPlayer);
                    skillTreeProgression.unlockNode(EpicSkillsSkillTrees.BATTLEBORN, EFNSkills.EFN_DODGE_STEP, finalServerPlayer);
                    skillTreeProgression.unlockNode(dpr, DPRSkills.STAMINA1, finalServerPlayer);
                });
                PlayerEventListeners.addSkill(serverPlayer, EFNSkills.EFN_DODGE_ROLL, (SkillSlot)SkillSlots.DODGE);
                PlayerEventListeners.addSkill(serverPlayer, EFNSkills.EFN_PARRY, (SkillSlot)SkillSlots.GUARD);
                PlayerEventListeners.addSkill(serverPlayer, DPRSkills.STAMINA1, (SkillSlot)SkillSlots.PASSIVE1);
                ItemUtil.addItem((Player)serverPlayer, Items.f_42383_, 1);
                ItemUtil.addItem((Player)serverPlayer, (Item)net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems.BACKPACK.get(), 1);
                ItemUtil.addItem((Player)serverPlayer, Items.f_42778_, 1);
                ItemUtil.addItem((Player)serverPlayer, Items.f_42406_, 32);
                ItemUtil.addItem((Player)serverPlayer, (Item)TDGItems.TUDI_COMMAND_SPELL.get(), 1);
                ItemUtil.addItem((Player)serverPlayer, (Item)EpicSkillsItems.ABILIITY_STONE.get(), 1);
                XianQiEntity xianQiEntity = new XianQiEntity((Level)serverPlayer.m_284548_(), WorldUtil.GUIDER_POS, (LivingEntity)serverPlayer, null);
                serverPlayer.m_5661_((Component)TCRCoreMod.getInfo("cloud_follow_me"), false);
                serverPlayer.m_284548_().m_7967_((Entity)xianQiEntity);
                PlayerDataManager.firstJoint.put((Player)serverPlayer, true);
            }
            if (TCRCoreMod.hasCheatMod()) {
                serverPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 9999, 9999));
                serverPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 9999, 9999));
                serverPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19621_, 9999, 9999));
            }
            PacketRelay.sendToPlayer((SimpleChannel)TCRPacketHandler.INSTANCE, (Object)new CSTipPacket(), (ServerPlayer)serverPlayer);
        }
    }

    public static void addSkill(ServerPlayer player, Skill skill, SkillSlot slot) {
        ServerPlayerPatch playerpatch = (ServerPlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, ServerPlayerPatch.class);
        SkillContainer skillContainer = playerpatch.getSkillCapability().getSkillContainerFor(slot);
        if (skillContainer.setSkill(skill)) {
            if (skill.getCategory().learnable()) {
                playerpatch.getSkillCapability().addLearnedSkill(skill);
            }
            EpicFightNetworkManager.sendToPlayer((Object)skillContainer.createSyncPacketToLocalPlayer(), (ServerPlayer)player, (Object[])new Object[0]);
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity((Object)skillContainer.createSyncPacketToRemotePlayer(), (Entity)player, (Object[])new Object[0]);
        }
    }

    @SubscribeEvent
    public static void onPlayerInteractBlock(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BlockState blockState = event.getLevel().m_8055_(event.getPos());
            if (blockState.m_60713_(net.blay09.mods.waystones.block.ModBlocks.waystone) && !PlayerDataManager.wayStoneInteracted.get((Player)serverPlayer).booleanValue()) {
                ItemUtil.addItemEntity((Entity)serverPlayer, net.blay09.mods.waystones.item.ModItems.warpStone.m_7968_());
                serverPlayer.m_5661_((Component)TCRCoreMod.getInfo("press_to_open_portal_screen2"), false);
                PlayerDataManager.wayStoneInteracted.put((Player)serverPlayer, true);
            }
            if (blockState.m_60713_((Block)ModBlocks.GODDESS_STATUE.get()) && ItemEvents.eyes.contains(serverPlayer.m_21205_().m_41720_())) {
                TCRPlayer tcrPlayer = TCRCapabilityProvider.getTCRPlayer((Player)serverPlayer);
                ServerLevel serverLevel = serverPlayer.m_284548_();
                BlockPos blessPos = event.getPos();
                serverLevel.m_5594_(null, blessPos, SoundEvents.f_11737_, SoundSource.AMBIENT, 0.7f, 0.5f + serverLevel.f_46441_.m_188501_() * 0.3f);
                TCRTaskManager.FIND_GODNESS_STATUE.finish(serverPlayer);
                if (!tcrPlayer.inBlessing()) {
                    tcrPlayer.setTickAfterBless(100);
                    tcrPlayer.setBlessPos(event.getPos());
                    tcrPlayer.setBlessItem(serverPlayer.m_21205_().m_41720_());
                }
            }
            if (CataclysmDimensions.LEVELS.contains(serverPlayer.m_284548_().m_46472_())) {
                boolean isChest;
                boolean bl = isChest = event.getLevel().m_8055_(event.getPos()).m_60713_(Blocks.f_50087_) || event.getLevel().m_8055_(event.getPos()).m_60713_((Block)noobanidus.mods.lootr.init.ModBlocks.CHEST.get());
                if (isChest && !TCRDimSaveData.get(serverPlayer.m_284548_()).isBossKilled()) {
                    serverPlayer.m_5661_((Component)TCRCoreMod.getInfo("dim_block_no_interact"), true);
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onCurioEquip(CurioEquipEvent event) {
        Player player;
        LivingEntity livingEntity;
        if (illegalItems.contains(event.getStack().m_41720_()) && (livingEntity = event.getEntity()) instanceof Player && (!PlayerDataManager.wraithonKilled.get(player = (Player)livingEntity).booleanValue() || event.getStack().m_150930_((Item)UAItems.STARVED_WOLF_SKULL.get()))) {
            player.m_5661_((Component)TCRCoreMod.getInfo("illegal_item_tip"), true);
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Player player;
            if (event.player.m_7578_() && WorldUtil.inMainLand((Entity)event.player) && PlayerEventListeners.isNearBarrier(event.player)) {
                event.player.m_5661_((Component)TCRCoreMod.getInfo("hit_barrier"), true);
            }
            if ((player = event.player) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ItemStack mainHandItem = serverPlayer.m_21205_();
                if (illegalItems.contains(mainHandItem.m_41720_()) && !PlayerDataManager.wraithonKilled.get((Player)serverPlayer).booleanValue()) {
                    serverPlayer.m_36176_(mainHandItem.m_41777_(), true);
                    mainHandItem.m_41774_(1);
                    serverPlayer.m_5661_((Component)TCRCoreMod.getInfo("illegal_item_tip"), true);
                }
                if (!serverPlayer.m_20147_()) {
                    if (serverPlayer.m_21023_((MobEffect)TCREffects.INVULNERABLE.get())) {
                        serverPlayer.m_20331_(true);
                    }
                } else if (!(serverPlayer.m_21023_((MobEffect)TCREffects.INVULNERABLE.get()) || serverPlayer.m_7500_() || serverPlayer.m_5833_())) {
                    serverPlayer.m_20331_(false);
                }
                if (!serverPlayer.m_284548_().m_46749_(serverPlayer.m_20097_())) {
                    return;
                }
                if (WorldUtil.inMainLand((Entity)serverPlayer)) {
                    if (serverPlayer.m_20142_()) {
                        serverPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 10, 2, false, false, true));
                    }
                    if (serverPlayer.m_20186_() < 63.0 && !serverPlayer.m_20159_()) {
                        if (PlayerDataManager.wayStoneInteracted.get((Player)serverPlayer).booleanValue()) {
                            serverPlayer.changeDimension(serverPlayer.f_8924_.m_129880_(Level.f_46428_), (ITeleporter)new OverworldVillageTeleporter());
                        } else {
                            serverPlayer.m_5661_((Component)TCRCoreMod.getInfo("need_to_unlock_waystone").m_130940_(ChatFormatting.RED), true);
                        }
                    }
                }
            }
        }
    }

    public static boolean isNearBarrier(Player player) {
        if (player.f_19794_) {
            return false;
        }
        float f = player.m_6972_((Pose)player.m_20089_()).f_20377_ * 1.5f;
        AABB aabb = AABB.m_165882_((Vec3)player.m_146892_(), (double)f, (double)1.0E-6, (double)f);
        return BlockPos.m_121921_((AABB)aabb).anyMatch(p_201942_ -> {
            BlockState blockstate = player.m_9236_().m_8055_(p_201942_);
            return blockstate.m_60713_(Blocks.f_50375_);
        });
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            TCRCapabilityProvider.syncPlayerDataToClient(serverPlayer);
            player.m_21153_(player.m_21233_());
            EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)player, ServerPlayerPatch.class).ifPresent(serverPlayerPatch -> serverPlayerPatch.setStamina(serverPlayerPatch.getMaxStamina()));
        }
    }

    @SubscribeEvent
    public static void onPlayerTryToEnterDim(EntityTravelToDimensionEvent event) {
        ServerPlayer serverPlayer;
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer && !(serverPlayer = (ServerPlayer)entity).m_7500_()) {
            ServerLevel targetLevel;
            if (event.getDimension() == Level.f_46429_ && !PlayerDataManager.canEnterNether.get((Player)serverPlayer).booleanValue()) {
                event.setCanceled(true);
                serverPlayer.m_5661_((Component)TCRCoreMod.getInfo("can_not_enter_dim"), true);
            }
            if (event.getDimension() == Level.f_46430_ && !PlayerDataManager.canEnterEnd.get((Player)serverPlayer).booleanValue()) {
                event.setCanceled(true);
                serverPlayer.m_5661_((Component)TCRCoreMod.getInfo("can_not_enter_dim"), true);
            }
            if (CataclysmDimensions.LEVELS.contains(event.getDimension()) && (targetLevel = serverPlayer.f_8924_.m_129880_(event.getDimension())) != null && targetLevel.m_6907_().size() >= 4) {
                event.setCanceled(true);
                serverPlayer.m_5661_((Component)TCRCoreMod.getInfo("dim_max_4_players"), false);
            }
            if (event.getDimension() == CataclysmDimensions.CATACLYSM_SANCTUM_FALLEN_LEVEL_KEY && PlayerDataManager.stormEyeTraded.get((Player)serverPlayer) == false || event.getDimension() == CataclysmDimensions.CATACLYSM_INFERNOS_MAW_LEVEL_KEY && PlayerDataManager.flameEyeTraded.get((Player)serverPlayer) == false || event.getDimension() == CataclysmDimensions.CATACLYSM_ETERNAL_FROSTHOLD_LEVEL_KEY && PlayerDataManager.cursedEyeTraded.get((Player)serverPlayer) == false || event.getDimension() == CataclysmDimensions.CATACLYSM_PHARAOHS_BANE_LEVEL_KEY && PlayerDataManager.desertEyeTraded.get((Player)serverPlayer) == false || event.getDimension() == CataclysmDimensions.CATACLYSM_ABYSSAL_DEPTHS_LEVEL_KEY && !PlayerDataManager.abyssEyeTraded.get((Player)serverPlayer).booleanValue()) {
                serverPlayer.m_5661_((Component)TCRCoreMod.getInfo("can_not_enter_before_finish"), false);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerEnterDim(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerLevel wraithonLevel;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            TCRCapabilityProvider.syncPlayerDataToClient(serverPlayer);
            if (event.getFrom() == WraithonDimensions.SANCTUM_OF_THE_WRAITHON_LEVEL_KEY && (wraithonLevel = serverPlayer.f_8924_.m_129880_(WraithonDimensions.SANCTUM_OF_THE_WRAITHON_LEVEL_KEY)).m_6907_().isEmpty()) {
                wraithonLevel.m_8583_().forEach(Entity::m_146870_);
                TCRDimSaveData.get(wraithonLevel).setBossSummoned(false);
            }
            if (CataclysmDimensions.LEVELS.contains(event.getTo())) {
                serverPlayer.m_5661_((Component)TCRCoreMod.getInfo("reset_when_no_player").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), false);
                if (serverPlayer.m_284548_().m_6907_().size() <= 1) {
                    TCRDimSaveData.get(serverPlayer.m_20194_().m_129880_(event.getTo())).setBossKilled(false);
                }
            }
            if (event.getTo() == Level.f_46429_ && !PlayerDataManager.netherEntered.get((Player)serverPlayer).booleanValue()) {
                serverPlayer.m_5661_((Component)TCRCoreMod.getInfo("unlock_new_dim_girl"), false);
                PlayerDataManager.netherEntered.put((Player)serverPlayer, true);
            }
            if (event.getTo() == Level.f_46430_ && !PlayerDataManager.endEntered.get((Player)serverPlayer).booleanValue()) {
                serverPlayer.m_5661_((Component)TCRCoreMod.getInfo("unlock_new_dim_girl"), false);
                PlayerDataManager.endEntered.put((Player)serverPlayer, true);
            }
            if (event.getTo() == Level.f_46428_) {
                TCRCapabilityProvider.getTCRPlayer((Player)serverPlayer).setTickAfterTpToOverworld(60);
            }
            PlayerEventListeners.updateHealth(serverPlayer, (ResourceKey<Level>)event.getFrom());
            PlayerEventListeners.updateHealth(serverPlayer, (ResourceKey<Level>)event.getTo());
        }
    }

    public static void updateHealth(ServerPlayer serverPlayer, ResourceKey<Level> levelResourceKey) {
        ServerLevel targetLevel;
        if (CataclysmDimensions.LEVELS.contains(levelResourceKey) && (targetLevel = serverPlayer.f_8924_.m_129880_(levelResourceKey)) != null) {
            int playerCnt = targetLevel.m_6907_().size();
            double healthMultiplier = 1.0;
            if (playerCnt == 2) {
                healthMultiplier = 1.6;
            } else if (playerCnt == 3) {
                healthMultiplier = 2.0;
            } else if (playerCnt >= 4) {
                healthMultiplier = 2.4;
            }
            double finalMultiplier = healthMultiplier;
            UUID HEALTH_MODIFIER_UUID = UUID.fromString("11451419-1981-0234-1234-123456789abc");
            targetLevel.m_8583_().forEach(entity -> {
                LivingEntity living;
                if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_6084_() && !(living instanceof Player)) {
                    float preHealth = living.m_21223_();
                    float preMaxHealth = living.m_21233_();
                    AttributeInstance maxHealthAttr = living.m_21051_(Attributes.f_22276_);
                    if (maxHealthAttr != null) {
                        maxHealthAttr.m_22120_(HEALTH_MODIFIER_UUID);
                        if (playerCnt > 1) {
                            AttributeModifier healthModifier = new AttributeModifier(HEALTH_MODIFIER_UUID, "team_health_boost", finalMultiplier - 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
                            maxHealthAttr.m_22125_(healthModifier);
                            living.m_21153_(preHealth * living.m_21233_() / preMaxHealth);
                        }
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerPickupItem(EntityItemPickupEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (!PlayerDataManager.stormEyeBlessed.get((Player)player2).booleanValue() && event.getItem().m_32055_().m_150930_((Item)ModItems.ABYSS_EYE.get())) {
                player2.m_5661_((Component)TCRCoreMod.getInfo("can_not_do_this_too_early"), true);
                event.setCanceled(true);
            }
            if (!PlayerDataManager.abyssEyeBlessed.get((Player)player2).booleanValue() && event.getItem().m_32055_().m_150930_((Item)ModItems.DESERT_EYE.get())) {
                player2.m_5661_((Component)TCRCoreMod.getInfo("can_not_do_this_too_early"), true);
                event.setCanceled(true);
            }
            if (!PlayerDataManager.desertEyeBlessed.get((Player)player2).booleanValue() && event.getItem().m_32055_().m_150930_((Item)ModItems.CURSED_EYE.get())) {
                player2.m_5661_((Component)TCRCoreMod.getInfo("can_not_do_this_too_early"), true);
                event.setCanceled(true);
            }
            if (!PlayerDataManager.cursedEyeBlessed.get((Player)player2).booleanValue() && event.getItem().m_32055_().m_150930_((Item)ModItems.FLAME_EYE.get())) {
                player2.m_5661_((Component)TCRCoreMod.getInfo("can_not_do_this_too_early"), true);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onItemPickup(PlayerEvent.ItemPickupEvent event) {
        ItemStack itemStack = event.getStack();
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (itemStack.m_150930_((Item)TCRItems.ANCIENT_ORACLE_FRAGMENT.get()) && itemStack.m_41784_().m_128461_("player_name").equals(player2.m_36316_().getName())) {
                TCRTaskManager.GIVE_ORACLE_TO_KEEPER.start(player2);
                if (!PlayerDataManager.mapMarked.get((Player)player2).booleanValue()) {
                    PlayerEventListeners.giveOracleEffect(player2, (Item)TCRItems.ANCIENT_ORACLE_FRAGMENT.get());
                }
                player2.m_5661_((Component)TCRCoreMod.getInfo("add_item_tip", itemStack.m_41611_(), 1), false);
            }
            if (!PlayerDataManager.stormEyeTraded.get((Player)player2).booleanValue() && itemStack.m_150930_((Item)ModItems.STORM_EYE.get())) {
                player2.m_5661_((Component)TCRCoreMod.getInfo("time_to_altar"), true);
                PlayerEventListeners.giveOracleEffect(player2, (Item)ModItems.STORM_EYE.get());
                PlayerDataManager.stormEyeTraded.put((Player)player2, true);
            }
            if (!PlayerDataManager.abyssEyeTraded.get((Player)player2).booleanValue() && itemStack.m_150930_((Item)ModItems.ABYSS_EYE.get())) {
                player2.m_5661_((Component)TCRCoreMod.getInfo("time_to_altar"), true);
                PlayerEventListeners.giveOracleEffect(player2, (Item)ModItems.ABYSS_EYE.get());
                PlayerDataManager.abyssEyeTraded.put((Player)player2, true);
            }
            if (itemStack.m_150930_((Item)ModItems.FLAME_EYE.get()) && !PlayerDataManager.flameEyeTraded.get((Player)player2).booleanValue()) {
                player2.m_5661_((Component)TCRCoreMod.getInfo("time_to_altar"), true);
                PlayerEventListeners.giveOracleEffect(player2, (Item)ModItems.FLAME_EYE.get());
                PlayerDataManager.flameEyeTraded.put((Player)player2, true);
            }
            if (itemStack.m_150930_((Item)ModItems.CURSED_EYE.get()) && !PlayerDataManager.cursedEyeTraded.get((Player)player2).booleanValue()) {
                player2.m_5661_((Component)TCRCoreMod.getInfo("time_to_altar"), true);
                PlayerEventListeners.giveOracleEffect(player2, (Item)ModItems.CURSED_EYE.get());
                PlayerDataManager.cursedEyeTraded.put((Player)player2, true);
            }
            if (itemStack.m_150930_((Item)ModItems.DESERT_EYE.get()) && !PlayerDataManager.desertEyeTraded.get((Player)player2).booleanValue()) {
                player2.m_5661_((Component)TCRCoreMod.getInfo("time_to_altar"), true);
                PlayerEventListeners.giveOracleEffect(player2, (Item)ModItems.DESERT_EYE.get());
                PlayerDataManager.desertEyeTraded.put((Player)player2, true);
            }
            if (itemStack.m_150930_((Item)ModItems.VOID_EYE.get()) && !PlayerDataManager.voidEyeTraded.get((Player)player2).booleanValue()) {
                player2.m_5661_((Component)TCRCoreMod.getInfo("time_to_altar"), true);
                PlayerEventListeners.giveOracleEffect(player2, (Item)ModItems.VOID_EYE.get());
                PlayerDataManager.voidEyeTraded.put((Player)player2, true);
            }
            if (itemStack.m_150930_((Item)ModItems.MECH_EYE.get()) && !PlayerDataManager.mechEyeTraded.get((Player)player2).booleanValue()) {
                player2.m_5661_((Component)TCRCoreMod.getInfo("time_to_altar"), true);
                PlayerEventListeners.giveOracleEffect(player2, (Item)ModItems.MECH_EYE.get());
                PlayerDataManager.mechEyeTraded.put((Player)player2, true);
            }
            if (itemStack.m_150930_((Item)ModItems.MONSTROUS_EYE.get()) && !PlayerDataManager.monstEyeTraded.get((Player)player2).booleanValue()) {
                player2.m_5661_((Component)TCRCoreMod.getInfo("time_to_altar"), true);
                PlayerEventListeners.giveOracleEffect(player2, (Item)ModItems.MONSTROUS_EYE.get());
                PlayerDataManager.monstEyeTraded.put((Player)player2, true);
            }
            if (itemStack.m_150930_((Item)AquamiraeItems.SHELL_HORN.get()) && !PlayerDataManager.abyssEyeTraded.get((Player)player2).booleanValue()) {
                PlayerEventListeners.giveOracleEffect(player2, (Item)AquamiraeItems.SHELL_HORN.get());
            }
        }
    }

    public static void giveOracleEffect(ServerPlayer player, Item toDisplay) {
        if (ItemEvents.eyes.contains(toDisplay)) {
            TCRTaskManager.FIND_GODNESS_STATUE.start(player);
        }
        PacketRelay.sendToPlayer((SimpleChannel)TCRPacketHandler.INSTANCE, (Object)new PlayItemPickupParticlePacket(toDisplay.m_7968_()), (ServerPlayer)player);
        player.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(BuiltInRegistries.f_256894_.m_263177_((Object)SoundEvents.f_12513_), SoundSource.PLAYERS, player.m_20185_(), player.m_20186_(), player.m_20189_(), 1.0f, 1.0f, (long)player.m_217043_().m_188502_()));
        player.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(BuiltInRegistries.f_256894_.m_263177_((Object)SoundEvents.f_12496_), SoundSource.PLAYERS, player.m_20185_(), player.m_20186_(), player.m_20189_(), 1.0f, 1.0f, (long)player.m_217043_().m_188502_()));
    }
}

