/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.tcrcore.events;

import com.mojang.blaze3d.systems.RenderSystem;
import com.obscuria.obscureapi.api.BossBarsRenderManager;
import com.p1nero.dialog_lib.client.screen.DialogueScreen;
import com.p1nero.dialog_lib.events.ClientNpcEntityDialogueEvent;
import com.p1nero.tcrcore.client.gui.CustomGuiderRenderer;
import com.p1nero.tcrcore.client.gui.HandleArteriusDialog;
import com.p1nero.tcrcore.client.gui.HandleIronGolemDialog;
import com.p1nero.tcrcore.client.gui.HandleSkrytheEntityDialog;
import com.p1nero.tcrcore.client.gui.HandleVillagerDialog;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.BossHealthOverlay;
import net.minecraft.client.gui.screens.LevelLoadingScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.npc.Villager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;
import net.shelmarow.nightfall_invade.entity.spear_knight.Arterius;

@Mod.EventBusSubscriber(modid="tcrcore", value={Dist.CLIENT})
public class ClientForgeEvents {
    public static final ResourceLocation BACKGROUND_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/gui/light_dirt_background.png");

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (Minecraft.m_91087_().f_91074_ != null) {
            CustomGuiderRenderer.tick(Minecraft.m_91087_().f_91074_);
        }
    }

    @SubscribeEvent
    public static void onRenderBossBar(CustomizeGuiOverlayEvent.BossEventProgress event) {
        Optional style = BossBarsRenderManager.getStyle((Component)event.getBossEvent().m_18861_());
        if (style.isPresent()) {
            Component component = event.getBossEvent().m_18861_();
            if (((BossBarsRenderManager.Style)style.get()).shouldRenderBar()) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)BossHealthOverlay.f_93697_);
            }
            Minecraft minecraft = Minecraft.m_91087_();
            ((BossBarsRenderManager.Style)style.get()).getFunction().render(minecraft, event.getGuiGraphics(), event.getX(), event.getY(), event.getBossEvent(), component);
            if (((BossBarsRenderManager.Style)style.get()).shouldRenderName()) {
                int x = event.getWindow().m_85445_() / 2 - minecraft.f_91062_.m_92852_((FormattedText)component) / 2;
                int y = event.getY() - 9;
                event.getGuiGraphics().m_280430_(minecraft.f_91062_, component, x, y, 0xFFFFFF);
            }
            event.setIncrement(((BossBarsRenderManager.Style)style.get()).getIncrement(minecraft));
        }
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiOverlayEvent.Pre event) {
        if (Minecraft.m_91087_().f_91080_ instanceof DialogueScreen) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRenderGui(RenderGuiEvent.Pre event) {
        if (!Minecraft.m_91087_().m_91104_() && Minecraft.m_91087_().f_91080_ == null && Minecraft.m_91087_().f_91074_ != null) {
            CustomGuiderRenderer.render(Minecraft.m_91087_().f_91074_, event.getGuiGraphics(), event.getWindow(), event.getPartialTick());
        }
    }

    @SubscribeEvent
    public static void onDialogSend(ClientNpcEntityDialogueEvent event) {
        Entity entity = event.getSelf();
        if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            HandleVillagerDialog.openDialogScreen(villager, event.getLocalPlayer(), event.getServerData());
        }
        if ((entity = event.getSelf()) instanceof IronGolem) {
            IronGolem ironGolem = (IronGolem)entity;
            HandleIronGolemDialog.openDialogScreen(ironGolem, event.getLocalPlayer(), event.getServerData());
        }
        if ((entity = event.getSelf()) instanceof AbstractLargeMonster) {
            AbstractLargeMonster abstractLargeMonster = (AbstractLargeMonster)entity;
            HandleSkrytheEntityDialog.openDialogScreen(abstractLargeMonster, event.getLocalPlayer(), event.getServerData());
        }
        if ((entity = event.getSelf()) instanceof Arterius) {
            Arterius arterius = (Arterius)entity;
            HandleArteriusDialog.openDialogScreen(arterius, event.getLocalPlayer(), event.getServerData());
        }
    }

    @SubscribeEvent
    public static void onRenderBackground(ScreenEvent.BackgroundRendered event) {
        if (Minecraft.m_91087_().f_91073_ == null && !(event.getScreen() instanceof LevelLoadingScreen)) {
            event.getGuiGraphics().m_280398_(BACKGROUND_LOCATION, 0, 0, 0, 0.0f, 0.0f, event.getScreen().f_96543_, event.getScreen().f_96544_, 32, 32);
        }
    }
}

