/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.tcrcore.entity.custom.tutorial_golem;

import com.p1nero.fast_tpa.network.PacketRelay;
import com.p1nero.tcrcore.TCRCoreMod;
import com.p1nero.tcrcore.capability.PlayerDataManager;
import com.p1nero.tcrcore.network.TCRPacketHandler;
import com.p1nero.tcrcore.network.packet.clientbound.PlayTitlePacket;
import com.p1nero.tcrcore.utils.WorldUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GolemRandomStrollInVillageGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.OfferFlowerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.simple.SimpleChannel;
import org.jetbrains.annotations.NotNull;
import yesman.epicfight.world.effect.EpicFightMobEffects;

public class TutorialGolem
extends IronGolem {
    public TutorialGolem(EntityType<? extends IronGolem> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier setAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 1000.0).m_22268_(Attributes.f_22281_, (double)0.01f).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22278_, 114514.0).m_22265_();
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.m_20238_(WorldUtil.GOLEM_CENTER_POS_VEC3) > 4900.0) {
            Vec3 dir = WorldUtil.GOLEM_CENTER_POS_VEC3.m_82546_(this.m_20182_()).m_82541_();
            Vec3 targetPos = this.m_20182_().m_82549_(dir.m_82490_(30.0));
            this.m_21573_().m_26519_(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_, 1.0);
        }
    }

    public boolean m_6469_(@NotNull DamageSource source, float value) {
        Entity entity = source.m_7639_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            serverPlayer.m_5661_((Component)TCRCoreMod.getInfo("hurt_damage", String.format("%.2f", Float.valueOf(value))).m_130940_(ChatFormatting.RED), false);
            if (!PlayerDataManager.locked.get((Player)serverPlayer).booleanValue()) {
                return false;
            }
        } else {
            return false;
        }
        this.m_7292_(new MobEffectInstance((MobEffect)EpicFightMobEffects.INSTABILITY.get(), 200, 1));
        return super.m_6469_(source, value);
    }

    public void m_6667_(@NotNull DamageSource damageSource) {
        if (damageSource.m_19390_()) {
            super.m_6667_(damageSource);
        }
        this.m_21153_(this.m_21233_());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(2, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 0.9, 32.0f));
        this.f_21345_.m_25352_(4, (Goal)new GolemRandomStrollInVillageGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(5, (Goal)new OfferFlowerGoal((IronGolem)this));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, this::shouldAttack));
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    private boolean shouldAttack(LivingEntity living) {
        if (this.m_21023_((MobEffect)EpicFightMobEffects.INSTABILITY.get())) {
            return true;
        }
        if (living instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)living;
            return PlayerDataManager.dodged.get((Player)serverPlayer) == false || PlayerDataManager.parried.get((Player)serverPlayer) == false || PlayerDataManager.locked.get((Player)serverPlayer) == false;
        }
        return false;
    }

    public void m_6075_() {
        super.m_6075_();
        LivingEntity livingEntity = this.m_5448_();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            if (this.f_19797_ % 40 == 0) {
                if (this.m_21023_((MobEffect)EpicFightMobEffects.INSTABILITY.get())) {
                    serverPlayer.m_5661_((Component)TCRCoreMod.getInfo("after_heal_stop_attack"), true);
                    return;
                }
                if (!PlayerDataManager.dodged.get((Player)serverPlayer).booleanValue()) {
                    PacketRelay.sendToPlayer((SimpleChannel)TCRPacketHandler.INSTANCE, (Object)new PlayTitlePacket(1), (ServerPlayer)serverPlayer);
                } else if (!PlayerDataManager.parried.get((Player)serverPlayer).booleanValue()) {
                    PacketRelay.sendToPlayer((SimpleChannel)TCRPacketHandler.INSTANCE, (Object)new PlayTitlePacket(2), (ServerPlayer)serverPlayer);
                } else if (!PlayerDataManager.locked.get((Player)serverPlayer).booleanValue()) {
                    PacketRelay.sendToPlayer((SimpleChannel)TCRPacketHandler.INSTANCE, (Object)new PlayTitlePacket(3), (ServerPlayer)serverPlayer);
                } else if (!PlayerDataManager.tutorial_passed.get((Player)serverPlayer).booleanValue()) {
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetTitleTextPacket((Component)TCRCoreMod.getInfo("you_pass")));
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(BuiltInRegistries.f_256894_.m_263177_((Object)SoundEvents.f_12496_), SoundSource.PLAYERS, serverPlayer.m_20185_(), serverPlayer.m_20186_(), serverPlayer.m_20189_(), 1.0f, 1.0f, (long)serverPlayer.m_217043_().m_188502_()));
                    this.m_6710_(null);
                    PlayerDataManager.tutorial_passed.put((Player)serverPlayer, true);
                } else {
                    this.m_6710_(null);
                }
            }
        }
    }
}

