/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.tcrcore.entity.custom.guider;

import com.mojang.blaze3d.vertex.PoseStack;
import com.p1nero.tcrcore.entity.custom.guider.GuiderEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.VillagerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CrossedArmsItemLayer;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class GuiderRenderer
extends MobRenderer<GuiderEntity, VillagerModel<GuiderEntity>> {
    private static final ResourceLocation SKIN = ResourceLocation.fromNamespaceAndPath((String)"tcrcore", (String)"textures/entity/god.png");

    public GuiderRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new VillagerModel(context.m_174023_(ModelLayers.f_171210_)), 0.5f);
        this.m_115326_((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.m_174027_(), context.m_234598_()));
        this.m_115326_((RenderLayer)new CrossedArmsItemLayer((RenderLayerParent)this, context.m_234598_()));
    }

    public void render(@NotNull GuiderEntity guider, float entityYaw, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int p_115460_) {
        poseStack.m_85836_();
        float floatingHeight = this.calculateFloatingHeight(guider, partialTicks);
        poseStack.m_85837_(0.0, (double)floatingHeight + 0.5, 0.0);
        super.m_7392_((Mob)guider, entityYaw, partialTicks, poseStack, multiBufferSource, p_115460_);
        poseStack.m_85849_();
    }

    private float calculateFloatingHeight(GuiderEntity entity, float partialTicks) {
        float BASE_HEIGHT = 0.1f;
        float SPEED = 0.1f;
        float BOBBING_SCALE = 0.5f;
        float time = ((float)entity.m_9236_().m_46467_() + partialTicks) * 0.1f;
        float entityPhase = (float)entity.m_19879_() * 0.1f;
        return Mth.m_14089_((float)(time + entityPhase)) * 0.1f * 0.5f;
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull GuiderEntity guider) {
        return SKIN;
    }
}

