/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.tcrcore.entity.custom.guider;

import com.mojang.blaze3d.vertex.PoseStack;
import com.p1nero.tcrcore.capability.PlayerDataManager;
import com.p1nero.tcrcore.entity.custom.guider.GuiderEntity;
import com.p1nero.tcrcore.entity.custom.guider.GuiderRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

@OnlyIn(value=Dist.CLIENT)
public class GuiderGeoRenderer
extends GeoEntityRenderer<GuiderEntity> {
    public static boolean useRedModel;
    private final GuiderRenderer renderer;

    public GuiderGeoRenderer(EntityRendererProvider.Context context) {
        super(context, (GeoModel)new DefaultedEntityGeoModel<GuiderEntity>(ResourceLocation.fromNamespaceAndPath((String)"tcrcore", (String)"guider")){

            public void setCustomAnimations(GuiderEntity animatable, long instanceId, AnimationState<GuiderEntity> animationState) {
                CoreGeoBone head = this.getAnimationProcessor().getBone("Head");
                if (head != null) {
                    EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
                    head.setRotX(entityData.headPitch() * ((float)Math.PI / 180));
                    head.setRotY(entityData.netHeadYaw() * ((float)Math.PI / 180));
                }
            }

            public ResourceLocation getTextureResource(GuiderEntity animatable) {
                if (useRedModel) {
                    return ResourceLocation.fromNamespaceAndPath((String)"tcrcore", (String)"textures/entity/guider_red.png");
                }
                return super.getTextureResource((GeoAnimatable)animatable);
            }
        });
        this.renderer = new GuiderRenderer(context);
    }

    public void render(@NotNull GuiderEntity entity, float entityYaw, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight) {
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        if (PlayerDataManager.pillagerKilled.get((Player)localPlayer).booleanValue()) {
            super.m_7392_((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        } else {
            this.renderer.render(entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        }
    }
}

