/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.tcrcore.entity.custom.guider;

import com.github.dodo.dodosmobs.init.ModEntities;
import com.obscuria.aquamirae.registry.AquamiraeEntities;
import com.p1nero.dialog_lib.api.component.DialogNode;
import com.p1nero.dialog_lib.api.component.DialogueComponentBuilder;
import com.p1nero.dialog_lib.api.entity.custom.IEntityNpc;
import com.p1nero.dialog_lib.api.entity.goal.LookAtConservingPlayerGoal;
import com.p1nero.dialog_lib.client.screen.DialogueScreen;
import com.p1nero.dialog_lib.client.screen.builder.StreamDialogueScreenBuilder;
import com.p1nero.tcrcore.TCRCoreMod;
import com.p1nero.tcrcore.capability.PlayerDataManager;
import com.p1nero.tcrcore.capability.TCRCapabilityProvider;
import com.p1nero.tcrcore.capability.TCRTaskManager;
import com.p1nero.tcrcore.datagen.TCRAdvancementData;
import com.p1nero.tcrcore.entity.custom.guider.GuiderGeoRenderer;
import com.p1nero.tcrcore.item.TCRItems;
import com.p1nero.tcrcore.save_data.TCRDimSaveData;
import com.p1nero.tcrcore.save_data.TCRMainLevelSaveData;
import com.p1nero.tcrcore.utils.WaypointUtil;
import com.p1nero.tcrcore.utils.WorldUtil;
import com.p1nero.tudigong.util.StructureUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.registries.ForgeRegistries;
import net.sonmok14.fromtheshadows.server.utils.registry.EntityRegistry;
import net.sonmok14.fromtheshadows.server.utils.registry.ItemRegistry;
import net.unusual.blockfactorysbosses.init.BlockFactorysBossesModEntities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlin204.wraithon.WraithonMod;
import org.merlin204.wraithon.entity.WraithonEntities;
import org.merlin204.wraithon.entity.wraithon.WraithonEntity;
import org.merlin204.wraithon.entity.wraithon.WraithonEntityPatch;
import org.merlin204.wraithon.epicfight.animation.WraithonAnimations;
import org.merlin204.wraithon.util.WraithonFieldTeleporter;
import org.merlin204.wraithon.worldgen.WraithonDimensions;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import xaero.hud.minimap.waypoint.WaypointColor;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class GuiderEntity
extends PathfinderMob
implements IEntityNpc,
GeoEntity {
    protected static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.god_girl.idle2");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    @Nullable
    private Player conversingPlayer;

    public GuiderEntity(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    public void m_6457_(@NotNull ServerPlayer serverPlayer) {
        super.m_6457_(serverPlayer);
        TCRCapabilityProvider.syncPlayerDataToClient(serverPlayer);
    }

    public void m_8119_() {
        super.m_8119_();
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            BlockPos myPos;
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.conversingPlayer != null && (this.conversingPlayer.m_213877_() || this.conversingPlayer.m_21224_() || this.conversingPlayer.m_20270_((Entity)this) > 5.0f)) {
                this.conversingPlayer = null;
            }
            if (this.f_19797_ % 100 == 0 && ((myPos = this.m_20097_()).m_123341_() != WorldUtil.GUIDER_BLOCK_POS.m_123341_() || myPos.m_123343_() != WorldUtil.GUIDER_BLOCK_POS.m_123343_())) {
                this.m_146884_(new BlockPos(WorldUtil.GUIDER_BLOCK_POS).m_252807_());
            }
        }
    }

    public boolean m_6469_(@NotNull DamageSource source, float value) {
        Player player;
        Entity entity = source.m_7639_();
        if (entity instanceof Player && (player = (Player)entity).m_7500_()) {
            player.m_5661_((Component)Component.m_237115_((String)("/summon " + String.valueOf(ForgeRegistries.ENTITY_TYPES.getKey((Object)this.m_6095_())))).m_130940_(ChatFormatting.RED), false);
            this.m_146870_();
        }
        if ((entity = source.m_7639_()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (this.getConversingPlayer() != null) {
                return false;
            }
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128379_("from_hurt", true);
            this.sendDialogTo(serverPlayer, compoundTag);
            this.setConversingPlayer((Player)serverPlayer);
            source.m_7639_().m_6469_(this.m_269291_().m_269104_((Entity)this, (Entity)this), value * 0.5f);
            EntityType.f_20465_.m_262496_(serverPlayer.m_284548_(), serverPlayer.m_20097_(), MobSpawnType.MOB_SUMMONED);
        }
        return source.m_19390_();
    }

    public static AttributeSupplier setAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22283_, 2.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22278_, 114514.0).m_22265_();
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new LookAtConservingPlayerGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6785_(double p_21542_) {
        return false;
    }

    @NotNull
    protected InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            WaypointUtil.sendWaypoint(serverPlayer, TCRCoreMod.getInfoKey("godness_statue_pos"), new BlockPos(WorldUtil.GODNESS_STATUE_POS), WaypointColor.AQUA);
            TCRTaskManager.GIVE_ORACLE_TO_KEEPER.finish(serverPlayer);
            TCRTaskManager.BACK_TO_KEEPER.finish(serverPlayer);
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("stage", PlayerDataManager.stage.getInt(player));
            tag.m_128379_("finished", TCRMainLevelSaveData.get(serverPlayer.m_284548_()).isAllFinish());
            tag.m_128379_("map_mark", PlayerDataManager.mapMarked.get((Player)serverPlayer).booleanValue());
            tag.m_128379_("pillager_kill", PlayerDataManager.pillagerKilled.get((Player)serverPlayer).booleanValue());
            tag.m_128379_("fire_eye_get", PlayerDataManager.flameEyeTraded.get((Player)serverPlayer).booleanValue());
            tag.m_128379_("finish_all_eye_boss", PlayerDataManager.isAllEyeGet((Player)serverPlayer));
            tag.m_128379_("finish_all_altar_boss", PlayerDataManager.isAllAltarKilled((Player)serverPlayer));
            ItemStack itemStack = player.m_21120_(hand);
            if (itemStack.m_150930_((Item)TCRItems.ANCIENT_ORACLE_FRAGMENT.get()) && (serverPlayer.m_7500_() || itemStack.m_41782_() && itemStack.m_41784_().m_128461_("player_name").equals(player.m_36316_().getName()))) {
                tag.m_128379_("is_oracle", true);
            }
            this.sendDialogTo(serverPlayer, tag);
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public DialogueScreen getDialogueScreen(CompoundTag compoundTag) {
        int stage = compoundTag.m_128451_("stage");
        StreamDialogueScreenBuilder treeBuilder = new StreamDialogueScreenBuilder((Entity)this, "tcrcore");
        DialogueComponentBuilder dBuilder = treeBuilder.getComponentBuildr();
        if (compoundTag.m_128471_("from_hurt")) {
            treeBuilder.start(5).addFinalOption(6);
            return treeBuilder.build();
        }
        if (compoundTag.m_128471_("finished") && compoundTag.m_128471_("finish_all_eye_boss")) {
            if (compoundTag.m_128471_("finish_all_altar_boss")) {
                treeBuilder.start(8).addOption(12, 11).thenExecute(4).thenExecute(dialogueScreen -> {
                    GuiderGeoRenderer.useRedModel = true;
                }).addOption(13, 12).addOption(14, 13).addFinalOption(15, 3);
            } else {
                treeBuilder.start(21).addFinalOption(0);
            }
            return treeBuilder.build();
        }
        if (compoundTag.m_128471_("is_oracle")) {
            switch (stage) {
                case 0: {
                    treeBuilder.start(7).addOption((Component)dBuilder.optWithBrackets(9), (Component)dBuilder.ans(15, new Object[]{Component.m_237113_((String)StructureUtils.getPrettyStructureName((ResourceLocation)ResourceLocation.parse((String)"trek:overworld/very_rare/floating_farm_large"))).m_130940_(ChatFormatting.AQUA), TCRCoreMod.getInfo("iron_golem_name").m_130940_(ChatFormatting.GOLD), Component.m_237113_((String)StructureUtils.getPrettyStructureName((ResourceLocation)ResourceLocation.parse((String)"trek:overworld/very_rare/floating_farm_large"))).m_130940_(ChatFormatting.AQUA)})).thenExecute(2).addFinalOption((Component)dBuilder.optWithBrackets(5), 1);
                    break;
                }
                case 1: {
                    treeBuilder.start(7).addOption((Component)dBuilder.optWithBrackets(9), (Component)dBuilder.ans(16, new Object[]{Component.m_237113_((String)StructureUtils.getPrettyStructureName((ResourceLocation)ResourceLocation.parse((String)"ribbits:ribbit_village"))).m_130940_(ChatFormatting.BLUE), ((EntityType)EntityRegistry.BULLDROGIOTH.get()).m_20676_().m_6881_().m_130940_(ChatFormatting.GOLD), Component.m_237113_((String)StructureUtils.getPrettyStructureName((ResourceLocation)ResourceLocation.parse((String)"ribbits:ribbit_village"))).m_130940_(ChatFormatting.BLUE), ((Item)ItemRegistry.CRIMSON_SHELL.get()).m_41466_().m_6881_().m_130940_(ChatFormatting.RED)})).thenExecute(2).addFinalOption((Component)dBuilder.optWithBrackets(5), 1);
                    break;
                }
                case 3: {
                    treeBuilder.start(7).addOption((Component)dBuilder.optWithBrackets(9), (Component)dBuilder.ans(17, new Object[]{Component.m_237113_((String)StructureUtils.getPrettyStructureName((ResourceLocation)ResourceLocation.parse((String)"aquamirae:ship"))).m_130940_(ChatFormatting.DARK_GREEN), ((EntityType)AquamiraeEntities.CAPTAIN_CORNELIA.get()).m_20676_().m_6881_().m_130940_(ChatFormatting.GOLD), Component.m_237113_((String)StructureUtils.getPrettyStructureName((ResourceLocation)ResourceLocation.parse((String)"aquamirae:ship"))).m_130940_(ChatFormatting.DARK_GREEN)})).thenExecute(2).addFinalOption((Component)dBuilder.optWithBrackets(5), 1);
                    break;
                }
                case 2: {
                    treeBuilder.start(7).addOption((Component)dBuilder.optWithBrackets(9), (Component)dBuilder.ans(18, new Object[]{Component.m_237113_((String)StructureUtils.getPrettyStructureName((ResourceLocation)ResourceLocation.parse((String)"dodosmobs:jungle_prison"))).m_130940_(ChatFormatting.YELLOW), ((EntityType)ModEntities.BONE_CHIMERA.get()).m_20676_().m_6881_().m_130940_(ChatFormatting.GOLD), Component.m_237113_((String)StructureUtils.getPrettyStructureName((ResourceLocation)ResourceLocation.parse((String)"dodosmobs:jungle_prison"))).m_130940_(ChatFormatting.YELLOW)})).thenExecute(2).addFinalOption((Component)dBuilder.optWithBrackets(5), 1);
                    break;
                }
                case 4: {
                    treeBuilder.start(7).addOption((Component)dBuilder.optWithBrackets(9), (Component)dBuilder.ans(19, new Object[]{Component.m_237113_((String)StructureUtils.getPrettyStructureName((ResourceLocation)ResourceLocation.parse((String)"tcrcore:underworld_arena"))).m_130940_(ChatFormatting.RED), ((EntityType)BlockFactorysBossesModEntities.UNDERWORLD_KNIGHT.get()).m_20676_().m_6881_().m_130940_(ChatFormatting.RED), Component.m_237113_((String)StructureUtils.getPrettyStructureName((ResourceLocation)ResourceLocation.parse((String)"tcrcore:underworld_arena"))).m_130940_(ChatFormatting.RED)})).thenExecute(2).addFinalOption((Component)dBuilder.optWithBrackets(5), 1);
                    break;
                }
                default: {
                    treeBuilder.start(20).addFinalOption(17);
                }
            }
            return treeBuilder.build();
        }
        if (compoundTag.m_128471_("map_mark")) {
            DialogNode root = new DialogNode((Component)dBuilder.ans(8), (Component)dBuilder.optWithBrackets(0));
            DialogNode ans2 = new DialogNode((Component)dBuilder.ans(10), (Component)dBuilder.optWithBrackets(11)).addChild(root);
            DialogNode ans3 = new DialogNode((Component)dBuilder.ans(14), (Component)dBuilder.optWithBrackets(16)).addChild(root);
            DialogNode ans4 = new DialogNode((Component)dBuilder.ans(22), (Component)dBuilder.optWithBrackets(18)).addChild(root);
            root.addChild(ans2).addChild(ans4).addChild(ans3);
            return treeBuilder.buildWith(root);
        }
        DialogNode root = new DialogNode((Component)dBuilder.ans(0), (Component)dBuilder.optWithBrackets(0));
        DialogNode ans1 = new DialogNode((Component)dBuilder.ans(1), (Component)dBuilder.optWithBrackets(1)).addChild(root);
        DialogNode ans2 = new DialogNode((Component)dBuilder.ans(2), (Component)dBuilder.optWithBrackets(3)).addChild(root);
        DialogNode ans3 = new DialogNode((Component)dBuilder.ans(3), (Component)dBuilder.optWithBrackets(4)).addChild(root);
        if (compoundTag.m_128471_("pillager_kill")) {
            treeBuilder.start(0).addOption((Component)dBuilder.optWithBrackets(7), (Component)dBuilder.ans(15, new Object[]{Component.m_237113_((String)StructureUtils.getPrettyStructureName((ResourceLocation)ResourceLocation.parse((String)"trek:overworld/very_rare/floating_farm_large"))).m_130940_(ChatFormatting.AQUA), TCRCoreMod.getInfo("iron_golem_name").m_130940_(ChatFormatting.GOLD), Component.m_237113_((String)StructureUtils.getPrettyStructureName((ResourceLocation)ResourceLocation.parse((String)"trek:overworld/very_rare/floating_farm_large"))).m_130940_(ChatFormatting.AQUA)})).thenExecute(2).addFinalOption((Component)dBuilder.optWithBrackets(5), 1);
            return treeBuilder.build();
        }
        root.addChild(ans1).addChild(ans2).addChild(ans3);
        return treeBuilder.buildWith(root);
    }

    public void handleNpcInteraction(ServerPlayer player, int code) {
        if (code == 4) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12548_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if (code == 3) {
            ServerLevel wraithonLevel = player.f_8924_.m_129880_(WraithonDimensions.SANCTUM_OF_THE_WRAITHON_LEVEL_KEY);
            player.changeDimension(wraithonLevel, (ITeleporter)new WraithonFieldTeleporter());
            if (!TCRDimSaveData.get(wraithonLevel).isBossSummoned() && wraithonLevel.m_143280_((EntityTypeTest)WraithonEntities.WRAITHON.get(), LivingEntity::m_6084_).isEmpty()) {
                EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)player, ServerPlayerPatch.class).ifPresent(serverPlayerPatch -> serverPlayerPatch.playAnimationSynchronized((AssetAccessor)WraithonAnimations.BIPE_COME, 0.0f));
                WraithonEntity wraithonEntity = (WraithonEntity)((EntityType)WraithonEntities.WRAITHON.get()).m_262496_(wraithonLevel, WraithonMod.WRAITHON_SPAWN_POS, MobSpawnType.MOB_SUMMONED);
                EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)wraithonEntity, WraithonEntityPatch.class).ifPresent(wraithonEntityPatch -> wraithonEntityPatch.playAnimationSynchronized((AssetAccessor)WraithonAnimations.WRAITHON_BEGIN, 0.0f));
                TCRDimSaveData.get(wraithonLevel).setBossSummoned(true);
            }
            player.m_5661_((Component)TCRCoreMod.getInfo("wraithon_start_tip"), false);
        }
        if (code == 1) {
            TCRAdvancementData.finishAdvancement("mark_map", player);
        }
        if (code == 2) {
            TCRCapabilityProvider.getTCRPlayer((Player)player).setNeedToMarkMapInOverworld(true);
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12496_, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (player.m_21205_().m_150930_((Item)TCRItems.ANCIENT_ORACLE_FRAGMENT.get())) {
                player.m_21205_().m_41774_(1);
            } else if (player.m_21206_().m_150930_((Item)TCRItems.ANCIENT_ORACLE_FRAGMENT.get())) {
                player.m_21206_().m_41774_(1);
            }
            TCRTaskManager.GO_TO_OVERWORLD.start(player);
            return;
        }
        if (!PlayerDataManager.pillagerKilled.get((Player)player).booleanValue()) {
            TCRTaskManager.KILL_PILLAGER.start(player);
            DialogueComponentBuilder dBuilder = new DialogueComponentBuilder((Entity)this, "tcrcore");
            player.m_5661_((Component)dBuilder.buildDialogue((Entity)this, (Component)dBuilder.ans(3)), false);
        }
        this.setConversingPlayer(null);
    }

    public void setConversingPlayer(@Nullable Player player) {
        this.conversingPlayer = player;
    }

    @Nullable
    public Player getConversingPlayer() {
        return this.conversingPlayer;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, this::deployAnimController)});
    }

    protected <E extends GuiderEntity> PlayState deployAnimController(AnimationState<E> state) {
        return state.setAndContinue(IDLE);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

