/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.tcrcore.entity.custom.girl;

import artifacts.item.ArtifactItem;
import artifacts.registry.ModItems;
import com.p1nero.dialog_lib.api.component.DialogNode;
import com.p1nero.dialog_lib.api.component.DialogueComponentBuilder;
import com.p1nero.dialog_lib.api.entity.custom.IEntityNpc;
import com.p1nero.dialog_lib.api.entity.goal.LookAtConservingPlayerGoal;
import com.p1nero.dialog_lib.client.screen.DialogueScreen;
import com.p1nero.dialog_lib.client.screen.builder.DialogueScreenBuilder;
import com.p1nero.tcrcore.TCRCoreMod;
import com.p1nero.tcrcore.capability.PlayerDataManager;
import com.p1nero.tcrcore.events.OverworldVillageTeleporter;
import com.p1nero.tcrcore.events.PlayerEventListeners;
import com.p1nero.tcrcore.events.SafeNetherTeleporter;
import com.p1nero.tcrcore.item.TCRItems;
import com.p1nero.tcrcore.utils.ItemUtil;
import com.p1nero.tcrcore.utils.WorldUtil;
import com.yesman.epicskills.client.gui.screen.SkillTreeScreen;
import com.yesman.epicskills.client.input.EpicSkillsKeyMappings;
import java.util.Collection;
import java.util.List;
import net.blay09.mods.waystones.block.ModBlocks;
import net.genzyuro.uniqueaccessories.item.UAUniqueCurioItem;
import net.genzyuro.uniqueaccessories.registry.UAItems;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;

public class GirlEntity
extends PathfinderMob
implements IEntityNpc,
GeoEntity,
Merchant {
    protected static final RawAnimation IDLE = RawAnimation.begin().thenLoop("idle");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    @Nullable
    private Player tradingPlayer;
    private MerchantOffers offers = new MerchantOffers();
    private final MerchantOffers offersWeapon = new MerchantOffers();
    private final MerchantOffers offersArmor = new MerchantOffers();
    private final MerchantOffers offersArtifact = new MerchantOffers();
    private final List<Item> rareItems = List.of((Item)ModItems.CRYSTAL_HEART.get(), (Item)ModItems.FERAL_CLAWS.get(), (Item)ModItems.VAMPIRIC_GLOVE.get(), (Item)ModItems.POWER_GLOVE.get(), (Item)ModItems.NOVELTY_DRINKING_HAT.get(), (Item)ModItems.PLASTIC_DRINKING_HAT.get(), (Item)UAItems.SUN_STONE.get(), (Item)UAItems.MOON_STONE.get(), (Item)UAItems.HERO_EMBLEM.get(), (Item)UAItems.SHINY_STONE.get());

    public GirlEntity(EntityType<? extends PathfinderMob> p_21683_, Level p_21684_) {
        super(p_21683_, p_21684_);
        this.initMerchant();
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            BlockPos myPos;
            if (this.f_19797_ % 100 == 0 && ((myPos = this.m_20097_()).m_123341_() != WorldUtil.GIRL_POS.m_123341_() || myPos.m_123343_() != WorldUtil.GIRL_POS.m_123343_())) {
                this.m_146884_(new BlockPos(WorldUtil.GIRL_POS).m_252807_());
            }
            if (this.getConversingPlayer() != null && (this.getConversingPlayer().m_213877_() || this.getConversingPlayer().m_21224_() || this.getConversingPlayer().m_20270_((Entity)this) > 5.0f)) {
                this.setConversingPlayer(null);
            }
        }
    }

    private void initMerchant() {
        this.offers.clear();
        this.offersArmor.clear();
        this.offersWeapon.clear();
        this.offersArtifact.clear();
        this.offersArtifact.add((Object)new MerchantOffer(new ItemStack((ItemLike)Items.f_42545_, 1), new ItemStack((ItemLike)ModBlocks.waystone, 1), 142857, 0, 0.02f));
        ForgeRegistries.ITEMS.getValues().forEach(item -> {
            if (PlayerEventListeners.illegalItems.contains(item)) {
                return;
            }
            if (item instanceof ArtifactItem || item instanceof UAUniqueCurioItem) {
                if (this.rareItems.contains(item)) {
                    this.offersArtifact.add((Object)new MerchantOffer(new ItemStack((ItemLike)TCRItems.RARE_ARTIFACT_TICKET.get(), 1), new ItemStack((ItemLike)item, 1), 142857, 0, 0.02f));
                } else {
                    this.offersArtifact.add((Object)new MerchantOffer(new ItemStack((ItemLike)TCRItems.ARTIFACT_TICKET.get(), 1), new ItemStack((ItemLike)item, 1), 142857, 0, 0.02f));
                }
            }
        });
    }

    public boolean m_6469_(@NotNull DamageSource damageSource, float p_21017_) {
        Player player;
        Entity entity = damageSource.m_7639_();
        if (entity instanceof Player && (player = (Player)entity).m_7500_()) {
            player.m_5661_((Component)Component.m_237115_((String)("/summon " + String.valueOf(ForgeRegistries.ENTITY_TYPES.getKey((Object)this.m_6095_())))).m_130940_(ChatFormatting.RED), false);
            this.m_146870_();
        }
        return false;
    }

    @NotNull
    protected InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        this.initMerchant();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CompoundTag tag = new CompoundTag();
            tag.m_128379_("boat", PlayerDataManager.boatGet.get((Player)serverPlayer).booleanValue());
            tag.m_128379_("nether_dim_unlock", PlayerDataManager.netherEntered.get(player).booleanValue());
            tag.m_128379_("end_dim_unlock", PlayerDataManager.endEntered.get(player).booleanValue());
            this.sendDialogTo(serverPlayer, tag);
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new LookAtConservingPlayerGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
    }

    @OnlyIn(value=Dist.CLIENT)
    public DialogueScreen getDialogueScreen(CompoundTag compoundTag) {
        DialogueScreenBuilder treeBuilder = new DialogueScreenBuilder((Entity)this, "tcrcore");
        DialogueComponentBuilder dBuilder = treeBuilder.getComponentBuildr();
        DialogNode root = new DialogNode((Component)dBuilder.ans(0), (Component)dBuilder.optWithBrackets(0));
        DialogNode ans1 = new DialogNode((Component)dBuilder.ans(1), (Component)dBuilder.optWithBrackets(1)).addChild(root);
        DialogNode ans4 = new DialogNode((Component)dBuilder.ans(5, new Object[]{I18n.m_118938_((String)"item.epicskills.ability_stone", (Object[])new Object[0]), I18n.m_118938_((String)"item.epicskills.ability_stone", (Object[])new Object[0]), EpicSkillsKeyMappings.OPEN_SKILL_TREE.m_90863_()}), (Component)dBuilder.optWithBrackets(4)).addChild((DialogNode)new DialogNode.FinalNode((Component)dBuilder.optWithBrackets(5), -1, s -> {
            LocalPlayerPatch localPlayerPatch = ClientEngine.getInstance().getPlayerPatch();
            if (localPlayerPatch != null) {
                Minecraft.m_91087_().m_91152_((Screen)new SkillTreeScreen(localPlayerPatch));
            }
        }));
        DialogNode.FinalNode ans7 = new DialogNode.FinalNode((Component)dBuilder.optWithBrackets(9), 7);
        root.addChild(ans1).addChild((DialogNode)ans7).addChild(ans4);
        if (compoundTag.m_128471_("nether_dim_unlock")) {
            DialogNode ans5 = new DialogNode((Component)dBuilder.ans(4), (Component)dBuilder.optWithBrackets(6)).addChild((DialogNode)new DialogNode.FinalNode((Component)dBuilder.optWithBrackets(8), 5)).addChild(root);
            root.addChild(ans5);
        }
        if (compoundTag.m_128471_("end_dim_unlock")) {
            DialogNode ans6 = new DialogNode((Component)dBuilder.ans(4), (Component)dBuilder.optWithBrackets(7)).addChild((DialogNode)new DialogNode.FinalNode((Component)dBuilder.optWithBrackets(8), 6)).addChild(root);
            root.addChild(ans6);
        }
        root.addLeaf((Component)dBuilder.optWithBrackets(10), 8);
        return treeBuilder.buildWith(root);
    }

    public void handleNpcInteraction(ServerPlayer serverPlayer, int i) {
        ServerLevel level;
        if (i == 5) {
            level = serverPlayer.f_8924_.m_129880_(Level.f_46429_);
            serverPlayer.changeDimension(level, (ITeleporter)new SafeNetherTeleporter());
        }
        if (i == 6) {
            level = serverPlayer.f_8924_.m_129880_(Level.f_46430_);
            serverPlayer.m_5489_(level);
        }
        if (i == 8) {
            if (PlayerDataManager.wayStoneInteracted.get((Player)serverPlayer).booleanValue()) {
                level = serverPlayer.f_8924_.m_129880_(Level.f_46428_);
                serverPlayer.changeDimension(level, (ITeleporter)new OverworldVillageTeleporter());
            } else {
                serverPlayer.m_5661_((Component)TCRCoreMod.getInfo("need_to_unlock_waystone").m_130940_(ChatFormatting.RED), false);
            }
        }
        if (i == 3 && !PlayerDataManager.boatGet.get((Player)serverPlayer).booleanValue()) {
            ItemUtil.addItemEntity((Entity)serverPlayer, ((Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.parse((String)"smallships:oak_cog"))).m_7968_());
            PlayerDataManager.boatGet.put((Player)serverPlayer, true);
        }
        if (i == 1) {
            this.offers.addAll((Collection)this.offersWeapon);
            this.startTrade(serverPlayer);
        }
        if (i == 2) {
            this.offers.addAll((Collection)this.offersArmor);
            this.startTrade(serverPlayer);
        }
        if (i == 7) {
            this.offers.addAll((Collection)this.offersArtifact);
            this.startTrade(serverPlayer);
        }
        this.setConversingPlayer(null);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, this::deployAnimController)});
    }

    protected <E extends GirlEntity> PlayState deployAnimController(AnimationState<E> state) {
        return state.setAndContinue(IDLE);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void startTrade(ServerPlayer serverPlayer) {
        this.m_7189_((Player)serverPlayer);
        this.m_45301_((Player)serverPlayer, (Component)Component.m_237119_(), 1);
    }

    public void m_7189_(@Nullable Player player) {
        this.tradingPlayer = player;
    }

    @Nullable
    public Player m_7962_() {
        return this.tradingPlayer;
    }

    @NotNull
    public MerchantOffers m_6616_() {
        return this.offers == null ? new MerchantOffers() : this.offers;
    }

    public void m_6255_(@NotNull MerchantOffers merchantOffers) {
    }

    public void m_6996_(@NotNull MerchantOffer merchantOffer) {
    }

    public void m_7713_(@NotNull ItemStack itemStack) {
    }

    public int m_7809_() {
        return 0;
    }

    public void m_6621_(int i) {
    }

    public boolean m_7826_() {
        return false;
    }

    @NotNull
    public SoundEvent m_7596_() {
        return SoundEvents.f_11871_;
    }

    public boolean m_183595_() {
        return this.m_9236_().f_46443_;
    }

    public boolean m_6785_(double p_21542_) {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }
}

