/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.tcrcore.datagen.lang;

import com.p1nero.dialog_lib.api.datagen.DialogueLanguageProvider;
import com.p1nero.tcrcore.capability.TCRTaskManager;
import java.util.function.Supplier;
import net.minecraft.client.KeyMapping;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.text.WordUtils;

public abstract class TCRLangProvider
extends LanguageProvider
implements DialogueLanguageProvider {
    public TCRLangProvider(PackOutput output, String locate) {
        super(output, "tcrcore", locate);
    }

    public void addKeyMapping(KeyMapping key, String name) {
        this.add(key.m_90860_(), name);
    }

    public void addInfo(String key, String content) {
        this.add("info.tcr." + key, content);
    }

    public void addTask(TCRTaskManager.Task task, String desc) {
        this.add(task.getDesc(), desc);
    }

    public void addBiome(ResourceKey<Biome> biome, String name) {
        this.add("biome.tcrcore." + biome.m_135782_().m_135815_(), name);
    }

    public void addTCRItemInfo(Item item, String info) {
        this.add(item.m_5524_() + ".tcr_info", info);
    }

    public void addTCRItemInfo(String info, Item ... items) {
        for (Item item : items) {
            this.add(item.m_5524_() + ".tcr_info", info);
        }
    }

    public void addSkill(String skill, String name, String tooltip) {
        this.add("skill.tcrcore." + skill, name);
        this.add("skill.tcrcore." + skill + ".tooltip", tooltip);
    }

    public void addSapling(String woodPrefix, String saplingName) {
        this.add("block.tcrcore" + woodPrefix + "_sapling", saplingName);
        this.add("block.tcrcorepotted_" + woodPrefix + "_sapling", "Potted " + saplingName);
    }

    public void createLogs(String woodPrefix, String woodName) {
        this.add("block.tcrcore." + woodPrefix + "_log", woodName + " Log");
        this.add("block.tcrcore." + woodPrefix + "_wood", woodName + " Wood");
        this.add("block.tcrcore.stripped_" + woodPrefix + "_log", "Stripped " + woodName + " Log");
        this.add("block.tcrcore.stripped_" + woodPrefix + "_wood", "Stripped " + woodName + " Wood");
        this.createHollowLogs(woodPrefix, woodName, false);
    }

    public void createHollowLogs(String woodPrefix, String woodName, boolean stem) {
        this.add("block.tcrcore.hollow_" + woodPrefix + (stem ? "_stem" : "_log") + "_horizontal", "Hollow " + woodName + (stem ? " Stem" : " Log"));
        this.add("block.tcrcore.hollow_" + woodPrefix + (stem ? "_stem" : "_log") + "_vertical", "Hollow " + woodName + (stem ? " Stem" : " Log"));
        this.add("block.tcrcore.hollow_" + woodPrefix + (stem ? "_stem" : "_log") + "_climbable", "Hollow " + woodName + (stem ? " Stem" : " Log"));
    }

    public void createWoodSet(String woodPrefix, String woodName) {
        this.add("block.tcrcore." + woodPrefix + "_planks", woodName + " Planks");
        this.add("block.tcrcore." + woodPrefix + "_slab", woodName + " Slab");
        this.add("block.tcrcore." + woodPrefix + "_stairs", woodName + " Stairs");
        this.add("block.tcrcore." + woodPrefix + "_button", woodName + " Button");
        this.add("block.tcrcore." + woodPrefix + "_fence", woodName + " Fence");
        this.add("block.tcrcore." + woodPrefix + "_fence_gate", woodName + " Fence Gate");
        this.add("block.tcrcore." + woodPrefix + "_pressure_plate", woodName + " Pressure Plate");
        this.add("block.tcrcore." + woodPrefix + "_trapdoor", woodName + " Trapdoor");
        this.add("block.tcrcore." + woodPrefix + "_door", woodName + " Door");
        this.add("block.tcrcore." + woodPrefix + "_sign", woodName + " Sign");
        this.add("block.tcrcore." + woodPrefix + "_wall_sign", woodName + " Wall Sign");
        this.add("block.tcrcore." + woodPrefix + "_banister", woodName + " Banister");
        this.add("block.tcrcore." + woodPrefix + "_chest", woodName + " Chest");
        this.add("item.tcrcore." + woodPrefix + "_boat", woodName + " Boat");
        this.add("item.tcrcore." + woodPrefix + "_chest_boat", woodName + " Chest Boat");
        this.add("block.tcrcore." + woodPrefix + "_hanging_sign", woodName + " Hanging Sign");
        this.add("block.tcrcore." + woodPrefix + "_wall_hanging_sign", woodName + " Wall Hanging Sign");
    }

    public void addBannerPattern(String patternPrefix, String patternName) {
        this.add("item.tcrcore." + patternPrefix + "_banner_pattern", "Banner Pattern");
        this.add("item.tcrcore." + patternPrefix + "_banner_pattern.desc", patternName);
        for (DyeColor color : DyeColor.values()) {
            this.add("block.minecraft.banner.tcrcore." + patternPrefix + "." + color.m_41065_(), WordUtils.capitalize((String)color.m_41065_().replace('_', ' ')) + " " + patternName);
        }
    }

    public void addStoneVariants(String blockKey, String blockName) {
        this.add("block.tcrcore." + blockKey, blockName);
        this.add("block.tcrcore.cracked_" + blockKey, "Cracked " + blockName);
        this.add("block.tcrcore.mossy_" + blockKey, "Mossy " + blockName);
    }

    public void addArmor(String itemKey, String item) {
        this.add("item.tcrcore." + itemKey + "_helmet", item + " Helmet");
        this.add("item.tcrcore." + itemKey + "_chestplate", item + " Chestplate");
        this.add("item.tcrcore." + itemKey + "_leggings", item + " Leggings");
        this.add("item.tcrcore." + itemKey + "_boots", item + " Boots");
    }

    public void addTools(String itemKey, String item) {
        this.add("item.tcrcore." + itemKey + "_sword", item + " Sword");
        this.add("item.tcrcore." + itemKey + "_pickaxe", item + " Pickaxe");
        this.add("item.tcrcore." + itemKey + "_axe", item + " Axe");
        this.add("item.tcrcore." + itemKey + "_shovel", item + " Shovel");
        this.add("item.tcrcore." + itemKey + "_hoe", item + " Hoe");
    }

    public void addMusicDisc(Supplier<Item> disc, String description) {
        this.addItem(disc, "Music Disc");
        this.add(disc.get().m_5524_() + ".desc", description);
    }

    public void addStructure(ResourceKey<Structure> biome, String name) {
        this.add("structure.tcrcore." + biome.m_135782_().m_135815_(), name);
    }

    public void addItemAdvancementDesc(ItemLike itemLike, String desc) {
        this.add("advancement.tcrcore.item." + String.valueOf(itemLike.m_5456_()) + ".desc", desc);
    }

    public void addAdvancement(String key, String title, String desc) {
        this.add("advancement.tcrcore." + key, title);
        this.add("advancement.tcrcore." + key + ".desc", desc);
    }

    public void addEnchantment(String key, String title, String desc) {
        this.add("enchantment.tcrcore." + key, title);
        this.add("enchantment.tcrcore." + key + ".desc", desc);
    }

    public void addEntityAndEgg(RegistryObject<? extends EntityType<?>> entity, String name) {
        this.addEntityType((Supplier)entity, name);
        this.add("item.tcrcore." + entity.getId().m_135815_() + "_spawn_egg", name + "\u5237\u602a\u86cb");
    }

    public void addEntityShaderName(RegistryObject<? extends EntityType<?>> entity, String name) {
        this.add(((EntityType)entity.get()).m_20675_() + "_shader", name);
    }

    public void addEntityType(Supplier<? extends EntityType<?>> key, int i, String name) {
        this.add(key.get().m_20675_() + i, name);
    }

    public void addScreenName(String key, String name) {
        this.add("screen.tcr." + key, name);
    }

    public void addScreenAns(String key, int id, String text) {
        this.add("screen.tcr.ans." + key + "_" + id, text);
    }

    public void addScreenOpt(String key, int id, String text) {
        this.add("screen.tcr.opt." + key + "_" + id, text);
    }

    public void addSubtitle(RegistryObject<SoundEvent> sound, String name) {
        String[] splitSoundName = sound.getId().m_135815_().split("\\.", 3);
        this.add("subtitles.tcrcore." + splitSoundName[0] + "." + splitSoundName[2], name);
    }

    public void addDeathMessage(String key, String name) {
        this.add("death.attack.tcrcore." + key, name);
    }

    public void addStat(String key, String name) {
        this.add("stat.tcrcore." + key, name);
    }

    public void addMessage(String key, String name) {
        this.add("misc.tcrcore." + key, name);
    }

    public void addCommand(String key, String name) {
        this.add("commands.tcrfeature." + key, name);
    }

    public void addTrim(String key, String name) {
        this.add("trim_material.tcrcore." + key, name + " Material");
    }

    public void addBookAndContents(String bookKey, String bookTitle, String ... pages) {
        this.add("tcrcore.book.author." + bookKey, "\u65e0\u540d\u6c0f");
        this.add("tcrcore.book." + bookKey, bookTitle);
        int pageCount = 0;
        for (String page : pages) {
            this.add("tcrcore.book." + bookKey + "." + ++pageCount, page);
        }
    }

    public void addBookAndAuthorAndContents(String bookKey, String author, String bookTitle, String ... pages) {
        this.add("tcrcore.book.author." + bookKey, author);
        this.add("tcrcore.book." + bookKey, bookTitle);
        int pageCount = 0;
        for (String page : pages) {
            this.add("tcrcore.book." + bookKey + "." + ++pageCount, page);
        }
    }

    public void addScreenMessage(String key, String name) {
        this.add("gui.tcrcore." + key, name);
    }

    public void addConfig(String key, String name) {
        this.add("config.tcrcore.common." + key, name);
    }

    public void addDrinkName(Item item, String name) {
        this.add(item.m_5524_() + ".effect.empty", name);
    }

    public void addDrinkName(Item item, String effect, String name) {
        this.add(item.m_5524_() + ".effect." + effect, name);
    }

    public void addItemInfo(Item item, String key, String name) {
        this.add(item.m_5524_() + "." + key, name);
    }

    public void addItemUsageInfo(Item item, String name) {
        this.add(item.m_5524_() + ".usage", name);
    }

    public void addItemUsageInfo(Item item, String name, int index) {
        this.add(item.m_5524_() + ".usage" + index, name);
    }

    public void addItemAdvDesc(Item item, String value) {
        this.add(item.m_5524_() + ".adv_desc", value);
    }
}

