/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.tcrcore.datagen;

import com.p1nero.tcrcore.capability.TCRTaskManager;
import com.p1nero.tcrcore.datagen.TCRAdvancementData;
import com.p1nero.tcrcore.datagen.TCRBlockStateProvider;
import com.p1nero.tcrcore.datagen.TCRItemModelProvider;
import com.p1nero.tcrcore.datagen.TCRRecipeGenerator;
import com.p1nero.tcrcore.datagen.lang.TCRENLangGenerator;
import com.p1nero.tcrcore.datagen.lang.TCRZHLangGenerator;
import com.p1nero.tcrcore.datagen.loot.TCRLootTableProvider;
import com.p1nero.tcrcore.datagen.sound.TCRSoundGenerator;
import com.p1nero.tcrcore.datagen.tags.TCRBlockTagGenerator;
import com.p1nero.tcrcore.datagen.tags.TCREntityTagGenerator;
import com.p1nero.tcrcore.datagen.tags.TCRItemTagGenerator;
import com.p1nero.tcrcore.datagen.tags.TCRPoiTypeTagsProvider;
import com.p1nero.tcrcore.worldgen.TCRWorldGenProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="tcrcore", bus=Mod.EventBusSubscriber.Bus.MOD)
public class TCRDataGenerators {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void gatherData(GatherDataEvent event) {
        TCRTaskManager.init();
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper helper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeClient(), (DataProvider)new TCRBlockStateProvider(output, helper));
        generator.addProvider(event.includeClient(), (DataProvider)new TCRItemModelProvider(output, helper));
        generator.addProvider(event.includeClient(), (DataProvider)new TCRENLangGenerator(output));
        generator.addProvider(event.includeClient(), (DataProvider)new TCRZHLangGenerator(output));
        generator.addProvider(event.includeClient(), (DataProvider)new TCRSoundGenerator(output, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new TCRRecipeGenerator(output));
        generator.addProvider(event.includeServer(), (DataProvider)TCRLootTableProvider.create(output));
        generator.addProvider(event.includeServer(), (DataProvider)new TCRAdvancementData(output, lookupProvider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new TCREntityTagGenerator(output, lookupProvider, helper));
        TCRBlockTagGenerator blockTagGenerator = (TCRBlockTagGenerator)generator.addProvider(event.includeServer(), (DataProvider)new TCRBlockTagGenerator(output, lookupProvider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new TCRItemTagGenerator(output, lookupProvider, blockTagGenerator.m_274426_(), helper));
        generator.addProvider(event.includeServer(), (DataProvider)new TCRPoiTypeTagsProvider(output, lookupProvider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new TCRWorldGenProvider(output, lookupProvider));
    }
}

