/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.tcrcore.datagen;

import com.p1nero.tcrcore.TCRCoreMod;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ImpossibleTrigger;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.advancements.critereon.TameAnimalTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;
import net.p1nero.ss.item.SwordSoaringItems;
import net.saksolm.monsterexpansion.entity.ModEntities;
import net.saksolm.monsterexpansion.item.ModItems;
import org.jetbrains.annotations.NotNull;

public class TCRAdvancementData
extends ForgeAdvancementProvider {
    public static final String PRE = "advancement.tcrcore.";

    public TCRAdvancementData(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, ExistingFileHelper helper) {
        super(output, registries, helper, List.of(new TCRAdvancements()));
    }

    public static void finishAdvancement(Advancement advancement, ServerPlayer serverPlayer) {
        AdvancementProgress progress = serverPlayer.m_8960_().m_135996_(advancement);
        if (!progress.m_8193_()) {
            for (String criteria : progress.m_8219_()) {
                serverPlayer.m_8960_().m_135988_(advancement, criteria);
            }
        }
    }

    public static void finishAdvancement(String name, ServerPlayer serverPlayer) {
        Advancement advancement = serverPlayer.f_8924_.m_129889_().m_136041_(ResourceLocation.fromNamespaceAndPath((String)"tcrcore", (String)name));
        if (advancement == null) {
            TCRCoreMod.LOGGER.error("advancement:\"{}\" is null!", (Object)name);
            return;
        }
        TCRAdvancementData.finishAdvancement(advancement, serverPlayer);
    }

    public static boolean isDone(String name, ServerPlayer serverPlayer) {
        Advancement advancement = serverPlayer.f_8924_.m_129889_().m_136041_(ResourceLocation.fromNamespaceAndPath((String)"tcrcore", (String)name));
        if (advancement == null) {
            TCRCoreMod.LOGGER.info("advancement:\"{}\" is null!", (Object)name);
            return false;
        }
        return TCRAdvancementData.isDone(advancement, serverPlayer);
    }

    public static boolean isDone(Advancement advancement, ServerPlayer serverPlayer) {
        AdvancementProgress advancementProgress = serverPlayer.m_8960_().m_135996_(advancement);
        return advancementProgress.m_8193_();
    }

    public static class TCRAdvancements
    implements ForgeAdvancementProvider.AdvancementGenerator {
        private Consumer<Advancement> consumer;
        private ExistingFileHelper helper;

        public void generate(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider, @NotNull Consumer<Advancement> consumer, @NotNull ExistingFileHelper existingFileHelper) {
            this.consumer = consumer;
            this.helper = existingFileHelper;
            Advancement root = Advancement.Builder.m_138353_().m_138371_((ItemLike)com.github.L_Ender.cataclysm.init.ModItems.STORM_EYE.get(), (Component)Component.m_237115_((String)"advancement.tcrcore.tcrcore"), (Component)Component.m_237115_((String)"advancement.tcrcore.tcrcore.desc"), ResourceLocation.fromNamespaceAndPath((String)"cataclysm", (String)"textures/block/azure_seastone_bricks.png"), FrameType.TASK, false, false, false).m_138386_("tcrcore", (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance()).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"tcrcore", (String)"tcrcore"), existingFileHelper);
            Advancement kill_pillager = this.registerAdvancement(root, "kill_pillager", FrameType.CHALLENGE, (ItemLike)Items.f_220219_, true, true, true, (CriterionTriggerInstance)KilledTrigger.TriggerInstance.m_48134_((EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_204077_(EntityTypeTags.f_13121_)));
            Advancement mark_map = this.registerAdvancement(kill_pillager, "mark_map", FrameType.TASK, (ItemLike)Items.f_42676_, true, true, true, (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance());
            Advancement vatansever = Advancement.Builder.m_138353_().m_138371_((ItemLike)SwordSoaringItems.VATANSEVER.get(), ((Item)SwordSoaringItems.VATANSEVER.get()).m_41466_(), (Component)Component.m_237113_((String)""), null, FrameType.CHALLENGE, true, true, false).m_138386_("tcrcore", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)SwordSoaringItems.VATANSEVER.get()})).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"tcrcore", (String)"vatansever"), existingFileHelper);
            Advancement dragonRide = this.registerAdvancement(root, "dragon_tame", FrameType.CHALLENGE, (ItemLike)ModItems.SKRYTHE_WING_MEMBRANE.get(), true, true, false, (CriterionTriggerInstance)TameAnimalTrigger.TriggerInstance.m_68848_((EntityPredicate)EntityPredicate.Builder.m_36633_().m_36636_((EntityType)ModEntities.SKRYTHE.get()).m_36662_()));
            Advancement stage1 = this.registerAdvancement(root, "stage1", FrameType.CHALLENGE, (ItemLike)Items.f_42146_, false, false, true);
            Advancement stage2 = this.registerAdvancement(root, "stage2", FrameType.CHALLENGE, (ItemLike)Items.f_42146_, false, false, true);
            Advancement stage3 = this.registerAdvancement(root, "stage3", FrameType.CHALLENGE, (ItemLike)Items.f_42146_, false, false, true);
            Advancement stage4 = this.registerAdvancement(root, "stage4", FrameType.CHALLENGE, (ItemLike)Items.f_42146_, false, false, true);
            Advancement stage5 = this.registerAdvancement(root, "stage5", FrameType.CHALLENGE, (ItemLike)Items.f_42146_, false, false, true);
        }

        public Advancement registerItemAdvancement(Advancement parent, ItemLike display, boolean specialDesc) {
            if (!specialDesc) {
                return this.registerItemAdvancement(parent, display);
            }
            String disc = "item." + String.valueOf(display.m_5456_());
            ItemStack itemStack = display.m_5456_().m_7968_();
            return Advancement.Builder.m_138353_().m_138398_(parent).m_138371_(display, display.m_5456_().m_7626_(itemStack), (Component)Component.m_237115_((String)(itemStack.m_41778_() + ".adv_desc")), null, FrameType.GOAL, true, true, false).m_138386_(disc, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{itemStack.m_41720_()})).save(this.consumer, ResourceLocation.fromNamespaceAndPath((String)"tcrcore", (String)disc), this.helper);
        }

        public Advancement registerItemAdvancement(Advancement parent, ItemLike display) {
            String disc = "item." + String.valueOf(display.m_5456_());
            ItemStack itemStack = display.m_5456_().m_7968_();
            MutableComponent desc = Component.m_237119_();
            ArrayList descList = new ArrayList();
            itemStack.m_41720_().m_7373_(itemStack, null, descList, (TooltipFlag)TooltipFlag.f_256752_);
            for (Component component : descList) {
                desc.m_130946_("\n").m_7220_(component);
            }
            return Advancement.Builder.m_138353_().m_138398_(parent).m_138371_(display, display.m_5456_().m_7626_(itemStack), (Component)desc, null, FrameType.GOAL, true, true, false).m_138386_(disc, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{itemStack.m_41720_()})).save(this.consumer, ResourceLocation.fromNamespaceAndPath((String)"tcrcore", (String)disc), this.helper);
        }

        public Advancement registerAdvancement(Advancement parent, String name, FrameType type, ItemLike display, boolean showToast, boolean announceToChat, boolean hidden) {
            return Advancement.Builder.m_138353_().m_138398_(parent).m_138371_(display, (Component)Component.m_237115_((String)(TCRAdvancementData.PRE + name)), (Component)Component.m_237115_((String)(TCRAdvancementData.PRE + name + ".desc")), null, type, showToast, announceToChat, hidden).m_138386_(name, (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance()).save(this.consumer, ResourceLocation.fromNamespaceAndPath((String)"tcrcore", (String)name), this.helper);
        }

        public Advancement registerAdvancement(Advancement parent, String name, FrameType type, ItemLike display, boolean showToast, boolean announceToChat, boolean hidden, CriterionTriggerInstance triggerInstance) {
            return Advancement.Builder.m_138353_().m_138398_(parent).m_138371_(display, (Component)Component.m_237115_((String)(TCRAdvancementData.PRE + name)), (Component)Component.m_237115_((String)(TCRAdvancementData.PRE + name + ".desc")), null, type, showToast, announceToChat, hidden).m_138386_(name, triggerInstance).save(this.consumer, ResourceLocation.fromNamespaceAndPath((String)"tcrcore", (String)name), this.helper);
        }

        public Advancement registerAdvancement(Advancement parent, String name, FrameType type, ItemLike display, CriterionTriggerInstance instance) {
            return Advancement.Builder.m_138353_().m_138398_(parent).m_138371_(display, (Component)Component.m_237115_((String)(TCRAdvancementData.PRE + name)), (Component)Component.m_237115_((String)(TCRAdvancementData.PRE + name + ".desc")), null, type, true, true, true).m_138386_(name, instance).save(this.consumer, ResourceLocation.fromNamespaceAndPath((String)"tcrcore", (String)name), this.helper);
        }

        public Advancement registerAdvancement(Advancement parent, String name, FrameType type, ItemLike display) {
            return this.registerAdvancement(parent, name, type, display, true, true, true);
        }
    }
}

