/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.tcrcore.client.gui;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import com.p1nero.tcrcore.client.sound.WinMusicPlayer;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.LogoRenderer;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class TCREndScreen
extends Screen {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ResourceLocation VIGNETTE_LOCATION = ResourceLocation.parse((String)"textures/misc/vignette.png");
    public static final ResourceLocation BACKGROUND_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"cataclysm", (String)"textures/block/azure_seastone_bricks.png");
    private static final Component SECTION_HEADING = Component.m_237113_((String)"============").m_130940_(ChatFormatting.WHITE);
    private static final String OBFUSCATE_TOKEN = String.valueOf(ChatFormatting.WHITE) + String.valueOf(ChatFormatting.OBFUSCATED) + String.valueOf(ChatFormatting.GREEN) + String.valueOf(ChatFormatting.AQUA);
    private final boolean poem;
    private final Runnable onFinished;
    private float scroll;
    private List<FormattedCharSequence> lines;
    private IntSet centeredLines;
    private int totalScrollLength;
    private boolean speedupActive;
    private final IntSet speedupModifiers = new IntOpenHashSet();
    private float scrollSpeed;
    private final float unmodifiedScrollSpeed;
    private int direction;
    private final LogoRenderer logoRenderer = new LogoRenderer(false);

    public TCREndScreen(boolean poem, Runnable onFinished) {
        super(GameNarrator.f_93310_);
        this.poem = poem;
        this.onFinished = onFinished;
        this.unmodifiedScrollSpeed = !poem ? 0.75f : 0.5f;
        this.direction = 1;
        this.scrollSpeed = this.unmodifiedScrollSpeed;
    }

    private float calculateScrollSpeed() {
        return this.speedupActive ? this.unmodifiedScrollSpeed * (5.0f + (float)this.speedupModifiers.size() * 15.0f) * (float)this.direction : this.unmodifiedScrollSpeed * (float)this.direction;
    }

    public void m_86600_() {
        if (this.f_96541_ == null) {
            return;
        }
        this.f_96541_.m_91397_().m_120183_();
        this.f_96541_.m_91106_().m_120389_(false);
        WinMusicPlayer.playWinMusic();
        float $$0 = this.totalScrollLength + this.f_96544_ + this.f_96544_ + 24;
        if (this.scroll > $$0) {
            this.respawn();
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 265) {
            this.direction = -1;
        } else if (keyCode != 341 && keyCode != 345) {
            if (keyCode == 32) {
                this.speedupActive = true;
            }
        } else {
            this.speedupModifiers.add(keyCode);
        }
        this.scrollSpeed = this.calculateScrollSpeed();
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 265) {
            this.direction = 1;
        }
        if (keyCode == 32) {
            this.speedupActive = false;
        } else if (keyCode == 341 || keyCode == 345) {
            this.speedupModifiers.remove(keyCode);
        }
        this.scrollSpeed = this.calculateScrollSpeed();
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public void m_7379_() {
        this.respawn();
    }

    private void respawn() {
        this.onFinished.run();
    }

    protected void m_7856_() {
        if (this.lines == null) {
            this.lines = Lists.newArrayList();
            this.centeredLines = new IntOpenHashSet();
            String currentLang = this.f_96541_.m_91102_().m_264236_();
            if (this.poem && this.f_96541_ != null) {
                String endTextPath = "tcrcore:texts/end_" + this.f_96541_.m_91102_().m_264236_() + ".txt";
                if (this.f_96541_.m_91098_().m_213713_(ResourceLocation.parse((String)endTextPath)).isPresent()) {
                    this.wrapCreditsIO(endTextPath, this::addPoemFile);
                } else {
                    this.wrapCreditsIO("tcrcore:texts/end_zh_cn.txt", this::addPoemFile);
                }
            }
            String creditsTextPath = "tcrcore:texts/credits_" + currentLang + ".json";
            if (this.f_96541_.m_91098_().m_213713_(ResourceLocation.parse((String)creditsTextPath)).isPresent()) {
                this.wrapCreditsIO("tcrcore:texts/credits_" + currentLang + ".json", this::addCreditsFile);
            } else {
                this.wrapCreditsIO("tcrcore:texts/credits_zh_cn.json", this::addCreditsFile);
            }
            if (this.poem && this.f_96541_ != null) {
                String postTextPath = "tcrcore:texts/postcredits_" + this.f_96541_.m_91102_().m_264236_() + ".txt";
                if (this.f_96541_.m_91098_().m_213713_(ResourceLocation.parse((String)postTextPath)).isPresent()) {
                    this.wrapCreditsIO(postTextPath, this::addPoemFile);
                } else {
                    this.wrapCreditsIO("tcrcore:texts/postcredits_zh_cn.txt", this::addPoemFile);
                }
            }
            this.totalScrollLength = this.lines.size() * 12;
        }
    }

    private void wrapCreditsIO(String creditsLocation, CreditsReader p_reader) {
        try (BufferedReader reader = this.f_96541_.m_91098_().m_215597_(ResourceLocation.parse((String)creditsLocation));){
            p_reader.read(reader);
        }
        catch (Exception var8) {
            LOGGER.error("Couldn't load credits", (Throwable)var8);
        }
    }

    private void addPoemFile(Reader reader) throws IOException {
        int $$4;
        Object $$3;
        BufferedReader $$1 = new BufferedReader(reader);
        RandomSource $$2 = RandomSource.m_216335_((long)8124371L);
        while (($$3 = $$1.readLine()) != null) {
            $$3 = ((String)$$3).replaceAll("PLAYERNAME", this.f_96541_.m_91094_().m_92546_());
            while (($$4 = ((String)$$3).indexOf(OBFUSCATE_TOKEN)) != -1) {
                String $$5 = ((String)$$3).substring(0, $$4);
                String $$6 = ((String)$$3).substring($$4 + OBFUSCATE_TOKEN.length());
                $$3 = $$5 + String.valueOf(ChatFormatting.WHITE) + String.valueOf(ChatFormatting.OBFUSCATED) + "XXXXXXXX".substring(0, $$2.m_188503_(4) + 3) + $$6;
            }
            this.addPoemLines((String)$$3);
            this.addEmptyLine();
        }
        for ($$4 = 0; $$4 < 8; ++$$4) {
            this.addEmptyLine();
        }
    }

    private void addCreditsFile(Reader reader) {
        JsonArray $$1 = GsonHelper.m_144765_((Reader)reader);
        for (JsonElement $$2 : $$1) {
            JsonObject $$3 = $$2.getAsJsonObject();
            String $$4 = $$3.get("section").getAsString();
            this.addCreditsLine(SECTION_HEADING, true);
            this.addCreditsLine((Component)Component.m_237113_((String)$$4).m_130940_(ChatFormatting.YELLOW), true);
            this.addCreditsLine(SECTION_HEADING, true);
            this.addEmptyLine();
            this.addEmptyLine();
            JsonArray $$5 = $$3.getAsJsonArray("disciplines");
            for (JsonElement $$6 : $$5) {
                JsonObject $$7 = $$6.getAsJsonObject();
                String $$8 = $$7.get("discipline").getAsString();
                if (StringUtils.isNotEmpty((CharSequence)$$8)) {
                    this.addCreditsLine((Component)Component.m_237113_((String)$$8).m_130940_(ChatFormatting.YELLOW), true);
                    this.addEmptyLine();
                    this.addEmptyLine();
                }
                JsonArray $$9 = $$7.getAsJsonArray("titles");
                for (JsonElement $$10 : $$9) {
                    JsonObject $$11 = $$10.getAsJsonObject();
                    String $$12 = $$11.get("title").getAsString();
                    JsonArray $$13 = $$11.getAsJsonArray("names");
                    this.addCreditsLine((Component)Component.m_237113_((String)$$12).m_130940_(ChatFormatting.GRAY), false);
                    for (JsonElement $$14 : $$13) {
                        String name = $$14.getAsString();
                        this.addCreditsLine((Component)Component.m_237113_((String)"           ").m_130946_(name.replaceAll("PLAYERNAME", this.f_96541_.m_91094_().m_92546_())).m_130940_(ChatFormatting.WHITE), false);
                    }
                    this.addEmptyLine();
                    this.addEmptyLine();
                }
            }
        }
    }

    private void addEmptyLine() {
        this.lines.add(FormattedCharSequence.f_13691_);
    }

    private void addPoemLines(String text) {
        this.lines.addAll(this.f_96541_.f_91062_.m_92923_((FormattedText)Component.m_237113_((String)text), 256));
    }

    private void addCreditsLine(Component creditsLine, boolean centered) {
        if (centered) {
            this.centeredLines.add(this.lines.size());
        }
        this.lines.add(creditsLine.m_7532_());
    }

    private void renderBg(GuiGraphics guiGraphics) {
        int $$1 = this.f_96543_;
        float $$2 = this.scroll * 0.5f;
        float $$6 = (float)(this.totalScrollLength + this.f_96544_ + this.f_96544_ + 24) / this.unmodifiedScrollSpeed;
        float $$4 = this.scroll / this.unmodifiedScrollSpeed;
        float $$7 = ($$6 - 20.0f - $$4) * 0.005f;
        float $$5 = $$4 * 0.02f;
        if ($$7 < $$5) {
            $$5 = $$7;
        }
        if ($$5 > 1.0f) {
            $$5 = 1.0f;
        }
        $$5 *= $$5;
        $$5 = $$5 * 96.0f / 255.0f;
        guiGraphics.m_280246_($$5, $$5, $$5, 1.0f);
        guiGraphics.m_280398_(BACKGROUND_LOCATION, 0, 0, 0, 0.0f, $$2, $$1, this.f_96544_, 64, 64);
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.scroll = Math.max(0.0f, this.scroll + partialTick * this.scrollSpeed);
        this.renderBg(guiGraphics);
        int $$4 = this.f_96543_ / 2 - 128;
        int $$5 = this.f_96544_ + 50;
        float $$6 = -this.scroll;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, $$6, 0.0f);
        this.logoRenderer.m_280118_(guiGraphics, this.f_96543_, 1.0f, $$5);
        int $$7 = $$5 + 100;
        for (int $$8 = 0; $$8 < this.lines.size(); ++$$8) {
            float $$9;
            if ($$8 == this.lines.size() - 1 && ($$9 = (float)$$7 + $$6 - (float)(this.f_96544_ / 2 - 6)) < 0.0f) {
                guiGraphics.m_280168_().m_252880_(0.0f, -$$9, 0.0f);
            }
            if ((float)$$7 + $$6 + 12.0f + 8.0f > 0.0f && (float)$$7 + $$6 < (float)this.f_96544_) {
                FormattedCharSequence $$10 = this.lines.get($$8);
                if (this.centeredLines.contains($$8)) {
                    guiGraphics.m_280364_(this.f_96547_, $$10, $$4 + 128, $$7, 0xFFFFFF);
                } else {
                    guiGraphics.m_280648_(this.f_96547_, $$10, $$4, $$7, 0xFFFFFF);
                }
            }
            $$7 += 12;
        }
        guiGraphics.m_280168_().m_85849_();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR);
        guiGraphics.m_280398_(VIGNETTE_LOCATION, 0, 0, 0, 0.0f, 0.0f, this.f_96543_, this.f_96544_, this.f_96543_, this.f_96544_);
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    public Music m_278176_() {
        return null;
    }

    @FunctionalInterface
    @OnlyIn(value=Dist.CLIENT)
    static interface CreditsReader {
        public void read(Reader var1) throws IOException;
    }
}

