/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.tcrcore.client.gui;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;

public class ScreenDialogueBuilder {
    private final String name;
    private final String modId;
    private final Set<ChatFormatting> defaultAnsFormats = new HashSet<ChatFormatting>();
    private final Set<ChatFormatting> defaultOptFormats = new HashSet<ChatFormatting>();

    public ScreenDialogueBuilder(String modId, String name) {
        this.name = name;
        this.modId = modId;
    }

    public void setDefaultAnsFormat(ChatFormatting ... formatting) {
        this.defaultAnsFormats.addAll(List.of(formatting));
    }

    public void setDefaultOptFormat(ChatFormatting ... formatting) {
        this.defaultOptFormats.addAll(List.of(formatting));
    }

    public Component ans(int id) {
        Component ans = ScreenDialogueBuilder.screenAns(this.modId, this.name, id);
        if (!this.defaultAnsFormats.isEmpty()) {
            return ans.m_6881_().m_130944_(this.defaultAnsFormats.toArray(new ChatFormatting[0]));
        }
        return ans;
    }

    public Component opt(int id) {
        Component opt = ScreenDialogueBuilder.screenOpt(this.modId, this.name, id);
        if (!this.defaultOptFormats.isEmpty()) {
            return opt.m_6881_().m_130944_(this.defaultOptFormats.toArray(new ChatFormatting[0]));
        }
        return opt;
    }

    public Component name() {
        return ScreenDialogueBuilder.screen(this.modId, this.name);
    }

    public static Component screen(String modId, String name) {
        return Component.m_237115_((String)("screen." + modId + "." + name));
    }

    public static Component screenAns(String modId, String name, int id) {
        return Component.m_237115_((String)("screen." + modId + ".ans." + name + "_" + id));
    }

    public static Component screenOpt(String modId, String name, int id) {
        return Component.m_237115_((String)("screen." + modId + ".opt." + name + "_" + id));
    }
}

