/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.tcrcore.client.gui;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.p1nero.tcrcore.TCRClientConfig;
import com.p1nero.tcrcore.capability.TCRTaskManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CustomGuiderRenderer {
    private static long fadeStartTime = 0L;
    private static boolean hasTask = false;
    private static boolean lastHasTask = false;
    private static float alpha = 0.0f;
    private static final int FADE_DURATION = 30;
    private static Component lastTaskDesc = Component.m_237119_();
    private static int x;
    private static int y;
    private static int textX;
    private static int textY;
    private static long timeSinceStateChange;
    public static final ResourceLocation TASK_ICON;

    public static void tick(LocalPlayer localPlayer) {
        Minecraft minecraft = Minecraft.m_91087_();
        Window window = minecraft.m_91268_();
        long currentTime = localPlayer.m_9236_().m_46467_();
        timeSinceStateChange = currentTime - fadeStartTime;
        hasTask = TCRTaskManager.hasTask((Player)localPlayer);
        if (hasTask != lastHasTask) {
            fadeStartTime = currentTime;
        }
        if (hasTask) {
            lastTaskDesc = TCRTaskManager.getCurrentTaskDesc((Player)localPlayer);
        }
        lastHasTask = hasTask;
        int screenHeight = window.m_85446_();
        int goldenRatioY = (int)((float)screenHeight * 0.382f);
        x = 10 + (Integer)TCRClientConfig.TASK_UI_X.get();
        y = goldenRatioY + (Integer)TCRClientConfig.TASK_UI_Y.get();
        textX = x + 20;
        textY = y + 4;
    }

    public static void render(LocalPlayer localPlayer, GuiGraphics guiGraphics, Window window, float partialTick) {
        Minecraft minecraft = Minecraft.m_91087_();
        float interpolatedTime = (float)timeSinceStateChange + partialTick;
        alpha = hasTask ? (interpolatedTime < 30.0f ? interpolatedTime / 30.0f : 1.0f) : (interpolatedTime < 30.0f ? 1.0f - interpolatedTime / 30.0f : 0.0f);
        if (alpha <= 0.0f || lastTaskDesc == null || lastTaskDesc.getString().isEmpty()) {
            return;
        }
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(0.93f, 0.93f, 0.93f);
        RenderSystem.enableBlend();
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, alpha);
        guiGraphics.m_280163_(TASK_ICON, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
        int textColor = (int)(alpha * 255.0f) << 24 | 0xFFFFFF;
        guiGraphics.m_280614_(minecraft.f_91062_, lastTaskDesc, textX, textY, textColor, true);
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.disableBlend();
        guiGraphics.m_280168_().m_85849_();
    }

    public static void reset() {
        fadeStartTime = 0L;
        alpha = 0.0f;
        hasTask = false;
        lastHasTask = false;
        lastTaskDesc = Component.m_237119_();
    }

    static {
        TASK_ICON = ResourceLocation.fromNamespaceAndPath((String)"tcrcore", (String)"textures/gui/task_icon.png");
    }
}

