/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.tcrcore.client.gui;

import com.p1nero.tcrcore.block.custom.AbstractAltarBlock;
import com.p1nero.tcrcore.block.entity.AbstractAltarBlockEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class BlockTooltipHandler {
    private static final Map<Block, List<Component>> BLOCK_TOOLTIPS = new ConcurrentHashMap<Block, List<Component>>();
    private static final int TOOLTIP_MARGIN = 5;
    private static final int LINE_SPACING = 2;
    private static final int BACKGROUND_COLOR = -872415232;
    private static final int BORDER_COLOR = -1;
    private static final int TEXT_COLOR = -1;

    public static void registerBlockTooltip(RegistryObject<Block> block, List<Component> tooltips) {
        if (block != null && tooltips != null && !tooltips.isEmpty()) {
            BLOCK_TOOLTIPS.put((Block)block.get(), new ArrayList<Component>(tooltips));
        }
    }

    public static void registerBlockTooltip(RegistryObject<Block> block, Component ... tooltips) {
        if (tooltips != null && tooltips.length > 0) {
            BlockTooltipHandler.registerBlockTooltip(block, Arrays.asList(tooltips));
        }
    }

    public static void removeBlockTooltip(RegistryObject<Block> block) {
        if (block != null) {
            BLOCK_TOOLTIPS.remove(block.get());
        }
    }

    public static void clearAllTooltips() {
        BLOCK_TOOLTIPS.clear();
    }

    @SubscribeEvent
    public static void onRenderGuiOverlay(RenderGuiOverlayEvent.Post event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ == null || minecraft.f_91080_ != null) {
            return;
        }
        HitResult hitResult = minecraft.f_91077_;
        if (hitResult == null || hitResult.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        BlockHitResult blockHitResult = (BlockHitResult)hitResult;
        BlockPos blockPos = blockHitResult.m_82425_();
        Block block = minecraft.f_91073_.m_8055_(blockPos).m_60734_();
        List<Component> tooltips = BLOCK_TOOLTIPS.get(block);
        if (tooltips == null || tooltips.isEmpty()) {
            return;
        }
        if (block instanceof AbstractAltarBlock) {
            AbstractAltarBlockEntity entity;
            AbstractAltarBlock abstractAltarBlock = (AbstractAltarBlock)block;
            BlockEntity blockEntity = minecraft.f_91073_.m_7702_(blockPos);
            if (blockEntity instanceof AbstractAltarBlockEntity && !(entity = (AbstractAltarBlockEntity)blockEntity).isActivated()) {
                return;
            }
        }
        BlockTooltipHandler.renderTooltip(event.getGuiGraphics(), tooltips, minecraft);
    }

    private static void renderTooltip(GuiGraphics guiGraphics, List<Component> tooltips, Minecraft minecraft) {
        Font font = minecraft.f_91062_;
        int maxWidth = 0;
        int totalHeight = 0;
        for (Component line : tooltips) {
            int lineWidth = font.m_92852_((FormattedText)line);
            maxWidth = Math.max(maxWidth, lineWidth);
            Objects.requireNonNull(font);
            totalHeight += 9 + 2;
        }
        int tooltipWidth = maxWidth + 10;
        int tooltipHeight = (totalHeight -= 2) + 10;
        int screenWidth = minecraft.m_91268_().m_85445_();
        int screenHeight = minecraft.m_91268_().m_85446_();
        int posX = screenWidth / 2 + 20;
        int posY = screenHeight / 2;
        guiGraphics.m_280509_(posX, posY, posX + tooltipWidth, posY + tooltipHeight, -872415232);
        guiGraphics.m_280637_(posX, posY, tooltipWidth, tooltipHeight, -1);
        int textY = posY + 5;
        for (Component line : tooltips) {
            int textX = posX + 5;
            guiGraphics.m_280614_(font, line, textX, textY, -1, false);
            Objects.requireNonNull(font);
            textY += 9 + 2;
        }
    }
}

