/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.tcrcore.capability;

import com.p1nero.tcrcore.capability.PlayerDataManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class TCRTaskManager {
    public static final int NO_TASK = 0;
    public static final String PRE = "tcrcore.task_desc.";
    public static final List<Task> TASKS = new ArrayList<Task>();
    public static int id = 0;
    public static Task EMPTY;
    public static Task KILL_PILLAGER;
    public static Task GIVE_ORACLE_TO_KEEPER;
    public static Task BACK_TO_KEEPER;
    public static Task FIND_GODNESS_STATUE;
    public static Task FIND_ARTERIUS;
    public static Task LIGHT_ALL_ALTAR;
    public static Task GO_TO_OVERWORLD;

    public static void init() {
        TASKS.clear();
        EMPTY = TCRTaskManager.createTask("empty");
        KILL_PILLAGER = TCRTaskManager.createTask("kill_pillager");
        GIVE_ORACLE_TO_KEEPER = TCRTaskManager.createTask("give_oracle_to_keeper");
        BACK_TO_KEEPER = TCRTaskManager.createTask("back_to_keeper");
        FIND_GODNESS_STATUE = TCRTaskManager.createTask("find_godness_statue");
        FIND_ARTERIUS = TCRTaskManager.createTask("find_arterius");
        LIGHT_ALL_ALTAR = TCRTaskManager.createTask("light_all_altar");
        GO_TO_OVERWORLD = TCRTaskManager.createTask("go_to_overworld");
    }

    public static Task createTask(String desc) {
        Task task = new Task(id++, PRE + desc);
        TASKS.add(task);
        return task;
    }

    public static boolean hasTask(Player player) {
        return PlayerDataManager.currentTaskId.get(player) != 0.0;
    }

    public static Component getCurrentTaskDesc(Player player) {
        if (!TCRTaskManager.hasTask(player)) {
            return Component.m_237119_();
        }
        int id = PlayerDataManager.currentTaskId.getInt(player);
        if (id >= 0 && id < TASKS.size()) {
            return TCRTaskManager.TASKS.get((int)id).componentDesc;
        }
        return Component.m_237119_();
    }

    public static void clearTask(ServerPlayer player) {
        PlayerDataManager.currentTaskId.put((Player)player, 0);
    }

    public static class Task {
        private final int id;
        private final String desc;
        private final Component componentDesc;

        public Task(int id, String desc) {
            this.id = id;
            this.desc = desc;
            this.componentDesc = Component.m_237115_((String)desc);
        }

        public void start(ServerPlayer player) {
            TCRTaskManager.clearTask(player);
            PlayerDataManager.currentTaskId.put((Player)player, this.id);
        }

        public void finish(ServerPlayer player) {
            if (PlayerDataManager.currentTaskId.get((Player)player) == (double)this.id) {
                TCRTaskManager.clearTask(player);
            }
        }

        public Component getComponentDesc() {
            return this.componentDesc;
        }

        public String getDesc() {
            return this.desc;
        }

        public int getId() {
            return this.id;
        }
    }
}

