/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.tcrcore.capability;

import com.github.L_Ender.cataclysm.init.ModItems;
import com.p1nero.fast_tpa.network.PacketRelay;
import com.p1nero.tcrcore.TCRCoreMod;
import com.p1nero.tcrcore.capability.PlayerDataManager;
import com.p1nero.tcrcore.capability.TCRTaskManager;
import com.p1nero.tcrcore.datagen.TCRAdvancementData;
import com.p1nero.tcrcore.item.TCRItems;
import com.p1nero.tcrcore.network.TCRPacketHandler;
import com.p1nero.tcrcore.network.packet.clientbound.OpenEndScreenPacket;
import com.p1nero.tcrcore.network.packet.clientbound.SyncTCRPlayerPacket;
import com.p1nero.tcrcore.save_data.TCRMainLevelSaveData;
import com.p1nero.tcrcore.utils.ItemUtil;
import com.p1nero.tcrcore.utils.WaypointUtil;
import com.p1nero.tcrcore.utils.WorldUtil;
import com.yesman.epicskills.registry.entry.EpicSkillsItems;
import dev.ftb.mods.ftbquests.item.FTBQuestsItems;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.simple.SimpleChannel;
import net.shelmarow.nightfall_invade.entity.spear_knight.Arterius;
import org.jetbrains.annotations.Nullable;
import org.merlin204.wraithon.entity.WraithonEntities;
import org.merlin204.wraithon.entity.wraithon.WraithonEntity;
import org.merlin204.wraithon.worldgen.WraithonDimensions;
import xaero.hud.minimap.waypoint.WaypointColor;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;

public class TCRPlayer {
    public static final String PLAYER_NAME = "player_name";
    private CompoundTag data = new CompoundTag();
    private double healthAdder = 0.0;
    private int tickAfterBossDieLeft;
    private int tickAfterBless;
    private int tickAfterTpToOverworld;
    private int tickAfterStartArterius;
    private boolean needToMarkMapInOverworld;
    private Arterius arterius;
    private BlockPos blessPos;
    private Item blessItem;
    private int spawnParticleTimer = 0;
    private final int particleCount = 20;
    private Vec3 from = Vec3.f_82478_;
    private Vec3 dir = Vec3.f_82478_;
    private PathfinderMob currentTalkingEntity;

    public void setTickAfterTpToOverworld(int tickAfterTpToOverworld) {
        this.tickAfterTpToOverworld = tickAfterTpToOverworld;
    }

    public void setTickAfterStartArterius(int tickAfterStartArterius) {
        this.tickAfterStartArterius = tickAfterStartArterius;
    }

    public void setArterius(Arterius arterius) {
        this.arterius = arterius;
    }

    public void setTickAfterBless(int tickAfterBless) {
        this.tickAfterBless = tickAfterBless;
    }

    public void setBlessItem(Item blessItem) {
        this.blessItem = blessItem;
    }

    public void setNeedToMarkMapInOverworld(boolean needToMarkMapInOverworld) {
        this.needToMarkMapInOverworld = needToMarkMapInOverworld;
    }

    public boolean inBlessing() {
        return this.tickAfterBless > 1;
    }

    public void setBlessPos(BlockPos blessPos) {
        this.blessPos = blessPos;
    }

    public void setTickAfterBossDieLeft(int tickAfterBossDieLeft) {
        this.tickAfterBossDieLeft = tickAfterBossDieLeft;
    }

    public int getTickAfterBossDieLeft() {
        return this.tickAfterBossDieLeft;
    }

    public void setCurrentTalkingEntity(@Nullable PathfinderMob currentTalkingEntity) {
        this.currentTalkingEntity = currentTalkingEntity;
    }

    @Nullable
    public PathfinderMob getCurrentTalkingEntity() {
        return this.currentTalkingEntity;
    }

    public boolean getBoolean(String key) {
        return this.data.m_128471_(key);
    }

    public double getDouble(String key) {
        return this.data.m_128459_(key);
    }

    public String getString(String key) {
        return this.data.m_128461_(key);
    }

    public void putBoolean(String key, boolean value) {
        this.data.m_128379_(key, value);
    }

    public void putDouble(String key, double v) {
        this.data.m_128347_(key, v);
    }

    public void putString(String k, String v) {
        this.data.m_128359_(k, v);
    }

    public CompoundTag getData() {
        return this.data;
    }

    public CompoundTag saveNBTData(CompoundTag tag) {
        tag.m_128365_("customDataManager", (Tag)this.data);
        tag.m_128347_("healthAdder", this.healthAdder);
        tag.m_128405_("tickAfterBossDieLeft", this.tickAfterBossDieLeft);
        tag.m_128405_("tickAfterTpToOverworld", this.tickAfterTpToOverworld);
        tag.m_128405_("tickAfterBless", this.tickAfterBless);
        tag.m_128379_("needToMarkMapInOverworld", this.needToMarkMapInOverworld);
        return tag;
    }

    public void loadNBTData(CompoundTag tag) {
        this.data = tag.m_128469_("customDataManager");
        this.healthAdder = tag.m_128459_("healthAdder");
        this.tickAfterBossDieLeft = tag.m_128451_("tickAfterBossDieLeft");
        this.tickAfterBless = tag.m_128451_("tickAfterBless");
        this.tickAfterTpToOverworld = tag.m_128451_("tickAfterTpToOverworld");
        this.needToMarkMapInOverworld = tag.m_128471_("needToMarkMapInOverworld");
    }

    public void copyFrom(TCRPlayer old) {
        this.data = old.data;
        this.healthAdder = old.healthAdder;
        this.tickAfterBossDieLeft = old.tickAfterBossDieLeft;
        this.tickAfterBless = old.tickAfterBless;
        this.needToMarkMapInOverworld = old.needToMarkMapInOverworld;
        this.tickAfterTpToOverworld = old.tickAfterTpToOverworld;
    }

    public void tryMarkMapInOverworld(ServerPlayer serverPlayer) {
        if (!PlayerDataManager.pillagerKilled.get((Player)serverPlayer).booleanValue()) {
            TCRTaskManager.clearTask(serverPlayer);
            TCRTaskManager.KILL_PILLAGER.start(serverPlayer);
        }
        if (this.needToMarkMapInOverworld && serverPlayer.m_284548_().m_46472_() == Level.f_46428_) {
            int stage = PlayerDataManager.stage.getInt((Player)serverPlayer);
            int newStage = stage + 1;
            if (newStage > 5) {
                return;
            }
            TCRAdvancementData.finishAdvancement("stage" + newStage, serverPlayer);
            PlayerDataManager.stage.put((Player)serverPlayer, Double.valueOf(newStage));
            if (!PlayerDataManager.mapMarked.get((Player)serverPlayer).booleanValue()) {
                ItemUtil.addItem((Player)serverPlayer, (Item)FTBQuestsItems.BOOK.get(), 1);
                PlayerDataManager.mapMarked.put((Player)serverPlayer, true);
            }
            CompletableFuture.supplyAsync(() -> {
                BlockPos pos = null;
                try {
                    pos = switch (newStage) {
                        case 1 -> WorldUtil.getNearbyStructurePos(serverPlayer, "trek:overworld/very_rare/floating_farm_large", 230);
                        case 2 -> WorldUtil.getNearbyStructurePos(serverPlayer, "ribbits:ribbit_village", 145);
                        case 3 -> WorldUtil.getNearbyStructurePos(serverPlayer, "dodosmobs:jungle_prison", 64);
                        case 4 -> WorldUtil.getNearbyStructurePos(serverPlayer, "aquamirae:ship", 64);
                        case 5 -> WorldUtil.getNearbyStructurePos(serverPlayer, "tcrcore:underworld_arena", 95);
                        default -> pos;
                    };
                }
                catch (Exception e) {
                    System.err.println("TCRCore : Error finding structure for stage " + newStage + ": " + e.getMessage());
                }
                return pos;
            }).thenAccept(pos -> {
                if (pos != null) {
                    switch (newStage) {
                        case 1: {
                            WaypointUtil.sendWaypoint(serverPlayer, TCRCoreMod.getInfoKey("storm_pos"), pos, WaypointColor.AQUA);
                            break;
                        }
                        case 2: {
                            TCRMainLevelSaveData.get(serverPlayer.m_284548_()).setAbyssPos((BlockPos)pos);
                            WaypointUtil.sendWaypoint(serverPlayer, TCRCoreMod.getInfoKey("abyss_pos"), pos, WaypointColor.DARK_BLUE);
                            break;
                        }
                        case 3: {
                            WaypointUtil.sendWaypoint(serverPlayer, TCRCoreMod.getInfoKey("desert_pos"), pos, WaypointColor.YELLOW);
                            break;
                        }
                        case 4: {
                            WaypointUtil.sendWaypoint(serverPlayer, TCRCoreMod.getInfoKey("cursed_pos"), pos, WaypointColor.BLUE);
                            break;
                        }
                        case 5: {
                            WaypointUtil.sendWaypoint(serverPlayer, TCRCoreMod.getInfoKey("flame_pos"), pos, WaypointColor.RED);
                        }
                    }
                    this.from = serverPlayer.m_146892_();
                    Vec3 target = new Vec3((double)pos.m_123341_(), serverPlayer.m_20188_(), (double)pos.m_123342_());
                    this.dir = target.m_82546_(this.from).m_82541_();
                }
                if (stage <= 5) {
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetTitleTextPacket((Component)TCRCoreMod.getInfo("press_to_open_map")));
                }
                serverPlayer.m_9236_().m_6263_(null, serverPlayer.m_20185_(), serverPlayer.m_20186_(), serverPlayer.m_20189_(), SoundEvents.f_11860_, serverPlayer.m_5720_(), 1.0f, 1.0f);
                this.spawnParticleTimer = 20;
                this.needToMarkMapInOverworld = false;
                if (stage <= 3) {
                    serverPlayer.m_5661_((Component)TCRCoreMod.getInfo("unlock_new_ftb_page"), false);
                }
                TCRTaskManager.GO_TO_OVERWORLD.finish(serverPlayer);
            });
        }
    }

    public void syncToClient(ServerPlayer serverPlayer) {
        PacketRelay.sendToPlayer((SimpleChannel)TCRPacketHandler.INSTANCE, (Object)new SyncTCRPlayerPacket(this.saveNBTData(new CompoundTag())), (ServerPlayer)serverPlayer);
    }

    public void tick(Player player) {
        if (!player.m_7578_() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ServerLevel serverLevel = serverPlayer.m_284548_();
            this.handleTalking(serverPlayer);
            this.handleAfterBossFight(serverPlayer);
            this.handleBless(serverLevel, serverPlayer);
            this.handleArtelus(serverPlayer);
            this.handleMarkMap(serverPlayer);
            this.handleParticle(serverPlayer);
        }
    }

    private void handleMarkMap(ServerPlayer serverPlayer) {
        if (this.tickAfterTpToOverworld > 0) {
            --this.tickAfterTpToOverworld;
            if (this.tickAfterTpToOverworld == 0) {
                this.tryMarkMapInOverworld(serverPlayer);
            }
        }
    }

    private void handleParticle(ServerPlayer serverPlayer) {
        double step = 0.25;
        if (this.spawnParticleTimer > 0) {
            --this.spawnParticleTimer;
            for (int i = 20 - this.spawnParticleTimer; i <= 20; ++i) {
                SimpleParticleType particle = ParticleTypes.f_123810_;
                double distance = (double)i * step;
                Vec3 particlePos = this.from.m_82549_(this.dir.m_82490_(distance).m_82520_(0.0, (double)i * 0.1, 0.0));
                serverPlayer.m_284548_().m_8767_((ParticleOptions)particle, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 0, this.dir.f_82479_, this.dir.f_82480_, this.dir.f_82481_, (double)0.1f);
            }
        }
    }

    private void handleArtelus(ServerPlayer player) {
        if (this.tickAfterStartArterius > 0) {
            --this.tickAfterStartArterius;
            if (this.arterius == null) {
                return;
            }
            this.arterius.m_21563_().m_148051_((Entity)player);
            if (this.tickAfterStartArterius % 20 == 0) {
                if (this.tickAfterStartArterius / 20 == 0) {
                    player.f_8906_.m_9829_((Packet)new ClientboundSetTitleTextPacket((Component)Component.m_237113_((String)"Go!").m_130940_(ChatFormatting.RED)));
                    player.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(BuiltInRegistries.f_256894_.m_263177_((Object)SoundEvents.f_11668_), SoundSource.PLAYERS, player.m_20185_(), player.m_20186_(), player.m_20189_(), 1.0f, 1.0f, (long)player.m_217043_().m_188502_()));
                } else {
                    player.f_8906_.m_9829_((Packet)new ClientboundSetTitleTextPacket((Component)Component.m_237113_((String)("" + this.tickAfterStartArterius / 20)).m_130940_(ChatFormatting.RED)));
                    player.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(BuiltInRegistries.f_256894_.m_263177_((Object)SoundEvents.f_11668_), SoundSource.PLAYERS, player.m_20185_(), player.m_20186_(), player.m_20189_(), 1.0f, 1.0f, (long)player.m_217043_().m_188502_()));
                }
            }
            if (this.tickAfterStartArterius == 0) {
                this.arterius.setInBattle(true);
                this.arterius.m_6710_((LivingEntity)player);
            }
        }
    }

    private void handleTalking(ServerPlayer player) {
        if (this.currentTalkingEntity != null && this.currentTalkingEntity.m_6084_()) {
            this.currentTalkingEntity.m_21563_().m_148051_((Entity)player);
            this.currentTalkingEntity.m_21573_().m_26573_();
            if (this.currentTalkingEntity.m_20270_((Entity)player) > 8.0f) {
                this.currentTalkingEntity = null;
            }
        }
    }

    private void handleAfterBossFight(ServerPlayer player) {
        if (this.tickAfterBossDieLeft > 0) {
            --this.tickAfterBossDieLeft;
            new ArrayList<WraithonEntity>(player.f_8924_.m_129880_(WraithonDimensions.SANCTUM_OF_THE_WRAITHON_LEVEL_KEY).m_143280_((EntityTypeTest)WraithonEntities.WRAITHON.get(), wraithonEntity -> !wraithonEntity.isDead())).forEach(Entity::m_146870_);
            if (this.tickAfterBossDieLeft % 40 == 0) {
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11668_, SoundSource.BLOCKS, 0.8f, 0.5f + (float)this.tickAfterBossDieLeft / 400.0f);
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11699_, SoundSource.BLOCKS, 0.8f, 0.5f + (float)this.tickAfterBossDieLeft / 400.0f);
            }
            player.m_5661_((Component)TCRCoreMod.getInfo("second_after_boss_die_left", this.tickAfterBossDieLeft / 20).m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.RED}), true);
            if (this.tickAfterBossDieLeft == 0) {
                PacketRelay.sendToPlayer((SimpleChannel)TCRPacketHandler.INSTANCE, (Object)new OpenEndScreenPacket(), (ServerPlayer)player);
            }
        }
    }

    private void handleBless(ServerLevel serverLevel, ServerPlayer serverPlayer) {
        if (this.tickAfterBless > 0) {
            --this.tickAfterBless;
            if (this.tickAfterBless % 10 == 0) {
                float progress = 1.0f - (float)this.tickAfterBless / 100.0f;
                float pitch = 0.5f + progress * 1.5f;
                serverLevel.m_5594_(null, this.blessPos, SoundEvents.f_144243_, SoundSource.AMBIENT, 3.0f, pitch);
                if (progress > 0.7f) {
                    serverLevel.m_5594_(null, this.blessPos, SoundEvents.f_11737_, SoundSource.AMBIENT, 3.0f, 0.8f + progress * 0.4f);
                }
                double centerX = (double)this.blessPos.m_123341_() + 0.5;
                double centerY = (double)this.blessPos.m_123342_() + 1.0;
                double centerZ = (double)this.blessPos.m_123343_() + 0.5;
                double baseRadius = 2.0;
                double maxRadius = 6.0;
                double currentRadius = baseRadius + (maxRadius - baseRadius) * (double)progress;
                int baseParticleCount = 8;
                int maxParticleCount = 32;
                int currentParticleCount = baseParticleCount + (int)((float)(maxParticleCount - baseParticleCount) * progress);
                for (int i = 0; i < currentParticleCount; ++i) {
                    double angle = Math.PI * 2 * (double)i / (double)currentParticleCount;
                    double x = centerX + currentRadius * Math.cos(angle);
                    double z = centerZ + currentRadius * Math.sin(angle);
                    double y = centerY + serverLevel.f_46441_.m_188500_() * 2.0;
                    double speedX = (centerX - x) * 0.1;
                    double speedZ = (centerZ - z) * 0.1;
                    double speedY = 0.1;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123810_, x, y, z, 1, speedX, speedY, speedZ, 0.05);
                }
                int baseVerticalCount = 4;
                int maxVerticalCount = 12;
                int currentVerticalCount = baseVerticalCount + (int)((float)(maxVerticalCount - baseVerticalCount) * progress);
                double verticalRadius = 1.5 + (double)progress * 2.5;
                for (int i = 0; i < currentVerticalCount; ++i) {
                    double angle = Math.PI * 2 * (double)i / (double)currentVerticalCount;
                    double x = centerX + verticalRadius * Math.cos(angle);
                    double z = centerZ + verticalRadius * Math.sin(angle);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123810_, x, centerY - 1.0, z, 1, 0.0, 0.2, 0.0, 0.02);
                }
                int baseRandomCount = 3;
                int maxRandomCount = 10;
                int currentRandomCount = baseRandomCount + (int)((float)(maxRandomCount - baseRandomCount) * progress);
                for (int i = 0; i < currentRandomCount; ++i) {
                    double offsetX = (serverLevel.f_46441_.m_188500_() - 0.5) * 2.0;
                    double offsetY = serverLevel.f_46441_.m_188500_() * 2.0;
                    double offsetZ = (serverLevel.f_46441_.m_188500_() - 0.5) * 2.0;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123810_, centerX + offsetX, centerY + offsetY, centerZ + offsetZ, 1, 0.0, 0.0, 0.0, 0.1);
                }
            }
            if (this.tickAfterBless == 0) {
                ItemStack item;
                double oldAdder = this.healthAdder;
                ItemStack oracle = ((Item)TCRItems.ANCIENT_ORACLE_FRAGMENT.get()).m_7968_();
                oracle.m_41784_().m_128359_(PLAYER_NAME, serverPlayer.m_36316_().getName());
                ItemStack itemStack = item = this.blessItem == null ? serverPlayer.m_21205_() : this.blessItem.m_7968_();
                if (item.m_150930_((Item)ModItems.STORM_EYE.get()) && PlayerDataManager.stormEyeTraded.get((Player)serverPlayer).booleanValue() && !PlayerDataManager.stormEyeBlessed.get((Player)serverPlayer).booleanValue()) {
                    ItemUtil.addItemEntity((Entity)serverPlayer, oracle, 1, (int)ChatFormatting.LIGHT_PURPLE.m_126665_());
                    this.healthAdder += 2.0;
                    ItemUtil.addItemEntity((Entity)serverPlayer, (Item)EpicSkillsItems.ABILIITY_STONE.get(), 1, (int)ChatFormatting.GOLD.m_126665_());
                    PlayerDataManager.stormEyeBlessed.put((Player)serverPlayer, true);
                } else if (item.m_150930_((Item)ModItems.ABYSS_EYE.get()) && PlayerDataManager.abyssEyeTraded.get((Player)serverPlayer).booleanValue() && !PlayerDataManager.abyssEyeBlessed.get((Player)serverPlayer).booleanValue()) {
                    ItemUtil.addItemEntity((Entity)serverPlayer, oracle, 1, (int)ChatFormatting.LIGHT_PURPLE.m_126665_());
                    this.healthAdder += 2.0;
                    ItemUtil.addItemEntity((Entity)serverPlayer, (Item)EpicSkillsItems.ABILIITY_STONE.get(), 1, (int)ChatFormatting.GOLD.m_126665_());
                    PlayerDataManager.abyssEyeBlessed.put((Player)serverPlayer, true);
                } else if (item.m_150930_((Item)ModItems.DESERT_EYE.get()) && PlayerDataManager.desertEyeTraded.get((Player)serverPlayer).booleanValue() && !PlayerDataManager.desertEyeBlessed.get((Player)serverPlayer).booleanValue()) {
                    ItemUtil.addItemEntity((Entity)serverPlayer, oracle, 1, (int)ChatFormatting.LIGHT_PURPLE.m_126665_());
                    this.healthAdder += 2.0;
                    ItemUtil.addItemEntity((Entity)serverPlayer, (Item)EpicSkillsItems.ABILIITY_STONE.get(), 2, (int)ChatFormatting.GOLD.m_126665_());
                    PlayerDataManager.desertEyeBlessed.put((Player)serverPlayer, true);
                    PlayerDataManager.canEnterNether.put((Player)serverPlayer, true);
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(BuiltInRegistries.f_256894_.m_263177_((Object)SoundEvents.f_11860_), SoundSource.PLAYERS, serverPlayer.m_20185_(), serverPlayer.m_20186_(), serverPlayer.m_20189_(), 1.0f, 1.0f, (long)serverPlayer.m_217043_().m_188502_()));
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetTitleTextPacket((Component)TCRCoreMod.getInfo("nether_unlock").m_130940_(ChatFormatting.RED)));
                } else if (item.m_150930_((Item)ModItems.CURSED_EYE.get()) && PlayerDataManager.cursedEyeTraded.get((Player)serverPlayer).booleanValue() && !PlayerDataManager.cursedEyeBlessed.get((Player)serverPlayer).booleanValue()) {
                    ItemUtil.addItemEntity((Entity)serverPlayer, oracle, 1, (int)ChatFormatting.LIGHT_PURPLE.m_126665_());
                    this.healthAdder += 2.0;
                    ItemUtil.addItemEntity((Entity)serverPlayer, (Item)EpicSkillsItems.ABILIITY_STONE.get(), 3, (int)ChatFormatting.GOLD.m_126665_());
                    PlayerDataManager.cursedEyeBlessed.put((Player)serverPlayer, true);
                    PlayerDataManager.canEnterEnd.put((Player)serverPlayer, true);
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(BuiltInRegistries.f_256894_.m_263177_((Object)SoundEvents.f_11860_), SoundSource.PLAYERS, serverPlayer.m_20185_(), serverPlayer.m_20186_(), serverPlayer.m_20189_(), 1.0f, 1.0f, (long)serverPlayer.m_217043_().m_188502_()));
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetTitleTextPacket((Component)TCRCoreMod.getInfo("end_unlock").m_130940_(ChatFormatting.LIGHT_PURPLE)));
                } else if (item.m_150930_((Item)ModItems.FLAME_EYE.get()) && PlayerDataManager.flameEyeTraded.get((Player)serverPlayer).booleanValue() && !PlayerDataManager.flameEyeBlessed.get((Player)serverPlayer).booleanValue()) {
                    this.healthAdder += 2.0;
                    ItemUtil.addItemEntity((Entity)serverPlayer, (Item)EpicSkillsItems.ABILIITY_STONE.get(), 6, (int)ChatFormatting.GOLD.m_126665_());
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(BuiltInRegistries.f_256894_.m_263177_((Object)SoundEvents.f_11860_), SoundSource.PLAYERS, serverPlayer.m_20185_(), serverPlayer.m_20186_(), serverPlayer.m_20189_(), 1.0f, 1.0f, (long)serverPlayer.m_217043_().m_188502_()));
                    PlayerDataManager.flameEyeBlessed.put((Player)serverPlayer, true);
                } else if (item.m_150930_((Item)ModItems.MONSTROUS_EYE.get()) && !PlayerDataManager.monstEyeBlessed.get((Player)serverPlayer).booleanValue()) {
                    this.healthAdder += 4.0;
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(BuiltInRegistries.f_256894_.m_263177_((Object)SoundEvents.f_11860_), SoundSource.PLAYERS, serverPlayer.m_20185_(), serverPlayer.m_20186_(), serverPlayer.m_20189_(), 1.0f, 1.0f, (long)serverPlayer.m_217043_().m_188502_()));
                    PlayerDataManager.monstEyeBlessed.put((Player)serverPlayer, true);
                } else if (item.m_150930_((Item)ModItems.MECH_EYE.get()) && !PlayerDataManager.mechEyeBlessed.get((Player)serverPlayer).booleanValue()) {
                    this.healthAdder += 4.0;
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(BuiltInRegistries.f_256894_.m_263177_((Object)SoundEvents.f_11860_), SoundSource.PLAYERS, serverPlayer.m_20185_(), serverPlayer.m_20186_(), serverPlayer.m_20189_(), 1.0f, 1.0f, (long)serverPlayer.m_217043_().m_188502_()));
                    PlayerDataManager.mechEyeBlessed.put((Player)serverPlayer, true);
                } else if (item.m_150930_((Item)ModItems.VOID_EYE.get()) && !PlayerDataManager.voidEyeBlessed.get((Player)serverPlayer).booleanValue()) {
                    this.healthAdder += 4.0;
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(BuiltInRegistries.f_256894_.m_263177_((Object)SoundEvents.f_11860_), SoundSource.PLAYERS, serverPlayer.m_20185_(), serverPlayer.m_20186_(), serverPlayer.m_20189_(), 1.0f, 1.0f, (long)serverPlayer.m_217043_().m_188502_()));
                    PlayerDataManager.voidEyeBlessed.put((Player)serverPlayer, true);
                }
                if (oldAdder < this.healthAdder) {
                    this.updateHealth(serverPlayer, true, oldAdder);
                    if (PlayerDataManager.isAllEyeGet((Player)serverPlayer) && !TCRMainLevelSaveData.get(serverLevel).isAllFinish()) {
                        TCRTaskManager.LIGHT_ALL_ALTAR.start(serverPlayer);
                    }
                } else {
                    serverPlayer.m_5661_((Component)TCRCoreMod.getInfo("nothing_happen_after_bless"), false);
                }
            }
        }
    }

    public void updateHealth(ServerPlayer serverPlayer, boolean showTip, double originalAdder) {
        AttributeInstance staminaAttr;
        UUID HEALTH_MODIFIER_UUID = UUID.fromString("11451419-1981-0234-1234-123456789abc");
        float preHealth = serverPlayer.m_21223_();
        float preMaxHealth = serverPlayer.m_21233_();
        AttributeInstance maxHealthAttr = serverPlayer.m_21051_(Attributes.f_22276_);
        if (maxHealthAttr != null) {
            maxHealthAttr.m_22120_(HEALTH_MODIFIER_UUID);
            AttributeModifier healthModifier = new AttributeModifier(HEALTH_MODIFIER_UUID, "health_boost", this.healthAdder, AttributeModifier.Operation.ADDITION);
            maxHealthAttr.m_22125_(healthModifier);
            serverPlayer.m_21153_(preHealth * serverPlayer.m_21233_() / preMaxHealth);
            if (showTip) {
                serverPlayer.m_5661_((Component)Component.m_237115_((String)Attributes.f_22276_.m_22087_()).m_130940_(ChatFormatting.RED).m_130946_(" + " + (this.healthAdder - originalAdder)), false);
            }
        }
        if ((staminaAttr = serverPlayer.m_21051_((Attribute)EpicFightAttributes.MAX_STAMINA.get())) != null) {
            staminaAttr.m_22120_(HEALTH_MODIFIER_UUID);
            AttributeModifier staminaModifier = new AttributeModifier(HEALTH_MODIFIER_UUID, "stamina_boost", this.healthAdder / 2.5, AttributeModifier.Operation.ADDITION);
            staminaAttr.m_22125_(staminaModifier);
            if (showTip) {
                serverPlayer.m_5661_((Component)Component.m_237115_((String)((Attribute)EpicFightAttributes.MAX_STAMINA.get()).m_22087_()).m_130940_(ChatFormatting.GOLD).m_130946_(String.format(" + %.1f", (this.healthAdder - originalAdder) / 2.5)), false);
            }
        }
    }
}

