/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.tcrcore.capability;

import com.p1nero.tcrcore.capability.TCRPlayer;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="tcrcore")
public class TCRCapabilityProvider
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    public static Capability<TCRPlayer> TCR_PLAYER = CapabilityManager.get((CapabilityToken)new CapabilityToken<TCRPlayer>(){});
    private TCRPlayer TCRPlayer = null;
    private final LazyOptional<TCRPlayer> optional = LazyOptional.of(this::createTCRPlayer);

    private TCRPlayer createTCRPlayer() {
        if (this.TCRPlayer == null) {
            this.TCRPlayer = new TCRPlayer();
        }
        return this.TCRPlayer;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction direction) {
        if (capability == TCR_PLAYER) {
            return this.optional.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        this.createTCRPlayer().saveNBTData(tag);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.createTCRPlayer().loadNBTData(tag);
    }

    @SubscribeEvent
    public static void attachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Player player;
        Object object = event.getObject();
        if (object instanceof Player && !(player = (Player)object).getCapability(TCR_PLAYER).isPresent()) {
            event.addCapability(ResourceLocation.fromNamespaceAndPath((String)"tcrcore", (String)"tcr_player"), (ICapabilityProvider)new TCRCapabilityProvider());
        }
    }

    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone event) {
        event.getOriginal().reviveCaps();
        if (event.isWasDeath()) {
            event.getOriginal().getCapability(TCR_PLAYER).ifPresent(oldStore -> event.getEntity().getCapability(TCR_PLAYER).ifPresent(newStore -> {
                newStore.copyFrom((TCRPlayer)oldStore);
                Player patt2835$temp = event.getEntity();
                if (patt2835$temp instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)patt2835$temp;
                    newStore.updateHealth(serverPlayer, false, 0.0);
                }
                newStore.syncToClient((ServerPlayer)event.getEntity());
            }));
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.END)) {
            TCRCapabilityProvider.getTCRPlayer(event.player).tick(event.player);
        }
    }

    @SubscribeEvent
    public static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.register(TCRPlayer.class);
    }

    public static TCRPlayer getTCRPlayer(Player player) {
        if (player == null) {
            return new TCRPlayer();
        }
        return (TCRPlayer)player.getCapability(TCR_PLAYER).orElse((Object)new TCRPlayer());
    }

    public static void syncPlayerDataToClient(ServerPlayer serverPlayer) {
        TCRCapabilityProvider.getTCRPlayer((Player)serverPlayer).syncToClient(serverPlayer);
    }
}

