/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.tcrcore.capability;

import com.p1nero.fast_tpa.network.PacketRelay;
import com.p1nero.tcrcore.capability.TCRCapabilityProvider;
import com.p1nero.tcrcore.capability.TCRPlayer;
import com.p1nero.tcrcore.network.TCRPacketHandler;
import com.p1nero.tcrcore.network.packet.clientbound.PersistentBoolDataSyncPacket;
import com.p1nero.tcrcore.network.packet.clientbound.PersistentDoubleDataSyncPacket;
import com.p1nero.tcrcore.network.packet.clientbound.PersistentStringDataSyncPacket;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.simple.SimpleChannel;

public class PlayerDataManager {
    private static final Set<String> EXISTING_ID = new HashSet<String>();
    public static DoubleData stage = new DoubleData("stage", 0.0);
    public static DoubleData currentTaskId = new DoubleData("currentTaskId", 0.0);
    public static BoolData wraithonKilled = new BoolData("wraithonKilled", false);
    public static BoolData boatGet = new BoolData("boat_get", false);
    public static BoolData letterGet = new BoolData("letterGet", false);
    public static BoolData tudigongGiftGet = new BoolData("tudigongGiftGet", false);
    public static BoolData arteriusKilled = new BoolData("arteriusKilled", false);
    public static BoolData canEnterNether = new BoolData("canEnterNether", false);
    public static BoolData canEnterEnd = new BoolData("canEnterEnd", false);
    public static BoolData netherEntered = new BoolData("netherEntered", false);
    public static BoolData endEntered = new BoolData("endEntered", false);
    public static BoolData swordSoaringUnlocked = new BoolData("sword_soaring_avoid_unlocked", false);
    public static BoolData fireAvoidUnlocked = new BoolData("fire_avoid_unlocked", false);
    public static BoolData waterAvoidUnlocked = new BoolData("water_avoid_unlocked", false);
    public static BoolData bllSummoned = new BoolData("bll_summoned", false);
    public static BoolData firstJoint = new BoolData("first_joint", false);
    public static BoolData wayStoneInteracted = new BoolData("way_stone_interacted", false);
    public static BoolData dodged = new BoolData("dodged", false);
    public static BoolData parried = new BoolData("parried", false);
    public static BoolData locked = new BoolData("locked", false);
    public static BoolData tutorial_passed = new BoolData("tutorial_passed", false);
    public static BoolData weapon_innate_used = new BoolData("weapon_innate_used", false);
    public static BoolData pillagerKilled = new BoolData("pillager_killed", false);
    public static BoolData mapMarked = new BoolData("map_marked", false);
    public static BoolData stormEyeTraded = new BoolData("storm_eye_traded", false);
    public static BoolData flameEyeTraded = new BoolData("flame_eye_traded", false);
    public static BoolData abyssEyeTraded = new BoolData("abyss_eye_traded", false);
    public static BoolData cursedEyeTraded = new BoolData("cursed_eye_traded", false);
    public static BoolData desertEyeTraded = new BoolData("desert_eye_traded", false);
    public static BoolData mechEyeTraded = new BoolData("mech_eye_traded", false);
    public static BoolData voidEyeTraded = new BoolData("void_eye_traded", false);
    public static BoolData monstEyeTraded = new BoolData("monst_eye_traded", false);
    public static BoolData stormEyeKilled = new BoolData("storm_eye_killed", false);
    public static BoolData flameEyeKilled = new BoolData("flame_eye_killed", false);
    public static BoolData abyssEyeKilled = new BoolData("abyss_eye_killed", false);
    public static BoolData cursedEyeKilled = new BoolData("cursed_eye_killed", false);
    public static BoolData desertEyeKilled = new BoolData("desert_eye_killed", false);
    public static BoolData mechEyeKilled = new BoolData("mech_eye_killed", false);
    public static BoolData voidEyeKilled = new BoolData("void_eye_killed", false);
    public static BoolData monstEyeKilled = new BoolData("monst_eye_killed", false);
    public static BoolData stormEyeBlessed = new BoolData("stormEyeBlessed", false);
    public static BoolData abyssEyeBlessed = new BoolData("abyssEyeBlessed", false);
    public static BoolData desertEyeBlessed = new BoolData("desertEyeBlessed", false);
    public static BoolData cursedEyeBlessed = new BoolData("cursedEyeBlessed", false);
    public static BoolData flameEyeBlessed = new BoolData("flameEyeBlessed", false);
    public static BoolData mechEyeBlessed = new BoolData("mechEyeBlessed", false);
    public static BoolData monstEyeBlessed = new BoolData("monstEyeBlessed", false);
    public static BoolData voidEyeBlessed = new BoolData("voidEyeBlessed", false);

    public static boolean canGetInvite(Player player) {
        return mechEyeTraded.get(player) != false && monstEyeTraded.get(player) != false && voidEyeTraded.get(player) != false;
    }

    public static boolean canGetInviteTip(Player player) {
        return mechEyeKilled.get(player) != false && monstEyeKilled.get(player) != false && voidEyeKilled.get(player) != false;
    }

    public static boolean isAllEyeGet(Player player) {
        return stormEyeTraded.get(player) != false && flameEyeTraded.get(player) != false && abyssEyeTraded.get(player) != false && cursedEyeTraded.get(player) != false && desertEyeTraded.get(player) != false;
    }

    public static boolean isAllAltarKilled(Player player) {
        return stormEyeKilled.get(player) != false && flameEyeKilled.get(player) != false && abyssEyeKilled.get(player) != false && cursedEyeKilled.get(player) != false && desertEyeKilled.get(player) != false;
    }

    public static void putData(Player player, String key, double value) {
        PlayerDataManager.getTCRPlayer(player).putDouble(key, value);
    }

    public static void putData(Player player, String key, String value) {
        PlayerDataManager.getTCRPlayer(player).putString(key, value);
    }

    public static void putData(Player player, String key, boolean value) {
        PlayerDataManager.getTCRPlayer(player).putBoolean(key, value);
    }

    public static boolean getBool(Player player, String key) {
        return PlayerDataManager.getTCRPlayer(player).getBoolean(key);
    }

    public static double getDouble(Player player, String key) {
        return PlayerDataManager.getTCRPlayer(player).getDouble(key);
    }

    public static String getString(Player player, String key) {
        return PlayerDataManager.getTCRPlayer(player).getString(key);
    }

    public static TCRPlayer getTCRPlayer(Player player) {
        return TCRCapabilityProvider.getTCRPlayer(player);
    }

    public static class BoolData
    extends Data<Boolean> {
        boolean defaultBool;

        public BoolData(String key, boolean defaultBool) {
            super(key);
            this.defaultBool = defaultBool;
        }

        @Override
        public void init(Player player) {
            this.isLocked = PlayerDataManager.getTCRPlayer(player).getBoolean(this.key + "isLocked");
            this.put(player, this.defaultBool);
        }

        @Override
        public void put(Player player, Boolean value) {
            if (this.isLocked(player)) {
                return;
            }
            PlayerDataManager.getTCRPlayer(player).putBoolean(this.key, value);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                PacketRelay.sendToPlayer((SimpleChannel)TCRPacketHandler.INSTANCE, (Object)new PersistentBoolDataSyncPacket(this.key, this.isLocked, value), (ServerPlayer)serverPlayer);
            } else {
                PacketRelay.sendToServer((SimpleChannel)TCRPacketHandler.INSTANCE, (Object)new PersistentBoolDataSyncPacket(this.key, this.isLocked, value));
            }
        }

        @Override
        public Boolean get(Player player) {
            return PlayerDataManager.getTCRPlayer(player).getBoolean(this.key);
        }

        public boolean get(CompoundTag playerData) {
            return playerData.m_128471_(this.key);
        }
    }

    public static class DoubleData
    extends Data<Double> {
        private final double defaultValue;

        public DoubleData(String key, double defaultValue) {
            super(key);
            this.defaultValue = defaultValue;
        }

        @Override
        public void init(Player player) {
            this.isLocked = PlayerDataManager.getTCRPlayer(player).getBoolean(this.key + "isLocked");
            this.put(player, this.defaultValue);
        }

        @Override
        public void put(Player player, Integer value) {
            this.put(player, value.doubleValue());
        }

        @Override
        public void put(Player player, Double value) {
            if (!this.isLocked(player)) {
                PlayerDataManager.getTCRPlayer(player).putDouble(this.key, value);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    PacketRelay.sendToPlayer((SimpleChannel)TCRPacketHandler.INSTANCE, (Object)new PersistentDoubleDataSyncPacket(this.key, this.isLocked, value), (ServerPlayer)serverPlayer);
                }
            }
        }

        public int getInt(Player player) {
            return this.get(player).intValue();
        }

        @Override
        public Double get(Player player) {
            return PlayerDataManager.getTCRPlayer(player).getDouble(this.key);
        }

        public double get(CompoundTag playerData) {
            return playerData.m_128459_(this.key);
        }
    }

    public static class StringData
    extends Data<String> {
        protected boolean isLocked = false;
        protected String defaultString;

        public StringData(String key, String defaultString) {
            super(key);
            this.defaultString = defaultString;
        }

        @Override
        public void init(Player player) {
            this.put(player, this.defaultString);
        }

        @Override
        public void put(Player player, String value) {
            if (!this.isLocked(player)) {
                PlayerDataManager.getTCRPlayer(player).putString(this.key, value);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    PacketRelay.sendToPlayer((SimpleChannel)TCRPacketHandler.INSTANCE, (Object)new PersistentStringDataSyncPacket(this.key, this.isLocked, value), (ServerPlayer)serverPlayer);
                }
            }
        }

        @Override
        public String get(Player player) {
            return PlayerDataManager.getTCRPlayer(player).getString(this.key);
        }

        public String get(CompoundTag playerData) {
            return playerData.m_128461_(this.key);
        }
    }

    public static abstract class Data<T> {
        protected String key;
        protected boolean isLocked = false;
        protected int id;

        public Data(String key) {
            if (EXISTING_ID.contains(key)) {
                throw new IllegalArgumentException(key + " is already exist!");
            }
            this.key = key;
            EXISTING_ID.add(key);
        }

        public String getKey() {
            return this.key;
        }

        public void init(Player player) {
            this.isLocked = PlayerDataManager.getTCRPlayer(player).getBoolean(this.key + "isLocked");
        }

        public boolean isLocked(Player player) {
            return PlayerDataManager.getTCRPlayer(player).getBoolean(this.key + "isLocked");
        }

        public boolean isLocked(CompoundTag playerData) {
            return playerData.m_128471_(this.key + "isLocked");
        }

        public void lock(Player player) {
            PlayerDataManager.getTCRPlayer(player).putBoolean(this.key + "isLocked", true);
            this.isLocked = true;
        }

        public void unLock(Player player) {
            PlayerDataManager.getTCRPlayer(player).putBoolean(this.key + "isLocked", false);
            LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
            this.isLocked = false;
        }

        public abstract T get(Player var1);

        public abstract void put(Player var1, T var2);
    }
}

