/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.tcrcore.block.entity;

import com.github.L_Ender.cataclysm.init.ModItems;
import com.p1nero.cataclysm_dimension.worldgen.CataclysmDimensions;
import com.p1nero.cataclysm_dimension.worldgen.portal.CDNetherTeleporter;
import com.p1nero.cataclysm_dimension.worldgen.portal.CDTeleporter;
import com.p1nero.tcrcore.TCRCoreMod;
import com.p1nero.tcrcore.capability.TCRTaskManager;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractAltarBlockEntity
extends BlockEntity {
    protected final Item itemInnate;
    protected boolean isActivated;

    public AbstractAltarBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState, Item item) {
        super(type, pos, blockState);
        this.itemInnate = item;
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        this.isActivated = tag.m_128471_("isActivated");
        super.m_142466_(tag);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag compoundTag = super.m_5995_();
        this.m_183515_(compoundTag);
        return compoundTag;
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        tag.m_128379_("isActivated", this.isActivated);
        super.m_183515_(tag);
    }

    public boolean isActivated() {
        return this.isActivated;
    }

    public Item getItemInnate() {
        return this.itemInnate;
    }

    public void sync() {
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
        this.m_6596_();
    }

    public void onPlayerInteract(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Player pPlayer, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHit) {
        ItemStack mainHandItem;
        if (pLevel.f_46443_) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)pLevel;
        TCRTaskManager.LIGHT_ALL_ALTAR.finish((ServerPlayer)pPlayer);
        MinecraftServer minecraftServer = pPlayer.m_20194_();
        if (minecraftServer == null) {
            return;
        }
        if (this.isActivated) {
            ServerLevel level;
            if (!pPlayer.m_7500_() && !this.checkEyeFound(pPlayer)) {
                pPlayer.m_5661_((Component)TCRCoreMod.getInfo("can_not_enter_before_finish"), false);
                return;
            }
            ItemStack defaultInstance = this.itemInnate.m_7968_();
            boolean flag = true;
            flag = defaultInstance.m_150930_((Item)ModItems.ABYSS_EYE.get()) ? null != pPlayer.changeDimension(level = minecraftServer.m_129880_(CataclysmDimensions.CATACLYSM_ABYSSAL_DEPTHS_LEVEL_KEY), (ITeleporter)new CDTeleporter(new BlockPos(0, 200, 0))) : (defaultInstance.m_150930_((Item)ModItems.MECH_EYE.get()) ? null != pPlayer.changeDimension(level = minecraftServer.m_129880_(CataclysmDimensions.CATACLYSM_FORGE_OF_AEONS_LEVEL_KEY), (ITeleporter)new CDTeleporter(new BlockPos(0, 150, 0))) : (defaultInstance.m_150930_((Item)ModItems.FLAME_EYE.get()) ? null != pPlayer.changeDimension(level = minecraftServer.m_129880_(CataclysmDimensions.CATACLYSM_INFERNOS_MAW_LEVEL_KEY), (ITeleporter)new CDNetherTeleporter(new BlockPos(0, 64, 0))) : (defaultInstance.m_150930_((Item)ModItems.VOID_EYE.get()) ? null != pPlayer.changeDimension(level = minecraftServer.m_129880_(CataclysmDimensions.CATACLYSM_BASTION_LOST_LEVEL_KEY), (ITeleporter)new CDTeleporter(new BlockPos(0, 150, 0))) : (defaultInstance.m_150930_((Item)ModItems.MONSTROUS_EYE.get()) ? null != pPlayer.changeDimension(level = minecraftServer.m_129880_(CataclysmDimensions.CATACLYSM_SOULS_ANVIL_LEVEL_KEY), (ITeleporter)new CDNetherTeleporter(new BlockPos(0, 64, 0))) : (defaultInstance.m_150930_((Item)ModItems.DESERT_EYE.get()) ? null != pPlayer.changeDimension(level = minecraftServer.m_129880_(CataclysmDimensions.CATACLYSM_PHARAOHS_BANE_LEVEL_KEY), (ITeleporter)new CDTeleporter(new BlockPos(0, 200, 0), 400)) : (defaultInstance.m_150930_((Item)ModItems.CURSED_EYE.get()) ? null != pPlayer.changeDimension(level = minecraftServer.m_129880_(CataclysmDimensions.CATACLYSM_ETERNAL_FROSTHOLD_LEVEL_KEY), (ITeleporter)new CDTeleporter(new BlockPos(0, 200, 0), 400)) : (defaultInstance.m_150930_((Item)ModItems.STORM_EYE.get()) ? null != pPlayer.changeDimension(level = minecraftServer.m_129880_(CataclysmDimensions.CATACLYSM_SANCTUM_FALLEN_LEVEL_KEY), (ITeleporter)new CDTeleporter(new BlockPos(0, 200, 0))) : false)))))));
            if (flag) {
                if (pPlayer instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)pPlayer;
                    player.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(BuiltInRegistries.f_256894_.m_263177_((Object)SoundEvents.f_12287_), SoundSource.PLAYERS, player.m_20185_(), player.m_20186_(), player.m_20189_(), 1.0f, 1.0f, (long)player.m_217043_().m_188502_()));
                }
                return;
            }
        }
        if ((mainHandItem = pPlayer.m_21120_(pHand)).m_150930_(this.itemInnate) && !this.isActivated) {
            this.onActive(pPlayer, mainHandItem, serverLevel, pPos);
        }
    }

    public static <T extends BlockEntity> void tick(Level pLevel, BlockPos pPos, BlockState state, T t) {
        if (t instanceof AbstractAltarBlockEntity) {
            AbstractAltarBlockEntity abstractAltarBlockEntity = (AbstractAltarBlockEntity)t;
            if (pLevel.f_46443_) {
                if (abstractAltarBlockEntity.isActivated) {
                    if (pLevel.m_46467_() % 10L == 0L) {
                        double rx = (float)pPos.m_123341_() + pLevel.m_213780_().m_188501_();
                        double ry = (float)pPos.m_123342_() + pLevel.m_213780_().m_188501_();
                        double rz = (float)pPos.m_123343_() + pLevel.m_213780_().m_188501_();
                        pLevel.m_7106_(abstractAltarBlockEntity.getSpawnerParticle(), rx, ry, rz, 0.0, 0.0, 0.0);
                        Vec3 center = pPos.m_252807_();
                        pLevel.m_45976_(Player.class, new AABB(center, center).m_82400_(5.0)).forEach(player -> player.m_5661_((Component)TCRCoreMod.getInfo("enter_dimension_tip"), true));
                    }
                } else if (pLevel.m_46467_() % 10L == 0L) {
                    Vec3 center = pPos.m_252807_();
                    pLevel.m_45976_(Player.class, new AABB(center, center).m_82400_(5.0)).forEach(abstractAltarBlockEntity::playUseEyeTip);
                }
            } else if (pLevel.m_46467_() % 120L == 0L && abstractAltarBlockEntity.isActivated) {
                pLevel.m_6263_(null, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), SoundEvents.f_11737_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    protected void playUseEyeTip(Player player) {
        player.m_5661_((Component)TCRCoreMod.getInfo("use_true_eye_tip", this.itemInnate.m_41466_().m_6881_().m_130940_(ChatFormatting.GOLD)), true);
    }

    protected void onActive(Player pPlayer, ItemStack mainHandItem, ServerLevel pLevel, BlockPos pPos) {
        this.isActivated = true;
        this.sync();
        pLevel.m_6263_(null, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), SoundEvents.f_11736_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    protected ParticleOptions getSpawnerParticle() {
        return ParticleTypes.f_123744_;
    }

    public abstract boolean checkBossKilled(Player var1);

    public abstract boolean checkEyeFound(Player var1);

    public abstract int getColor();

    public float getAlpha() {
        return 1.0f;
    }
}

