/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.tcrcore.block.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.p1nero.tcrcore.block.entity.AbstractAltarBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BeaconRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class AltarBlockRenderer<T extends AbstractAltarBlockEntity>
implements BlockEntityRenderer<T> {
    private ItemStack stack = null;

    public AltarBlockRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(@NotNull AbstractAltarBlockEntity altarBlockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        if (localPlayer == null) {
            return;
        }
        if (altarBlockEntity.isActivated()) {
            if (this.stack == null) {
                this.stack = altarBlockEntity.getItemInnate().m_7968_();
            }
            poseStack.m_85836_();
            poseStack.m_252880_(0.5f, 0.35f, 0.5f);
            float time = ((float)altarBlockEntity.m_58904_().m_46467_() + partialTick) * 0.05f;
            float floatOffset = (float)Math.sin(time * 2.0f) * 0.1f;
            poseStack.m_252880_(0.0f, floatOffset, 0.0f);
            poseStack.m_252781_(Axis.f_252436_.m_252961_(time));
            float scale = 1.4f + (float)Math.sin(time * 3.0f) * 0.1f;
            poseStack.m_85841_(scale, scale, scale);
            BakedModel model = Minecraft.m_91087_().m_91291_().m_115103_().m_109406_(this.stack);
            Minecraft.m_91087_().m_91291_().m_115143_(this.stack, ItemDisplayContext.GROUND, false, poseStack, bufferSource, 0xF000F0, OverlayTexture.f_118083_, model);
            poseStack.m_85849_();
            if (altarBlockEntity.checkBossKilled((Player)localPlayer)) {
                long i = altarBlockEntity.m_58904_().m_46467_();
                int color = altarBlockEntity.getColor();
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                float[] colorArr = new float[]{r, g, b};
                poseStack.m_85836_();
                poseStack.m_252880_(0.0f, 1.0f, 0.0f);
                AltarBlockRenderer.renderBeaconBeam(poseStack, bufferSource, partialTick, i, 0, 1024, colorArr);
                poseStack.m_85849_();
            }
        }
    }

    private static void renderBeaconBeam(PoseStack p_112177_, MultiBufferSource p_112178_, float p_112179_, long p_112180_, int p_112181_, int p_112182_, float[] p_112183_) {
        BeaconRenderer.m_112184_((PoseStack)p_112177_, (MultiBufferSource)p_112178_, (ResourceLocation)BeaconRenderer.f_112102_, (float)p_112179_, (float)1.0f, (long)p_112180_, (int)p_112181_, (int)p_112182_, (float[])p_112183_, (float)0.2f, (float)0.25f);
    }

    public boolean shouldRenderOffScreen(@NotNull AbstractAltarBlockEntity entity) {
        return true;
    }

    public int m_142163_() {
        return 256;
    }

    public boolean shouldRender(AbstractAltarBlockEntity p_173531_, Vec3 p_173532_) {
        return Vec3.m_82512_((Vec3i)p_173531_.m_58899_()).m_82542_(1.0, 0.0, 1.0).m_82509_((Position)p_173532_.m_82542_(1.0, 0.0, 1.0), (double)this.m_142163_());
    }
}

