/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.property.AnimationEvent;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class TeleportGroundUtils {
    public static AnimationEvent.InTimeEvent create(int startFrame, float offsetY) {
        return TeleportGroundUtils.create(startFrame, offsetY, null, 0.0f, 0.0f);
    }

    public static AnimationEvent.InTimeEvent create(int startFrame, float offsetY, String jointName, float forwardOffset, float sideOffset) {
        float startTime = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)startTime, (entityPatch, self, params) -> {
            LivingEntity entity = (LivingEntity)entityPatch.getOriginal();
            Vec3 groundPos = TeleportGroundUtils.getGroundPosition(entityPatch, offsetY, jointName);
            if (forwardOffset != 0.0f || sideOffset != 0.0f) {
                Vec3 offset = TeleportGroundUtils.calculateHorizontalOffset(entity, forwardOffset, sideOffset);
                groundPos = groundPos.m_82549_(offset);
            }
            TeleportGroundUtils.teleportToPosition(entityPatch, groundPos);
        }, (AnimationEvent.Side)AnimationEvent.Side.BOTH);
    }

    private static void spawnBeforeTeleportParticle(LivingEntity entity) {
        if (entity.m_9236_().f_46443_) {
            float yRotRad = (float)Math.toRadians(entity.m_146908_());
            double forwardX = -Math.sin(yRotRad);
            double forwardZ = Math.cos(yRotRad);
            entity.m_9236_().m_7106_((ParticleOptions)EpicFightParticles.WHITE_AFTERIMAGE.get(), entity.m_20185_() + forwardX, entity.m_20186_() + (double)(entity.m_20206_() / 2.0f) - 0.3, entity.m_20189_() + forwardZ, Double.longBitsToDouble(entity.m_19879_()), 0.0, 0.0);
        }
    }

    private static void spawnAfterTeleportParticle(LivingEntity entity) {
        if (entity.m_9236_().f_46443_) {
            float yRotRad = (float)Math.toRadians(entity.m_146908_());
            double forwardX = -Math.sin(yRotRad);
            double forwardZ = Math.cos(yRotRad);
            entity.m_9236_().m_7106_((ParticleOptions)EpicFightParticles.WHITE_AFTERIMAGE.get(), entity.m_20185_() + forwardX, entity.m_20186_() + (double)(entity.m_20206_() / 2.0f) - 1.1, entity.m_20189_() + forwardZ, Double.longBitsToDouble(entity.m_19879_()), 0.0, 0.0);
        }
    }

    public static Vec3 getGroundPosition(LivingEntityPatch<?> entityPatch, float offsetY, String jointName) {
        Armature armature;
        Joint joint;
        LivingEntity entity = (LivingEntity)entityPatch.getOriginal();
        if (jointName != null && entityPatch.getArmature() != null && (joint = (armature = entityPatch.getArmature()).searchJointByName(jointName)) != null) {
            OpenMatrix4f transform = armature.getBoundTransformFor(entityPatch.getAnimator().getPose(1.0f), joint);
            OpenMatrix4f correction = new OpenMatrix4f().rotate((float)(-Math.toRadians(entity.m_146908_() + 180.0f)), new Vec3f(0.0f, 1.0f, 0.0f));
            OpenMatrix4f.mul((OpenMatrix4f)correction, (OpenMatrix4f)transform, (OpenMatrix4f)transform);
            double x = (double)transform.m30 + entity.m_20185_();
            double y = (double)transform.m31 + entity.m_20186_() + (double)offsetY;
            double z = (double)transform.m32 + entity.m_20189_();
            return TeleportGroundUtils.findActualGround(entity, x, y, z);
        }
        return TeleportGroundUtils.getSimpleGroundPosition(entity, offsetY);
    }

    private static Vec3 calculateHorizontalOffset(LivingEntity entity, float forward, float side) {
        float yRotRad = (float)Math.toRadians(entity.m_146908_());
        float xOffset = -forward * (float)Math.sin(yRotRad) + side * (float)Math.cos(yRotRad);
        float zOffset = forward * (float)Math.cos(yRotRad) + side * (float)Math.sin(yRotRad);
        return new Vec3((double)xOffset, 0.0, (double)zOffset);
    }

    private static void teleportToPosition(LivingEntityPatch<?> entityPatch, Vec3 targetPos) {
        LivingEntity entity = (LivingEntity)entityPatch.getOriginal();
        Vec3 moveVec = new Vec3(targetPos.f_82479_ - entity.m_20185_(), targetPos.f_82480_ - entity.m_20186_(), targetPos.f_82481_ - entity.m_20189_());
        entity.m_6478_(MoverType.SELF, moveVec);
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            serverPlayer.f_8906_.m_9774_(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_, entity.m_146908_(), entity.m_146909_());
        }
    }

    private static Vec3 findActualGround(LivingEntity entity, double x, double y, double z) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, y, z);
        BlockState blockState = entity.m_9236_().m_8055_((BlockPos)pos);
        while ((blockState.m_60795_() || blockState.m_60734_() instanceof BushBlock) && !blockState.m_60713_(Blocks.f_50752_) && y > (double)entity.m_9236_().m_141937_()) {
            pos.m_122169_(x, y -= 1.0, z);
            blockState = entity.m_9236_().m_8055_((BlockPos)pos);
        }
        return new Vec3(x, y + 1.0, z);
    }

    public static Vec3 getSimpleGroundPosition(LivingEntity entity, float offsetY) {
        double y = entity.m_20186_() - (double)(entity.m_20206_() / 2.0f) + (double)offsetY;
        return TeleportGroundUtils.findActualGround(entity, entity.m_20185_(), y, entity.m_20189_());
    }
}

