/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.util;

import com.hm.efn.entity.effect.CoTachiSlashEntity;
import com.hm.efn.entity.effect.CoTachiSlashPatch;
import com.hm.efn.entity.effect.FireWindEntity;
import com.hm.efn.entity.effect.FireWindPatch;
import com.hm.efn.entity.effect.SecludedEntity;
import com.hm.efn.entity.effect.SecludedPatch;
import com.hm.efn.entity.effect.TrailEntity;
import com.hm.efn.entity.effect.TrailPatch;
import com.hm.efn.gameasset.combos.Aetherialdusk;
import com.hm.efn.gameasset.combos.Yamato;
import com.p1nero.invincible.capability.InvinciblePlayerCapabilityProvider;
import java.util.Map;
import java.util.WeakHashMap;
import net.mehvahdjukaar.dummmmmmy.common.TargetDummyEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.animation.property.AnimationEvent;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class EffectEntityInvoker {
    private static final boolean HAS_DUMMY_MOD = ModList.get().isLoaded("dummmmmmy");
    private static final Map<LivingEntity, FireWindEntity> activeFireWinds = new WeakHashMap<LivingEntity, FireWindEntity>();
    private static final Map<LivingEntity, Boolean> secludedAttackEnabledMap = new WeakHashMap<LivingEntity, Boolean>();
    private static final boolean secludedAttackEnabled = true;

    public static void setSecludedAttackEnabled(LivingEntity player, boolean enabled) {
        secludedAttackEnabledMap.put(player, enabled);
    }

    public static boolean isSecludedAttackEnabled(LivingEntity player) {
        return secludedAttackEnabledMap.getOrDefault(player, true);
    }

    public static AnimationEvent.InTimeEvent summonTrail(int startFrame, double forwardDist, double heightOffset, double sideOffset, float scale, float zRotation) {
        float start = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)start, (entityPatch, self, params) -> {
            Entity rawEntity = entityPatch.getOriginal();
            if (!(rawEntity instanceof LivingEntity)) {
                return;
            }
            LivingEntity owner = (LivingEntity)rawEntity;
            Level patt2472$temp = owner.m_9236_();
            if (!(patt2472$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel level = (ServerLevel)patt2472$temp;
            Vec3 spawnPos = EffectEntityInvoker.calculateEffectPosition(owner, forwardDist, heightOffset, sideOffset);
            TrailEntity entity = new TrailEntity(owner, scale, new Vec3(sideOffset, heightOffset, forwardDist));
            entity.m_146884_(spawnPos);
            level.m_7967_((Entity)entity);
            level.m_7654_().execute(() -> {
                TrailPatch patch = entity.getPatch();
                if (patch != null) {
                    patch.setZRotation(zRotation);
                }
            });
        }, (AnimationEvent.Side)AnimationEvent.Side.BOTH);
    }

    public static AnimationEvent.InTimeEvent summonTrailAtTarget(int startFrame, float scale, float zRotation, double heightAdjustment) {
        float start = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)start, (entityPatch, self, params) -> {
            LivingEntity caster = (LivingEntity)entityPatch.getOriginal();
            Level patt3509$temp = caster.m_9236_();
            if (!(patt3509$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel level = (ServerLevel)patt3509$temp;
            LivingEntity target = entityPatch.getTarget();
            if (target == null) {
                return;
            }
            Vec3 spawnPos = target.m_20182_().m_82520_(0.0, heightAdjustment, 0.0);
            TrailEntity entity = new TrailEntity(caster, scale, Vec3.f_82478_);
            entity.m_146884_(spawnPos);
            level.m_7967_((Entity)entity);
            level.m_7654_().execute(() -> {
                TrailPatch patch = entity.getPatch();
                if (patch != null) {
                    patch.setZRotation(zRotation);
                }
            });
        }, (AnimationEvent.Side)AnimationEvent.Side.BOTH);
    }

    public static AnimationEvent.InTimeEvent summonTachiSlash(int startFrame, double forwardDist, double heightOffset, double sideOffset, float scale, float zRotation) {
        float start = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)start, (entityPatch, self, params) -> {
            Entity rawEntity = entityPatch.getOriginal();
            if (!(rawEntity instanceof LivingEntity)) {
                return;
            }
            LivingEntity owner = (LivingEntity)rawEntity;
            Level patt4781$temp = owner.m_9236_();
            if (!(patt4781$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel level = (ServerLevel)patt4781$temp;
            Vec3 spawnPos = EffectEntityInvoker.calculateEffectPosition(owner, forwardDist, heightOffset, sideOffset);
            CoTachiSlashEntity entity = new CoTachiSlashEntity(owner, scale, new Vec3(sideOffset, heightOffset, forwardDist));
            entity.m_146884_(spawnPos);
            level.m_7967_((Entity)entity);
            level.m_7654_().execute(() -> {
                CoTachiSlashPatch patch = (CoTachiSlashPatch)entity.getPatch();
                if (patch != null) {
                    patch.setZRotation(zRotation);
                }
            });
        }, (AnimationEvent.Side)AnimationEvent.Side.BOTH);
    }

    public static AnimationEvent.InTimeEvent summonSecluded_Skill(int startFrame, double forwardDist, double heightOffset, double sideOffset, float scale, float zRotation) {
        float start = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)start, (entityPatch, self, params) -> {
            Entity rawEntity = entityPatch.getOriginal();
            if (!(rawEntity instanceof LivingEntity)) {
                return;
            }
            LivingEntity owner = (LivingEntity)rawEntity;
            Level patt5986$temp = owner.m_9236_();
            if (!(patt5986$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel level = (ServerLevel)patt5986$temp;
            Vec3 spawnPos = EffectEntityInvoker.calculateEffectPosition(owner, forwardDist, heightOffset, sideOffset);
            SecludedEntity entity = new SecludedEntity(owner, scale, new Vec3(sideOffset, heightOffset, forwardDist));
            entity.m_146884_(spawnPos);
            level.m_7967_((Entity)entity);
            level.m_7654_().execute(() -> {
                SecludedPatch patch = entity.getPatch();
                if (patch != null) {
                    patch.setZRotation(zRotation);
                }
            });
        }, (AnimationEvent.Side)AnimationEvent.Side.BOTH);
    }

    public static AnimationEvent.InTimeEvent summonSecluded_Attack(int startFrame, double forwardDist, double heightOffset, double sideOffset, float scale, float zRotation) {
        float start = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)start, (entityPatch, self, params) -> {
            Entity rawEntity = entityPatch.getOriginal();
            if (!(rawEntity instanceof LivingEntity)) {
                return;
            }
            LivingEntity owner = (LivingEntity)rawEntity;
            Level patt7162$temp = owner.m_9236_();
            if (!(patt7162$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel level = (ServerLevel)patt7162$temp;
            if (!EffectEntityInvoker.isSecludedAttackEnabled(owner)) {
                return;
            }
            Vec3 spawnPos = EffectEntityInvoker.calculateEffectPosition(owner, forwardDist, heightOffset, sideOffset);
            SecludedEntity entity = new SecludedEntity(owner, scale, new Vec3(sideOffset, heightOffset, forwardDist));
            entity.m_146884_(spawnPos);
            level.m_7967_((Entity)entity);
            level.m_7654_().execute(() -> {
                SecludedPatch patch = entity.getPatch();
                if (patch != null) {
                    patch.setZRotation(zRotation);
                }
            });
        }, (AnimationEvent.Side)AnimationEvent.Side.BOTH);
    }

    public static AnimationEvent.InTimeEvent summonSecludedAtTarget(int startFrame, float scale, float zRotation, float attractRadius, float minKnockbackResistance, float constantPullStrength, double heightAdjustment) {
        float start = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)start, (entityPatch, self, params) -> {
            LivingEntity caster = (LivingEntity)entityPatch.getOriginal();
            Level patt8485$temp = caster.m_9236_();
            if (!(patt8485$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel level = (ServerLevel)patt8485$temp;
            if (!EffectEntityInvoker.isSecludedAttackEnabled(caster)) {
                return;
            }
            LivingEntity target = entityPatch.getTarget();
            if (target == null) {
                return;
            }
            Vec3 spawnPos = target.m_20182_().m_82520_(0.0, heightAdjustment, 0.0);
            SecludedEntity entity = new SecludedEntity(caster, scale, Vec3.f_82478_);
            entity.m_146884_(spawnPos);
            level.m_7967_((Entity)entity);
            if (attractRadius > 0.0f) {
                EffectEntityInvoker.attractTargets(level, spawnPos, attractRadius, minKnockbackResistance, constantPullStrength);
            }
            level.m_7654_().execute(() -> {
                SecludedPatch patch = entity.getPatch();
                if (patch != null) {
                    patch.setZRotation(zRotation);
                }
            });
        }, (AnimationEvent.Side)AnimationEvent.Side.BOTH);
    }

    private static void attractTargets(ServerLevel level, Vec3 centerPos, float radius, float minKnockbackResistance, float strength) {
        BlockPos centerBlockPos = new BlockPos((int)centerPos.f_82479_, (int)centerPos.f_82480_, (int)centerPos.f_82481_);
        AABB area = new AABB(centerBlockPos).m_82400_((double)radius);
        level.m_6249_((Entity)null, area, e -> {
            if (!(e instanceof LivingEntity)) return false;
            LivingEntity living = (LivingEntity)e;
            if (e instanceof Player) return false;
            if (e.m_5833_()) return false;
            if (!(living.m_21133_(Attributes.f_22278_) < (double)minKnockbackResistance)) return false;
            return true;
        }).forEach(target -> {
            Vec3 toCenter = centerPos.m_82546_(target.m_20182_()).m_82541_();
            target.m_20256_(target.m_20184_().m_82549_(toCenter.m_82490_((double)strength)));
            target.f_19864_ = true;
        });
    }

    public static AnimationEvent.InPeriodEvent setDodgeCounterNodeEvent(int startFrame, int endFrame) {
        float start = (float)startFrame / 60.0f;
        float end = (float)endFrame / 60.0f;
        return AnimationEvent.InPeriodEvent.create((float)start, (float)end, (livingEntityPatch, staticAnimation, objects) -> {
            LivingEntity player = (LivingEntity)livingEntityPatch.getOriginal();
            PlayerPatch playerPatch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, PlayerPatch.class);
            if (player.m_9236_().m_5776_() || !(player instanceof ServerPlayer)) {
                return;
            }
            if (playerPatch == null || playerPatch.getSkill(Aetherialdusk.Aetherialdusk) == null) {
                return;
            }
            player.getCapability(InvinciblePlayerCapabilityProvider.INVINCIBLE_PLAYER).ifPresent(inv -> inv.setCurrentNode(Aetherialdusk.DodgeCounter));
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER);
    }

    public static AnimationEvent.InPeriodEvent setYamatoDodgeNode(int startFrame, int endFrame) {
        float start = (float)startFrame / 60.0f;
        float end = (float)endFrame / 60.0f;
        return AnimationEvent.InPeriodEvent.create((float)start, (float)end, (livingEntityPatch, staticAnimation, objects) -> {
            LivingEntity player = (LivingEntity)livingEntityPatch.getOriginal();
            PlayerPatch playerPatch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, PlayerPatch.class);
            if (player.m_9236_().m_5776_() || !(player instanceof ServerPlayer)) {
                return;
            }
            if (playerPatch == null || playerPatch.getSkill(Yamato.yamato) == null) {
                return;
            }
            player.getCapability(InvinciblePlayerCapabilityProvider.INVINCIBLE_PLAYER).ifPresent(inv -> inv.setCurrentNode(Yamato.yamato_root));
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER);
    }

    public static AnimationEvent.InPeriodEvent catchEntities(int startFrame, int endFrame, float radius, double forwardDist, float minKnockbackResistance) {
        float start = (float)startFrame / 60.0f;
        float end = (float)endFrame / 60.0f;
        return AnimationEvent.InPeriodEvent.create((float)start, (float)end, (livingEntityPatch, staticAnimation, objects) -> {
            LivingEntity caster = (LivingEntity)livingEntityPatch.getOriginal();
            Level patt13021$temp = caster.m_9236_();
            if (!(patt13021$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel level = (ServerLevel)patt13021$temp;
            if (!EffectEntityInvoker.isSecludedAttackEnabled(caster)) {
                return;
            }
            Vec3 targetPos = EffectEntityInvoker.calculateEffectPosition(caster, forwardDist, 0.0, 0.0);
            double groundY = EffectEntityInvoker.findGroundHeight((Level)level, (Entity)caster, forwardDist);
            Vec3 finalPos = new Vec3(targetPos.f_82479_, groundY, targetPos.f_82481_);
            Vec3 lookVec = caster.m_20154_();
            level.m_6249_((Entity)caster, caster.m_20191_().m_82400_((double)radius), entity -> {
                LivingEntity living;
                block6: {
                    block5: {
                        if (!(entity instanceof LivingEntity)) break block5;
                        living = (LivingEntity)entity;
                        if (!(entity instanceof SecludedEntity) && (!HAS_DUMMY_MOD || !(entity instanceof TargetDummyEntity)) && !(entity instanceof Player) && !entity.m_5833_()) break block6;
                    }
                    return false;
                }
                if (living.m_21133_(Attributes.f_22278_) > (double)minKnockbackResistance) {
                    return false;
                }
                Vec3 toEntity = entity.m_20182_().m_82546_(caster.m_20182_());
                double distance = toEntity.m_82553_();
                if (distance > (double)radius) {
                    return false;
                }
                return lookVec.m_82526_(toEntity = toEntity.m_82541_()) > 0.94;
            }).forEach(entity -> {
                Vec3 toTarget = finalPos.m_82546_(entity.m_20182_());
                if (toTarget.m_82556_() > (double)(radius * radius)) {
                    return;
                }
                Vec3 safePos = EffectEntityInvoker.ensureInsideWorld(level, finalPos, entity.m_20191_());
                level.m_7654_().execute(() -> {
                    double verifiedY = EffectEntityInvoker.findGroundHeight((Level)level, entity, 0.0);
                    entity.m_6027_(finalPos.f_82479_, verifiedY, finalPos.f_82481_);
                    entity.m_20256_(Vec3.f_82478_);
                    entity.f_19864_ = true;
                    entity.m_6853_(true);
                });
            });
        }, (AnimationEvent.Side)AnimationEvent.Side.BOTH);
    }

    private static Vec3 ensureInsideWorld(ServerLevel level, Vec3 targetPos, AABB entityBox) {
        double minX = entityBox.m_82362_() / 2.0;
        double minZ = entityBox.m_82385_() / 2.0;
        return new Vec3(Mth.m_14008_((double)targetPos.f_82479_, (double)minX, (double)(level.m_6857_().m_61957_() - minX)), targetPos.f_82480_, Mth.m_14008_((double)targetPos.f_82481_, (double)minZ, (double)(level.m_6857_().m_61958_() - minZ)));
    }

    private static double findGroundHeight(Level level, Entity entity, double forward) {
        Vec3 startPos = entity.m_20182_().m_82549_(entity.m_20154_().m_82490_(forward)).m_82520_(0.0, 1.0, 0.0);
        BlockHitResult result = level.m_45547_(new ClipContext(startPos, startPos.m_82520_(0.0, -64.0, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity));
        return result.m_82450_().f_82480_ + 0.1;
    }

    private static Vec3 calculateEffectPosition(LivingEntity owner, double forward, double height, double side) {
        Vec3 horizontalLook = new Vec3(Math.sin((double)(-owner.m_146908_()) * (Math.PI / 180)), 0.0, Math.cos((double)owner.m_146908_() * (Math.PI / 180))).m_82541_();
        Vec3 right = new Vec3(-horizontalLook.f_82481_, 0.0, horizontalLook.f_82479_).m_82541_();
        return owner.m_146892_().m_82549_(horizontalLook.m_82490_(forward)).m_82549_(right.m_82490_(side)).m_82520_(0.0, height, 0.0);
    }

    public static AnimationEvent.InTimeEvent summonFireWind(int startFrame, double xOffset, double yOffset, double zOffset, float scale, float initRotX, float initRotY, float initRotZ) {
        float start = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)start, (entityPatch, self, params) -> {
            Entity rawEntity = entityPatch.getOriginal();
            if (!(rawEntity instanceof LivingEntity)) {
                return;
            }
            LivingEntity livingEntity = (LivingEntity)rawEntity;
            Level level = livingEntity.m_9236_();
            if (!(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            FireWindEntity fireWind = new FireWindEntity(livingEntity, scale, new Vec3(xOffset, yOffset, zOffset));
            FireWindPatch patch = fireWind.getEntityPatch();
            if (patch != null) {
                patch.setRotation(initRotX, initRotY, initRotZ);
            }
            fireWind.m_146884_(livingEntity.m_20182_().m_82520_(xOffset, yOffset, zOffset));
            serverLevel.m_7967_((Entity)fireWind);
            activeFireWinds.put(livingEntity, fireWind);
        }, (AnimationEvent.Side)AnimationEvent.Side.BOTH);
    }

    public static AnimationEvent.InTimeEvent clearFireWind(int startFrame) {
        float start = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)start, (entityPatch, self, params) -> {
            LivingEntity entity = (LivingEntity)entityPatch.getOriginal();
            EffectEntityInvoker.clearExistingFireWind(entity);
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER);
    }

    private static void clearExistingFireWind(LivingEntity owner) {
        FireWindEntity existing = activeFireWinds.get(owner);
        if (existing != null && !existing.m_213877_()) {
            existing.markForRemoval();
            activeFireWinds.remove(owner);
        }
    }

    private static TrailEntity findExistingTrail(LivingEntity owner) {
        Object object = owner.m_9236_();
        if (!(object instanceof ServerLevel)) {
            return null;
        }
        ServerLevel level = (ServerLevel)object;
        object = level.m_6249_((Entity)owner, owner.m_20191_().m_82400_(10.0), e -> {
            TrailEntity trail;
            return e instanceof TrailEntity && (trail = (TrailEntity)((Object)e)).getOwner() == owner;
        }).iterator();
        if (object.hasNext()) {
            Entity entity = (Entity)object.next();
            return (TrailEntity)entity;
        }
        return null;
    }

    public static AnimationEvent.InTimeEvent clearTrail(int startFrame) {
        float start = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)start, (entityPatch, self, params) -> {
            Entity rawEntity = entityPatch.getOriginal();
            if (!(rawEntity instanceof LivingEntity)) {
                return;
            }
            LivingEntity owner = (LivingEntity)rawEntity;
            Level patt19699$temp = owner.m_9236_();
            if (!(patt19699$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel level = (ServerLevel)patt19699$temp;
            for (Entity entity : level.m_6249_((Entity)owner, owner.m_20191_().m_82400_(50.0), e -> {
                TrailEntity trail;
                return e instanceof TrailEntity && (trail = (TrailEntity)((Object)((Object)e))).getOwner() == owner;
            })) {
                entity.m_146870_();
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER);
    }

    @Nullable
    public static FireWindPatch getFireWindPatch(LivingEntity owner) {
        FireWindEntity entity = activeFireWinds.get(owner);
        return entity != null ? entity.getEntityPatch() : null;
    }
}

