/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.skill.weapon_innate;

import com.google.common.collect.Lists;
import com.hm.efn.gameasset.EFNSKillDataKeys;
import com.hm.efn.gameasset.animations.EFNShortSwordAnimations;
import com.hm.efn.gameasset.combos.Shortsword;
import com.hm.efn.registries.EFNMobEffectRegistry;
import com.hm.efn.skill.EFNWeaponInnateBase;
import com.p1nero.invincible.capability.InvinciblePlayerCapabilityProvider;
import com.p1nero.invincible.client.InvincibleKeyMappings;
import com.p1nero.invincible.skill.ComboBasicAttack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.dodge.DodgeSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.entity.eventlistener.DealDamageEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class ShortSwordInnate
extends EFNWeaponInnateBase {
    private static final UUID DODGE_TRIGGER_UUID = UUID.fromString("e5f6a1b2-c8d1-11ed-a51b-0242ac121029");
    private static final UUID DAMAGE_LISTENER_UUID = UUID.fromString("f6e7b2c3-d9e2-12fd-b52c-1352bd232130");
    private static final UUID DAMAGE_ADDER_UUID = UUID.fromString("f6e7b2c3-d9e2-12fd-b52c-1352bd602102");

    public ShortSwordInnate(ComboBasicAttack.Builder builder) {
        super(builder);
    }

    @Override
    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        PlayerEventListener listener = container.getExecutor().getEventListener();
        listener.addEventListener(PlayerEventListener.EventType.SKILL_CAST_EVENT, DODGE_TRIGGER_UUID, event -> {
            PlayerPatch patt2571$temp;
            if (event.getSkillContainer().getSkill() instanceof DodgeSkill && (patt2571$temp = container.getExecutor()) instanceof ServerPlayerPatch) {
                ServerPlayerPatch playerPatch = (ServerPlayerPatch)patt2571$temp;
                ServerPlayer player = (ServerPlayer)playerPatch.getOriginal();
                if (this.isHoldingWeapon(container)) {
                    player.getCapability(InvinciblePlayerCapabilityProvider.INVINCIBLE_PLAYER).ifPresent(inv -> inv.setCurrentNode(Shortsword.DodgeCounter));
                }
            }
        });
        listener.addEventListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_DAMAGE, DAMAGE_ADDER_UUID, event -> {
            PlayerPatch patt3242$temp = container.getExecutor();
            if (patt3242$temp instanceof ServerPlayerPatch) {
                ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)patt3242$temp;
                ServerPlayer player = (ServerPlayer)serverPlayerPatch.getOriginal();
                if (this.isHoldingWeapon(container) && event.getAttackDamage() > 0.0f) {
                    this.recordDamage(container, event.getAttackDamage(), player.f_19797_);
                }
            }
        });
        listener.addEventListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_ATTACK, DAMAGE_LISTENER_UUID, event -> {
            PlayerPatch patt3849$temp = container.getExecutor();
            if (patt3849$temp instanceof ServerPlayerPatch) {
                ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)patt3849$temp;
                ServerPlayer player = (ServerPlayer)serverPlayerPatch.getOriginal();
                if (this.isHoldingWeapon(container) && event.getAttackDamage() > 0.0f && this.shouldApplyReplayBonus(serverPlayerPatch)) {
                    this.applyReplayBonus(container, (DealDamageEvent.Attack)event, player.f_19797_);
                }
            }
        });
    }

    private void recordDamage(SkillContainer container, float damage, int currentTick) {
        SkillDataManager data = container.getDataManager();
        Boolean isReplayDamage = (Boolean)data.getDataValue((SkillDataKey)EFNSKillDataKeys.IS_REPLAY_DAMAGE.get());
        if (Boolean.TRUE.equals(isReplayDamage)) {
            data.setData((SkillDataKey)EFNSKillDataKeys.IS_REPLAY_DAMAGE.get(), (Object)false);
            return;
        }
        ArrayList<EFNSKillDataKeys.DamageRecord> history = new ArrayList<EFNSKillDataKeys.DamageRecord>((Collection)data.getDataValue((SkillDataKey)EFNSKillDataKeys.DAMAGE_HISTORY.get()));
        if (!history.isEmpty()) {
            this.cleanupExpiredRecords(history, currentTick);
        }
        history.add(new EFNSKillDataKeys.DamageRecord(damage, currentTick));
        data.setDataSync((SkillDataKey)EFNSKillDataKeys.DAMAGE_HISTORY.get(), history, (ServerPlayer)((ServerPlayerPatch)container.getExecutor()).getOriginal());
    }

    private void cleanupExpiredRecords(List<EFNSKillDataKeys.DamageRecord> history, int currentTick) {
        history.removeIf(record -> record.isExpired(currentTick));
    }

    private boolean shouldApplyReplayBonus(ServerPlayerPatch playerPatch) {
        if (playerPatch == null || playerPatch.getOriginal() == null) {
            return false;
        }
        boolean hasReplayEffect = ((ServerPlayer)playerPatch.getOriginal()).m_21023_((MobEffect)EFNMobEffectRegistry.REPLAY.get());
        boolean alreadyEnhanced = (Boolean)playerPatch.getSkill((Skill)this).getDataManager().getDataValue((SkillDataKey)EFNSKillDataKeys.REPLAY_ENHANCED.get());
        return hasReplayEffect && !alreadyEnhanced;
    }

    private void applyReplayBonus(SkillContainer container, DealDamageEvent.Attack event, int currentTick) {
        SkillDataManager data = container.getDataManager();
        ArrayList<EFNSKillDataKeys.DamageRecord> history = new ArrayList<EFNSKillDataKeys.DamageRecord>((Collection)data.getDataValue((SkillDataKey)EFNSKillDataKeys.DAMAGE_HISTORY.get()));
        if (history.isEmpty()) {
            return;
        }
        EFNSKillDataKeys.DamageRecord lastRecord = (EFNSKillDataKeys.DamageRecord)history.get(history.size() - 1);
        float bonusDamage = lastRecord.damage();
        int recordTimestamp = lastRecord.timestamp();
        if (new EFNSKillDataKeys.DamageRecord(0.0f, recordTimestamp).isExpired(currentTick)) {
            this.cleanupExpiredRecords(history, currentTick);
            data.setDataSync((SkillDataKey)EFNSKillDataKeys.DAMAGE_HISTORY.get(), history, (ServerPlayer)((ServerPlayerPatch)container.getExecutor()).getOriginal());
            return;
        }
        this.cleanupExpiredRecords(history, currentTick);
        data.setData((SkillDataKey)EFNSKillDataKeys.IS_REPLAY_DAMAGE.get(), (Object)true);
        EpicFightDamageSource damageSource = event.getDamageSource();
        damageSource.attachDamageModifier(ValueModifier.adder((float)bonusDamage));
        damageSource.attachArmorNegationModifier(ValueModifier.setter((float)100.0f));
        data.setDataSync((SkillDataKey)EFNSKillDataKeys.REPLAY_ENHANCED.get(), (Object)true, (ServerPlayer)((ServerPlayerPatch)container.getExecutor()).getOriginal());
        ServerPlayer player = (ServerPlayer)((ServerPlayerPatch)container.getExecutor()).getOriginal();
        if (player.m_21023_((MobEffect)EFNMobEffectRegistry.REPLAY.get())) {
            player.m_21195_((MobEffect)EFNMobEffectRegistry.REPLAY.get());
        }
        data.setDataSync((SkillDataKey)EFNSKillDataKeys.DAMAGE_HISTORY.get(), history, (ServerPlayer)((ServerPlayerPatch)container.getExecutor()).getOriginal());
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        if (!container.getExecutor().isLogicalClient()) {
            PlayerPatch playerPatch;
            if (container.getExecutor().getTickSinceLastAction() > 9) {
                this.resetCombo(container, (PlayerPatch)container.getServerExecutor(), this.root);
            }
            if ((playerPatch = container.getExecutor()) instanceof ServerPlayerPatch) {
                ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)playerPatch;
                SkillDataManager manager = container.getDataManager();
                PlayerPatch executor = container.getExecutor();
                if (manager.hasData((SkillDataKey)EFNSKillDataKeys.COMBO_COUNTER.get())) {
                    float current = ((Float)manager.getDataValue((SkillDataKey)EFNSKillDataKeys.COMBO_COUNTER.get())).floatValue();
                    if (current < 1.0f) {
                        float newValue = current + 0.05f;
                        manager.setDataSync((SkillDataKey)EFNSKillDataKeys.COMBO_COUNTER.get(), (Object)Float.valueOf(newValue), (ServerPlayer)serverPlayerPatch.getOriginal());
                    } else {
                        manager.setDataSync((SkillDataKey)EFNSKillDataKeys.COMBO_COUNTER.get(), (Object)Float.valueOf(0.0f), (ServerPlayer)serverPlayerPatch.getOriginal());
                    }
                }
                if (((Boolean)manager.getDataValue((SkillDataKey)EFNSKillDataKeys.KEY3_PRESS.get())).booleanValue()) {
                    boolean hasEnergy;
                    ServerPlayer player = (ServerPlayer)serverPlayerPatch.getOriginal();
                    SkillContainer weaponInnate = container.getExecutor().getSkill((SkillSlot)SkillSlots.WEAPON_INNATE);
                    boolean bl = hasEnergy = weaponInnate != null && (weaponInnate.getStack() >= 1 || player.m_150110_().f_35937_);
                    if (hasEnergy) {
                        MobEffectInstance replayEffect = new MobEffectInstance((MobEffect)EFNMobEffectRegistry.REPLAY.get(), 100, 0, false, false, false);
                        if (!executor.getEntityState().inaction()) {
                            serverPlayerPatch.playAnimationSynchronized(EFNShortSwordAnimations.NF_SHORTSWORD_SKILL, 0.05f);
                        }
                        serverPlayerPatch.playSound((SoundEvent)SoundEvents.f_12377_.get(), 1.0f, 1.0f);
                        player.m_7292_(replayEffect);
                        if (!player.m_150110_().f_35937_) {
                            weaponInnate.getSkill().setStackSynchronize(weaponInnate, weaponInnate.getStack() - 1);
                        }
                    } else {
                        serverPlayerPatch.playSound(SoundEvents.f_12374_, 0.5f, 1.0f);
                    }
                    manager.setDataSync((SkillDataKey)EFNSKillDataKeys.KEY3_PRESS.get(), (Object)false, player);
                }
                if (manager.hasData((SkillDataKey)EFNSKillDataKeys.REPLAY_ENHANCED.get()) && !((ServerPlayer)serverPlayerPatch.getOriginal()).m_21023_((MobEffect)EFNMobEffectRegistry.REPLAY.get())) {
                    manager.setDataSync((SkillDataKey)EFNSKillDataKeys.REPLAY_ENHANCED.get(), (Object)false, (ServerPlayer)serverPlayerPatch.getOriginal());
                }
            }
        }
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.SKILL_CAST_EVENT, DODGE_TRIGGER_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_ATTACK, DAMAGE_LISTENER_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_DAMAGE, DAMAGE_ADDER_UUID);
    }

    private boolean isHoldingWeapon(SkillContainer container) {
        ItemStack itemstack = ((Player)container.getExecutor().getOriginal()).m_21205_();
        return EpicFightCapabilities.getItemStackCapability((ItemStack)itemstack).getInnateSkill(container.getExecutor(), itemstack) == this;
    }

    public List<Component> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerpatch) {
        ArrayList list = Lists.newArrayList();
        String keyName = Component.m_237115_((String)InvincibleKeyMappings.KEY3.m_90860_()).getString();
        list.add(Component.m_237115_((String)"skill.efn.shortsword.tooltip").m_130940_(ChatFormatting.GRAY));
        list.add(Component.m_237115_((String)"skill.efn.shortsword.tooltip1").m_7220_((Component)Component.m_237113_((String)keyName)).m_130946_(": ").m_130940_(ChatFormatting.GRAY).m_7220_(InvincibleKeyMappings.KEY3.m_90863_()));
        list.add(Component.m_237115_((String)"skill.efn.shortsword.tooltip2"));
        return list;
    }
}

