/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.skill.weapon_innate;

import com.google.common.collect.Lists;
import com.hm.efn.gameasset.EFNSKillDataKeys;
import com.hm.efn.gameasset.animations.EFNLanceAnimations;
import com.hm.efn.gameasset.combos.Meenlance;
import com.hm.efn.skill.EFNWeaponInnateBase;
import com.hm.efn.util.DuskFireArmorHelper;
import com.p1nero.invincible.skill.ComboBasicAttack;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.lwjgl.glfw.GLFW;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.modules.HoldableSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class MeenLanceInnate
extends EFNWeaponInnateBase {
    public static final int MAX_CHARGING_TICKS = 60;
    public static final int MID_CHARGING_TICKS = 35;
    public static final int MIN_CHARGING_TICKS = 15;
    private static final AnimationManager.AnimationAccessor<? extends StaticAnimation> CHARGING_ANIM = EFNLanceAnimations.NF_MEEN_CHARGING;
    private static final AnimationManager.AnimationAccessor<? extends AttackAnimation> FULL_CHARGE_ANIM = EFNLanceAnimations.NF_MEEN_CHARGE3;
    private static final AnimationManager.AnimationAccessor<? extends AttackAnimation> MID_CHARGE_ANIM = EFNLanceAnimations.NF_MEEN_CHARGE2;
    private static final AnimationManager.AnimationAccessor<? extends AttackAnimation> LOW_CHARGE_ANIM = EFNLanceAnimations.NF_MEEN_CHARGE1;
    private static final AnimationManager.AnimationAccessor<? extends AttackAnimation> MIN_CHARGE_ANIM = EFNLanceAnimations.NF_MEEN_AUTO3;
    private static final int CONSUMPTION_TICK_INTERVAL = 20;
    private static final UUID MOVEMENT_LOCK_UUID = UUID.fromString("d34db33f-5a1d-4b3a-9f1c-8e3a7b5c2d1a");
    private static final UUID CHARGE_UPDATE_UUID = UUID.fromString("d34db33f-5a1d-4b3a-9f1c-114514c2d1a");
    private static final UUID ANIMATION_EVENT_UUID = UUID.fromString("d34db33f-5a1d-4b3a-9f1c-8e3a7b114514");
    private static final UUID ENERGY_CHECK_UUID = UUID.fromString("d34db33f-5a1d-4b3a-9f1c-8e1145142d1a");
    private static final UUID DISABLE_GUARD_UUID = UUID.fromString("d34db33f-5a1d-4b3a-9f1c-8e2245142d1a");
    private static final UUID ANIMATION_INTERRUPT_LISTENER_UUID = UUID.fromString("d34db23f-5a1d-4b3a-9f2c-1415810c2d1a");
    private boolean hasPlayedFullChargeSound = false;
    private boolean hasAutoTriggered = false;
    private int consumptionTickCounter = 0;

    public MeenLanceInnate(ComboBasicAttack.Builder builder) {
        super(builder);
    }

    @Override
    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, MOVEMENT_LOCK_UUID, event -> {
            SkillContainer skillContainer = ((LocalPlayerPatch)event.getPlayerPatch()).getSkill(Meenlance.Meenlance);
            if (skillContainer == null || !((Boolean)skillContainer.getDataManager().getDataValue((SkillDataKey)EFNSKillDataKeys.IS_CHARGING.get())).booleanValue()) {
                return;
            }
            Input input = event.getMovementInput();
            input.f_108567_ = 0.0f;
            input.f_108566_ = 0.0f;
            input.f_108572_ = false;
            input.f_108573_ = false;
            if (((LocalPlayerPatch)event.getPlayerPatch()).isLogicalClient()) {
                LocalPlayer player = (LocalPlayer)((LocalPlayerPatch)event.getPlayerPatch()).getOriginal();
                player.m_6858_(false);
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.ATTACK_PHASE_END_EVENT, ANIMATION_EVENT_UUID, event -> {
            StaticAnimation animation = (StaticAnimation)event.getAnimation().get();
            PlayerPatch executor = container.getExecutor();
            SkillDataManager dataManager = container.getDataManager();
            if (animation == FULL_CHARGE_ANIM.get() || animation == MID_CHARGE_ANIM.get() || animation == LOW_CHARGE_ANIM.get() || animation == MIN_CHARGE_ANIM.get()) {
                if (animation == MIN_CHARGE_ANIM.get() && ((Boolean)dataManager.getDataValue((SkillDataKey)EFNSKillDataKeys.IS_CHARGING.get())).booleanValue()) {
                    return;
                }
                this.resetChargeState(dataManager, executor.getOriginal());
                if (executor instanceof ServerPlayerPatch) {
                    SkillContainer weaponInnate;
                    ServerPlayerPatch serverPatch = (ServerPlayerPatch)executor;
                    if (((ServerPlayer)serverPatch.getOriginal()).m_7500_()) {
                        return;
                    }
                    int cost = 0;
                    if (animation == FULL_CHARGE_ANIM.get()) {
                        cost = 10;
                    } else if (animation == MID_CHARGE_ANIM.get()) {
                        cost = 5;
                    } else if (animation == LOW_CHARGE_ANIM.get()) {
                        cost = 3;
                    }
                    if (cost > 0 && (weaponInnate = serverPatch.getSkill(Meenlance.Meenlance)) != null && weaponInnate.getStack() >= cost) {
                        weaponInnate.getSkill().setStackSynchronize(weaponInnate, weaponInnate.getStack() - cost);
                    }
                }
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, ENERGY_CHECK_UUID, event -> {
            if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)EFNSKillDataKeys.IS_PRESSING.get())).booleanValue()) {
                ServerPlayerPatch serverPatch;
                PlayerPatch patt7174$temp = container.getExecutor();
                if (patt7174$temp instanceof ServerPlayerPatch && ((ServerPlayer)(serverPatch = (ServerPlayerPatch)patt7174$temp).getOriginal()).m_7500_()) {
                    return;
                }
                SkillContainer weaponInnate = container.getExecutor().getSkill(Meenlance.Meenlance);
                int chargeTime = (Integer)container.getDataManager().getDataValue((SkillDataKey)EFNSKillDataKeys.CHARGE_TICKS.get());
                if (weaponInnate == null) {
                    container.getDataManager().setData((SkillDataKey)EFNSKillDataKeys.IS_PRESSING.get(), (Object)false);
                    this.hasAutoTriggered = true;
                }
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.SKILL_CAST_EVENT, DISABLE_GUARD_UUID, event -> {
            if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)EFNSKillDataKeys.IS_CHARGING.get())).booleanValue() && event.getSkillContainer().getSkill() instanceof HoldableSkill) {
                event.setCanceled(true);
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.ANIMATION_BEGIN_EVENT, ANIMATION_INTERRUPT_LISTENER_UUID, event -> {
            if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)EFNSKillDataKeys.IS_CHARGING.get())).booleanValue() && !this.isChargeRelatedAnimation(event.getAnimation())) {
                this.cancelCharging(container);
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        this.hasPlayedFullChargeSound = false;
        this.hasAutoTriggered = false;
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, MOVEMENT_LOCK_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, CHARGE_UPDATE_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.ATTACK_PHASE_END_EVENT, ANIMATION_EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, ENERGY_CHECK_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.SKILL_CAST_EVENT, DISABLE_GUARD_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.ANIMATION_BEGIN_EVENT, ANIMATION_INTERRUPT_LISTENER_UUID);
        super.onRemoved(container);
    }

    public void updateContainer(SkillContainer container) {
        PlayerPatch playerPatch;
        super.updateContainer(container);
        if (!container.getExecutor().isLogicalClient() && (playerPatch = container.getExecutor()) instanceof ServerPlayerPatch) {
            ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)playerPatch;
            ServerPlayer player = (ServerPlayer)serverPlayerPatch.getOriginal();
            boolean wearingFullSet = DuskFireArmorHelper.isWearingFullDuskFireArmor((Player)player);
            if (wearingFullSet) {
                ++this.consumptionTickCounter;
                if (this.consumptionTickCounter >= 20) {
                    float maxConsumption;
                    this.consumptionTickCounter = 0;
                    float currentConsumption = container.getResource();
                    float newConsumption = Math.min(currentConsumption + 5.0f, maxConsumption = container.getMaxResource());
                    if (newConsumption > currentConsumption) {
                        this.setConsumptionSynchronize(container, newConsumption);
                    }
                }
            } else if (this.consumptionTickCounter > 0) {
                this.consumptionTickCounter = 0;
            }
        }
        if (container.getExecutor().getEntityState().inaction()) {
            return;
        }
        if (this.isPlayingFullChargeAnimation(container)) {
            return;
        }
        if (container.getExecutor().isLogicalClient()) {
            this.handleClientInput(container);
        } else {
            this.validateServerState(container);
        }
    }

    private boolean isPlayingFullChargeAnimation(SkillContainer container) {
        PlayerPatch executor = container.getExecutor();
        AnimationPlayer animPlayer = executor.getAnimator().getPlayerFor(FULL_CHARGE_ANIM);
        return animPlayer != null && animPlayer.getAnimation() == FULL_CHARGE_ANIM.get();
    }

    private void handleClientInput(SkillContainer container) {
        boolean isHoldingSpear;
        LocalPlayer player = (LocalPlayer)container.getExecutor().getOriginal();
        SkillDataManager data = container.getDataManager();
        if (player.m_9236_().f_46443_ && Minecraft.m_91087_().f_91080_ != null) {
            return;
        }
        ItemStack heldItem = player.m_21205_();
        boolean bl = isHoldingSpear = EpicFightCapabilities.getItemStackCapability((ItemStack)heldItem) != null && EpicFightCapabilities.getItemStackCapability((ItemStack)heldItem).getInnateSkill(container.getExecutor(), heldItem) == this;
        if (!isHoldingSpear && ((Boolean)data.getDataValue((SkillDataKey)EFNSKillDataKeys.IS_CHARGING.get())).booleanValue()) {
            this.resetChargeState(data, player);
            return;
        }
        if (isHoldingSpear) {
            boolean isKeyDown = false;
            boolean wasPressing = (Boolean)data.getDataValue((SkillDataKey)EFNSKillDataKeys.IS_PRESSING.get());
            if (player.m_9236_().f_46443_) {
                long windowHandle = Minecraft.m_91087_().m_91268_().m_85439_();
                boolean isRightMouseDown = GLFW.glfwGetMouseButton((long)windowHandle, (int)1) == 1;
                boolean isLeftMouseDown = GLFW.glfwGetMouseButton((long)windowHandle, (int)0) == 1;
                boolean bl2 = isKeyDown = isRightMouseDown && isLeftMouseDown;
            }
            if (isKeyDown != wasPressing) {
                if (player.m_9236_().f_46443_) {
                    data.setDataSync((SkillDataKey)EFNSKillDataKeys.IS_PRESSING.get(), (Object)isKeyDown, player);
                }
                if (isKeyDown) {
                    SkillContainer weaponInnate = container.getExecutor().getSkill((SkillSlot)SkillSlots.WEAPON_INNATE);
                    if (weaponInnate != null && (weaponInnate.getStack() >= 10 || player.m_150110_().f_35937_)) {
                        this.startCharging(container, player, data);
                    } else {
                        this.triggerEnergyDeficiencyAttack(container, player);
                    }
                } else {
                    int chargeTime = (Integer)data.getDataValue((SkillDataKey)EFNSKillDataKeys.CHARGE_TICKS.get());
                    if (!this.hasAutoTriggered) {
                        this.releaseAttack(container, chargeTime, player, false, 10);
                    }
                }
            }
        }
    }

    private void triggerEnergyDeficiencyAttack(SkillContainer container, LocalPlayer player) {
        if (!container.getExecutor().getEntityState().inaction()) {
            container.getExecutor().playAnimationSynchronized(MIN_CHARGE_ANIM, -0.3f);
        }
    }

    private boolean isPlayingChargeAnimation(PlayerPatch<?> playerPatch) {
        AnimationPlayer chargingAnim = playerPatch.getAnimator().getPlayerFor(CHARGING_ANIM);
        AnimationPlayer fullChargeAnim = playerPatch.getAnimator().getPlayerFor(FULL_CHARGE_ANIM);
        AnimationPlayer midChargeAnim = playerPatch.getAnimator().getPlayerFor(MID_CHARGE_ANIM);
        AnimationPlayer lowChargeAnim = playerPatch.getAnimator().getPlayerFor(LOW_CHARGE_ANIM);
        return chargingAnim != null && chargingAnim.getAnimation() == CHARGING_ANIM.get() || fullChargeAnim != null && fullChargeAnim.getAnimation() == FULL_CHARGE_ANIM.get() || midChargeAnim != null && midChargeAnim.getAnimation() == MID_CHARGE_ANIM.get() || lowChargeAnim != null && lowChargeAnim.getAnimation() == LOW_CHARGE_ANIM.get();
    }

    private boolean isChargeRelatedAnimation(StaticAnimation animation) {
        return animation.getRealAnimation().equals(CHARGING_ANIM) || animation.getRealAnimation().equals(FULL_CHARGE_ANIM) || animation.getRealAnimation().equals(MID_CHARGE_ANIM) || animation.getRealAnimation().equals(LOW_CHARGE_ANIM);
    }

    private void cancelCharging(SkillContainer container) {
        SkillDataManager data = container.getDataManager();
        if (!data.hasData((SkillDataKey)EFNSKillDataKeys.IS_CHARGING.get()) || !data.hasData((SkillDataKey)EFNSKillDataKeys.IS_PRESSING.get())) {
            return;
        }
        data.setDataSync((SkillDataKey)EFNSKillDataKeys.IS_CHARGING.get(), (Object)false);
        data.setDataSync((SkillDataKey)EFNSKillDataKeys.CHARGE_TICKS.get(), (Object)0);
        PlayerPatch playerPatch = container.getExecutor();
        if (playerPatch instanceof ServerPlayerPatch) {
            ServerPlayerPatch serverPatch = (ServerPlayerPatch)playerPatch;
            if (data.hasData((SkillDataKey)EFNSKillDataKeys.IS_PRESSING.get())) {
                data.setDataSync((SkillDataKey)EFNSKillDataKeys.IS_PRESSING.get(), (Object)false, (ServerPlayer)serverPatch.getOriginal());
            }
        }
        this.hasAutoTriggered = false;
    }

    private void startCharging(SkillContainer container, LocalPlayer player, SkillDataManager data) {
        PlayerPatch executor = container.getExecutor();
        if (this.isPlayingChargeAnimation(executor)) {
            return;
        }
        if (!executor.getEntityState().inaction() && !((Boolean)data.getDataValue((SkillDataKey)EFNSKillDataKeys.IS_CHARGING.get())).booleanValue()) {
            Skill skill;
            data.setDataSync((SkillDataKey)EFNSKillDataKeys.IS_CHARGING.get(), (Object)true, player);
            data.setDataSync((SkillDataKey)EFNSKillDataKeys.CHARGE_TICKS.get(), (Object)0, player);
            SkillContainer skillContainer = container.getExecutor().getSkill((SkillSlot)SkillSlots.GUARD);
            if (skillContainer != null && (skill = skillContainer.getSkill()) instanceof HoldableSkill) {
                HoldableSkill holdableSkill = (HoldableSkill)skill;
                if (skillContainer.isActivated()) {
                    skillContainer.deactivate();
                }
            }
            this.hasAutoTriggered = false;
            executor.playAnimationSynchronized(CHARGING_ANIM, 0.0f);
        }
    }

    private void releaseAttack(SkillContainer container, int chargeTime, LocalPlayer player, boolean isAutoTrigger, int currentEnergy) {
        PlayerPatch executor = container.getExecutor();
        SkillDataManager data = container.getDataManager();
        if (this.isPlayingChargeAnimation(executor)) {
            return;
        }
        if (chargeTime < 15 && currentEnergy >= 10) {
            executor.playAnimationSynchronized(MIN_CHARGE_ANIM, -0.3f);
            this.resetChargeState(data, player);
            data.setDataSync((SkillDataKey)EFNSKillDataKeys.IS_PRESSING.get(), (Object)false, player);
            return;
        }
        if (currentEnergy >= 10) {
            this.playAttackAnimation(container, chargeTime, isAutoTrigger, currentEnergy);
        }
    }

    private void resetChargeState(SkillDataManager data, Object player) {
        if (player instanceof ServerPlayer) {
            data.setDataSync((SkillDataKey)EFNSKillDataKeys.IS_CHARGING.get(), (Object)false, (ServerPlayer)player);
            data.setDataSync((SkillDataKey)EFNSKillDataKeys.CHARGE_TICKS.get(), (Object)0, (ServerPlayer)player);
            data.setDataSync((SkillDataKey)EFNSKillDataKeys.IS_PRESSING.get(), (Object)false, (ServerPlayer)player);
        } else if (player instanceof LocalPlayer) {
            data.setDataSync((SkillDataKey)EFNSKillDataKeys.IS_CHARGING.get(), (Object)false, (LocalPlayer)player);
            data.setDataSync((SkillDataKey)EFNSKillDataKeys.CHARGE_TICKS.get(), (Object)0, (LocalPlayer)player);
            data.setDataSync((SkillDataKey)EFNSKillDataKeys.IS_PRESSING.get(), (Object)false, (LocalPlayer)player);
        } else {
            data.setData((SkillDataKey)EFNSKillDataKeys.IS_CHARGING.get(), (Object)false);
            data.setData((SkillDataKey)EFNSKillDataKeys.CHARGE_TICKS.get(), (Object)0);
            data.setData((SkillDataKey)EFNSKillDataKeys.IS_PRESSING.get(), (Object)false);
        }
        this.hasAutoTriggered = true;
    }

    private void playAttackAnimation(SkillContainer container, int chargeTime, boolean isAutoTrigger, int currentEnergy) {
        AnimationManager.AnimationAccessor<? extends AttackAnimation> anim;
        PlayerPatch executor = container.getExecutor();
        SkillDataManager data = container.getDataManager();
        if (executor.getEntityState().inaction()) {
            return;
        }
        if (chargeTime >= 60) {
            anim = FULL_CHARGE_ANIM;
        } else if (chargeTime >= 35) {
            anim = MID_CHARGE_ANIM;
            executor.playSound(SoundEvents.f_12518_, 120.0f, 0.0f, 0.0f);
        } else {
            anim = LOW_CHARGE_ANIM;
            executor.playSound(SoundEvents.f_12517_, 120.0f, 0.0f, 0.0f);
        }
        this.resetChargeState(data, executor.getOriginal());
        executor.playAnimationSynchronized(anim, -0.05f);
        if (!executor.isLogicalClient() && anim == FULL_CHARGE_ANIM) {
            ServerPlayer player = (ServerPlayer)executor.getOriginal();
            Vec3 pos = player.m_20182_();
            player.m_284548_().m_8767_((ParticleOptions)ParticleTypes.f_175827_, pos.f_82479_, pos.f_82480_ + 1.0, pos.f_82481_, 15, 0.5, 0.2, 0.5, 0.5);
        }
    }

    private void validateServerState(SkillContainer container) {
        ServerPlayerPatch serverPatch = (ServerPlayerPatch)container.getExecutor();
        SkillDataManager data = container.getDataManager();
        if (((Boolean)data.getDataValue((SkillDataKey)EFNSKillDataKeys.IS_CHARGING.get())).booleanValue()) {
            int currentTime = (Integer)data.getDataValue((SkillDataKey)EFNSKillDataKeys.CHARGE_TICKS.get());
            int newTime = Math.min(currentTime + 1, 60);
            data.setDataSync((SkillDataKey)EFNSKillDataKeys.CHARGE_TICKS.get(), (Object)newTime, (ServerPlayer)serverPatch.getOriginal());
        } else {
            this.hasPlayedFullChargeSound = false;
        }
    }

    public List<Component> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerpatch) {
        ArrayList list = Lists.newArrayList();
        list.add(Component.m_237115_((String)"skill.efn.meenlance.tooltip").m_130940_(ChatFormatting.GOLD));
        list.add(Component.m_237115_((String)"skill.efn.meenlance.tooltip1").m_130940_(ChatFormatting.GOLD));
        list.add(Component.m_237115_((String)"skill.efn.meenlance.tooltip2"));
        list.add(Component.m_237115_((String)"skill.efn.meenlance.tooltip3").m_130940_(ChatFormatting.RED));
        list.add(Component.m_237115_((String)"skill.efn.meenlance.tooltip4"));
        return list;
    }

    public boolean isHasPlayedFullChargeSound() {
        return this.hasPlayedFullChargeSound;
    }
}

