/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.skill.weapon_innate;

import com.google.common.collect.Lists;
import com.hm.efn.EFN;
import com.hm.efn.EFNCommonConfig;
import com.hm.efn.comboevents.events.TickChange;
import com.hm.efn.gameasset.animations.EFNDualSwordAnimations;
import com.hm.efn.gameasset.combos.Aetherialdusk;
import com.hm.efn.registries.EFNMobEffectRegistry;
import com.hm.efn.skill.EFNWeaponInnateBase;
import com.p1nero.invincible.capability.InvinciblePlayerCapabilityProvider;
import com.p1nero.invincible.client.InvincibleKeyMappings;
import com.p1nero.invincible.skill.ComboBasicAttack;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class AetherialDuskDualSwordInnate
extends EFNWeaponInnateBase {
    private static final UUID DODGE_SUCCESS_UUID = UUID.fromString("a496c93a-42cb-12eb-b378-0242ac170004");
    private static final UUID DAMAGE_EVENT_UUID = UUID.fromString("b496c93a-42cb-21eb-b378-0242ac170005");
    private static final float TRANSITION_TIME = 0.0f;
    private static final float INVINCIBLE_DURATION = 2.0f;

    public AetherialDuskDualSwordInnate(ComboBasicAttack.Builder builder) {
        super(builder);
    }

    @Override
    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        SkillDataManager data = container.getDataManager();
        PlayerEventListener listener = container.getExecutor().getEventListener();
        listener.addEventListener(PlayerEventListener.EventType.DODGE_SUCCESS_EVENT, DODGE_SUCCESS_UUID, event -> {
            ServerPlayerPatch playerPatch = (ServerPlayerPatch)container.getExecutor();
            ServerPlayer player = (ServerPlayer)playerPatch.getOriginal();
            if (!player.m_6084_() || player.m_20202_() != null || !this.isHoldingWeapon(container)) {
                return;
            }
            playerPatch.playAnimationSynchronized(EFNDualSwordAnimations.NF_DUAL_DODGE, 0.0f);
            playerPatch.playSound(SoundEvents.f_12317_, 1.4f, 0.8f, 1.2f);
            player.m_7292_(new MobEffectInstance((MobEffect)EFNMobEffectRegistry.SIN_STUN_IMMUNITY.get(), 40, 1, false, false, false));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 40, 5, false, false, false));
            if (((Boolean)EFNCommonConfig.ENABLE_DUALSOWRD_DODGE_TIMESLOWDOWN.get()).booleanValue()) {
                boolean isDedicatedServer;
                Level level = ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_9236_();
                int playerCount = level.m_6907_().size();
                boolean bl = isDedicatedServer = level.m_7654_() != null && level.m_7654_().m_6982_();
                if (!isDedicatedServer) {
                    ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19597_, 6, 3, false, false, false));
                    int BegindelayTicks = (Integer)EFNCommonConfig.DUALSOWRD_DODGE_TIMESLOW_DELAY_BEGIN.get();
                    int EndTicks = (Integer)EFNCommonConfig.DUALSOWRD_DODGE_TIMESLOW_DELAY_END.get();
                    int amplifier = (Integer)EFNCommonConfig.DUALSOWRD_DODGE_TIMESLOW_AMPLIFIER.get();
                    if (playerCount <= 1) {
                        EFN.queueServerWork(BegindelayTicks, () -> {
                            EFN.queueServerWork(BegindelayTicks, () -> TickChange.requestChange(amplifier));
                            EFN.queueServerWork(EndTicks, () -> TickChange.requestChange(20.0f));
                        });
                    }
                }
            }
            player.getCapability(InvinciblePlayerCapabilityProvider.INVINCIBLE_PLAYER).ifPresent(inv -> inv.setCurrentNode(Aetherialdusk.DodgeCounter));
        });
        listener.addEventListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, DAMAGE_EVENT_UUID, event -> {
            ServerPlayerPatch playerPatch = (ServerPlayerPatch)container.getExecutor();
            ServerPlayer player = (ServerPlayer)playerPatch.getOriginal();
            if (!player.m_6084_() || !this.isHoldingWeapon(container)) {
                return;
            }
            AnimationPlayer dodgeAnim = playerPatch.getAnimator().getPlayerFor(EFNDualSwordAnimations.NF_DUAL_DODGE);
            if (dodgeAnim != null && dodgeAnim.getAnimation() == EFNDualSwordAnimations.NF_DUAL_DODGE && dodgeAnim.getElapsedTime() <= 2.0f) {
                event.setCanceled(true);
                event.setResult(AttackResult.ResultType.MISSED);
            }
        }, 0);
    }

    private boolean isHoldingWeapon(SkillContainer container) {
        ItemStack itemstack = ((Player)container.getExecutor().getOriginal()).m_21205_();
        return EpicFightCapabilities.getItemStackCapability((ItemStack)itemstack).getInnateSkill(container.getExecutor(), itemstack) == this;
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        PlayerEventListener listener = container.getExecutor().getEventListener();
        listener.removeListener(PlayerEventListener.EventType.DODGE_SUCCESS_EVENT, DODGE_SUCCESS_UUID);
        listener.removeListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, DAMAGE_EVENT_UUID, 0);
    }

    public List<Component> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerpatch) {
        ArrayList list = Lists.newArrayList();
        String keyName = Component.m_237115_((String)InvincibleKeyMappings.KEY3.m_90860_()).getString();
        list.add(Component.m_237115_((String)"skill.efn.aetherialdusk.tooltip").m_130940_(ChatFormatting.AQUA));
        list.add(Component.m_237115_((String)"skill.efn.aetherialdusk.tooltip1").m_7220_((Component)Component.m_237113_((String)keyName)).m_130946_(": ").m_130940_(ChatFormatting.AQUA).m_7220_(InvincibleKeyMappings.KEY3.m_90863_()));
        list.add(Component.m_237115_((String)"skill.efn.aetherialdusk.tooltip2"));
        list.add(Component.m_237115_((String)"skill.efn.aetherialdusk.tooltip3").m_130940_(ChatFormatting.BLUE));
        list.add(Component.m_237115_((String)"skill.efn.aetherialdusk.tooltip4"));
        return list;
    }
}

