/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.skill.passive;

import com.hm.efn.client.sound.EFNSounds;
import com.hm.efn.gameasset.EFNSKillDataKeys;
import com.hm.efn.gameasset.EFNSkills;
import com.hm.efn.registries.EFNMobEffectRegistry;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.gameasset.EpicFightSkills;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.guard.GuardSkill;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.EpicFightDamageTypeTags;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class PreciseParryPassive
extends PassiveSkill {
    private static final UUID EVENT_UUID = UUID.fromString("a1b2c3d4-5678-90ef-1234-56789abcdef2");
    private static final UUID DAMAGE_EVENT_UUID = UUID.fromString("b1b2c3d4-5678-90ef-1234-56789abcdef1");
    private static final float BUFF_DURATION = 0.7f;
    private float damageMultiplier = 1.5f;
    private float windowStart = 0.0f;
    private float windowEnd = 0.13f;

    public PreciseParryPassive(Builder builder) {
        super((SkillBuilder)builder);
    }

    public static Builder createPreciseParryBuilder() {
        return (Builder)new Builder().setCategory((SkillCategory)SkillCategories.PASSIVE).setResource(Skill.Resource.NONE);
    }

    public void setParams(CompoundTag parameters) {
        super.setParams(parameters);
        this.damageMultiplier = parameters.m_128441_("damage_multiplier") ? parameters.m_128457_("damage_multiplier") : this.damageMultiplier;
        this.windowStart = parameters.m_128441_("window_start") ? parameters.m_128457_("window_start") : this.windowStart;
        float f = this.windowEnd = parameters.m_128441_("window_end") ? parameters.m_128457_("window_end") : this.windowEnd;
        if (this.windowEnd <= this.windowStart) {
            this.windowEnd = this.windowStart + 0.05f;
        }
    }

    public void onInitiate(SkillContainer container) {
        PlayerEventListener listener = container.getExecutor().getEventListener();
        SkillDataManager data = container.getDataManager();
        listener.addEventListener(PlayerEventListener.EventType.SKILL_CAST_EVENT, EVENT_UUID, event -> {
            if (event.getSkillContainer().getSkill() instanceof GuardSkill && !container.getExecutor().isLogicalClient()) {
                ServerPlayer player = (ServerPlayer)container.getExecutor().getOriginal();
                int currentTick = player.f_19797_;
                data.setDataSync((SkillDataKey)EFNSKillDataKeys.DEFENSE_START_TICK.get(), (Object)currentTick, player);
            }
        });
        listener.addEventListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, EVENT_UUID, event -> {
            if (event.isParried() && !container.getExecutor().isLogicalClient()) {
                boolean haveEFNParry;
                ServerPlayer player = (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
                SkillContainer weaponSkillContainer = ((ServerPlayerPatch)event.getPlayerPatch()).getSkill((SkillSlot)SkillSlots.WEAPON_INNATE);
                int currentTick = player.f_19797_;
                int defenseStart = (Integer)data.getDataValue((SkillDataKey)EFNSKillDataKeys.DEFENSE_START_TICK.get());
                float elapsed = (float)(currentTick - defenseStart) / 20.0f;
                int currentStack = weaponSkillContainer.getStack();
                int maxStack = weaponSkillContainer.getSkill().getMaxStack();
                int newCharge = Math.min(maxStack, currentStack + 1);
                SkillContainer efnParryContainer = container.getExecutor().getSkill(EFNSkills.EFN_PARRY);
                boolean bl = haveEFNParry = efnParryContainer != null && efnParryContainer.hasSkill();
                if (elapsed >= this.windowStart && elapsed <= this.windowEnd) {
                    data.setDataSync((SkillDataKey)EFNSKillDataKeys.BUFF_ACTIVE.get(), (Object)true, player);
                    data.setDataSync((SkillDataKey)EFNSKillDataKeys.BUFF_END_TICK.get(), (Object)(currentTick + 14), player);
                    if (!haveEFNParry) {
                        ((ServerPlayerPatch)event.getPlayerPatch()).playSound((SoundEvent)EFNSounds.PARRY.get(), 0.6f, 0.0f, 0.0f);
                    }
                    ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_7292_(new MobEffectInstance((MobEffect)EFNMobEffectRegistry.RING.get(), 30, 0, false, false, false));
                    ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19598_, 30, 3, false, false, false));
                    ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19606_, 30, 2, false, false, false));
                    ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19601_, 1, 2, false, false, false));
                    weaponSkillContainer.getSkill().setStackSynchronize(weaponSkillContainer, newCharge);
                }
            }
        }, -1);
        listener.addEventListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_ATTACK, DAMAGE_EVENT_UUID, event -> {
            if (!container.getExecutor().isLogicalClient()) {
                ServerPlayer player = (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
                boolean isBuffActive = (Boolean)data.getDataValue((SkillDataKey)EFNSKillDataKeys.BUFF_ACTIVE.get());
                if (isBuffActive) {
                    int currentTick = player.f_19797_;
                    int buffEnd = (Integer)data.getDataValue((SkillDataKey)EFNSKillDataKeys.BUFF_END_TICK.get());
                    if (currentTick <= buffEnd) {
                        if (event.getDamageSource() instanceof EpicFightDamageSource) {
                            EpicFightDamageSource damageSource = event.getDamageSource();
                            damageSource.attachDamageModifier(ValueModifier.multiplier((float)this.damageMultiplier));
                            damageSource.attachArmorNegationModifier((ValueModifier)new ValueModifier.Multiplier(damageSource.getBaseArmorNegation() * 2.0f));
                            damageSource.setStunType(StunType.LONG);
                            damageSource.addRuntimeTag(EpicFightDamageTypeTags.GUARD_PUNCTURE);
                            ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_7292_(new MobEffectInstance((MobEffect)EFNMobEffectRegistry.INVINCIBILITY_EFFECT.get(), 10, 0, false, false, false));
                            ((ServerPlayerPatch)event.getPlayerPatch()).playSound((SoundEvent)EpicFightSounds.EVISCERATE.get(), 0.0f, 0.0f);
                            data.setDataSync((SkillDataKey)EFNSKillDataKeys.BUFF_ACTIVE.get(), (Object)false, player);
                        }
                    } else {
                        data.setDataSync((SkillDataKey)EFNSKillDataKeys.BUFF_ACTIVE.get(), (Object)false, player);
                    }
                }
            }
        });
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        if (!container.getExecutor().isLogicalClient()) {
            int buffEnd;
            int currentTick;
            ServerPlayer player = (ServerPlayer)container.getExecutor().getOriginal();
            SkillDataManager data = container.getDataManager();
            boolean isBuffActive = (Boolean)data.getDataValue((SkillDataKey)EFNSKillDataKeys.BUFF_ACTIVE.get());
            if (isBuffActive && (currentTick = player.f_19797_) > (buffEnd = ((Integer)data.getDataValue((SkillDataKey)EFNSKillDataKeys.BUFF_END_TICK.get())).intValue())) {
                data.setDataSync((SkillDataKey)EFNSKillDataKeys.BUFF_ACTIVE.get(), (Object)false, player);
            }
        }
    }

    public void onRemoved(SkillContainer container) {
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.SKILL_CAST_EVENT, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, EVENT_UUID, -1);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_ATTACK, DAMAGE_EVENT_UUID);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return false;
    }

    public Skill getPriorSkill() {
        return EpicFightSkills.PARRYING;
    }

    public static class Builder
    extends SkillBuilder<PreciseParryPassive> {
    }
}

