/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.skill.arts;

import com.hm.efn.client.input.keymapping.EFNKeyMappings;
import com.hm.efn.gameasset.EFNSKillDataKeys;
import com.hm.efn.gameasset.EFNSkillCategories;
import com.hm.efn.gameasset.animations.EFNSkillAnimations;
import com.hm.efn.gameasset.combos.Yamato;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPSkillRequest;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class StompSkill
extends PassiveSkill {
    private static final UUID EVENT_UUID = UUID.fromString("a416c93a-42cb-11eb-b378-0721ac170003");
    private float stamina_cost;
    private int cooldown;

    public StompSkill(Builder builder) {
        super((SkillBuilder)builder);
    }

    public static Builder createStompBuilder() {
        return (Builder)new Builder().setCategory(EFNSkillCategories.EFN_ARTS).setActivateType(Skill.ActivateType.ONE_SHOT).setResource(Skill.Resource.NONE);
    }

    public void setParams(CompoundTag parameters) {
        super.setParams(parameters);
        this.cooldown = parameters.m_128451_("cooldown");
        this.stamina_cost = parameters.m_128451_("stamina_cost");
    }

    public boolean canExecute(SkillContainer container) {
        PlayerPatch executor = container.getExecutor();
        SkillContainer yamatoSkillContainer = executor.getSkill(Yamato.yamato);
        if (yamatoSkillContainer != null && yamatoSkillContainer.hasSkill()) {
            return false;
        }
        boolean isOnGround = ((Player)executor.getOriginal()).m_20096_();
        boolean isCreative = ((Player)executor.getOriginal()).m_7500_();
        return isOnGround && (isCreative || (Integer)container.getDataManager().getDataValue((SkillDataKey)EFNSKillDataKeys.COOLDOWN.get()) <= 0);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        if (container.getExecutor().isLogicalClient()) {
            container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID, event -> this.handleKeyInput(container));
        }
    }

    public void onRemoved(SkillContainer container) {
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID);
    }

    public void updateContainer(SkillContainer container) {
        int currentCooldown;
        super.updateContainer(container);
        if (container.getExecutor().isLogicalClient()) {
            this.handleKeyInput(container);
        }
        if ((currentCooldown = ((Integer)container.getDataManager().getDataValue((SkillDataKey)EFNSKillDataKeys.COOLDOWN.get())).intValue()) > 0) {
            container.getDataManager().setData((SkillDataKey)EFNSKillDataKeys.COOLDOWN.get(), (Object)(currentCooldown - 1));
        }
    }

    private void handleKeyInput(SkillContainer container) {
        if (EFNKeyMappings.EFN_ARTS.m_90857_()) {
            CPSkillRequest packet = new CPSkillRequest((SkillSlot)SkillSlot.ENUM_MANAGER.get(container.getSlot().universalOrdinal()), CPSkillRequest.WorkType.CAST);
            EpicFightNetworkManager.sendToServer((Object)packet);
        }
    }

    public void executeOnServer(SkillContainer container, FriendlyByteBuf args) {
        super.executeOnServer(container, args);
        PlayerPatch executor = container.getExecutor();
        if (!((Player)executor.getOriginal()).m_7500_()) {
            float currentStamina = executor.getStamina();
            executor.setStamina(currentStamina - this.stamina_cost);
            executor.setStaminaRegenAwaitTicks(5);
        }
        container.getDataManager().setDataSync((SkillDataKey)EFNSKillDataKeys.COOLDOWN.get(), (Object)this.cooldown);
        container.getServerExecutor().playAnimationSynchronized(EFNSkillAnimations.STOMP, 0.1f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        PlayerPatch executer = container.getExecutor();
        boolean hasEnoughStamina = executer.getStamina() >= this.stamina_cost;
        boolean isOnCooldown = (Integer)container.getDataManager().getDataValue((SkillDataKey)EFNSKillDataKeys.COOLDOWN.get()) > 0;
        return !hasEnoughStamina || isOnCooldown;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgsOfScreen(List<Object> list) {
        list.add(EFNKeyMappings.EFN_ARTS.m_90863_());
        list.add(Float.valueOf(this.stamina_cost));
        list.add((double)this.cooldown / 20.0);
        return list;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y, float partialTick) {
        boolean hasEnoughStamina;
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, (float)gui.getSlidingProgression(), 0.0f);
        guiGraphics.m_280411_(this.getSkillTexture(), (int)x, (int)y, 24, 24, 0.0f, 0.0f, 1, 1, 1, 1);
        PlayerPatch executer = container.getExecutor();
        boolean bl = hasEnoughStamina = executer.getStamina() >= this.stamina_cost;
        if (!hasEnoughStamina) {
            guiGraphics.drawString(gui.getFont(), "No Stamina", x + 2.0f, y + 8.0f, 0xFF5555, true);
        } else {
            int currentCooldown = (Integer)container.getDataManager().getDataValue((SkillDataKey)EFNSKillDataKeys.COOLDOWN.get());
            if (currentCooldown > 0) {
                guiGraphics.drawString(gui.getFont(), String.format("%.1f", (double)currentCooldown / 20.0), x + 2.0f, y + 8.0f, 0xFFFFFF, true);
            }
        }
        poseStack.m_85849_();
    }

    public static class Builder
    extends SkillBuilder<StompSkill> {
    }
}

