/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.skill.arts;

import com.hm.efn.client.input.keymapping.EFNKeyMappings;
import com.hm.efn.entity.skill.SoulHuntOrb;
import com.hm.efn.gameasset.EFNSKillDataKeys;
import com.hm.efn.gameasset.EFNSkillCategories;
import com.hm.efn.gameasset.animations.EFNSkillAnimations;
import com.hm.efn.gameasset.combos.Yamato;
import com.hm.efn.network.EFNNetworkHandler;
import com.hm.efn.network.SoulAfterimagePacket;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPSkillRequest;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.entity.eventlistener.PlayerKilledEvent;

public class ExecuteSkill
extends PassiveSkill {
    private static final UUID EVENT_UUID = UUID.fromString("a416c93a-42cb-11eb-b378-0171ac170003");
    private static final UUID KILL_EVENT_UUID = UUID.fromString("a416c93a-42cb-11eb-b378-0171ac170004");
    private static final UUID DAMAGE_EVENT_UUID = UUID.fromString("a416c93a-42cb-22eb-b378-0171ac170004");
    private static final UUID ANIMATION_BEGIN_EVENT_UUID = UUID.fromString("a416c93a-42cb-33eb-b378-0171ac170004");
    private static final UUID PARRY_EVENT_UUID = UUID.fromString("a416c93a-42cb-11eb-b378-0721ac170005");
    private static final UUID DODGE_EVENT_UUID = UUID.fromString("a416c93a-42cb-22eb-b378-0721ac170005");
    private int cooldown;
    private int parryCooldownReduction;
    private int dodgeSuccessCooldownReduction;
    private int killCooldownReduction;
    private int skillKillCooldownReduction;
    private int neutralizeTargetHitCooldownReduction;
    private int skillKillStackReward;
    private int neutralizeTargetHitStackReward;
    private float neutralizeTargetHitDamageMultiplier;
    private float neutralizeTargetHitImpactMultiplier;
    private List<LivingEntity> currentNeutralizeEntities = new ArrayList<LivingEntity>();

    public ExecuteSkill(Builder builder) {
        super((SkillBuilder)builder);
    }

    public static Builder createExecuteBuilder() {
        return (Builder)new Builder().setCategory(EFNSkillCategories.EFN_ARTS).setActivateType(Skill.ActivateType.ONE_SHOT).setResource(Skill.Resource.NONE);
    }

    @NotNull
    private static SoulHuntOrb getSoulHuntOrb(int i, Player original, LivingEntity target) {
        double offsetX = (double)(i - 1) * 0.5;
        double offsetY = (double)i * 0.3;
        double offsetZ = i % 2 == 0 ? 0.3 : -0.3;
        return new SoulHuntOrb(original, target.m_20185_() + offsetX, target.m_20186_() + (double)target.m_20206_() * 0.5 + offsetY, target.m_20189_() + offsetZ);
    }

    public void setParams(CompoundTag parameters) {
        super.setParams(parameters);
        this.cooldown = parameters.m_128451_("cooldown");
        this.parryCooldownReduction = parameters.m_128451_("parry_cooldown_reduction");
        this.dodgeSuccessCooldownReduction = parameters.m_128451_("dodge_cooldown_reduction");
        this.killCooldownReduction = parameters.m_128451_("kill_cooldown_reduction");
        this.skillKillCooldownReduction = parameters.m_128451_("skill_kill_cooldown_reduction");
        this.neutralizeTargetHitCooldownReduction = parameters.m_128451_("neutralize_target_hit_cooldown_reduction");
        this.skillKillStackReward = parameters.m_128451_("skill_kill_stack_reward");
        this.neutralizeTargetHitStackReward = parameters.m_128451_("neutralize_target_hit_stack_reward");
        this.neutralizeTargetHitDamageMultiplier = parameters.m_128457_("neutralize_target_hit_damage_multiplier");
        this.neutralizeTargetHitImpactMultiplier = parameters.m_128457_("neutralize_target_hit_impact_multiplier");
    }

    public boolean canExecute(SkillContainer container) {
        PlayerPatch executor = container.getExecutor();
        SkillContainer yamatoSkillContainer = executor.getSkill(Yamato.yamato);
        if (yamatoSkillContainer != null && yamatoSkillContainer.hasSkill()) {
            return false;
        }
        boolean isOnGround = ((Player)executor.getOriginal()).m_20096_();
        boolean isCreative = ((Player)executor.getOriginal()).m_7500_();
        return isOnGround && (isCreative || (Integer)container.getDataManager().getDataValue((SkillDataKey)EFNSKillDataKeys.COOLDOWN.get()) <= 0);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        PlayerEventListener listener = container.getExecutor().getEventListener();
        if (container.getExecutor().isLogicalClient()) {
            listener.addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID, event -> this.handleKeyInput(container));
        }
        if (!container.getExecutor().isLogicalClient()) {
            listener.addEventListener(PlayerEventListener.EventType.ANIMATION_BEGIN_EVENT, ANIMATION_BEGIN_EVENT_UUID, event -> {
                StaticAnimation skillAnimation = (StaticAnimation)EFNSkillAnimations.EXECUTION.get();
                if (skillAnimation != null && skillAnimation.equals((Object)event.getAnimation())) {
                    this.currentNeutralizeEntities.clear();
                    this.currentNeutralizeEntities = this.findNeutralizeEntities(event.getPlayerPatch());
                }
            });
            listener.addEventListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, PARRY_EVENT_UUID, event -> {
                if (event.isParried() && !container.getExecutor().isLogicalClient()) {
                    ServerPlayer serverplayer = (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
                    int currentCooldown = (Integer)container.getDataManager().getDataValue((SkillDataKey)EFNSKillDataKeys.COOLDOWN.get());
                    if (currentCooldown > 0) {
                        int newCooldown = Math.max(0, currentCooldown - this.parryCooldownReduction);
                        container.getDataManager().setDataSync((SkillDataKey)EFNSKillDataKeys.COOLDOWN.get(), (Object)newCooldown);
                        serverplayer.m_284548_().m_8767_((ParticleOptions)ParticleTypes.f_123746_, Objects.requireNonNull(event.getDamageSource().m_7270_()).m_7096_(), Objects.requireNonNull(event.getDamageSource().m_7270_()).m_7098_() + 1.4, Objects.requireNonNull(event.getDamageSource().m_7270_()).m_7094_(), 4, 0.0, 0.0, 0.0, 0.1);
                    }
                }
            }, -1);
            listener.addEventListener(PlayerEventListener.EventType.DODGE_SUCCESS_EVENT, DODGE_EVENT_UUID, event -> {
                ServerPlayer serverplayer = (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
                int currentCooldown = (Integer)container.getDataManager().getDataValue((SkillDataKey)EFNSKillDataKeys.COOLDOWN.get());
                if (currentCooldown > 0) {
                    int newCooldown = Math.max(0, currentCooldown - this.dodgeSuccessCooldownReduction);
                    container.getDataManager().setDataSync((SkillDataKey)EFNSKillDataKeys.COOLDOWN.get(), (Object)newCooldown);
                    serverplayer.m_284548_().m_8767_((ParticleOptions)ParticleTypes.f_235898_, event.getLocation().m_7096_(), event.getLocation().m_7098_() + 1.4, event.getLocation().m_7094_(), 4, 0.0, 0.0, 0.0, 0.075);
                }
            });
            listener.addEventListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_ATTACK, DAMAGE_EVENT_UUID, event -> {
                StaticAnimation skillAnimation = (StaticAnimation)EFNSkillAnimations.EXECUTION.get();
                SkillContainer weaponSkillContainer = ((ServerPlayerPatch)event.getPlayerPatch()).getSkill((SkillSlot)SkillSlots.WEAPON_INNATE);
                if (skillAnimation != null && event.getDamageSource().getAnimation().get() != null && skillAnimation.equals(event.getDamageSource().getAnimation().get())) {
                    boolean hitNeutralizeEntity = this.isTargetInNeutralizeList(event.getTarget());
                    if (hitNeutralizeEntity) {
                        int currentCooldown = (Integer)container.getDataManager().getDataValue((SkillDataKey)EFNSKillDataKeys.COOLDOWN.get());
                        int currentStack = weaponSkillContainer.getStack();
                        int maxStack = weaponSkillContainer.getSkill().getMaxStack();
                        int newCharge = Math.min(maxStack, currentStack + this.neutralizeTargetHitStackReward);
                        if (currentCooldown > 0) {
                            int newCooldown = Math.max(0, currentCooldown - this.neutralizeTargetHitCooldownReduction);
                            container.getDataManager().setDataSync((SkillDataKey)EFNSKillDataKeys.COOLDOWN.get(), (Object)newCooldown);
                        }
                        if (event.getDamageSource() instanceof EpicFightDamageSource) {
                            EpicFightDamageSource damageSource = event.getDamageSource();
                            damageSource.attachDamageModifier(ValueModifier.multiplier((float)this.neutralizeTargetHitDamageMultiplier));
                            damageSource.attachImpactModifier(ValueModifier.multiplier((float)this.neutralizeTargetHitImpactMultiplier));
                            ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19601_, 1, 2, false, false, false));
                            ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200, 1, false, false, false));
                            ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19606_, 200, 1, false, false, false));
                            ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19600_, 200, 1, false, false, false));
                            ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19598_, 200, 1, false, false, false));
                        }
                        weaponSkillContainer.getSkill().setStackSynchronize(weaponSkillContainer, newCharge);
                    }
                    this.currentNeutralizeEntities.clear();
                }
            });
            listener.addEventListener(PlayerEventListener.EventType.PLAYER_KILLED_EVENT, KILL_EVENT_UUID, event -> {
                SkillContainer weaponSkillContainer = ((ServerPlayerPatch)event.getPlayerPatch()).getSkill((SkillSlot)SkillSlots.WEAPON_INNATE);
                PlayerPatch playerpatch = container.getExecutor();
                Player original = (Player)playerpatch.getOriginal();
                LivingEntity target = event.getKilledEntity();
                int currentCooldown = (Integer)container.getDataManager().getDataValue((SkillDataKey)EFNSKillDataKeys.COOLDOWN.get());
                int currentStack = weaponSkillContainer.getStack();
                int maxStack = weaponSkillContainer.getSkill().getMaxStack();
                int newCharge = Math.min(maxStack, currentStack + this.skillKillStackReward);
                boolean isSkillKill = this.isSkillAnimationKill((PlayerKilledEvent)event);
                if (isSkillKill) {
                    ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19601_, 1, 2, false, false, false));
                    ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200, 1, false, false, false));
                    ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19606_, 200, 1, false, false, false));
                    ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19600_, 200, 1, false, false, false));
                    ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19598_, 200, 1, false, false, false));
                    weaponSkillContainer.getSkill().setStackSynchronize(weaponSkillContainer, newCharge);
                    if (!original.m_9236_().m_5776_()) {
                        SoulAfterimagePacket packet = new SoulAfterimagePacket(target);
                        EFNNetworkHandler.sendToAllPlayersTrackingEntity(target, packet);
                    }
                }
                if (currentCooldown > 0) {
                    int reductionAmount = isSkillKill ? this.skillKillCooldownReduction : this.killCooldownReduction;
                    int newCooldown = Math.max(0, currentCooldown - reductionAmount);
                    int orbCount = isSkillKill ? 3 : 1;
                    container.getDataManager().setDataSync((SkillDataKey)EFNSKillDataKeys.COOLDOWN.get(), (Object)newCooldown);
                    for (int i = 0; i < orbCount; ++i) {
                        SoulHuntOrb soulHuntOrb = ExecuteSkill.getSoulHuntOrb(i, original, target);
                        original.m_9236_().m_7967_((Entity)soulHuntOrb);
                        ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19601_, 1, 0, false, false, false));
                        ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19596_, 100, 0, false, false, false));
                    }
                }
            });
        }
    }

    private List<LivingEntity> findNeutralizeEntities(PlayerPatch<?> playerPatch) {
        LivingEntity player = (LivingEntity)playerPatch.getOriginal();
        float neutralizeDetectionRange = 10.0f;
        AABB detectionArea = player.m_20191_().m_82400_((double)neutralizeDetectionRange);
        List nearbyEntities = player.m_9236_().m_6443_(LivingEntity.class, detectionArea, entity -> entity != player && entity.m_6084_());
        ArrayList<LivingEntity> neutralizeEntities = new ArrayList<LivingEntity>();
        for (LivingEntity entity2 : nearbyEntities) {
            AssetAccessor hitAnimation;
            LivingEntityPatch entityPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)entity2, LivingEntityPatch.class);
            if (entityPatch == null || (hitAnimation = entityPatch.getHitAnimation(StunType.NEUTRALIZE)) == null || !this.isEntityInNeutralizeState(entityPatch)) continue;
            neutralizeEntities.add(entity2);
        }
        return neutralizeEntities;
    }

    private boolean isTargetInNeutralizeList(LivingEntity target) {
        for (LivingEntity entity : this.currentNeutralizeEntities) {
            if (entity != target) continue;
            return true;
        }
        return false;
    }

    private boolean isEntityInNeutralizeState(LivingEntityPatch<?> entityPatch) {
        ResourceLocation currentAnimation;
        AnimationPlayer animPlayer = entityPatch.getAnimator().getPlayerFor(null);
        if (animPlayer != null && (currentAnimation = ((DynamicAnimation)animPlayer.getAnimation().get()).getRegistryName()) != null) {
            ResourceLocation neutralizeAnimation = ((StaticAnimation)entityPatch.getHitAnimation(StunType.NEUTRALIZE).get()).getRegistryName();
            return currentAnimation.equals((Object)neutralizeAnimation);
        }
        return false;
    }

    private boolean isSkillAnimationKill(PlayerKilledEvent event) {
        DamageSource damageSource = event.getDamageSource();
        if (damageSource instanceof EpicFightDamageSource) {
            EpicFightDamageSource epicDamageSource = (EpicFightDamageSource)damageSource;
            StaticAnimation skillAnimation = (StaticAnimation)EFNSkillAnimations.EXECUTION.get();
            StaticAnimation killingAnimation = (StaticAnimation)epicDamageSource.getAnimation().get();
            return skillAnimation != null && skillAnimation.equals((Object)killingAnimation);
        }
        return false;
    }

    public void onRemoved(SkillContainer container) {
        PlayerEventListener listener = container.getExecutor().getEventListener();
        listener.removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID);
        listener.removeListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, PARRY_EVENT_UUID, -1);
        listener.removeListener(PlayerEventListener.EventType.DODGE_SUCCESS_EVENT, DODGE_EVENT_UUID);
        listener.removeListener(PlayerEventListener.EventType.PLAYER_KILLED_EVENT, KILL_EVENT_UUID);
        listener.removeListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_ATTACK, DAMAGE_EVENT_UUID);
        listener.removeListener(PlayerEventListener.EventType.ANIMATION_BEGIN_EVENT, ANIMATION_BEGIN_EVENT_UUID);
        this.currentNeutralizeEntities.clear();
    }

    public void updateContainer(SkillContainer container) {
        int currentCooldown;
        super.updateContainer(container);
        if (container.getExecutor().isLogicalClient()) {
            this.handleKeyInput(container);
        }
        if ((currentCooldown = ((Integer)container.getDataManager().getDataValue((SkillDataKey)EFNSKillDataKeys.COOLDOWN.get())).intValue()) > 0) {
            container.getDataManager().setData((SkillDataKey)EFNSKillDataKeys.COOLDOWN.get(), (Object)(currentCooldown - 1));
        }
    }

    private void handleKeyInput(SkillContainer container) {
        if (EFNKeyMappings.EFN_ARTS.m_90857_()) {
            CPSkillRequest packet = new CPSkillRequest((SkillSlot)SkillSlot.ENUM_MANAGER.get(container.getSlot().universalOrdinal()), CPSkillRequest.WorkType.CAST);
            EpicFightNetworkManager.sendToServer((Object)packet);
        }
    }

    public void executeOnServer(SkillContainer container, FriendlyByteBuf args) {
        super.executeOnServer(container, args);
        container.getDataManager().setDataSync((SkillDataKey)EFNSKillDataKeys.COOLDOWN.get(), (Object)this.cooldown);
        container.getServerExecutor().playAnimationSynchronized(EFNSkillAnimations.EXECUTION, 0.1f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return (Integer)container.getDataManager().getDataValue((SkillDataKey)EFNSKillDataKeys.COOLDOWN.get()) > 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgsOfScreen(List<Object> list) {
        list.add(EFNKeyMappings.EFN_ARTS.m_90863_());
        list.add((double)this.cooldown / 20.0);
        list.add((double)this.killCooldownReduction / 20.0);
        list.add((double)this.skillKillCooldownReduction / 20.0);
        list.add(this.skillKillStackReward);
        list.add(Float.valueOf(this.neutralizeTargetHitDamageMultiplier));
        list.add(Float.valueOf(this.neutralizeTargetHitImpactMultiplier));
        list.add((double)this.neutralizeTargetHitCooldownReduction / 20.0);
        list.add(this.neutralizeTargetHitStackReward);
        return list;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y, float partialTick) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, (float)gui.getSlidingProgression(), 0.0f);
        guiGraphics.m_280411_(this.getSkillTexture(), (int)x, (int)y, 24, 24, 0.0f, 0.0f, 1, 1, 1, 1);
        int currentCooldown = (Integer)container.getDataManager().getDataValue((SkillDataKey)EFNSKillDataKeys.COOLDOWN.get());
        if (currentCooldown > 0) {
            guiGraphics.drawString(gui.getFont(), String.format("%.1f", (double)currentCooldown / 20.0), x + 2.0f, y + 8.0f, 0xFFFFFF, true);
        }
        poseStack.m_85849_();
    }

    public static class Builder
    extends SkillBuilder<ExecuteSkill> {
    }
}

