/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.entity.effect;

import com.hm.efn.entity.EFNEntity;
import com.hm.efn.entity.effect.TrailPatch;
import com.hm.efn.gameasset.EFNAnimations;
import com.merlin204.avalon.entity.vfx.VFXEntity;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.client.model.SkinnedMesh;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;

public class TrailEntity
extends VFXEntity {
    public static final EntityDataAccessor<Float> DATA_Z_ROT = SynchedEntityData.m_135353_(TrailEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    public TrailEntity(LivingEntity owner, float scale, Vec3 offset) {
        super((EntityType)EFNEntity.TRAIL.get(), owner, scale);
        this.f_19794_ = true;
        this.f_19811_ = true;
        this.m_20331_(true);
        this.m_20242_(true);
    }

    public TrailEntity(EntityType<? extends VFXEntity> entityType, Level level) {
        super(entityType, level);
        this.f_19794_ = true;
        this.f_19811_ = true;
        this.m_20331_(true);
        this.m_20242_(true);
    }

    public static void applyRotationToJoint(Pose pose, Armature armature, String jointName, float xRot, float yRot, float zRot) {
        if (armature == null || pose == null) {
            return;
        }
        Joint joint = armature.searchJointByName(jointName);
        if (joint == null) {
            return;
        }
        Vec3f xAxis = OpenMatrix4f.transform3v((OpenMatrix4f)joint.getLocalTransform(), (Vec3f)Vec3f.X_AXIS, null);
        Vec3f yAxis = OpenMatrix4f.transform3v((OpenMatrix4f)joint.getLocalTransform(), (Vec3f)Vec3f.Y_AXIS, null);
        Vec3f zAxis = OpenMatrix4f.transform3v((OpenMatrix4f)joint.getLocalTransform(), (Vec3f)Vec3f.Z_AXIS, null);
        OpenMatrix4f rotation = OpenMatrix4f.createRotatorDeg((float)yRot, (Vec3f)yAxis).rotateDeg(xRot, xAxis).rotateDeg(zRot, zAxis);
        pose.orElseEmpty(jointName).frontResult(JointTransform.fromMatrix((OpenMatrix4f)rotation), OpenMatrix4f::mul);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_Z_ROT, (Object)Float.valueOf(0.0f));
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> key) {
        TrailPatch patch;
        super.m_7350_(key);
        if (DATA_Z_ROT.equals(key) && this.m_9236_().f_46443_ && (patch = this.getPatch()) != null) {
            patch.setZRotation(((Float)this.f_19804_.m_135370_(DATA_Z_ROT)).floatValue());
        }
    }

    public AABB m_6921_() {
        return this.m_20191_().m_82400_(100.0);
    }

    @Nullable
    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getIdleAnimation() {
        return EFNAnimations.TRAIL_IDLE;
    }

    @Nullable
    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getDefaultAnimation() {
        return EFNAnimations.TRAIL;
    }

    @Nullable
    public Armature getArmature() {
        return Armatures.ArmatureAccessor.create((String)"efn", (String)"entity/effect/trail", Armature::new).get();
    }

    @Nullable
    public AssetAccessor<? extends SkinnedMesh> getMesh() {
        return Meshes.MeshAccessor.create((String)"efn", (String)"entity/effect/trail", jsonModelLoader -> jsonModelLoader.loadSkinnedMesh(SkinnedMesh::new));
    }

    @Nullable
    public ResourceLocation getTexture() {
        return ResourceLocation.fromNamespaceAndPath((String)"efn", (String)"textures/entity/trail.png");
    }

    @Nullable
    public ResourceLocation getLitTexture() {
        return ResourceLocation.fromNamespaceAndPath((String)"efn", (String)"textures/entity/trail.png");
    }

    public TrailPatch getPatch() {
        EntityPatch patch = EpicFightCapabilities.getEntityPatch((Entity)this, EntityPatch.class);
        return patch instanceof TrailPatch ? (TrailPatch)patch : null;
    }
}

