/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.comboevents.events;

import com.hm.efn.util.DuskFireArmorHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="efn")
public class DuskFireArmorEffectListener {
    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            DuskFireArmorEffectListener.handleFireDamageReduction(player, event);
        }
    }

    private static void handleFireDamageReduction(Player player, LivingDamageEvent event) {
        int armorCount;
        boolean isFireDamage;
        DamageSource source = event.getSource();
        boolean bl = isFireDamage = source.m_276093_(DamageTypes.f_268631_) || source.m_276093_(DamageTypes.f_268468_) || source.m_276093_(DamageTypes.f_268546_) || source.m_276093_(DamageTypes.f_268434_);
        if (isFireDamage && (armorCount = DuskFireArmorHelper.getDuskFireArmorCount(player)) > 0) {
            float damageReduction = DuskFireArmorEffectListener.calculateFireDamageReduction(armorCount);
            float originalDamage = event.getAmount();
            float reducedDamage = originalDamage * (1.0f - damageReduction);
            event.setAmount(reducedDamage);
        }
    }

    private static float calculateFireDamageReduction(int armorCount) {
        return switch (armorCount) {
            case 1 -> 0.25f;
            case 2 -> 0.5f;
            case 3 -> 0.75f;
            case 4 -> 1.0f;
            default -> 0.0f;
        };
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            DuskFireArmorEffectListener.handleFireImmunity(player);
        }
    }

    private static void handleFireImmunity(Player player) {
        boolean wearingFullSet = DuskFireArmorHelper.isWearingFullDuskFireArmor(player);
        if (wearingFullSet) {
            if (player.m_6060_()) {
                player.m_20095_();
            }
            if (player.m_20077_() && player.m_20184_().f_82480_ < 0.1) {
                player.m_20334_(player.m_20184_().f_82479_, 0.1, player.m_20184_().f_82481_);
            }
        }
    }
}

