/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.comboevents;

import com.hm.efn.entity.effect.SummonedSwordEntity_In;
import com.hm.efn.entity.effect.SummonedSwordEntity_Out;
import com.hm.efn.gameasset.EFNSKillDataKeys;
import com.hm.efn.gameasset.EFNWeaponCategories;
import com.hm.efn.util.FireballExplosionListener;
import com.hm.efn.util.ParticleEffectInvoker;
import com.p1nero.invincible.api.events.TimeStampedEvent;
import com.p1nero.invincible.api.skill.ComboNode;
import com.p1nero.invincible.api.skill.ComboType;
import com.p1nero.invincible.skill.ComboBasicAttack;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import yesman.epicfight.api.animation.property.AnimationEvent;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class TimeEvents {
    private static final Logger LOGGER = LogManager.getLogger((String)"ComboEvents");

    public static TimeStampedEvent timeConsumeStamina(float time, float consumeStamina) {
        return new TimeStampedEvent(time, entityPatch -> {
            if (entityPatch instanceof ServerPlayerPatch) {
                ServerPlayerPatch serverPlayerPatch;
                float currentStamina = (serverPlayerPatch = (ServerPlayerPatch)entityPatch).getStamina();
                serverPlayerPatch.setStamina(currentStamina < consumeStamina ? 0.0f : currentStamina - consumeStamina);
            }
        });
    }

    public static TimeStampedEvent timeAddTargetEffect(float time, Supplier<MobEffect> effect, int level, int duration) {
        return new TimeStampedEvent(time, livingEntityPatch -> {
            LivingEntity target = livingEntityPatch.getTarget();
            if (target != null) {
                target.m_7292_(new MobEffectInstance((MobEffect)effect.get(), duration, level));
            }
        });
    }

    public static TimeStampedEvent applyEffectAtTime(MobEffect effect, int duration, int amplifier, float timestamp) {
        return TimeEvents.applyEffectAtTime(() -> effect, duration, amplifier, timestamp);
    }

    public static TimeStampedEvent applyEffectAtTime(Supplier<MobEffect> effect, int duration, int amplifier, float timestamp) {
        return new TimeStampedEvent(timestamp, entityPatch -> {
            LivingEntity target = (LivingEntity)entityPatch.getOriginal();
            if (target != null) {
                int finalDuration = duration == -1 ? Integer.MAX_VALUE : duration;
                target.m_7292_(new MobEffectInstance((MobEffect)effect.get(), finalDuration, amplifier, false, false));
            }
        });
    }

    public static TimeStampedEvent removeEffectAtTime(Supplier<MobEffect> effectSupplier, float timestamp) {
        return new TimeStampedEvent(timestamp, entityPatch -> {
            LivingEntity target = (LivingEntity)entityPatch.getOriginal();
            if (target != null) {
                target.m_21195_((MobEffect)effectSupplier.get());
            }
        });
    }

    public static TimeStampedEvent playSound(SoundEvent sound, float timestamp, float volume) {
        return new TimeStampedEvent(timestamp, entityPatch -> {
            if (!entityPatch.isLogicalClient()) {
                entityPatch.playSound(sound, volume, 0.0f);
            }
        });
    }

    public static TimeStampedEvent timeConsumeStack(float time, int stackCost) {
        return new TimeStampedEvent(time, entityPatch -> {
            ServerPlayerPatch serverPlayerPatch;
            SkillContainer container;
            if (entityPatch instanceof ServerPlayerPatch && (container = (serverPlayerPatch = (ServerPlayerPatch)entityPatch).getSkill((SkillSlot)SkillSlots.WEAPON_INNATE)) != null && container.getStack() >= stackCost) {
                container.getSkill().setStackSynchronize(container, container.getStack() - stackCost);
            }
        });
    }

    public static TimeStampedEvent timeConsumeConsumption(float time, float amount) {
        return new TimeStampedEvent(time, entityPatch -> {
            ServerPlayerPatch serverPlayerPatch;
            SkillContainer container;
            if (entityPatch instanceof ServerPlayerPatch && (container = (serverPlayerPatch = (ServerPlayerPatch)entityPatch).getSkill((SkillSlot)SkillSlots.WEAPON_INNATE)) != null) {
                float newValue = Math.max(0.0f, container.getResource() - amount);
                container.getSkill().setConsumptionSynchronize(container, newValue);
            }
        });
    }

    public static TimeStampedEvent TimeSimulationComboNodeEvent(float time, ComboNode.ComboTypes comboType) {
        return new TimeStampedEvent(time, entityPatch -> {
            if (entityPatch instanceof ServerPlayerPatch) {
                ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)entityPatch;
                ServerPlayer serverPlayer = (ServerPlayer)serverPlayerPatch.getOriginal();
                ComboBasicAttack.executeOnServer((ServerPlayer)serverPlayer, (ComboType)comboType);
            }
        });
    }

    public static AnimationEvent.InTimeEvent createComboNodeEvent(float startFrame, ComboNode.ComboTypes comboType) {
        float time = startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)time, (entitypatch, self, params) -> {
            ServerPlayerPatch serverPlayerPatch;
            ServerPlayer player;
            if (entitypatch instanceof ServerPlayerPatch && TimeEvents.isHoldingYamato(player = (ServerPlayer)(serverPlayerPatch = (ServerPlayerPatch)entitypatch).getOriginal())) {
                ComboBasicAttack.executeOnServer((ServerPlayer)player, (ComboType)comboType);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER);
    }

    private static boolean isHoldingYamato(ServerPlayer player) {
        return Stream.of(player.m_21205_(), player.m_21206_()).map(EpicFightCapabilities::getItemStackCapability).filter(Objects::nonNull).anyMatch(cap -> cap.getWeaponCategory() == EFNWeaponCategories.EFN_YAMATO);
    }

    public static TimeStampedEvent summonSingleSwordAtPlayerWaist(float time, Vec3 offset, float scale) {
        return new TimeStampedEvent(time, entityPatch -> {
            if (entityPatch instanceof ServerPlayerPatch) {
                ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)entityPatch;
                SummonedSwordEntity_Out.summonAtWaist(serverPlayerPatch, offset, scale);
            }
        });
    }

    public static TimeStampedEvent summonSingleSwordAtTargetWaist(float time, Vec3 offset, float scale) {
        return new TimeStampedEvent(time, entityPatch -> {
            if (entityPatch instanceof ServerPlayerPatch) {
                ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)entityPatch;
                LivingEntity target = entityPatch.getTarget();
                if (target != null && target.m_6084_()) {
                    SummonedSwordEntity_In.summonAtTargetWaist(serverPlayerPatch, target, offset, scale);
                }
            }
        });
    }

    public static TimeStampedEvent playTargetAnimationAtTime(Supplier<? extends DynamicAnimation> animation, float convertTime, float timestamp) {
        return new TimeStampedEvent(timestamp, entityPatch -> {
            LivingEntityPatch targetPatch;
            LivingEntity target = entityPatch.getTarget();
            if (target != null && (targetPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)target, LivingEntityPatch.class)) != null) {
                targetPatch.playAnimationSynchronized((AssetAccessor)((DynamicAnimation)animation.get()).getAccessor(), convertTime);
            }
        });
    }

    public static TimeStampedEvent shootGiantFireballDownward(float time) {
        return new TimeStampedEvent(time, entityPatch -> {
            if (entityPatch instanceof ServerPlayerPatch) {
                ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)entityPatch;
                ServerPlayer player = (ServerPlayer)serverPlayerPatch.getOriginal();
                ServerLevel level = (ServerLevel)player.m_9236_();
                Vec3 playerPos = player.m_20182_();
                Vec3 spawnPos = new Vec3(playerPos.f_82479_, playerPos.f_82480_, playerPos.f_82481_);
                Vec3 groundPos = FireballExplosionListener.getGroundPosition(spawnPos, (Level)level);
                double fallDistance = Math.max(0.5, spawnPos.f_82480_ - groundPos.f_82480_);
                double targetTime = 0.1;
                double baseSpeed = fallDistance / (targetTime * 20.0);
                double gravityCompensation = fallDistance / 2.0 * 0.5;
                double finalSpeed = baseSpeed + gravityCompensation;
                finalSpeed = Math.max(0.8, Math.min(30.0, finalSpeed));
                LargeFireball fireball = new LargeFireball((Level)level, (LivingEntity)player, 0.0, -0.5, 0.0, 1);
                fireball.m_6034_(spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_);
                fireball.m_20334_(0.0, -finalSpeed, 0.0);
                level.m_7967_((Entity)fireball);
                ParticleEffectInvoker.spawnEnhancedFireballParticles(level, new Vec3(playerPos.f_82479_, playerPos.f_82480_ + 0.3, playerPos.f_82481_));
                player.m_5496_(SoundEvents.f_11874_, 0.8f, 1.0f);
            }
        });
    }

    public static TimeStampedEvent startComboCounter(float time) {
        return new TimeStampedEvent(time, entityPatch -> {
            if (entityPatch instanceof ServerPlayerPatch) {
                ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)entityPatch;
                SkillDataManager dataManager = serverPlayerPatch.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager();
                dataManager.setDataSync((SkillDataKey)EFNSKillDataKeys.COMBO_COUNTER.get(), (Object)Float.valueOf(0.0f), (ServerPlayer)serverPlayerPatch.getOriginal());
            }
        });
    }

    public static TimeStampedEvent resetComboCounter(float time) {
        return new TimeStampedEvent(time, entityPatch -> {
            if (entityPatch instanceof ServerPlayerPatch) {
                ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)entityPatch;
                SkillDataManager dataManager = serverPlayerPatch.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager();
                dataManager.setDataSync((SkillDataKey)EFNSKillDataKeys.COMBO_COUNTER.get(), (Object)Float.valueOf(0.0f), (ServerPlayer)serverPlayerPatch.getOriginal());
            }
        });
    }

    public static TimeStampedEvent pauseComboCounter(float time) {
        return new TimeStampedEvent(time, entityPatch -> {
            if (entityPatch instanceof ServerPlayerPatch) {
                ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)entityPatch;
                SkillDataManager dataManager = serverPlayerPatch.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager();
                float current = ((Float)dataManager.getDataValue((SkillDataKey)EFNSKillDataKeys.COMBO_COUNTER.get())).floatValue();
                dataManager.setDataSync((SkillDataKey)EFNSKillDataKeys.COMBO_COUNTER.get(), (Object)Float.valueOf(current), (ServerPlayer)serverPlayerPatch.getOriginal());
            }
        });
    }
}

