/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.comboevents;

import com.hm.efn.gameasset.EFNSKillDataKeys;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class KeyLongPressCondition
implements Condition<ServerPlayerPatch> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int MAX_SYNC_ATTEMPTS = 3;
    private static final int SYNC_RETRY_DELAY = 1;
    private final TargetKey targetKey;
    private KeyState currentState = KeyState.RELEASED;
    private int lastPressTicks = 0;

    public KeyLongPressCondition(TargetKey targetKey) {
        this.targetKey = targetKey;
    }

    public Condition<ServerPlayerPatch> read(CompoundTag tag) {
        try {
            return new KeyLongPressCondition(TargetKey.valueOf(tag.m_128461_("targetKey")));
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Invalid key target in NBT: {}", (Object)tag);
            return null;
        }
    }

    public CompoundTag serializePredicate() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("targetKey", this.targetKey.name());
        return tag;
    }

    public boolean predicate(ServerPlayerPatch playerPatch) {
        if (!this.validatePlayer(playerPatch)) {
            return false;
        }
        SkillDataManager dataManager = this.getDataManager(playerPatch);
        if (dataManager == null) {
            return false;
        }
        if (!this.syncKeyData(dataManager, (ServerPlayer)playerPatch.getOriginal())) {
            return false;
        }
        return this.updateAndCheckState(dataManager);
    }

    public KeyState getCurrentState() {
        return this.currentState;
    }

    public boolean isPressed() {
        return this.currentState == KeyState.PRESSED;
    }

    public boolean isLongPressed() {
        return this.currentState == KeyState.LONG_PRESSED;
    }

    public boolean isReleasedAfterShort() {
        return this.currentState == KeyState.RELEASED_AFTER_SHORT;
    }

    public boolean isReleasedAfterLong() {
        return this.currentState == KeyState.RELEASED_AFTER_LONG;
    }

    public int getLastPressDuration() {
        return this.lastPressTicks;
    }

    private boolean validatePlayer(ServerPlayerPatch playerPatch) {
        return playerPatch != null && playerPatch.getOriginal() instanceof ServerPlayer;
    }

    private SkillDataManager getDataManager(ServerPlayerPatch playerPatch) {
        SkillContainer container = playerPatch.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE);
        return container != null ? container.getDataManager() : null;
    }

    private boolean syncKeyData(SkillDataManager dataManager, ServerPlayer player) {
        for (int attempt = 0; attempt < 3; ++attempt) {
            try {
                if (attempt > 0) {
                    Thread.sleep(1L);
                }
                Boolean pressState = (Boolean)dataManager.getDataValue(this.targetKey.keyData.pressKey.get());
                Integer timerValue = (Integer)dataManager.getDataValue(this.targetKey.keyData.timerKey.get());
                Boolean longPressState = (Boolean)dataManager.getDataValue(this.targetKey.keyData.longPressKey.get());
                if (pressState != null) {
                    dataManager.setDataSync(this.targetKey.keyData.pressKey.get(), (Object)pressState);
                }
                if (timerValue != null) {
                    dataManager.setDataSync(this.targetKey.keyData.timerKey.get(), (Object)timerValue);
                }
                if (longPressState != null) {
                    dataManager.setDataSync(this.targetKey.keyData.longPressKey.get(), (Object)longPressState);
                }
                return true;
            }
            catch (Exception e) {
                LOGGER.debug("Sync attempt {} failed: {}", (Object)(attempt + 1), (Object)e.getMessage());
                continue;
            }
        }
        return false;
    }

    private boolean updateAndCheckState(SkillDataManager dataManager) {
        Boolean isPressed = (Boolean)dataManager.getDataValue(this.targetKey.keyData.pressKey.get());
        Integer pressTicks = (Integer)dataManager.getDataValue(this.targetKey.keyData.timerKey.get());
        Boolean isLongPress = (Boolean)dataManager.getDataValue(this.targetKey.keyData.longPressKey.get());
        if (isPressed == null || pressTicks == null) {
            this.currentState = KeyState.RELEASED;
            return false;
        }
        if (isPressed.booleanValue()) {
            this.lastPressTicks = pressTicks;
            if (Boolean.TRUE.equals(isLongPress) || pressTicks >= 4) {
                this.currentState = KeyState.LONG_PRESSED;
                return true;
            }
            this.currentState = KeyState.PRESSED;
            return false;
        }
        if (this.lastPressTicks > 0) {
            this.currentState = this.lastPressTicks >= 4 ? KeyState.RELEASED_AFTER_LONG : KeyState.RELEASED_AFTER_SHORT;
            this.lastPressTicks = 0;
        } else {
            this.currentState = KeyState.RELEASED;
        }
        return false;
    }

    public List<Condition.ParameterEditor> getAcceptingParameters(Screen screen) {
        return Collections.emptyList();
    }

    public static enum KeyState {
        RELEASED,
        PRESSED,
        LONG_PRESSED,
        RELEASED_AFTER_SHORT,
        RELEASED_AFTER_LONG;

    }

    public static enum TargetKey {
        KEYINNATE(new KeyData((Supplier<SkillDataKey<Boolean>>)EFNSKillDataKeys.INNATE_PRESS, (Supplier<SkillDataKey<Integer>>)EFNSKillDataKeys.INNATE_PRESS_TIMER, (Supplier<SkillDataKey<Boolean>>)EFNSKillDataKeys.INNATE_LONG_PRESS)),
        KEY1(new KeyData((Supplier<SkillDataKey<Boolean>>)EFNSKillDataKeys.KEY1_PRESS, (Supplier<SkillDataKey<Integer>>)EFNSKillDataKeys.KEY1_PRESS_TIMER, (Supplier<SkillDataKey<Boolean>>)EFNSKillDataKeys.KEY1_LONG_PRESS)),
        KEY2(new KeyData((Supplier<SkillDataKey<Boolean>>)EFNSKillDataKeys.KEY2_PRESS, (Supplier<SkillDataKey<Integer>>)EFNSKillDataKeys.KEY2_PRESS_TIMER, (Supplier<SkillDataKey<Boolean>>)EFNSKillDataKeys.KEY2_LONG_PRESS)),
        KEY3(new KeyData((Supplier<SkillDataKey<Boolean>>)EFNSKillDataKeys.KEY3_PRESS, (Supplier<SkillDataKey<Integer>>)EFNSKillDataKeys.KEY3_PRESS_TIMER, (Supplier<SkillDataKey<Boolean>>)EFNSKillDataKeys.KEY3_LONG_PRESS)),
        KEY4(new KeyData((Supplier<SkillDataKey<Boolean>>)EFNSKillDataKeys.KEY4_PRESS, (Supplier<SkillDataKey<Integer>>)EFNSKillDataKeys.KEY4_PRESS_TIMER, (Supplier<SkillDataKey<Boolean>>)EFNSKillDataKeys.KEY4_LONG_PRESS));

        final KeyData keyData;

        private TargetKey(KeyData keyData) {
            this.keyData = keyData;
        }
    }

    private static final class KeyData {
        final Supplier<SkillDataKey<Boolean>> pressKey;
        final Supplier<SkillDataKey<Integer>> timerKey;
        final Supplier<SkillDataKey<Boolean>> longPressKey;

        KeyData(Supplier<SkillDataKey<Boolean>> pressKey, Supplier<SkillDataKey<Integer>> timerKey, Supplier<SkillDataKey<Boolean>> longPressKey) {
            this.pressKey = pressKey;
            this.timerKey = timerKey;
            this.longPressKey = longPressKey;
        }
    }

    public static class ReleaseAfterLongCondition
    extends KeyLongPressCondition {
        public ReleaseAfterLongCondition(TargetKey targetKey) {
            super(targetKey);
        }

        @Override
        public boolean predicate(ServerPlayerPatch playerPatch) {
            super.predicate(playerPatch);
            return this.isReleasedAfterLong();
        }
    }
}

