/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.comboevents;

import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class EFNEntityStateCondition
implements Condition<ServerPlayerPatch> {
    private int minLevel;
    private int maxLevel;
    private ComparisonType comparisonType;

    public EFNEntityStateCondition(int minLevel, int maxLevel, ComparisonType comparisonType) {
        this.minLevel = minLevel;
        this.maxLevel = maxLevel;
        this.comparisonType = comparisonType;
    }

    public EFNEntityStateCondition() {
        this.minLevel = 0;
        this.maxLevel = 0;
        this.comparisonType = ComparisonType.EQUAL;
    }

    public Condition<ServerPlayerPatch> read(CompoundTag compoundTag) {
        if (!(compoundTag.m_128441_("minLevel") || compoundTag.m_128441_("maxLevel") || compoundTag.m_128441_("comparisonType"))) {
            throw new IllegalArgumentException("EFN entity state condition error: parameters not specified!");
        }
        this.minLevel = compoundTag.m_128451_("minLevel");
        this.maxLevel = compoundTag.m_128451_("maxLevel");
        this.comparisonType = ComparisonType.valueOf(compoundTag.m_128461_("comparisonType"));
        return this;
    }

    public CompoundTag serializePredicate() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("minLevel", this.minLevel);
        tag.m_128405_("maxLevel", this.maxLevel);
        tag.m_128359_("comparisonType", this.comparisonType.name());
        return tag;
    }

    public boolean predicate(ServerPlayerPatch serverPlayerPatch) {
        if (serverPlayerPatch == null) {
            return false;
        }
        EntityState entityState = serverPlayerPatch.getEntityState();
        if (entityState == null) {
            return false;
        }
        int phaseLevel = entityState.getLevel();
        return switch (this.comparisonType) {
            default -> throw new IncompatibleClassChangeError();
            case ComparisonType.EQUAL -> {
                if (phaseLevel == this.minLevel) {
                    yield true;
                }
                yield false;
            }
            case ComparisonType.GREATER_THAN -> {
                if (phaseLevel > this.minLevel) {
                    yield true;
                }
                yield false;
            }
            case ComparisonType.LESS_THAN -> {
                if (phaseLevel < this.minLevel) {
                    yield true;
                }
                yield false;
            }
            case ComparisonType.GREATER_THAN_OR_EQUAL -> {
                if (phaseLevel >= this.minLevel) {
                    yield true;
                }
                yield false;
            }
            case ComparisonType.LESS_THAN_OR_EQUAL -> {
                if (phaseLevel <= this.minLevel) {
                    yield true;
                }
                yield false;
            }
            case ComparisonType.BETWEEN -> {
                if (phaseLevel >= this.minLevel && phaseLevel <= this.maxLevel) {
                    yield true;
                }
                yield false;
            }
            case ComparisonType.OUTSIDE -> phaseLevel < this.minLevel || phaseLevel > this.maxLevel;
        };
    }

    public List<Condition.ParameterEditor> getAcceptingParameters(Screen screen) {
        return List.of();
    }

    public static enum ComparisonType {
        EQUAL,
        GREATER_THAN,
        LESS_THAN,
        GREATER_THAN_OR_EQUAL,
        LESS_THAN_OR_EQUAL,
        BETWEEN,
        OUTSIDE;

    }
}

