/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.client.screeneffect;

import com.hm.efn.client.screeneffect.ScreenEffectBase;
import com.hm.efn.client.targets.TargetManager;
import com.hm.efn.registries.PostPasses;
import com.hm.efn.util.OjangUtils;
import com.mojang.blaze3d.pipeline.RenderTarget;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;

public class HsvFilterEffect
extends ScreenEffectBase {
    static final float recovery = 15.0f;
    static ResourceLocation hsv_filter = OjangUtils.newRL("efn", "hsv_filter");
    public final ScreenEffectBase.SE_Pipeline ppl;
    public boolean should_render;
    public Type type = Type.POST;
    public float alpha = 1.0f;

    public HsvFilterEffect(Vec3 pos, int lt, boolean should_render) {
        super(hsv_filter, pos);
        this.ppl = new HsvFilter_Pipeline(this);
        this.lifetime = lt;
        this.should_render = should_render;
    }

    float getTimeChannel() {
        if (this.age < 5) {
            return (float)this.age / 5.0f;
        }
        return Math.max(Math.min(1.0f, (float)(this.lifetime - this.age) / 15.0f), 0.0f);
    }

    public float getAlpha() {
        return this.alpha * this.getTimeChannel();
    }

    @Override
    public boolean shouldPost(Camera camera, Frustum clippingHelper) {
        if (!this.should_render) {
            return false;
        }
        double distance = this.pos.m_82546_(camera.m_90583_()).m_82553_();
        if (distance >= 24.0) {
            this.alpha = (float)Math.max(0.0, -0.125 * distance + 4.0);
        }
        return distance < 32.0 && this.alpha >= 0.01f;
    }

    @Override
    public ScreenEffectBase.SE_Pipeline getPipeline() {
        return this.ppl;
    }

    public static enum Type {
        PREV,
        POST;

    }

    public static class HsvFilter_Pipeline
    extends ScreenEffectBase.SE_Pipeline<HsvFilterEffect> {
        static ResourceLocation hsv_filter_tmp = OjangUtils.newRL("efn", "hsv_filter_tmp");

        public HsvFilter_Pipeline(HsvFilterEffect effect) {
            super(hsv_filter, effect);
            this.priority = 101;
        }

        @Override
        public void PostEffectHandler() {
            RenderTarget tmp = TargetManager.getTarget(hsv_filter_tmp);
            PostPasses.blit.process(Minecraft.m_91087_().m_91385_(), tmp);
            PostPasses.hsv_filter.process(tmp, Minecraft.m_91087_().m_91385_(), 1.0f, 0.97f, ((HsvFilterEffect)this.effect).getAlpha());
        }
    }
}

