/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.client.render.custom;

import com.hm.efn.client.pipeline.PostEffectPipelines;
import com.hm.efn.client.pipeline.PostParticleRenderType;
import com.hm.efn.client.render.custom.SubMaskRenderType;
import com.hm.efn.client.targets.TargetManager;
import com.hm.efn.registries.PostPasses;
import com.hm.efn.util.OjangUtils;
import com.hm.efn.util.RenderUtils;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class SubSpaceRenderType
extends PostParticleRenderType {
    public static final PPL ppl = new PPL(OjangUtils.newRL("efn", "sub_space"));

    public SubSpaceRenderType(ResourceLocation renderTypeID, ResourceLocation texture) {
        super(renderTypeID, texture);
    }

    public RenderTarget getTarget() {
        if (ppl.getBufferTarget() == null) {
            RenderTarget ret = TargetManager.getTarget(SubSpaceRenderType.ppl.name);
            ret.m_83931_(0.0f, 0.0f, 0.0f, 1.0f);
            ret.m_83954_(Minecraft.f_91002_);
            return ret;
        }
        return ppl.getBufferTarget();
    }

    @Override
    public void m_6505_(@NotNull BufferBuilder bufferBuilder, @NotNull TextureManager textureManager) {
        RenderSystem.enableBlend();
        RenderSystem.enableCull();
        Minecraft.m_91087_().f_91063_.m_109154_().m_109896_();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.setShader(() -> this.getShader());
        if (this.texture != null) {
            RenderUtils.GLSetTexture(this.texture);
        }
        this.getPipeline().start();
        this.setupBufferBuilder(bufferBuilder);
    }

    @Override
    public void setupBufferBuilder(BufferBuilder bufferBuilder) {
        bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85820_);
    }

    @Override
    public PostEffectPipelines.Pipeline getPipeline() {
        return ppl;
    }

    public static class PPL
    extends PostEffectPipelines.Pipeline {
        private static final ResourceLocation tmpTarget = OjangUtils.newRL("efn", "sub_space_tmp");

        public PPL(ResourceLocation name) {
            super(name);
        }

        public RenderTarget getBufferTarget() {
            return this.bufferTarget;
        }

        @Override
        public void suspend() {
            if (PostEffectPipelines.isActive()) {
                this.bufferTarget.m_83970_();
                this.bufferTarget.m_83963_();
                RenderTarget rt = PostEffectPipelines.getSource();
                rt.m_83947_(false);
            } else {
                PostEffectPipelines.getSource().m_83947_(false);
            }
        }

        @Override
        public void start() {
            if (this.started) {
                if (PostEffectPipelines.isActive()) {
                    this.bufferTarget.m_83947_(false);
                }
            } else {
                if (this.bufferTarget == null) {
                    this.bufferTarget = TargetManager.getTarget(this.name);
                    this.bufferTarget.m_83954_(Minecraft.f_91002_);
                }
                if (PostEffectPipelines.isActive()) {
                    PostEffectPipelines.PostEffectQueue.add(this);
                    this.bufferTarget.m_83947_(false);
                    this.started = true;
                }
            }
        }

        @Override
        public void PostEffectHandler() {
            RenderTarget mask = SubMaskRenderType.ppl.getBufferTarget();
            if (mask == null) {
                return;
            }
            RenderTarget tmp = TargetManager.getTarget(tmpTarget);
            RenderTarget main = Minecraft.m_91087_().m_91385_();
            PostPasses.mask_composite.process(main, mask, this.bufferTarget, tmp);
            PostPasses.blit.process(tmp, main);
            TargetManager.ReleaseTarget(tmpTarget);
        }
    }
}

