/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.client.particle.spark;

import com.hm.efn.particle.EFNParticles;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.NoRenderParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import yesman.epicfight.client.particle.EpicFightParticleRenderTypes;

@OnlyIn(value=Dist.CLIENT)
public class ZandatsuSparkParticle
extends TextureSheetParticle {
    private final PhysicsType physicsType;
    private final float baseSize;
    private final float rotationSpeed;

    public ZandatsuSparkParticle(ClientLevel level, double x, double y, double z, double xd, double yd, double zd, PhysicsType physicsType) {
        super(level, x, y, z);
        this.f_107212_ = x;
        this.f_107213_ = y;
        this.f_107214_ = z;
        this.f_107227_ = 0.1f + this.f_107223_.m_188501_() * 0.2f;
        this.f_107228_ = 0.7f + this.f_107223_.m_188501_() * 0.3f;
        this.f_107229_ = 0.9f + this.f_107223_.m_188501_() * 0.2f;
        this.f_107663_ = this.baseSize = physicsType == PhysicsType.NORMAL ? (this.f_107223_.m_188501_() * 0.032f + 0.016f) * 0.4f : (this.f_107223_.m_188501_() * 0.048f + 0.032f) * 0.4f;
        this.f_107225_ = (physicsType == PhysicsType.NORMAL ? 35 : 12) + this.f_107223_.m_188503_(25);
        this.f_107219_ = true;
        this.f_107226_ = physicsType == PhysicsType.NORMAL ? 3.5f : (physicsType == PhysicsType.EXPANSIVE ? 0.1f : 0.4f);
        this.f_107204_ = this.f_107231_ = this.f_107223_.m_188501_() * 360.0f;
        this.rotationSpeed = (this.f_107223_.m_188501_() - 0.5f) * 0.8f;
        Vec3 deltaMovement = physicsType.function.getDeltaMovement(xd, yd, zd);
        this.f_107215_ = deltaMovement.f_82479_ * (1.5 + this.f_107223_.m_188500_() * 1.2);
        this.f_107216_ = deltaMovement.f_82480_ * (1.5 + this.f_107223_.m_188500_() * 1.2);
        this.f_107217_ = deltaMovement.f_82481_ * (1.5 + this.f_107223_.m_188500_() * 1.2);
        this.physicsType = physicsType;
    }

    public boolean shouldCull() {
        return false;
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return EpicFightParticleRenderTypes.LIGHTNING;
    }

    public void m_5989_() {
        super.m_5989_();
        this.f_107204_ = this.f_107231_;
        this.f_107231_ += this.rotationSpeed;
        float lifeProgress = (float)this.f_107224_ / (float)this.f_107225_;
        this.f_107663_ = this.physicsType == PhysicsType.EXPANSIVE ? (lifeProgress < 0.4f ? this.baseSize * (1.0f + lifeProgress * 1.2f) : this.baseSize * (1.48f - (lifeProgress - 0.4f) * 0.8f)) : (this.physicsType == PhysicsType.CONTRACTIVE ? this.baseSize * (1.0f - lifeProgress * 0.6f) : this.baseSize * (1.0f + lifeProgress * 0.2f - lifeProgress * lifeProgress * 0.6f));
        if (lifeProgress < 0.4f) {
            float intensity = 1.0f + lifeProgress * 0.5f;
            this.f_107227_ = 0.15f * intensity;
            this.f_107228_ = 0.85f * intensity;
            this.f_107229_ = intensity;
        } else if (lifeProgress < 0.8f) {
            float phase = (lifeProgress - 0.4f) / 0.4f;
            this.f_107227_ = 0.15f + 0.25f * phase;
            this.f_107228_ = 0.85f - 0.35f * phase;
            this.f_107229_ = 1.0f - 0.2f * phase;
        } else {
            float fade = (lifeProgress - 0.8f) / 0.2f;
            this.f_107227_ *= 1.0f - fade;
            this.f_107228_ *= 1.0f - fade;
            this.f_107229_ *= 1.0f - fade;
        }
        if (this.physicsType == PhysicsType.EXPANSIVE) {
            this.f_107215_ *= 0.96;
            this.f_107216_ *= 0.96;
            this.f_107217_ *= 0.96;
        } else if (this.physicsType == PhysicsType.CONTRACTIVE) {
            this.f_107215_ *= 0.98;
            this.f_107216_ *= 0.98;
            this.f_107217_ *= 0.98;
        } else {
            this.f_107215_ *= 0.95;
            this.f_107216_ *= 0.95;
            this.f_107217_ *= 0.95;
        }
        if (this.f_107223_.m_188503_(3) == 0) {
            this.f_107215_ += (this.f_107223_.m_188500_() - 0.5) * 0.04;
            this.f_107216_ += (this.f_107223_.m_188500_() - 0.5) * 0.04;
            this.f_107217_ += (this.f_107223_.m_188500_() - 0.5) * 0.04;
        }
    }

    public static enum PhysicsType {
        EXPANSIVE(Vec3::new),
        CONTRACTIVE((dx, dy, dz) -> new Vec3(dx * 0.08, dy * 0.08, dz * 0.08)),
        NORMAL(Vec3::new);

        final DeltaMovementFunction function;

        private PhysicsType(DeltaMovementFunction function) {
            this.function = function;
        }
    }

    @FunctionalInterface
    static interface DeltaMovementFunction {
        public Vec3 getDeltaMovement(double var1, double var3, double var5);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ContractiveMetaParticle
    extends NoRenderParticle {
        private final double radius;
        private final int density;

        public ContractiveMetaParticle(ClientLevel level, double x, double y, double z, double radius, int lifetime, int density) {
            super(level, x, y, z);
            this.radius = radius;
            this.f_107225_ = lifetime;
            this.density = (int)((double)density * 1.3);
        }

        public void m_5989_() {
            super.m_5989_();
            for (int x = -1; x <= 1; x += 2) {
                for (int y = -1; y <= 1; y += 2) {
                    for (int z = -1; z <= 1; z += 2) {
                        for (int i = 0; i < this.density; ++i) {
                            Vec3 rand = new Vec3(Math.random() * (double)x, Math.random() * (double)y * 0.8, Math.random() * (double)z).m_82541_().m_82490_(this.radius);
                            this.f_107208_.m_7106_((ParticleOptions)EFNParticles.SPARK_CONTRACTIVE_ZANDATSU.get(), this.f_107212_ + rand.f_82479_, this.f_107213_ + rand.f_82480_, this.f_107214_ + rand.f_82481_, -rand.f_82479_, -rand.f_82480_, -rand.f_82481_);
                        }
                    }
                }
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        public static class Provider
        implements ParticleProvider<SimpleParticleType> {
            public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
                ContractiveMetaParticle particle = new ContractiveMetaParticle(worldIn, x, y, z, xSpeed, (int)Double.doubleToLongBits(ySpeed), (int)Double.doubleToLongBits(zSpeed));
                return particle;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ExpansiveMetaParticle
    extends NoRenderParticle {
        public ExpansiveMetaParticle(ClientLevel level, double x, double y, double z, double radius, int density) {
            super(level, x, y, z);
            int newDensity = (int)((double)density * 1.3);
            for (int vx = -1; vx <= 1; vx += 2) {
                for (int vz = -1; vz <= 1; vz += 2) {
                    for (int i = 0; i < newDensity; ++i) {
                        Vec3 rand = new Vec3(Math.random() * (double)vx, Math.random() * 0.8, Math.random() * (double)vz).m_82541_().m_82490_(radius);
                        level.m_7106_((ParticleOptions)EFNParticles.SPARK_EXPANSIVE_ZANDATSU.get(), x, y, z, rand.f_82479_, rand.f_82480_, rand.f_82481_);
                    }
                }
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        public static class Provider
        implements ParticleProvider<SimpleParticleType> {
            public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
                ExpansiveMetaParticle particle = new ExpansiveMetaParticle(worldIn, x, y, z, xSpeed, (int)Double.doubleToLongBits(ySpeed));
                return particle;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ExpansiveDustProvider
    implements ParticleProvider<SimpleParticleType> {
        protected SpriteSet sprite;

        public ExpansiveDustProvider(SpriteSet sprite) {
            this.sprite = sprite;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ZandatsuSparkParticle SparkParticle2 = new ZandatsuSparkParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, PhysicsType.EXPANSIVE);
            SparkParticle2.m_108335_(this.sprite);
            return SparkParticle2;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ContractiveDustProvider
    implements ParticleProvider<SimpleParticleType> {
        protected SpriteSet sprite;

        public ContractiveDustProvider(SpriteSet sprite) {
            this.sprite = sprite;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ZandatsuSparkParticle SparkParticle2 = new ZandatsuSparkParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, PhysicsType.CONTRACTIVE);
            SparkParticle2.m_108335_(this.sprite);
            return SparkParticle2;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class NormalDustProvider
    implements ParticleProvider<SimpleParticleType> {
        protected SpriteSet sprite;

        public NormalDustProvider(SpriteSet sprite) {
            this.sprite = sprite;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ZandatsuSparkParticle SparkParticle2 = new ZandatsuSparkParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, PhysicsType.NORMAL);
            SparkParticle2.m_108335_(this.sprite);
            return SparkParticle2;
        }
    }
}

