/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.animations.types.yamato;

import com.google.common.collect.Lists;
import com.hm.efn.EFNCommonConfig;
import com.hm.efn.animations.types.yamato.YamatoPhase;
import com.hm.efn.entity.doppelganger.DoppelgangerEntity;
import com.hm.efn.gameasset.EFNSKillDataKeys;
import com.hm.efn.gameasset.combos.Yamato;
import com.hm.efn.registries.EFNMobEffectRegistry;
import com.hm.efn.skill.weapon_passive.YamatoPassive;
import com.merlin204.avalon.epicfight.animations.AvalonAttackAnimation;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.registries.ForgeRegistries;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.AnimationVariables;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.BasicAttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.damagesource.ExtraDamageInstance;
import yesman.epicfight.world.effect.EpicFightMobEffects;
import yesman.epicfight.world.entity.eventlistener.TakeDamageEvent;

public class YamatoAttackAnimation
extends AvalonAttackAnimation {
    public static final AnimationVariables.SharedAnimationVariableKey<List<Entity>> Y_ATTACK_TRIED_ENTITIES = AnimationVariables.shared(animator -> Lists.newArrayList(), (boolean)true);
    public static final AnimationVariables.SharedAnimationVariableKey<List<LivingEntity>> Y_ACTUALLY_HIT_ENTITIES = AnimationVariables.shared(animator -> Lists.newArrayList(), (boolean)true);

    public YamatoAttackAnimation(float transitionTime, AnimationManager.AnimationAccessor<? extends BasicAttackAnimation> accessor, AssetAccessor<? extends Armature> armature, float play_speed, float damageMulti, Supplier<? extends StaticAnimation> hitAnimation, YamatoPhase ... phases) {
        super(transitionTime, accessor, armature, play_speed, damageMulti, (AvalonAttackAnimation.AvalonPhase[])phases);
        this.addProperty(AnimationProperty.AttackPhaseProperty.EXTRA_DAMAGE, Set.of(ExtraDamageInstance.SWEEPING_EDGE_ENCHANTMENT.create(new float[0])));
        this.addProperty(AnimationProperty.AttackPhaseProperty.ARMOR_NEGATION_MODIFIER, ValueModifier.setter((float)120.0f));
    }

    public YamatoAttackAnimation(float transitionTime, float antic, float preDelay, float contact, float recovery, Collider collider, Joint colliderJoint, AnimationManager.AnimationAccessor<? extends BasicAttackAnimation> accessor, AssetAccessor<? extends Armature> armature, float play_speed, float damageMulti) {
        super(transitionTime, antic, preDelay, contact, recovery, collider, colliderJoint, accessor, armature, play_speed, damageMulti);
        this.addProperty(AnimationProperty.AttackPhaseProperty.EXTRA_DAMAGE, Set.of(ExtraDamageInstance.SWEEPING_EDGE_ENCHANTMENT.create(new float[0])));
        this.addProperty(AnimationProperty.AttackPhaseProperty.ARMOR_NEGATION_MODIFIER, ValueModifier.setter((float)120.0f));
    }

    public YamatoAttackAnimation(float transitionTime, AnimationManager.AnimationAccessor<? extends BasicAttackAnimation> accessor, AssetAccessor<? extends Armature> armature, float play_speed, float damageMulti, AvalonAttackAnimation.AvalonPhase ... phases) {
        super(transitionTime, accessor, armature, play_speed, damageMulti, phases);
        this.addProperty(AnimationProperty.AttackPhaseProperty.EXTRA_DAMAGE, Set.of(ExtraDamageInstance.SWEEPING_EDGE_ENCHANTMENT.create(new float[0])));
        this.addProperty(AnimationProperty.AttackPhaseProperty.ARMOR_NEGATION_MODIFIER, ValueModifier.setter((float)120.0f));
    }

    public YamatoAttackAnimation(float transitionTime, AnimationManager.AnimationAccessor<? extends BasicAttackAnimation> accessor, AssetAccessor<? extends Armature> armature, float damageMulti, AvalonAttackAnimation.AvalonPhase ... phases) {
        super(transitionTime, accessor, armature, damageMulti, phases);
        this.addProperty(AnimationProperty.AttackPhaseProperty.EXTRA_DAMAGE, Set.of(ExtraDamageInstance.SWEEPING_EDGE_ENCHANTMENT.create(new float[0])));
        this.addProperty(AnimationProperty.AttackPhaseProperty.ARMOR_NEGATION_MODIFIER, ValueModifier.setter((float)120.0f));
    }

    public YamatoAttackAnimation(float transitionTime, AnimationManager.AnimationAccessor<? extends BasicAttackAnimation> accessor, AssetAccessor<? extends Armature> armature, AvalonAttackAnimation.AvalonPhase ... phases) {
        super(transitionTime, accessor, armature, phases);
        this.addProperty(AnimationProperty.AttackPhaseProperty.EXTRA_DAMAGE, Set.of(ExtraDamageInstance.SWEEPING_EDGE_ENCHANTMENT.create(new float[0])));
        this.addProperty(AnimationProperty.AttackPhaseProperty.ARMOR_NEGATION_MODIFIER, ValueModifier.setter((float)120.0f));
    }

    public YamatoAttackAnimation(float convertTime, String path, AssetAccessor<? extends Armature> armature, float play_speed, float damageMulti, AvalonAttackAnimation.AvalonPhase ... phases) {
        super(convertTime, path, armature, play_speed, damageMulti, phases);
        this.addProperty(AnimationProperty.AttackPhaseProperty.EXTRA_DAMAGE, Set.of(ExtraDamageInstance.SWEEPING_EDGE_ENCHANTMENT.create(new float[0])));
        this.addProperty(AnimationProperty.AttackPhaseProperty.ARMOR_NEGATION_MODIFIER, ValueModifier.setter((float)120.0f));
    }

    public YamatoAttackAnimation(float transitionTime, AnimationManager.AnimationAccessor<? extends BasicAttackAnimation> accessor, AssetAccessor<? extends Armature> armature, float play_speed, float damageMulti, YamatoPhase ... phases) {
        this(transitionTime, accessor, armature, play_speed, damageMulti, (Supplier<? extends StaticAnimation>)null, phases);
    }

    public void end(LivingEntityPatch<?> entitypatch, AssetAccessor<? extends DynamicAnimation> nextAnimation, boolean isEnd) {
        super.end(entitypatch, nextAnimation, true);
    }

    protected void bindPhaseState(AttackAnimation.Phase phase) {
        float preDelay = phase.preDelay;
        this.stateSpectrumBlueprint.newTimePair(0.0f, preDelay).addState(EntityState.PHASE_LEVEL, (Object)1).newTimePair(phase.start, phase.recovery).addState(EntityState.CAN_SKILL_EXECUTION, (Object)true).newTimePair(phase.start, phase.recovery + 0.1f).addState(EntityState.MOVEMENT_LOCKED, (Object)true).addState(EntityState.UPDATE_LIVING_MOTION, (Object)false).newTimePair(phase.start, phase.recovery).addState(EntityState.CAN_BASIC_ATTACK, (Object)false).newTimePair(phase.start, phase.end).addState(EntityState.INACTION, (Object)true).newTimePair(phase.antic, phase.end).addState(EntityState.TURNING_LOCKED, (Object)true).newTimePair(preDelay, phase.contact).addState(EntityState.ATTACKING, (Object)true).addState(EntityState.PHASE_LEVEL, (Object)2).newTimePair(phase.contact, phase.end).addState(EntityState.PHASE_LEVEL, (Object)3);
    }

    protected void hurtCollidingEntities(LivingEntityPatch<?> entitypatch, float prevElapsedTime, float elapsedTime, EntityState prevState, EntityState state, AttackAnimation.Phase phase) {
        super.hurtCollidingEntities(entitypatch, prevElapsedTime, elapsedTime, prevState, state, phase);
        if (phase instanceof YamatoPhase) {
            YamatoPhase yamatoPhase = (YamatoPhase)phase;
            if (state.attacking() && this.isInDamageFrame(prevElapsedTime, elapsedTime, phase)) {
                List actuallyHit = entitypatch.getCurrentlyActuallyHitEntities();
                Vec3 attackerPos = ((LivingEntity)entitypatch.getOriginal()).m_20182_();
                AttackResult attackResult = this.getAttackResult(entitypatch);
                for (Entity entity : actuallyHit) {
                    LivingEntity livingEntity = this.getTrueEntity(entity);
                    if (livingEntity == null || !livingEntity.m_6084_()) continue;
                    LivingEntityPatch targetPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)livingEntity, LivingEntityPatch.class);
                    if (targetPatch != null) {
                        if (!(livingEntity instanceof Player)) {
                            livingEntity.m_7618_(EntityAnchorArgument.Anchor.FEET, attackerPos);
                        }
                        yamatoPhase.playHitAnimation(targetPatch, entitypatch, attackResult);
                    }
                    this.applyYamatoStunToMonster(livingEntity, attackResult);
                }
            }
        }
    }

    private void applyYamatoStunToMonster(LivingEntity target, AttackResult attackResult) {
        Level container;
        PlayerPatch playerPatch;
        if (!(target instanceof Monster)) {
            return;
        }
        if (attackResult.resultType != AttackResult.ResultType.SUCCESS || attackResult.damage <= 0.0f) {
            return;
        }
        if (!YamatoPassive.wasRecentlyParried(target)) {
            return;
        }
        YamatoPassive.clearParryRecord(target);
        if (!this.canBeStunnedByYamato(target)) {
            return;
        }
        target.m_7292_(new MobEffectInstance((MobEffect)EFNMobEffectRegistry.STUN.get(), ((Integer)EFNCommonConfig.YAMATO_PARRY_STUN_DURATION.get()).intValue(), 0, false, false, true));
        TakeDamageEvent.Attack parryEvent = YamatoPassive.getParryEvent(target);
        if (parryEvent != null && (playerPatch = parryEvent.getPlayerPatch()) != null && (container = playerPatch.getSkill(Yamato.yamato)) != null) {
            container.getDataManager().setData((SkillDataKey)EFNSKillDataKeys.STUN_COOLDOWN.get(), (Object)((Integer)EFNCommonConfig.YAMATO_PARRY_STUN_COOLDOWN.get()));
        }
        if (!target.m_9236_().f_46443_ && (container = target.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)container;
            LightningBolt lightningBolt = (LightningBolt)EntityType.f_20465_.m_20615_((Level)serverLevel);
            if (lightningBolt != null) {
                lightningBolt.m_6027_(target.m_20185_(), target.m_20186_(), target.m_20189_());
                lightningBolt.m_20874_(true);
                serverLevel.m_7967_((Entity)lightningBolt);
            }
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175830_, target.m_20185_(), target.m_20186_() + (double)target.m_20206_() * 0.5, target.m_20189_(), 15, 0.5, 0.5, 0.5, 0.05);
            serverLevel.m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_12090_, SoundSource.WEATHER, 1.5f, 0.8f + serverLevel.f_46441_.m_188501_() * 0.4f);
            serverLevel.m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_12089_, SoundSource.WEATHER, 1.2f, 1.0f);
        }
    }

    private boolean canBeStunnedByYamato(LivingEntity entity) {
        if (entity.m_20147_() || entity.m_21023_((MobEffect)EFNMobEffectRegistry.SIN_STUN_IMMUNITY.get()) || entity.m_21023_((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get())) {
            return false;
        }
        ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        if (entityId == null) {
            return false;
        }
        String entityIdString = entityId.toString();
        String modId = entityId.m_135827_();
        for (Object whitelistedObj : (List)EFNCommonConfig.YAMATO_GLOBALSTUN_WHITELIST.get()) {
            String whitelisted = whitelistedObj.toString();
            if (whitelisted.equals(modId + ":all")) {
                return true;
            }
            if (!whitelisted.equals(entityIdString)) continue;
            return true;
        }
        return false;
    }

    public LivingEntity getTrueEntity(Entity entity) {
        if (entity == null) {
            return null;
        }
        if (entity instanceof LivingEntity) {
            return (LivingEntity)entity;
        }
        if (entity instanceof PartEntity) {
            PartEntity partEntity = (PartEntity)entity;
            Entity parent = partEntity.getParent();
            return parent instanceof LivingEntity ? (LivingEntity)parent : null;
        }
        return null;
    }

    private AttackResult getAttackResult(LivingEntityPatch<?> entitypatch) {
        try {
            Field resultTypeField = LivingEntityPatch.class.getDeclaredField("lastAttackResultType");
            Field damageField = LivingEntityPatch.class.getDeclaredField("lastDealDamage");
            resultTypeField.setAccessible(true);
            damageField.setAccessible(true);
            AttackResult.ResultType resultType = (AttackResult.ResultType)resultTypeField.get(entitypatch);
            float damage = ((Float)damageField.get(entitypatch)).floatValue();
            LivingEntity attacker = (LivingEntity)entitypatch.getOriginal();
            boolean isDoppelganger = attacker instanceof DoppelgangerEntity;
            return new AttackResult(resultType, damage);
        }
        catch (Exception e) {
            return AttackResult.success((float)0.0f);
        }
    }

    private boolean isInDamageFrame(float prevTime, float currentTime, AttackAnimation.Phase phase) {
        float contactStart = phase.start + phase.preDelay;
        float contactEnd = phase.start + phase.contact;
        return prevTime < contactEnd && currentTime >= contactStart;
    }
}

