/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.animations.types;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.AnimationVariables;
import yesman.epicfight.api.animation.property.AnimationEvent;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.MovementAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class SelectiveMovementAnimation
extends MovementAnimation {
    public static final AnimationVariables.IndependentAnimationVariableKey<Integer> PREVIOUS_STATE = AnimationVariables.independent(animator -> 0, (boolean)true);
    private final Function<LivingEntityPatch<?>, Integer> selector;
    private final List<AssetAccessor<? extends StaticAnimation>> animationsInEachState;

    @SafeVarargs
    public SelectiveMovementAnimation(Function<LivingEntityPatch<?>, Integer> selector, AnimationManager.AnimationAccessor<? extends SelectiveMovementAnimation> accessor, AssetAccessor<? extends StaticAnimation> ... selectOptions) {
        super(0.15f, false, accessor, null);
        this.selector = selector;
        this.animationsInEachState = List.of(selectOptions);
        for (AssetAccessor<? extends StaticAnimation> subAnimation : this.animationsInEachState) {
            Objects.requireNonNull((StaticAnimation)subAnimation.get()).addEvents(new AnimationEvent[]{AnimationEvent.SimpleEvent.create((entitypatch, animation, params) -> this.handleAnimationEnd(entitypatch), (AnimationEvent.Side)AnimationEvent.Side.BOTH)});
        }
    }

    private void handleAnimationEnd(LivingEntityPatch<?> entitypatch) {
        int currentStateId = this.selector.apply(entitypatch);
        Optional prevState = entitypatch.getAnimator().getVariables().get(PREVIOUS_STATE, (AssetAccessor)this.getAccessor());
        prevState.ifPresentOrElse(prevStateId -> {
            if (prevStateId != currentStateId) {
                entitypatch.getAnimator().playAnimation(this.animationsInEachState.get(currentStateId), 0.0f);
                entitypatch.getAnimator().getVariables().put(PREVIOUS_STATE, (AssetAccessor)this.getAccessor(), (Object)currentStateId);
            } else {
                entitypatch.getAnimator().playAnimation(this.animationsInEachState.get(currentStateId), 0.0f);
            }
        }, () -> {
            entitypatch.getAnimator().playAnimation(this.animationsInEachState.get(0), 0.0f);
            entitypatch.getAnimator().getVariables().put(PREVIOUS_STATE, (AssetAccessor)this.getAccessor(), (Object)0);
        });
    }

    public void begin(LivingEntityPatch<?> entitypatch) {
        super.begin(entitypatch);
        int result = this.selector.apply(entitypatch);
        entitypatch.getAnimator().getVariables().put(PREVIOUS_STATE, (AssetAccessor)this.getAccessor(), (Object)result);
        entitypatch.getAnimator().playAnimation(this.animationsInEachState.get(result), 0.0f);
    }

    public void tick(LivingEntityPatch<?> entitypatch) {
        super.tick(entitypatch);
        int currentStateId = this.selector.apply(entitypatch);
        Optional prevState = entitypatch.getAnimator().getVariables().get(PREVIOUS_STATE, (AssetAccessor)this.getAccessor());
        prevState.ifPresent(prevStateId -> {
            if (prevStateId != currentStateId) {
                entitypatch.getAnimator().playAnimation(this.animationsInEachState.get(currentStateId), 0.0f);
                entitypatch.getAnimator().getVariables().put(PREVIOUS_STATE, (AssetAccessor)this.getAccessor(), (Object)currentStateId);
            }
        });
    }

    public float getPlaySpeed(LivingEntityPatch<?> entitypatch, DynamicAnimation animation) {
        if (animation.isLinkAnimation()) {
            return 1.0f;
        }
        float movementSpeed = 1.0f;
        if (Math.abs(((LivingEntity)entitypatch.getOriginal()).f_267362_.m_267731_() - ((LivingEntity)entitypatch.getOriginal()).f_267362_.m_267711_(1.0f)) < 0.007f) {
            movementSpeed *= ((LivingEntity)entitypatch.getOriginal()).f_267362_.m_267731_() * 1.16f;
        }
        return movementSpeed;
    }

    public boolean isMetaAnimation() {
        return true;
    }

    public List<AssetAccessor<? extends StaticAnimation>> getSubAnimations() {
        return this.animationsInEachState;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Layer.Priority getPriority() {
        return Objects.requireNonNull((StaticAnimation)this.animationsInEachState.get(0).get()).getPriority();
    }

    @OnlyIn(value=Dist.CLIENT)
    public Layer.LayerType getLayerType() {
        return Objects.requireNonNull((StaticAnimation)this.animationsInEachState.get(0).get()).getLayerType();
    }

    public boolean canBePlayedReverse() {
        return true;
    }
}

