/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.hungerstrike;

import com.jaquadro.minecraft.hungerstrike.ExtendedPlayer;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.LogicalSide;

public class PlayerHandler {
    private static final Map<GameProfile, Map<String, CompoundTag>> dataStore = new HashMap<GameProfile, Map<String, CompoundTag>>();

    public static List<Player> getStrikingPlayers(MinecraftServer server) {
        return PlayerHandler.getPlayers(server, true);
    }

    public static List<Player> getNonStrikingPlayers(MinecraftServer server) {
        return PlayerHandler.getPlayers(server, false);
    }

    private static List<Player> getPlayers(MinecraftServer server, boolean isStriking) {
        ArrayList<Player> players = new ArrayList<Player>();
        for (ServerPlayer playerEnt : server.m_6846_().m_11314_()) {
            ExtendedPlayer playerExt = ExtendedPlayer.get((Player)playerEnt);
            if (playerExt == null || playerExt.isOnHungerStrike() != isStriking) continue;
            players.add((Player)playerEnt);
        }
        return players;
    }

    public void storeData(Player player) {
        ExtendedPlayer playerExt = ExtendedPlayer.get(player);
        if (playerExt != null) {
            CompoundTag data = new CompoundTag();
            playerExt.saveNBTData(data);
            this.storeData(player, "HungerStrike", data);
        }
    }

    public void storeData(Player player, String name, CompoundTag data) {
        this.storeData(player.m_36316_(), name, data);
    }

    public void storeData(GameProfile profile, String name, CompoundTag data) {
        Map<String, CompoundTag> store = dataStore.get(profile);
        if (store == null) {
            store = new HashMap<String, CompoundTag>();
            dataStore.put(profile, store);
        }
        store.put(name, data);
    }

    public void restoreData(Player player) {
        CompoundTag data;
        ExtendedPlayer playerExt = ExtendedPlayer.get(player);
        if (playerExt != null && (data = this.getData(player, "HungerStrike")) != null) {
            playerExt.loadNBTData(data);
        }
    }

    public CompoundTag getData(Player player, String name) {
        return this.getData(player.m_36316_(), name);
    }

    public CompoundTag getData(GameProfile profile, String name) {
        Map<String, CompoundTag> store = dataStore.get(profile);
        if (store == null) {
            return null;
        }
        return store.remove(name);
    }

    public void tick(Player player, TickEvent.Phase phase, LogicalSide side) {
        ExtendedPlayer playerExt = ExtendedPlayer.get(player);
        if (playerExt != null) {
            playerExt.tick(phase, side);
        }
    }

    public boolean isOnHungerStrike(Player player) {
        ExtendedPlayer playerExt = ExtendedPlayer.get(player);
        if (playerExt != null) {
            return playerExt.isOnHungerStrike();
        }
        return false;
    }
}

