/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.p1nero_ec.utils;

import com.github.L_Ender.cataclysm.config.CMConfig;
import com.github.L_Ender.cataclysm.entity.effect.Lightning_Storm_Entity;
import com.github.L_Ender.cataclysm.entity.effect.ScreenShake_Entity;
import com.github.L_Ender.cataclysm.entity.effect.Wave_Entity;
import com.github.L_Ender.cataclysm.entity.projectile.Lightning_Spear_Entity;
import com.github.L_Ender.cataclysm.entity.projectile.Spark_Entity;
import com.github.L_Ender.cataclysm.entity.projectile.Storm_Serpent_Entity;
import com.github.L_Ender.cataclysm.entity.projectile.Water_Spear_Entity;
import com.github.L_Ender.cataclysm.init.ModParticle;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import yesman.epicfight.api.animation.property.AnimationEvent;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.utils.HitEntityList;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.ExtraDamageInstance;

public class ScyllaEffectInvoker {
    public static final AnimationEvent.E0 SUMMON_THUNDER_UPGRADED = (entitypatch, animation, params) -> {
        if (entitypatch.isLogicalClient()) {
            return;
        }
        Object patt2389$temp = animation.get();
        if (patt2389$temp instanceof AttackAnimation) {
            AttackAnimation attackAnimation = (AttackAnimation)patt2389$temp;
            AttackAnimation.Phase phase = attackAnimation.phases[1];
            int strikeCount = (int)ValueModifier.calculator().attach(phase.getProperty(AnimationProperty.AttackPhaseProperty.MAX_STRIKES_MODIFIER).orElse(ValueModifier.setter((float)3.0f))).getResult(0.0f);
            float damage = ValueModifier.calculator().attach(phase.getProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER).orElse(ValueModifier.setter((float)8.0f))).getResult(0.0f);
            LivingEntity original = (LivingEntity)entitypatch.getOriginal();
            ServerLevel level = (ServerLevel)original.m_9236_();
            float total = damage + ExtraDamageInstance.SWEEPING_EDGE_ENCHANTMENT.create(new float[0]).get(original, original.m_21120_(InteractionHand.MAIN_HAND), null, damage);
            List list = level.m_6249_((Entity)original, original.m_20191_().m_82377_(10.0, 4.0, 10.0), e -> !(e.m_20280_((Entity)original) > 100.0) && !e.m_7307_((Entity)original) && ((LivingEntity)entitypatch.getOriginal()).m_142582_(e));
            list = HitEntityList.Priority.HOSTILITY.sort(entitypatch, list);
            int count = 0;
            while (count < strikeCount && count < list.size()) {
                ServerPlayer serverPlayer;
                Entity e2 = (Entity)list.get(count++);
                BlockPos blockpos = e2.m_20183_();
                ScyllaEffectInvoker.createSixDirectionLightningStorms(level, original, blockpos, total);
                ScyllaEffectInvoker.createRandomSpearBarrage(level, original, e2, 8, total * 0.6f);
                ScyllaEffectInvoker.createMultipleLightningBolts(level, original, e2, blockpos, entitypatch, attackAnimation, phase, total);
                LightningBolt mainLightning = (LightningBolt)EntityType.f_20465_.m_20615_((Level)level);
                mainLightning.m_20874_(true);
                mainLightning.m_20219_(Vec3.m_82539_((Vec3i)blockpos));
                mainLightning.setDamage(0.0f);
                if (entitypatch instanceof ServerPlayerPatch) {
                    ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)entitypatch;
                    serverPlayer = (ServerPlayer)serverPlayerPatch.getOriginal();
                } else {
                    serverPlayer = null;
                }
                mainLightning.m_20879_(serverPlayer);
                DamageSource dmgSource = new DamageSource((Holder)e2.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268450_), entitypatch.getOriginal());
                EpicFightDamageSource damageSource = attackAnimation.getEpicFightDamageSource(dmgSource, entitypatch, e2, phase).setUsedItem(((LivingEntity)entitypatch.getOriginal()).m_21120_(InteractionHand.MAIN_HAND));
                e2.m_6469_((DamageSource)damageSource, total);
                e2.m_8038_(level, mainLightning);
                level.m_7967_((Entity)mainLightning);
                Vec3 lightningPos = Vec3.m_82539_((Vec3i)blockpos);
                level.m_8767_((ParticleOptions)((SimpleParticleType)ModParticle.LIGHTNING_EXPLODE.get()), lightningPos.f_82479_, lightningPos.f_82480_, lightningPos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            }
            if (count > 0) {
                if (level.m_46469_().m_46207_(GameRules.f_46150_) && level.f_46441_.m_188501_() < 0.08f && level.m_46661_(1.0f) < 1.0f) {
                    level.m_8606_(0, Mth.m_216287_((RandomSource)level.f_46441_, (int)12000, (int)180000), true, true);
                }
                original.m_5496_(SoundEvents.f_12521_, 5.0f, 1.0f);
                ScreenShake_Entity.ScreenShake((Level)level, (Vec3)original.m_20182_(), (float)25.0f, (float)0.15f, (int)0, (int)20);
            }
        }
    };
    public static final AnimationEvent.E0 SUMMON_THUNDER = (entitypatch, animation, params) -> {
        Object patt173405$temp;
        if (!entitypatch.isLogicalClient() && (patt173405$temp = animation.get()) instanceof AttackAnimation) {
            AttackAnimation attackAnimation = (AttackAnimation)patt173405$temp;
            AttackAnimation.Phase phase = attackAnimation.phases[1];
            int i = (int)ValueModifier.calculator().attach(phase.getProperty(AnimationProperty.AttackPhaseProperty.MAX_STRIKES_MODIFIER).orElse(ValueModifier.setter((float)3.0f))).getResult(0.0f);
            float damage = ValueModifier.calculator().attach(phase.getProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER).orElse(ValueModifier.setter((float)8.0f))).getResult(0.0f);
            LivingEntity original = (LivingEntity)entitypatch.getOriginal();
            ServerLevel level = (ServerLevel)original.m_9236_();
            float total = damage + ExtraDamageInstance.SWEEPING_EDGE_ENCHANTMENT.create(new float[0]).get(original, original.m_21120_(InteractionHand.MAIN_HAND), (LivingEntity)null, damage);
            List list = level.m_6249_((Entity)original, original.m_20191_().m_82377_(10.0, 4.0, 10.0), ex -> !(ex.m_20280_((Entity)original) > 100.0) && !ex.m_7307_((Entity)original) && ((LivingEntity)entitypatch.getOriginal()).m_142582_(ex));
            list = HitEntityList.Priority.HOSTILITY.sort(entitypatch, list);
            int count = 0;
            while (count < i && count < list.size()) {
                ServerPlayer var19;
                Entity e = (Entity)list.get(count++);
                BlockPos blockpos = e.m_20183_();
                ScyllaEffectInvoker.createMultipleLightningBolts(level, original, e, blockpos, entitypatch, attackAnimation, phase, total);
                LightningBolt lightningbolt = (LightningBolt)EntityType.f_20465_.m_20615_((Level)level);
                lightningbolt.m_20874_(true);
                lightningbolt.m_20219_(Vec3.m_82539_((Vec3i)blockpos));
                lightningbolt.setDamage(0.0f);
                if (entitypatch instanceof ServerPlayerPatch) {
                    ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)entitypatch;
                    var19 = (ServerPlayer)serverPlayerPatch.getOriginal();
                } else {
                    var19 = null;
                }
                lightningbolt.m_20879_(var19);
                DamageSource dmgSource = new DamageSource((Holder)e.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268450_), entitypatch.getOriginal());
                EpicFightDamageSource damageSource = attackAnimation.getEpicFightDamageSource(dmgSource, entitypatch, e, phase).setUsedItem(((LivingEntity)entitypatch.getOriginal()).m_21120_(InteractionHand.MAIN_HAND));
                e.m_6469_((DamageSource)damageSource, total);
                e.m_8038_(level, lightningbolt);
                level.m_7967_((Entity)lightningbolt);
            }
            if (count > 0) {
                if (level.m_46469_().m_46207_(GameRules.f_46150_) && level.f_46441_.m_188501_() < 0.08f && level.m_46661_(1.0f) < 1.0f) {
                    level.m_8606_(0, Mth.m_216287_((RandomSource)level.f_46441_, (int)12000, (int)180000), true, true);
                }
                original.m_5496_(SoundEvents.f_12521_, 5.0f, 1.0f);
            }
        }
    };

    public static void spawnLightningStorm(Level world, double x, double y, double z, double v, float rotation, int delay, float damage, float hpDamage, LivingEntity caster, float size) {
        if (world == null) {
            return;
        }
        BlockPos blockpos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        boolean foundGround = false;
        double groundY = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1;
            BlockState blockstate;
            if (!(blockstate = world.m_8055_(blockpos1 = blockpos.m_7495_())).m_60783_((BlockGetter)world, blockpos1, Direction.UP)) continue;
            if (!world.m_46859_(blockpos) && !(voxelshape = (blockstate1 = world.m_8055_(blockpos)).m_60812_((BlockGetter)world, blockpos)).m_83281_()) {
                groundY = voxelshape.m_83297_(Direction.Axis.Y);
            }
            foundGround = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)y) - 1);
        if (foundGround) {
            Lightning_Storm_Entity storm = new Lightning_Storm_Entity(world, x, (double)blockpos.m_123342_() + groundY, z, rotation, delay, damage, hpDamage, caster, size);
            world.m_7967_((Entity)storm);
        }
    }

    public static Water_Spear_Entity spawnWaterSpear(Level world, LivingEntity caster, Vec3 direction, double x, double y, double z, float damage) {
        if (world == null) {
            return null;
        }
        Water_Spear_Entity spear = new Water_Spear_Entity(caster, direction, world, damage);
        spear.m_6034_(x, y, z);
        world.m_7967_((Entity)spear);
        return spear;
    }

    public static Lightning_Spear_Entity spawnLightningSpear(Level world, LivingEntity caster, Vec3 direction, double x, double y, double z, float damage, float areaDamage, float hpDamage, float areaRadius) {
        if (world == null) {
            return null;
        }
        Lightning_Spear_Entity spear = new Lightning_Spear_Entity(caster, direction, world, damage);
        spear.setAreaDamage(areaDamage);
        spear.setHpDamage(hpDamage);
        spear.setAreaRadius(areaRadius);
        spear.m_6034_(x, y, z);
        world.m_7967_((Entity)spear);
        return spear;
    }

    public static Spark_Entity spawnSpark(Level world, LivingEntity caster, double x, double y, double z, float damage, float areaDamage, float hpDamage, float areaRadius) {
        if (world == null) {
            return null;
        }
        Spark_Entity spark = new Spark_Entity(world, caster);
        spark.setDamage(damage);
        spark.setAreaDamage(areaDamage);
        spark.setHpDamage(hpDamage);
        spark.setAreaRadius(areaRadius);
        spark.m_6034_(x, y, z);
        world.m_7967_((Entity)spark);
        return spark;
    }

    public static void spawnStormSerpent(Level world, double x, double y, double z, float rotation, int delay, LivingEntity caster, float damage, LivingEntity target, boolean isFirst) {
        if (world == null) {
            return;
        }
        Storm_Serpent_Entity serpent = new Storm_Serpent_Entity(world, x, y, z, rotation, delay, caster, damage, target, isFirst);
        world.m_7967_((Entity)serpent);
    }

    public static Wave_Entity spawnWave(Level world, LivingEntity caster, double x, double y, double z, int duration, float speed) {
        if (world == null) {
            return null;
        }
        Wave_Entity wave = new Wave_Entity(world, caster, duration, speed);
        wave.m_6034_(x, y, z);
        world.m_7967_((Entity)wave);
        return wave;
    }

    public static void createForwardLightningStorm(Level world, LivingEntity caster, double distance, float damage, float hpDamage, float size) {
        if (world == null || world.m_5776_() || caster == null) {
            return;
        }
        Vec3 lookVec = caster.m_20154_();
        Vec3 spawnPos = caster.m_20182_().m_82520_(lookVec.f_82479_ * distance, 0.0, lookVec.f_82481_ * distance);
        float rotation = caster.m_146908_() * ((float)Math.PI / 180);
        ScyllaEffectInvoker.spawnLightningStorm(world, spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, caster.m_20186_() + 3.0, rotation, 0, damage, hpDamage, caster, size);
    }

    public static void createForwardLightningStormLine(Level world, LivingEntity caster, double baseDistance, double maxDistance, int count, double stepDistance, float damage, float hpDamage, float size) {
        double currentDistance;
        if (world == null || world.m_5776_() || caster == null) {
            return;
        }
        Vec3 lookVec = caster.m_20154_();
        float baseRotation = caster.m_146908_() * ((float)Math.PI / 180);
        double actualBaseDistance = Math.min(baseDistance, maxDistance);
        for (int i = 0; i < count && !((currentDistance = actualBaseDistance + stepDistance * (double)i) > maxDistance); ++i) {
            Vec3 spawnPos = caster.m_20182_().m_82520_(lookVec.f_82479_ * currentDistance, 0.0, lookVec.f_82481_ * currentDistance);
            ScyllaEffectInvoker.spawnLightningStorm(world, spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, caster.m_20186_() + 3.0, baseRotation, 0, 3.0f, hpDamage, caster, 2.5f);
        }
    }

    public static void createFanLightningStorms(Level world, LivingEntity caster, double distance, int count, float spreadAngle, float damage, float hpDamage, float size) {
        if (world == null || world.m_5776_() || caster == null) {
            return;
        }
        float baseYaw = caster.m_146908_();
        for (int i = 0; i < count; ++i) {
            float horizontalAngle = -spreadAngle / 2.0f + spreadAngle * (float)i / (float)(count - 1);
            double spawnX = caster.m_20185_();
            double spawnY = caster.m_20186_() + (double)(caster.m_20206_() * 0.7f);
            double spawnZ = caster.m_20189_();
            double horizontalRad = Math.toRadians(baseYaw + horizontalAngle);
            double verticalRad = 0.0;
            Vec3 direction = new Vec3(-Math.sin(horizontalRad) * Math.cos(verticalRad), Math.sin(verticalRad), Math.cos(horizontalRad) * Math.cos(verticalRad)).m_82541_();
            Vec3 spawnPos = caster.m_20182_().m_82520_(direction.f_82479_ * distance, 0.0, direction.f_82481_ * distance);
            float rotation = (float)Math.atan2(direction.f_82481_, direction.f_82479_);
            ScyllaEffectInvoker.spawnLightningStorm(world, spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, caster.m_20186_() + 3.0, rotation, 0, damage, hpDamage, caster, size);
        }
    }

    public static void createCircleLightningStorms(Level world, LivingEntity caster, double radius, int count, float damage, float hpDamage, float size) {
        if (world == null || world.m_5776_() || caster == null) {
            return;
        }
        Vec3 center = caster.m_20182_();
        for (int i = 0; i < count; ++i) {
            float angle = (float)i * (float)Math.PI * 2.0f / (float)count;
            Vec3 offset = new Vec3((double)Mth.m_14089_((float)angle) * radius, 0.0, (double)Mth.m_14031_((float)angle) * radius);
            Vec3 spawnPos = center.m_82549_(offset);
            ScyllaEffectInvoker.spawnLightningStorm(world, spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, caster.m_20186_() + 3.0, angle, 0, damage, hpDamage, caster, size);
        }
    }

    public static void createLightningWall(Level world, LivingEntity caster, double startX, double startZ, double endX, double endZ, int lightningCount, float damage, float hpDamage) {
        if (world == null || world.m_5776_() || caster == null) {
            return;
        }
        double dx = endX - startX;
        double dz = endZ - startZ;
        double length = Math.sqrt(dx * dx + dz * dz);
        double unitX = dx / length;
        double unitZ = dz / length;
        for (int i = 0; i < lightningCount; ++i) {
            double progress = (double)i / (double)(lightningCount - 1);
            double x = startX + dx * progress;
            double z = startZ + dz * progress;
            double perpX = -unitZ;
            for (int side = -1; side <= 1; side += 2) {
                double offsetX = x + perpX * (double)side * 2.0;
                double offsetZ = z + unitX * (double)side * 2.0;
                float rotation = (float)Math.atan2(unitX * (double)side, perpX * (double)side);
                ScyllaEffectInvoker.spawnLightningStorm(world, offsetX, offsetZ, caster.m_20186_() - 2.0, caster.m_20186_() + 5.0, rotation, 0, damage, hpDamage, caster, 2.0f);
            }
        }
    }

    public static void createArcLightningWall(Level world, LivingEntity caster, double distance, float arcAngle, int lightningCount, float damage, float hpDamage) {
        if (world == null || world.m_5776_() || caster == null) {
            return;
        }
        Vec3 lookVec = caster.m_20154_();
        float baseYaw = caster.m_146908_();
        for (int i = 0; i < lightningCount; ++i) {
            float angle = -arcAngle / 2.0f + arcAngle * (float)i / (float)(lightningCount - 1);
            double angleRad = Math.toRadians(angle);
            Vec3 direction = lookVec.m_82524_((float)angleRad).m_82541_();
            double x = caster.m_20185_() + direction.f_82479_ * distance;
            double z = caster.m_20189_() + direction.f_82481_ * distance;
            float rotation = (baseYaw + angle) * ((float)Math.PI / 180);
            ScyllaEffectInvoker.spawnLightningStorm(world, x, z, caster.m_20186_() - 2.0, caster.m_20186_() + 5.0, rotation, i * 2, damage, hpDamage, caster, 2.0f);
        }
    }

    public static void createCircleLightningWall(Level world, LivingEntity caster, double radius, int lightningCount, float damage, float hpDamage) {
        if (world == null || world.m_5776_() || caster == null) {
            return;
        }
        Vec3 center = caster.m_20182_();
        for (int i = 0; i < lightningCount; ++i) {
            float angle = (float)i * (float)Math.PI * 2.0f / (float)lightningCount;
            double x = center.f_82479_ + Math.cos(angle) * radius;
            double z = center.f_82481_ + Math.sin(angle) * radius;
            ScyllaEffectInvoker.spawnLightningStorm(world, x, z, caster.m_20186_() - 2.0, caster.m_20186_() + 5.0, angle, i * 2, damage, hpDamage, caster, 2.0f);
        }
    }

    public static void createDualSpearAttack(Level world, LivingEntity caster, LivingEntity target, int spearCount, float spreadAngle, float damage) {
        if (world == null || world.m_5776_() || caster == null || target == null) {
            return;
        }
        float f = Mth.m_14089_((float)(caster.m_146908_() * ((float)Math.PI / 180)));
        float f1 = Mth.m_14031_((float)(caster.m_146908_() * ((float)Math.PI / 180)));
        for (int i = 0; i < spearCount; ++i) {
            double offsetAngle = ((double)i - (double)(spearCount - 1) / 2.0) * Math.toRadians(spreadAngle);
            double d0 = caster.m_20185_() + (double)f * -0.5;
            double d1 = caster.m_20186_() + (double)(caster.m_20206_() * 0.7f);
            double d2 = caster.m_20189_() + (double)f1 * -0.5;
            double d3 = target.m_20185_() - d0;
            double d4 = target.m_20227_(0.2) - d1;
            double d5 = target.m_20189_() - d2;
            double x = d3 * Math.cos(offsetAngle) + d5 * Math.sin(offsetAngle);
            double y = d4;
            double z = -d3 * Math.sin(offsetAngle) + d5 * Math.cos(offsetAngle);
            Vec3 direction = new Vec3(x, y, z).m_82541_();
            float yRot = (float)(Mth.m_14136_((double)direction.f_82481_, (double)direction.f_82479_) * 57.29577951308232) + 90.0f;
            float xRot = (float)(-(Mth.m_14136_((double)direction.f_82480_, (double)Math.sqrt(direction.f_82479_ * direction.f_82479_ + direction.f_82481_ * direction.f_82481_)) * 57.29577951308232));
            if (i % 2 == 0) {
                Water_Spear_Entity waterSpear = ScyllaEffectInvoker.spawnWaterSpear(world, caster, direction, d0, d1, d2, damage);
                if (waterSpear == null) continue;
                waterSpear.m_146922_(yRot);
                waterSpear.m_146926_(xRot);
                continue;
            }
            Lightning_Spear_Entity lightningSpear = ScyllaEffectInvoker.spawnLightningSpear(world, caster, direction, d0, d1, d2, damage, (float)CMConfig.ScyllaLightningAreaDamage, (float)CMConfig.ScyllaLightningStormHpDamage, 2.0f);
            if (lightningSpear == null) continue;
            lightningSpear.m_146922_(yRot);
            lightningSpear.m_146926_(xRot);
        }
    }

    public static void createForwardDualSpears(Level world, LivingEntity caster, int spearCount, float spreadAngle, float distance, float damage) {
        if (world == null || world.m_5776_() || caster == null) {
            return;
        }
        Vec3 lookVec = caster.m_20154_();
        float f = Mth.m_14089_((float)(caster.m_146908_() * ((float)Math.PI / 180)));
        float f1 = Mth.m_14031_((float)(caster.m_146908_() * ((float)Math.PI / 180)));
        for (int i = 0; i < spearCount; ++i) {
            double offsetAngle = ((double)i - (double)(spearCount - 1) / 2.0) * Math.toRadians(spreadAngle);
            double spawnX = caster.m_20185_() + (double)f * -0.5;
            double spawnY = caster.m_20186_() + (double)(caster.m_20206_() * 0.7f);
            double spawnZ = caster.m_20189_() + (double)f1 * -0.5;
            Vec3 baseDirection = lookVec.m_82524_((float)offsetAngle).m_82541_();
            Vec3 direction = baseDirection.m_82490_((double)distance).m_82541_();
            float yRot = (float)(Mth.m_14136_((double)direction.f_82481_, (double)direction.f_82479_) * 57.29577951308232) + 90.0f;
            float xRot = (float)(-(Mth.m_14136_((double)direction.f_82480_, (double)Math.sqrt(direction.f_82479_ * direction.f_82479_ + direction.f_82481_ * direction.f_82481_)) * 57.29577951308232));
            if (i % 2 == 0) {
                Water_Spear_Entity waterSpear = ScyllaEffectInvoker.spawnWaterSpear(world, caster, direction, spawnX, spawnY, spawnZ, damage);
                if (waterSpear == null) continue;
                waterSpear.m_146922_(yRot);
                waterSpear.m_146926_(xRot);
                waterSpear.accelerationPower = 0.2;
                continue;
            }
            Lightning_Spear_Entity lightningSpear = ScyllaEffectInvoker.spawnLightningSpear(world, caster, direction, spawnX, spawnY, spawnZ, damage, (float)CMConfig.ScyllaLightningAreaDamage, (float)CMConfig.ScyllaLightningStormHpDamage, 2.0f);
            if (lightningSpear == null) continue;
            lightningSpear.m_146922_(yRot);
            lightningSpear.m_146926_(xRot);
            lightningSpear.accelerationPower = 0.2;
        }
    }

    public static void createFanSpearBarrage(Level world, LivingEntity caster, int rows, int spearsPerRow, float horizontalSpread, float verticalSpread, float baseDistance, float damage) {
        if (world == null || world.m_5776_() || caster == null) {
            return;
        }
        float baseYaw = caster.m_146908_();
        for (int row = 0; row < rows; ++row) {
            float verticalAngle = -verticalSpread / 2.0f + verticalSpread * (float)row / (float)(rows - 1);
            for (int col = 0; col < spearsPerRow; ++col) {
                boolean isWaterSpear;
                float horizontalAngle = -horizontalSpread / 2.0f + horizontalSpread * (float)col / (float)(spearsPerRow - 1);
                double spawnX = caster.m_20185_();
                double spawnY = caster.m_20186_() + (double)(caster.m_20206_() * 0.7f);
                double spawnZ = caster.m_20189_();
                double horizontalRad = Math.toRadians(baseYaw + horizontalAngle);
                double verticalRad = Math.toRadians(verticalAngle);
                Vec3 direction = new Vec3(-Math.sin(horizontalRad) * Math.cos(verticalRad), Math.sin(verticalRad), Math.cos(horizontalRad) * Math.cos(verticalRad)).m_82541_();
                float yRot = (float)(Mth.m_14136_((double)direction.f_82481_, (double)direction.f_82479_) * 57.29577951308232) + 90.0f;
                float xRot = (float)(-(Mth.m_14136_((double)direction.f_82480_, (double)Math.sqrt(direction.f_82479_ * direction.f_82479_ + direction.f_82481_ * direction.f_82481_)) * 57.29577951308232));
                boolean bl = isWaterSpear = (row + col) % 2 == 0;
                if (isWaterSpear) {
                    Water_Spear_Entity waterSpear = ScyllaEffectInvoker.spawnWaterSpear(world, caster, direction, spawnX, spawnY, spawnZ, damage);
                    if (waterSpear == null) continue;
                    waterSpear.m_146922_(yRot);
                    waterSpear.m_146926_(xRot);
                    waterSpear.setTotalBounces(6);
                    continue;
                }
                Lightning_Spear_Entity lightningSpear = ScyllaEffectInvoker.spawnLightningSpear(world, caster, direction, spawnX, spawnY, spawnZ, damage, 3.0f, 0.025f, 2.0f);
                if (lightningSpear == null) continue;
                lightningSpear.m_146922_(yRot);
                lightningSpear.m_146926_(xRot);
            }
        }
    }

    public static void createRotatingSpearRing(Level world, LivingEntity caster, double radius, int spearCount, float rotationSpeed, float damage) {
        if (world == null || world.m_5776_() || caster == null) {
            return;
        }
        Vec3 center = caster.m_20182_();
        Vec3 lookVec = caster.m_20154_();
        Vec3 upVec = new Vec3(0.0, 1.0, 0.0);
        Vec3 rightVec = lookVec.m_82537_(upVec).m_82541_();
        Vec3 upVecCorrected = rightVec.m_82537_(lookVec).m_82541_();
        for (int i = 0; i < spearCount; ++i) {
            float angle = (float)i * (float)Math.PI * 2.0f / (float)spearCount;
            double offsetX = Math.cos(angle) * radius;
            double offsetY = Math.sin(angle) * radius;
            Vec3 ringOffset = rightVec.m_82490_(offsetX).m_82549_(upVecCorrected.m_82490_(offsetY));
            Vec3 spawnPos = center.m_82549_(ringOffset).m_82520_(0.0, (double)caster.m_20206_() * 0.7, 0.0);
            Vec3 direction = ringOffset.m_82541_();
            float yRot = (float)(Mth.m_14136_((double)direction.f_82481_, (double)direction.f_82479_) * 57.29577951308232) + 90.0f;
            float xRot = (float)(-(Mth.m_14136_((double)direction.f_82480_, (double)Math.sqrt(direction.f_82479_ * direction.f_82479_ + direction.f_82481_ * direction.f_82481_)) * 57.29577951308232));
            if (i % 2 == 0) {
                Water_Spear_Entity waterSpear = ScyllaEffectInvoker.spawnWaterSpear(world, caster, direction, spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, damage);
                if (waterSpear == null) continue;
                waterSpear.m_146922_(yRot);
                waterSpear.m_146926_(xRot);
                continue;
            }
            Lightning_Spear_Entity lightningSpear = ScyllaEffectInvoker.spawnLightningSpear(world, caster, direction, spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, damage, (float)CMConfig.ScyllaLightningAreaDamage, (float)CMConfig.ScyllaLightningStormHpDamage, 1.8f);
            if (lightningSpear == null) continue;
            lightningSpear.m_146922_(yRot);
            lightningSpear.m_146926_(xRot);
        }
    }

    public static void createFocusedSpearBeam(Level world, LivingEntity caster, int spearCount, float convergenceDistance, float damage) {
        if (world == null || world.m_5776_() || caster == null) {
            return;
        }
        Vec3 lookVec = caster.m_20154_();
        Vec3 convergencePoint = caster.m_20182_().m_82520_(lookVec.f_82479_ * (double)convergenceDistance, (double)caster.m_20206_() * 0.7, lookVec.f_82481_ * (double)convergenceDistance);
        for (int i = 0; i < spearCount; ++i) {
            double angle = Math.random() * 2.0 * Math.PI;
            double radius = 1.5 + Math.random();
            double spawnX = caster.m_20185_() + Math.cos(angle) * radius;
            double spawnY = caster.m_20186_() + (double)caster.m_20206_() * 0.7 + (Math.random() - 0.5);
            double spawnZ = caster.m_20189_() + Math.sin(angle) * radius;
            Vec3 direction = convergencePoint.m_82492_(spawnX, spawnY, spawnZ).m_82541_();
            float yRot = (float)(Mth.m_14136_((double)direction.f_82481_, (double)direction.f_82479_) * 57.29577951308232) + 90.0f;
            float xRot = (float)(-(Mth.m_14136_((double)direction.f_82480_, (double)Math.sqrt(direction.f_82479_ * direction.f_82479_ + direction.f_82481_ * direction.f_82481_)) * 57.29577951308232));
            if (i % 2 == 0) {
                Water_Spear_Entity waterSpear = ScyllaEffectInvoker.spawnWaterSpear(world, caster, direction, spawnX, spawnY, spawnZ, damage);
                if (waterSpear == null) continue;
                waterSpear.m_146922_(yRot);
                waterSpear.m_146926_(xRot);
                continue;
            }
            Lightning_Spear_Entity lightningSpear = ScyllaEffectInvoker.spawnLightningSpear(world, caster, direction, spawnX, spawnY, spawnZ, damage, (float)CMConfig.ScyllaLightningAreaDamage, (float)CMConfig.ScyllaLightningStormHpDamage, 2.0f);
            if (lightningSpear == null) continue;
            lightningSpear.m_146922_(yRot);
            lightningSpear.m_146926_(xRot);
        }
    }

    public static void createStormSerpentSwarm(Level world, LivingEntity caster, LivingEntity target, int serpentCount, double spreadDistance, float damage) {
        if (world == null || world.m_5776_() || caster == null || target == null) {
            return;
        }
        float f = Mth.m_14089_((float)(caster.m_146908_() * ((float)Math.PI / 180)));
        float f1 = Mth.m_14031_((float)(caster.m_146908_() * ((float)Math.PI / 180)));
        for (int i = 0; i < serpentCount; ++i) {
            double firstAngleOffset = (double)(serpentCount - 1) / 2.0 * spreadDistance;
            double math = 0.0 - firstAngleOffset + (double)i * spreadDistance;
            double d0 = caster.m_20185_() + (double)f * math;
            double d1 = caster.m_20186_() + (double)(caster.m_20206_() * 0.7f);
            double d2 = caster.m_20189_() + (double)f1 * math;
            double d3 = target.m_20185_() - d0;
            double d4 = target.m_20227_(0.35) - d1;
            double d5 = target.m_20189_() - d2;
            Vec3 direction = new Vec3(d3, d4, d5).m_82541_();
            ScyllaEffectInvoker.spawnStormSerpent(world, d0, caster.m_20186_(), d2, (float)Mth.m_14136_((double)direction.f_82481_, (double)direction.f_82479_), i * 8, caster, damage, target, i == 0);
        }
    }

    public static void createWaveAttack(Level world, LivingEntity caster, int waveCount, float angleStep, double distance, int duration, float speed) {
        if (world == null || world.m_5776_() || caster == null) {
            return;
        }
        Vec3 lookVec = caster.m_20154_();
        double theta = (double)caster.m_146908_() * (Math.PI / 180);
        double vecX = Math.cos(theta += 1.5707963267948966);
        double vecZ = Math.sin(theta);
        double firstAngleOffset = (double)(waveCount - 1) / 2.0 * (double)angleStep;
        for (int i = 0; i < waveCount; ++i) {
            double spawnZ;
            double spawnY;
            double angle = (double)caster.m_146908_() - firstAngleOffset + (double)((float)i * angleStep);
            double rad = Math.toRadians(angle);
            double dx = -Math.sin(rad);
            double dz = Math.cos(rad);
            double spawnX = caster.m_20185_() + vecX * distance;
            Wave_Entity wave = ScyllaEffectInvoker.spawnWave(world, caster, spawnX, spawnY = caster.m_20186_(), spawnZ = caster.m_20189_() + vecZ * distance, duration, speed);
            if (wave == null) continue;
            wave.setState(1);
            wave.m_146922_(-((float)(Mth.m_14136_((double)dx, (double)dz) * 57.29577951308232)));
        }
    }

    public static void createSparkExplosion(Level world, LivingEntity caster, double x, double y, double z, int sparkCount, float damage, float areaDamage, float hpDamage, float areaRadius) {
        if (world == null || world.m_5776_() || caster == null) {
            return;
        }
        for (int i = 0; i < sparkCount; ++i) {
            Spark_Entity spark = ScyllaEffectInvoker.spawnSpark(world, caster, x, y, z, damage, areaDamage, hpDamage, areaRadius);
            if (spark == null) continue;
            spark.m_6686_((world.f_46441_.m_188500_() - 0.5) * 0.5, world.f_46441_.m_188500_() * (double)0.4f + (double)0.01f, (world.f_46441_.m_188500_() - 0.5) * 0.5, 1.0f, 1.0f);
        }
    }

    public static void createForwardDualSpears(Level world, LivingEntity caster, int spearCount, float spreadAngle, float distance) {
        ScyllaEffectInvoker.createForwardDualSpears(world, caster, spearCount, spreadAngle, distance, (float)CMConfig.ScyllaSpearDamage);
    }

    public static void createFanSpearBarrage(Level world, LivingEntity caster, int rows, int spearsPerRow, float horizontalSpread, float verticalSpread, float baseDistance) {
        ScyllaEffectInvoker.createFanSpearBarrage(world, caster, rows, spearsPerRow, horizontalSpread, verticalSpread, baseDistance, 2.0f);
    }

    public static void createRotatingSpearRing(Level world, LivingEntity caster, double radius, int spearCount, float rotationSpeed) {
        ScyllaEffectInvoker.createRotatingSpearRing(world, caster, radius, spearCount, rotationSpeed, (float)CMConfig.ScyllaSpearDamage);
    }

    public static void createFocusedSpearBeam(Level world, LivingEntity caster, int spearCount, float convergenceDistance) {
        ScyllaEffectInvoker.createFocusedSpearBeam(world, caster, spearCount, convergenceDistance, 5.0f);
    }

    public static void createForwardDualSpears(LivingEntity caster, int spearCount, float spreadAngle, float distance) {
        ScyllaEffectInvoker.createForwardDualSpears(caster.m_9236_(), caster, spearCount, spreadAngle, distance);
    }

    public static void createFanSpearBarrage(LivingEntity caster, int rows, int spearsPerRow, float horizontalSpread, float verticalSpread, float baseDistance) {
        ScyllaEffectInvoker.createFanSpearBarrage(caster.m_9236_(), caster, rows, spearsPerRow, horizontalSpread, verticalSpread, baseDistance);
    }

    public static void createRotatingSpearRing(LivingEntity caster, double radius, int spearCount, float rotationSpeed) {
        ScyllaEffectInvoker.createRotatingSpearRing(caster.m_9236_(), caster, radius, spearCount, rotationSpeed);
    }

    public static void createFocusedSpearBeam(LivingEntity caster, int spearCount, float convergenceDistance) {
        ScyllaEffectInvoker.createFocusedSpearBeam(caster.m_9236_(), caster, spearCount, convergenceDistance);
    }

    public static void createForwardLightningStorm(Level world, LivingEntity caster, double distance) {
        ScyllaEffectInvoker.createForwardLightningStorm(world, caster, distance, (float)CMConfig.ScyllaLightningStormDamage, (float)CMConfig.ScyllaLightningStormHpDamage, 2.0f);
    }

    public static void createFanLightningStorms(Level world, LivingEntity caster, double distance, int count, float spreadAngle) {
        ScyllaEffectInvoker.createFanLightningStorms(world, caster, distance, count, spreadAngle, 3.0f, 0.02f, 2.5f);
    }

    public static void createForwardLightningStormLine(Level world, LivingEntity caster, double baseDistance, double maxDistance, int count, double stepDistance) {
        ScyllaEffectInvoker.createForwardLightningStormLine(world, caster, baseDistance, maxDistance, count, stepDistance, 3.0f, 0.02f, 2.3f);
    }

    public static void createCircleLightningStorms(Level world, LivingEntity caster, double radius, int count) {
        ScyllaEffectInvoker.createCircleLightningStorms(world, caster, radius, count, (float)CMConfig.ScyllaLightningStormDamage, (float)CMConfig.ScyllaLightningStormHpDamage, 2.0f);
    }

    public static void createDualSpearAttack(Level world, LivingEntity caster, LivingEntity target, int spearCount, float spreadAngle) {
        ScyllaEffectInvoker.createDualSpearAttack(world, caster, target, spearCount, spreadAngle, (float)CMConfig.ScyllaSpearDamage);
    }

    public static void createStormSerpentSwarm(Level world, LivingEntity caster, LivingEntity target, int serpentCount, double spreadDistance) {
        ScyllaEffectInvoker.createStormSerpentSwarm(world, caster, target, serpentCount, spreadDistance, (float)CMConfig.ScyllaSnakeDamage);
    }

    public static void createWaveAttack(Level world, LivingEntity caster, int waveCount, float angleStep, double distance) {
        ScyllaEffectInvoker.createWaveAttack(world, caster, waveCount, angleStep, distance, 80, 9.0f);
    }

    public static void createSparkExplosion(Level world, LivingEntity caster, double x, double y, double z, int sparkCount) {
        ScyllaEffectInvoker.createSparkExplosion(world, caster, x, y, z, sparkCount, (float)CMConfig.ScyllaLightningStormDamage, (float)CMConfig.ScyllaLightningAreaDamage, (float)CMConfig.ScyllaLightningStormHpDamage, 2.0f);
    }

    public static void createForwardLightningWall(LivingEntity caster, double distance, int lightningCount) {
        Vec3 lookVec = caster.m_20154_();
        double startX = caster.m_20185_() + lookVec.f_82479_ * 2.0;
        double startZ = caster.m_20189_() + lookVec.f_82481_ * 2.0;
        double endX = caster.m_20185_() + lookVec.f_82479_ * distance;
        double endZ = caster.m_20189_() + lookVec.f_82481_ * distance;
        ScyllaEffectInvoker.createLightningWall(caster.m_9236_(), caster, startX, startZ, endX, endZ, lightningCount, (float)CMConfig.ScyllaLightningStormDamage, (float)CMConfig.ScyllaLightningStormHpDamage);
    }

    public static void createCircularLightningWall(LivingEntity caster, double radius, int lightningCount) {
        ScyllaEffectInvoker.createCircleLightningWall(caster.m_9236_(), caster, radius, lightningCount, (float)CMConfig.ScyllaLightningStormDamage, (float)CMConfig.ScyllaLightningStormHpDamage);
    }

    public static void createArcingLightningWall(LivingEntity caster, double distance, float arcAngle, int lightningCount) {
        ScyllaEffectInvoker.createArcLightningWall(caster.m_9236_(), caster, distance, arcAngle, lightningCount, (float)CMConfig.ScyllaLightningStormDamage, (float)CMConfig.ScyllaLightningStormHpDamage);
    }

    public static void createForwardLightningStorm(LivingEntity caster, double distance) {
        ScyllaEffectInvoker.createForwardLightningStorm(caster.m_9236_(), caster, distance);
    }

    public static void createFanLightningStorms(LivingEntity caster, double distance, int count, float spreadAngle) {
        ScyllaEffectInvoker.createFanLightningStorms(caster.m_9236_(), caster, distance, count, spreadAngle);
    }

    public static void createForwardLightningStormLine(LivingEntity caster, double baseDistance, double maxDistance, int count, double stepDistance) {
        ScyllaEffectInvoker.createForwardLightningStormLine(caster.m_9236_(), caster, baseDistance, maxDistance, count, stepDistance);
    }

    public static void createCircleLightningStorms(LivingEntity caster, double radius, int count) {
        ScyllaEffectInvoker.createCircleLightningStorms(caster.m_9236_(), caster, radius, count);
    }

    public static void createDualSpearAttack(LivingEntity caster, LivingEntity target, int spearCount, float spreadAngle) {
        ScyllaEffectInvoker.createDualSpearAttack(caster.m_9236_(), caster, target, spearCount, spreadAngle);
    }

    public static void createStormSerpentSwarm(LivingEntity caster, LivingEntity target, int serpentCount, double spreadDistance) {
        ScyllaEffectInvoker.createStormSerpentSwarm(caster.m_9236_(), caster, target, serpentCount, spreadDistance);
    }

    public static void createWaveAttack(LivingEntity caster, int waveCount, float angleStep, double distance) {
        ScyllaEffectInvoker.createWaveAttack(caster.m_9236_(), caster, waveCount, angleStep, distance);
    }

    public static void createSparkExplosion(LivingEntity caster, double x, double y, double z, int sparkCount) {
        ScyllaEffectInvoker.createSparkExplosion(caster.m_9236_(), caster, x, y, z, sparkCount);
    }

    public static void createChainLightningEffect(Level world, LivingEntity caster, double centerX, double centerZ, int branchCount, int particlesPerBranch, double initialRadius, double radiusIncrement, double curveFactor, int delay) {
        if (world == null || world.m_5776_() || caster == null) {
            return;
        }
        float angleIncrement = (float)(Math.PI * 2 / (double)branchCount);
        for (int branch = 0; branch < branchCount; ++branch) {
            float baseAngle = angleIncrement * (float)branch;
            for (int i = 0; i < particlesPerBranch; ++i) {
                double currentRadius = initialRadius + (double)i * radiusIncrement;
                float currentAngle = (float)((double)baseAngle + (double)((float)i * angleIncrement) / initialRadius + (double)((float)((double)i * curveFactor)));
                double xOffset = currentRadius * Math.cos(currentAngle);
                double zOffset = currentRadius * Math.sin(currentAngle);
                double spawnX = centerX + xOffset;
                double spawnZ = centerZ + zOffset;
                int actualDelay = delay * (i + 1);
                ScyllaEffectInvoker.spawnLightningStorm(world, spawnX, spawnZ, caster.m_20186_() - 5.0, caster.m_20186_() + 3.0, currentAngle, actualDelay, (float)CMConfig.ScyllaLightningStormDamage, (float)CMConfig.ScyllaLightningStormHpDamage, caster, 1.0f);
            }
        }
    }

    public static void createRotatingLightningRing(Level world, LivingEntity caster, double radius, int lightningCount, float rotationSpeed, int duration) {
        if (world == null || world.m_5776_() || caster == null) {
            return;
        }
        Vec3 center = caster.m_20182_();
        for (int i = 0; i < lightningCount; ++i) {
            float angle = (float)i * (float)Math.PI * 2.0f / (float)lightningCount;
            Vec3 offset = new Vec3((double)Mth.m_14089_((float)angle) * radius, 0.0, (double)Mth.m_14031_((float)angle) * radius);
            Vec3 spawnPos = center.m_82549_(offset);
            int delay = (int)((float)i * rotationSpeed);
            ScyllaEffectInvoker.spawnLightningStorm(world, spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, caster.m_20186_() + 3.0, angle, delay, (float)CMConfig.ScyllaLightningStormDamage, (float)CMConfig.ScyllaLightningStormHpDamage, caster, 1.5f);
        }
    }

    public static void createHomingLightningSpears(Level world, LivingEntity caster, LivingEntity target, int spearCount, float spreadAngle) {
        if (world == null || world.m_5776_() || caster == null || target == null) {
            return;
        }
        Vec3 casterPos = caster.m_20182_();
        Vec3 targetPos = target.m_20182_();
        Vec3 direction = targetPos.m_82546_(casterPos).m_82541_();
        for (int i = 0; i < spearCount; ++i) {
            double spawnZ;
            double spawnY;
            double spawnX;
            float angle = -spreadAngle / 2.0f + spreadAngle * (float)i / (float)(spearCount - 1);
            double angleRad = (double)angle * (Math.PI / 180);
            Vec3 spearDirection = direction.m_82524_((float)angleRad).m_82541_();
            Lightning_Spear_Entity spear = ScyllaEffectInvoker.spawnLightningSpear(world, caster, spearDirection, spawnX = casterPos.f_82479_ + spearDirection.f_82479_ * 2.0, spawnY = casterPos.f_82480_ + (double)caster.m_20206_() * 0.7, spawnZ = casterPos.f_82481_ + spearDirection.f_82481_ * 2.0, (float)CMConfig.ScyllaSpearDamage, (float)CMConfig.ScyllaLightningAreaDamage, (float)CMConfig.ScyllaLightningStormHpDamage, 2.0f);
            if (spear == null) continue;
            spear.accelerationPower = 0.15;
        }
    }

    public static void createCombinedElementalAttack(Level world, LivingEntity caster, LivingEntity target) {
        if (world == null || world.m_5776_() || caster == null) {
            return;
        }
        Vec3 casterPos = caster.m_20182_();
        ScyllaEffectInvoker.createForwardLightningStorm(world, caster, 3.0);
        ScyllaEffectInvoker.createWaveAttack(world, caster, 8, 45.0f, 2.5);
        if (target != null) {
            ScyllaEffectInvoker.createSparkExplosion(world, caster, target.m_20185_(), target.m_20186_(), target.m_20189_(), 8);
        }
        ScreenShake_Entity.ScreenShake((Level)world, (Vec3)casterPos, (float)30.0f, (float)0.2f, (int)0, (int)20);
    }

    public static void createPhaseTransitionEffect(Level world, LivingEntity caster, int phaseLevel) {
        if (world == null || world.m_5776_() || caster == null) {
            return;
        }
        Vec3 center = caster.m_20182_();
        switch (phaseLevel) {
            case 1: {
                ScyllaEffectInvoker.createCircleLightningStorms(world, caster, 4.0, 6);
                ScyllaEffectInvoker.createWaveAttack(world, caster, 4, 90.0f, 3.0);
                break;
            }
            case 2: {
                ScyllaEffectInvoker.createRotatingLightningRing(world, caster, 5.0, 12, 10.0f, 100);
                ScyllaEffectInvoker.createSparkExplosion(world, caster, center.f_82479_, center.f_82480_, center.f_82481_, 12);
                break;
            }
            default: {
                ScyllaEffectInvoker.createForwardLightningStorm(world, caster, 2.0);
            }
        }
        ScreenShake_Entity.ScreenShake((Level)world, (Vec3)center, (float)25.0f, (float)0.15f, (int)10, (int)15);
    }

    public static Vec3 calculateAimDirection(LivingEntity caster, LivingEntity target, double heightRatio) {
        if ((caster == null || target == null) && caster != null) {
            return caster.m_20154_();
        }
        double targetX = target.m_20185_();
        double targetY = target.m_20186_() + (double)target.m_20206_() * heightRatio;
        double targetZ = target.m_20189_();
        double casterX = 0.0;
        if (caster != null) {
            casterX = caster.m_20185_();
        }
        double casterY = 0.0;
        if (caster != null) {
            casterY = caster.m_20186_() + (double)caster.m_20206_() * 0.7;
        }
        double casterZ = 0.0;
        if (caster != null) {
            casterZ = caster.m_20189_();
        }
        return new Vec3(targetX - casterX, targetY - casterY, targetZ - casterZ).m_82541_();
    }

    public static Vec3 getRandomCirclePosition(Vec3 center, double radius) {
        double angle = Math.random() * 2.0 * Math.PI;
        double x = center.f_82479_ + Math.cos(angle) * radius * Math.random();
        double z = center.f_82481_ + Math.sin(angle) * radius * Math.random();
        return new Vec3(x, center.f_82480_, z);
    }

    public static boolean isValidSpawnPosition(Level world, double x, double y, double z) {
        BlockPos pos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        return world.m_46859_(pos) && world.m_46859_(pos.m_7494_());
    }

    private static void createSixDirectionLightningStorms(ServerLevel level, LivingEntity caster, BlockPos targetPos, float damage) {
        Vec3 center = Vec3.m_82539_((Vec3i)targetPos);
        double distance = 5.0;
        for (int i = 0; i < 6; ++i) {
            float angle = (float)i * 60.0f;
            double angleRad = Math.toRadians(angle);
            double stormX = center.f_82479_ + Math.cos(angleRad) * distance;
            double stormZ = center.f_82481_ + Math.sin(angleRad) * distance;
            ScyllaEffectInvoker.spawnLightningStorm((Level)level, stormX, center.f_82480_, stormZ, center.f_82480_ + 5.0, angle, 0, damage * 0.7f, (float)CMConfig.ScyllaLightningStormHpDamage * 0.8f, caster, 2.3f);
            ScyllaEffectInvoker.createSparkExplosion((Level)level, caster, stormX, center.f_82480_ + 1.0, stormZ, 3, damage * 0.3f, (float)CMConfig.ScyllaLightningAreaDamage * 0.6f, (float)CMConfig.ScyllaLightningStormHpDamage * 0.4f, 1.5f);
        }
        ScyllaEffectInvoker.spawnLightningStorm((Level)level, center.f_82479_, center.f_82480_, center.f_82481_, center.f_82480_ + 6.0, caster.m_146908_() * ((float)Math.PI / 180), 0, damage, (float)CMConfig.ScyllaLightningStormHpDamage, caster, 2.2f);
    }

    private static void createMultipleLightningBolts(ServerLevel level, LivingEntity caster, Entity target, BlockPos targetPos, LivingEntityPatch<?> entityPatch, AttackAnimation attackAnimation, AttackAnimation.Phase phase, float damage) {
        Vec3 center = Vec3.m_82539_((Vec3i)targetPos);
        int lightningCount = 3;
        for (int i = 0; i < lightningCount; ++i) {
            ServerPlayer serverPlayer;
            LightningBolt lightningbolt = (LightningBolt)EntityType.f_20465_.m_20615_((Level)level);
            lightningbolt.m_20874_(true);
            double offsetX = (level.f_46441_.m_188500_() - 0.5) * 3.0;
            double offsetZ = (level.f_46441_.m_188500_() - 0.5) * 3.0;
            double offsetY = level.f_46441_.m_188500_() * 2.0;
            Vec3 lightningPos = center.m_82520_(offsetX, offsetY, offsetZ);
            lightningbolt.m_20219_(lightningPos);
            lightningbolt.setDamage(0.0f);
            if (entityPatch instanceof ServerPlayerPatch) {
                ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)entityPatch;
                serverPlayer = (ServerPlayer)serverPlayerPatch.getOriginal();
            } else {
                serverPlayer = null;
            }
            lightningbolt.m_20879_(serverPlayer);
            level.m_7967_((Entity)lightningbolt);
            level.m_8767_((ParticleOptions)((SimpleParticleType)ModParticle.LIGHTNING_EXPLODE.get()), lightningPos.f_82479_, lightningPos.f_82480_, lightningPos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            ScyllaEffectInvoker.createSplashDamageAtPosition(level, caster, lightningPos, damage * 0.4f, entityPatch, attackAnimation, phase);
        }
    }

    private static void createSplashDamageAtPosition(ServerLevel level, LivingEntity caster, Vec3 position, float splashDamage, LivingEntityPatch<?> entityPatch, AttackAnimation attackAnimation, AttackAnimation.Phase phase) {
        List splashTargets = level.m_6249_((Entity)caster, new AABB(position, position).m_82400_(2.0), e -> !e.m_7307_((Entity)caster) && e instanceof LivingEntity);
        for (Entity splashTarget : splashTargets) {
            DamageSource dmgSource;
            EpicFightDamageSource damageSource;
            if (!splashTarget.m_6469_((DamageSource)(damageSource = attackAnimation.getEpicFightDamageSource(dmgSource = new DamageSource((Holder)splashTarget.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268450_), (Entity)caster), entityPatch, splashTarget, phase).setUsedItem(caster.m_21120_(InteractionHand.MAIN_HAND))), splashDamage)) continue;
            Vec3 knockback = splashTarget.m_20182_().m_82546_(position).m_82541_().m_82490_(0.5);
            splashTarget.m_20256_(splashTarget.m_20184_().m_82520_(knockback.f_82479_, 0.2, knockback.f_82481_));
        }
    }

    private static void createRandomSpearBarrage(ServerLevel level, LivingEntity caster, Entity target, int spearCount, float damage) {
        Vec3 casterPos = caster.m_20182_();
        Vec3 targetPos = target.m_20182_();
        for (int i = 0; i < spearCount; ++i) {
            double angle = Math.random() * 2.0 * Math.PI;
            double radius = 2.0 + Math.random() * 2.0;
            double spawnX = casterPos.f_82479_ + Math.cos(angle) * radius;
            double spawnY = casterPos.f_82480_ + (double)caster.m_20206_() * 0.7 + (Math.random() - 0.5) * 1.5;
            double spawnZ = casterPos.f_82481_ + Math.sin(angle) * radius;
            Vec3 direction = targetPos.m_82492_(spawnX, spawnY, spawnZ).m_82541_();
            float yRot = (float)(Mth.m_14136_((double)direction.f_82481_, (double)direction.f_82479_) * 57.29577951308232) + 90.0f;
            float xRot = (float)(-(Mth.m_14136_((double)direction.f_82480_, (double)Math.sqrt(direction.f_82479_ * direction.f_82479_ + direction.f_82481_ * direction.f_82481_)) * 57.29577951308232));
            if (i % 2 == 0) {
                Water_Spear_Entity waterSpear = ScyllaEffectInvoker.spawnWaterSpear((Level)level, caster, direction, spawnX, spawnY, spawnZ, damage);
                if (waterSpear == null) continue;
                waterSpear.m_146922_(yRot);
                waterSpear.m_146926_(xRot);
                waterSpear.accelerationPower = 0.15;
                continue;
            }
            Lightning_Spear_Entity lightningSpear = ScyllaEffectInvoker.spawnLightningSpear((Level)level, caster, direction, spawnX, spawnY, spawnZ, damage, (float)CMConfig.ScyllaLightningAreaDamage * 0.8f, (float)CMConfig.ScyllaLightningStormHpDamage * 0.6f, 1.5f);
            if (lightningSpear == null) continue;
            lightningSpear.m_146922_(yRot);
            lightningSpear.m_146926_(xRot);
            lightningSpear.accelerationPower = 0.15;
        }
    }

    public static void createDirectionalLightningStormLine(ServerLevel level, LivingEntity caster, double startX, double startZ, double dirX, double dirZ, double distance, int count, double stepDistance) {
        double currentDistance;
        double length = Math.sqrt(dirX * dirX + dirZ * dirZ);
        double normX = dirX / length;
        double normZ = dirZ / length;
        float rotation = (float)Math.atan2(normZ, normX);
        for (int i = 0; i < count && !((currentDistance = stepDistance * (double)i) > distance); ++i) {
            double spawnX = startX + normX * currentDistance;
            double spawnZ = startZ + normZ * currentDistance;
            ScyllaEffectInvoker.spawnLightningStorm((Level)level, spawnX, caster.m_20186_(), spawnZ, caster.m_20186_() + 3.0, rotation, i * 2, 4.0f, 0.02f, caster, 2.0f);
        }
    }
}

