/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.p1nero_ec.utils;

import com.github.L_Ender.cataclysm.config.CMConfig;
import com.github.L_Ender.cataclysm.entity.projectile.Axe_Blade_Entity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class AxeBladeInvoker {
    private static float calculateRotationFromMovement(double xPower, double zPower) {
        return (float)Math.toDegrees(Math.atan2(zPower, xPower));
    }

    private static double findGroundY(Level world, double x, double z, double searchMinY, double searchMaxY) {
        BlockPos blockpos = BlockPos.m_274561_((double)x, (double)searchMaxY, (double)z);
        boolean foundGround = false;
        double groundY = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos belowPos;
            BlockState blockstate;
            if (!(blockstate = world.m_8055_(belowPos = blockpos.m_7495_())).m_60783_((BlockGetter)world, belowPos, Direction.UP)) continue;
            if (!world.m_46859_(blockpos) && !(voxelshape = (blockstate1 = world.m_8055_(blockpos)).m_60812_((BlockGetter)world, blockpos)).m_83281_()) {
                groundY = voxelshape.m_83297_(Direction.Axis.Y);
            }
            foundGround = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)searchMinY) - 1);
        return foundGround ? (double)blockpos.m_123342_() + groundY : searchMaxY;
    }

    private static void spawnAxeBladeOnGround(Level world, LivingEntity caster, double x, double z, double searchMinY, double searchMaxY, double xPower, double zPower, float damage, float rotation) {
        double groundY = AxeBladeInvoker.findGroundY(world, x, z, searchMinY, searchMaxY);
        Axe_Blade_Entity axeBlade = new Axe_Blade_Entity(caster, xPower, 0.0, zPower, world, damage, rotation - 90.0f);
        axeBlade.m_6034_(x, groundY, z);
        world.m_7967_((Entity)axeBlade);
    }

    public static void createForwardAxeBlade(Level world, LivingEntity caster, double distance, float damage) {
        if (world == null || world.m_5776_() || caster == null) {
            return;
        }
        Vec3 lookVec = caster.m_20154_();
        Vec3 spawnPos = caster.m_20182_().m_82520_(lookVec.f_82479_ * distance, 0.0, lookVec.f_82481_ * distance);
        float rotation = AxeBladeInvoker.calculateRotationFromMovement(lookVec.f_82479_, lookVec.f_82481_);
        AxeBladeInvoker.spawnAxeBladeOnGround(world, caster, spawnPos.f_82479_, spawnPos.f_82481_, caster.m_20186_() - 2.0, caster.m_20186_() + 2.0, lookVec.f_82479_, lookVec.f_82481_, damage, rotation);
    }

    public static void createClawAxeBlades(Level world, LivingEntity caster, double distance, float damage) {
        if (world == null || world.m_5776_() || caster == null) {
            return;
        }
        Vec3 lookVec = caster.m_20154_();
        int clawCount = 3;
        double spreadAngle = 45.0;
        for (int claw = 0; claw < clawCount; ++claw) {
            double angle = -spreadAngle / 2.0 + spreadAngle * (double)claw / (double)(clawCount - 1);
            double angleRad = angle * (Math.PI / 180);
            Vec3 clawDirection = lookVec.m_82524_((float)angleRad).m_82541_();
            Vec3 spawnPos = caster.m_20182_().m_82520_(clawDirection.f_82479_ * distance, 0.0, clawDirection.f_82481_ * distance);
            float rotation = AxeBladeInvoker.calculateRotationFromMovement(clawDirection.f_82479_, clawDirection.f_82481_);
            AxeBladeInvoker.spawnAxeBladeOnGround(world, caster, spawnPos.f_82479_, spawnPos.f_82481_, caster.m_20186_() - 2.0, caster.m_20186_() + 2.0, clawDirection.f_82479_, clawDirection.f_82481_, damage, rotation);
        }
    }

    public static void createRadialAxeBlades(Level world, LivingEntity caster, double startDistance, float damage) {
        if (world == null || world.m_5776_() || caster == null) {
            return;
        }
        int directions = 8;
        Vec3 center = caster.m_20182_();
        for (int i = 0; i < directions; ++i) {
            float angle = (float)i * (float)Math.PI * 2.0f / (float)directions;
            Vec3 direction = new Vec3((double)Mth.m_14089_((float)angle), 0.0, (double)Mth.m_14031_((float)angle)).m_82541_();
            Vec3 spawnPos = center.m_82520_(direction.f_82479_ * startDistance, 0.0, direction.f_82481_ * startDistance);
            float rotation = AxeBladeInvoker.calculateRotationFromMovement(direction.f_82479_, direction.f_82481_);
            AxeBladeInvoker.spawnAxeBladeOnGround(world, caster, spawnPos.f_82479_, spawnPos.f_82481_, caster.m_20186_() - 2.0, caster.m_20186_() + 2.0, direction.f_82479_, direction.f_82481_, damage, rotation);
        }
    }

    public static void createFiveClawAxeBlades(Level world, LivingEntity caster, double baseDistance, float damage) {
        if (world == null || world.m_5776_() || caster == null) {
            return;
        }
        Vec3 lookVec = caster.m_20154_();
        int clawCount = 5;
        double spreadAngle = 100.0;
        for (int claw = 0; claw < clawCount; ++claw) {
            double angle = -spreadAngle / 2.0 + spreadAngle * (double)claw / (double)(clawCount - 1);
            double angleRad = angle * (Math.PI / 180);
            Vec3 clawDirection = lookVec.m_82524_((float)angleRad).m_82541_();
            int bladesPerClaw = 3;
            for (int i = 0; i < bladesPerClaw; ++i) {
                double progress = (double)(i + 1) / (double)(bladesPerClaw + 1);
                double distance = baseDistance + progress * 3.0;
                Vec3 spawnPos = caster.m_20182_().m_82520_(clawDirection.f_82479_ * distance, 0.0, clawDirection.f_82481_ * distance);
                float rotation = AxeBladeInvoker.calculateRotationFromMovement(clawDirection.f_82479_, clawDirection.f_82481_);
                AxeBladeInvoker.spawnAxeBladeOnGround(world, caster, spawnPos.f_82479_, spawnPos.f_82481_, caster.m_20186_() - 2.0, caster.m_20186_() + 2.0, clawDirection.f_82479_, clawDirection.f_82481_, damage * (1.0f - (float)progress * 0.2f), rotation);
            }
        }
    }

    public static void createForwardAxeBladeOnSlope(Level world, LivingEntity caster, double distance, float damage) {
        if (world == null || world.m_5776_() || caster == null) {
            return;
        }
        Vec3 lookVec = caster.m_20154_();
        for (double d = 1.0; d <= distance; d += 1.0) {
            Vec3 checkPos = caster.m_20182_().m_82520_(lookVec.f_82479_ * d, 0.0, lookVec.f_82481_ * d);
            double groundY = AxeBladeInvoker.findGroundY(world, checkPos.f_82479_, checkPos.f_82481_, caster.m_20186_() - 3.0, caster.m_20186_() + 2.0);
            if (!(groundY > caster.m_20186_() - 2.5) || !(d >= 1.0)) continue;
            float rotation = AxeBladeInvoker.calculateRotationFromMovement(lookVec.f_82479_, lookVec.f_82481_);
            Axe_Blade_Entity axeBlade = new Axe_Blade_Entity(caster, lookVec.f_82479_, 0.0, lookVec.f_82481_, world, damage, rotation - 90.0f);
            axeBlade.m_6034_(checkPos.f_82479_, groundY, checkPos.f_82481_);
            world.m_7967_((Entity)axeBlade);
            break;
        }
    }

    public static void createForwardAxeBlade(Level world, LivingEntity caster, double distance) {
        AxeBladeInvoker.createForwardAxeBlade(world, caster, distance, (float)CMConfig.AptrgangrAxeBladeDamage);
    }

    public static void createClawAxeBlades(Level world, LivingEntity caster, double distance) {
        AxeBladeInvoker.createClawAxeBlades(world, caster, distance, (float)CMConfig.AptrgangrAxeBladeDamage);
    }

    public static void createRadialAxeBlades(Level world, LivingEntity caster, double startDistance) {
        AxeBladeInvoker.createRadialAxeBlades(world, caster, startDistance, (float)CMConfig.AptrgangrAxeBladeDamage);
    }

    public static void createFiveClawAxeBlades(Level world, LivingEntity caster, double baseDistance) {
        AxeBladeInvoker.createFiveClawAxeBlades(world, caster, baseDistance, (float)CMConfig.AptrgangrAxeBladeDamage);
    }

    public static void createForwardAxeBlade(LivingEntity caster) {
        AxeBladeInvoker.createForwardAxeBlade(caster.m_9236_(), caster, 1.5);
    }

    public static void createClawAxeBlades(LivingEntity caster) {
        AxeBladeInvoker.createClawAxeBlades(caster.m_9236_(), caster, 1.5);
    }

    public static void createRadialAxeBlades(LivingEntity caster) {
        AxeBladeInvoker.createRadialAxeBlades(caster.m_9236_(), caster, 1.5);
    }

    public static void createFiveClawAxeBlades(LivingEntity caster) {
        AxeBladeInvoker.createFiveClawAxeBlades(caster.m_9236_(), caster, 1.5);
    }
}

