/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.p1nero_ec.skills;

import com.google.common.collect.Lists;
import com.p1nero.p1nero_ec.capability.PECPlayer;
import com.p1nero.p1nero_ec.client.KeyMappings;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;

public abstract class PECWeaponInnateSkillBase
extends Skill {
    public PECWeaponInnateSkillBase(SkillBuilder<? extends Skill> builder) {
        super(builder);
    }

    public static SkillBuilder<Skill> createBuilder() {
        return new SkillBuilder().setCategory((SkillCategory)SkillCategories.WEAPON_INNATE).setResource(Skill.Resource.NONE);
    }

    public void executeOnServer(SkillContainer container, FriendlyByteBuf args) {
        int skillId = args.readInt();
        ServerPlayerPatch serverPlayerPatch = container.getServerExecutor();
        if (!PECPlayer.isValidWeapon(((ServerPlayer)serverPlayerPatch.getOriginal()).m_21205_())) {
            return;
        }
        switch (skillId) {
            case 1: {
                this.tryExecuteSkill1(serverPlayerPatch, container);
                break;
            }
            case 2: {
                this.tryExecuteSkill2(serverPlayerPatch, container);
                break;
            }
            case 3: {
                this.tryExecuteSkill3(serverPlayerPatch, container);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasSkillKeyIn(KeyMapping keyMapping) {
        return this.getAvailableKeys().contains(keyMapping);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected List<KeyMapping> getAvailableKeys() {
        return List.of(KeyMappings.SKILL_1, KeyMappings.SKILL_2, KeyMappings.SKILL_3);
    }

    public int getSkillRequired(int slot) {
        return slot;
    }

    public boolean canExecute(PlayerPatch<?> playerPatch, int slot) {
        return PECPlayer.hasSkillPoint((Player)playerPatch.getOriginal(), slot) && this.isExecutableState(playerPatch);
    }

    protected void tryExecuteSkill(ServerPlayerPatch serverPlayerPatch, SkillContainer container, int slot) {
        int skillRequired = this.getSkillRequired(slot);
        if (PECPlayer.consumeSkillPoint((ServerPlayer)serverPlayerPatch.getOriginal(), skillRequired)) {
            this.executeSkill1(serverPlayerPatch, container);
        } else {
            this.onSkillPointNotEnough(container, slot, skillRequired);
        }
    }

    protected void tryExecuteSkill1(ServerPlayerPatch serverPlayerPatch, SkillContainer container) {
        if (PECPlayer.consumeSkillPoint((ServerPlayer)serverPlayerPatch.getOriginal(), 1)) {
            this.executeSkill1(serverPlayerPatch, container);
        } else {
            this.onSkillPointNotEnough(container, 1);
        }
    }

    protected void tryExecuteSkill2(ServerPlayerPatch serverPlayerPatch, SkillContainer container) {
        if (PECPlayer.consumeSkillPoint((ServerPlayer)serverPlayerPatch.getOriginal(), 2)) {
            this.executeSkill2(serverPlayerPatch, container);
        } else {
            this.onSkillPointNotEnough(container, 2);
        }
    }

    protected void tryExecuteSkill3(ServerPlayerPatch serverPlayerPatch, SkillContainer container) {
        if (PECPlayer.consumeSkillPoint((ServerPlayer)serverPlayerPatch.getOriginal(), 3)) {
            this.executeSkill3(serverPlayerPatch, container);
        } else {
            this.onSkillPointNotEnough(container, 3);
        }
    }

    public abstract void executeSkill1(ServerPlayerPatch var1, SkillContainer var2);

    public abstract void executeSkill2(ServerPlayerPatch var1, SkillContainer var2);

    public abstract void executeSkill3(ServerPlayerPatch var1, SkillContainer var2);

    public void executeSkill(ServerPlayerPatch serverPlayerPatch, SkillContainer container, int slot) {
    }

    public void onSkillPointNotEnough(SkillContainer container, int need) {
        ((Player)container.getExecutor().getOriginal()).m_5661_((Component)Component.m_237110_((String)"info.p1nero_ec.skill_point_lack", (Object[])new Object[]{need}), true);
    }

    public void onSkillPointNotEnough(SkillContainer container, int slot, int need) {
        ((Player)container.getExecutor().getOriginal()).m_5661_((Component)Component.m_237110_((String)"info.p1nero_ec.skill_point_lack", (Object[])new Object[]{need}), true);
    }

    public List<Component> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerpatch) {
        ArrayList list = Lists.newArrayList();
        list.add(Component.m_237113_((String)""));
        return list;
    }
}

