/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.p1nero_ec.client.gui;

import com.mojang.blaze3d.platform.Window;
import com.p1nero.p1nero_ec.PECConfig;
import com.p1nero.p1nero_ec.capability.PECPlayer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;

@OnlyIn(value=Dist.CLIENT)
public class CustomGuiRenderer {
    private static final ResourceLocation BG_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"p1nero_ec", (String)"textures/gui/skill_point/bg.png");
    private static final ResourceLocation IN_OUT_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"p1nero_ec", (String)"textures/gui/skill_point/in_out.png");
    private static final ResourceLocation LOOP_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"p1nero_ec", (String)"textures/gui/skill_point/loop.png");
    private static final List<SkillIcon> SKILL_ICONS = new ArrayList<SkillIcon>();
    private static final int MAX_INTERVAL = 1;
    private static int interval = 1;

    public static void renderSkillPoints(GuiGraphics guiGraphics, Window window, float partialTick) {
        LocalPlayerPatch localPlayerPatch = ClientEngine.getInstance().getPlayerPatch();
        if (localPlayerPatch != null) {
            if (!((Boolean)PECConfig.GLOBAL_CHARGE.get()).booleanValue() && !PECPlayer.isValidWeapon(((LocalPlayer)localPlayerPatch.getOriginal()).m_21205_())) {
                return;
            }
            LocalPlayer localPlayer = (LocalPlayer)localPlayerPatch.getOriginal();
            if (!localPlayer.m_7500_() && !localPlayer.m_5833_()) {
                int x = (int)((float)window.m_85445_() / 2.0f - 32.0f);
                int y = window.m_85446_() - 70;
                if (!SKILL_ICONS.isEmpty()) {
                    for (int i = 0; i < 5; ++i) {
                        SkillIcon skillIcon = SKILL_ICONS.get(i);
                        skillIcon.updateXY(100 + (Integer)PECConfig.UI_X.get() + x + 20 * i, (Integer)PECConfig.UI_Y.get() + y);
                        skillIcon.render(guiGraphics);
                    }
                }
            }
        }
    }

    public static void addPoint(int index) {
        if (SKILL_ICONS.size() <= index) {
            return;
        }
        SKILL_ICONS.get(index).onAdd();
    }

    public static void remove(int index) {
        if (SKILL_ICONS.size() <= index) {
            return;
        }
        SKILL_ICONS.get(index).setDelete();
    }

    public static boolean isSkillPointEmpty(int index) {
        if (SKILL_ICONS.size() <= index) {
            return false;
        }
        return CustomGuiRenderer.SKILL_ICONS.get((int)index).removed;
    }

    public static void update() {
        if (interval > 0 && --interval == 0) {
            interval = 1;
            if (SKILL_ICONS.isEmpty()) {
                for (int i = 0; i < 5; ++i) {
                    SKILL_ICONS.add(new SkillIcon());
                }
            }
            SKILL_ICONS.forEach(SkillIcon::update);
        }
    }

    public static void reset() {
        SKILL_ICONS.forEach(SkillIcon::reset);
    }

    private static class SkillIcon {
        private final int IN = 0;
        private final int LOOP = 1;
        private final int OUT = 2;
        private final int MAX_FRAME_INDEX = 7;
        private int x;
        private int y;
        private int currentType = 0;
        private int currentIndex = 0;
        private ResourceLocation currentTexture = IN_OUT_TEXTURE;
        private boolean removed = true;

        private SkillIcon() {
        }

        private void reset() {
            this.removed = true;
            this.currentType = 0;
            this.currentIndex = 0;
            this.currentTexture = IN_OUT_TEXTURE;
        }

        private void onAdd() {
            this.removed = false;
            this.currentType = 0;
            this.currentIndex = 0;
            this.currentTexture = IN_OUT_TEXTURE;
        }

        private void setDelete() {
            if (this.currentType == 2) {
                return;
            }
            this.currentTexture = IN_OUT_TEXTURE;
            this.currentType = 2;
            this.currentIndex = 7;
        }

        private void setLoop() {
            this.currentTexture = LOOP_TEXTURE;
            this.currentIndex = 0;
            this.currentType = 1;
        }

        private void updateXY(int x, int y) {
            this.x = x;
            this.y = y;
        }

        private void update() {
            if (this.currentType == 0) {
                ++this.currentIndex;
                if (this.currentIndex > 7) {
                    this.setLoop();
                }
            }
            if (this.currentType == 1) {
                ++this.currentIndex;
                if (this.currentIndex > 7) {
                    this.currentIndex = 0;
                }
            }
            if (this.currentType == 2 && this.currentIndex > 0) {
                --this.currentIndex;
                if (this.currentIndex == 0) {
                    this.removed = true;
                }
            }
        }

        private void render(GuiGraphics guiGraphics) {
            guiGraphics.m_280411_(BG_TEXTURE, this.x, this.y, 64, 64, 0.0f, 0.0f, 64, 64, 64, 64);
            if (!this.removed) {
                guiGraphics.m_280411_(this.currentTexture, this.x, this.y, 64, 64, (float)(64 * this.currentIndex), 0.0f, 64, 64, 512, 64);
            }
        }
    }
}

