/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.sw.entity.super_warden;

import com.merlin204.sw.entity.super_warden.ai.SWCombatBehaviors;
import com.merlin204.sw.epicfight.gameassets.animations.SuperWardenAnimation;
import java.util.Set;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.warden.SonicBoom;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.ai.behavior.AnimatedCombatBehavior;
import yesman.epicfight.world.entity.ai.brain.BrainRecomposer;

public class SWPatch
extends MobPatch<Warden> {
    public void onJoinWorld(Warden warden, EntityJoinLevelEvent event) {
        super.onJoinWorld((Mob)warden, event);
    }

    public void onConstructed(Warden entityIn) {
        super.onConstructed((LivingEntity)entityIn);
        if (!((Warden)this.original).m_9236_().f_46443_) {
            this.setMaxStunShield(300.0f);
            this.setStunShield(300.0f);
        }
    }

    public void damageStunShield(float damage, float impact) {
        super.damageStunShield(damage, impact);
        this.setStunShield(this.getStunShield() - damage);
    }

    protected void initAI() {
        super.initAI();
        BrainRecomposer.replaceBehavior((Brain)((Warden)this.original).m_6274_(), (Activity)Activity.f_37988_, (int)15, (BehaviorControl)new AnimatedCombatBehavior((MobPatch)this, SWCombatBehaviors.TYPE1.build((MobPatch)this)), (Class[])new Class[]{OneShot.class});
        BrainRecomposer.removeBehavior((Brain)((Warden)this.original).m_6274_(), (Activity)Activity.f_37988_, (int)14, SonicBoom.class);
    }

    protected void selectGoalToRemove(Set<Goal> toRemove) {
    }

    public void rotateTo(Entity target, float limit, boolean syncPrevRot) {
        if (target != null) {
            Vec3 playerPosition = ((Warden)this.original).m_20182_();
            Vec3 targetPosition = target.m_20182_();
            float yaw = (float)MathUtils.getYRotOfVector((Vec3)targetPosition.m_82546_(playerPosition));
            this.rotateTo(yaw, limit, syncPrevRot);
        }
    }

    public void tick(LivingEvent.LivingTickEvent event) {
        super.tick(event);
        if (((Warden)this.original).f_219312_.m_216984_()) {
            ((Warden)this.original).f_219312_.m_216973_();
        }
        if (((Warden)this.original).f_219346_.m_216984_() && !this.getEntityState().inaction()) {
            this.playAnimationSynchronized((AssetAccessor)SuperWardenAnimation.SW_EMERGE, 0.1f);
            ((Warden)this.original).f_219346_.m_216973_();
        }
        if (((Warden)this.original).f_219347_.m_216984_() && !this.getEntityState().inaction()) {
            this.playAnimationSynchronized((AssetAccessor)SuperWardenAnimation.SW_DIGGING, 0.1f);
            ((Warden)this.original).f_219347_.m_216973_();
        }
        if (((Warden)this.original).f_219316_.m_216984_() && !this.getEntityState().inaction()) {
            if (this.getTarget() == null) {
                this.playAnimationSynchronized((AssetAccessor)SuperWardenAnimation.SW_SNIFF, 0.1f);
            }
            ((Warden)this.original).f_219316_.m_216973_();
        }
    }

    public void poseTick(DynamicAnimation animation, Pose pose, float elapsedTime, float partialTicks) {
        if (pose.hasTransform("head") && this.armature.hasJoint("head") && animation.doesHeadRotFollowEntityHead()) {
            float headRotO = ((Warden)this.getOriginal()).f_20884_ - ((Warden)this.original).f_20886_;
            float headRot = ((Warden)this.getOriginal()).f_20883_ - ((Warden)this.original).f_20885_;
            float partialHeadRot = Mth.m_14177_((float)MathUtils.lerpBetween((float)headRotO, (float)headRot, (float)partialTicks));
            float xRot = -((Warden)this.original).m_146909_();
            partialHeadRot = Mth.m_14036_((float)partialHeadRot, (float)-60.0f, (float)60.0f);
            xRot = Mth.m_14036_((float)xRot, (float)-30.0f, (float)30.0f);
            OpenMatrix4f toOriginalRotation = this.armature.getBoundTransformFor(pose, this.armature.searchJointByName("head")).removeScale().removeTranslation().invert();
            Vec3f xAxis = OpenMatrix4f.transform3v((OpenMatrix4f)toOriginalRotation, (Vec3f)Vec3f.X_AXIS, (Vec3f)null);
            Vec3f yAxis = OpenMatrix4f.transform3v((OpenMatrix4f)toOriginalRotation, (Vec3f)Vec3f.Y_AXIS, (Vec3f)null);
            OpenMatrix4f headRotation = OpenMatrix4f.createRotatorDeg((float)partialHeadRot, (Vec3f)yAxis).rotateDeg(xRot, xAxis);
            pose.orElseEmpty("head").frontResult(JointTransform.fromMatrix((OpenMatrix4f)headRotation), OpenMatrix4f::mul);
        }
    }

    public static void initAttributes(EntityAttributeModificationEvent event) {
        event.add(EntityType.f_217015_, (Attribute)EpicFightAttributes.MAX_STRIKES.get(), 10.0);
        event.add(EntityType.f_217015_, (Attribute)EpicFightAttributes.IMPACT.get(), 200.0);
        event.add(EntityType.f_217015_, (Attribute)EpicFightAttributes.WEIGHT.get(), 800.0);
        event.add(EntityType.f_217015_, (Attribute)EpicFightAttributes.ARMOR_NEGATION.get(), 30.0);
    }

    public void initAnimator(Animator animator) {
        super.initAnimator(animator);
        animator.addLivingAnimation((LivingMotion)LivingMotions.IDLE, SuperWardenAnimation.SW_IDLE);
        animator.addLivingAnimation((LivingMotion)LivingMotions.WALK, SuperWardenAnimation.SW_WALK);
        animator.addLivingAnimation((LivingMotion)LivingMotions.CHASE, SuperWardenAnimation.SW_CHASE);
        animator.addLivingAnimation((LivingMotion)LivingMotions.DEATH, SuperWardenAnimation.SW_DEATH);
        animator.addLivingAnimation((LivingMotion)LivingMotions.FALL, SuperWardenAnimation.SW_FALL);
    }

    public void updateMotion(boolean considerInaction) {
        super.commonAggressiveMobUpdateMotion(considerInaction);
    }

    public SoundEvent getWeaponHitSound(InteractionHand hand) {
        return (SoundEvent)EpicFightSounds.BLUNT_HIT_HARD.get();
    }

    public SoundEvent getSwingSound(InteractionHand hand) {
        return (SoundEvent)EpicFightSounds.WHOOSH_BIG.get();
    }

    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getHitAnimation(StunType stunType) {
        return null;
    }
}

