/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import org.dawnoftime.dawnoftime.registry.DoTBBlocksRegistry;

public class DoTBColorsRegistry {
    private static final Map<BlockColor, List<Supplier<Block>>> BLOCKS_COLOR_REGISTRY = new HashMap<BlockColor, List<Supplier<Block>>>();
    public static final BlockColor WATER_BLOCK_COLOR = DoTBColorsRegistry.register((blockStateIn, blockDisplayReaderIn, blockPosIn, tintIndexIn) -> BiomeColors.m_108811_((BlockAndTintGetter)blockDisplayReaderIn, (BlockPos)blockPosIn), DoTBBlocksRegistry.INSTANCE.STONE_BRICKS_FAUCET, DoTBBlocksRegistry.INSTANCE.STONE_BRICKS_POOL, DoTBBlocksRegistry.INSTANCE.STONE_BRICKS_SMALL_POOL, DoTBBlocksRegistry.INSTANCE.WATER_FLOWING_TRICKLE, DoTBBlocksRegistry.INSTANCE.WATER_SOURCE_TRICKLE, DoTBBlocksRegistry.INSTANCE.STONE_BRICKS_WATER_JET);
    private static final Map<ItemColor, List<Supplier<Item>>> ITEMS_COLOR_REGISTRY = new HashMap<ItemColor, List<Supplier<Item>>>();
    public static final ItemColor WATER_ITEM_COLOR = DoTBColorsRegistry.register((itemStackIn, i) -> {
        ClientLevel clientLevel = Minecraft.m_91087_().f_91073_;
        if (clientLevel == null) {
            return 0;
        }
        Optional registryOptional = clientLevel.m_9598_().m_6632_(Registries.f_256952_);
        if (registryOptional.isEmpty()) {
            return 0;
        }
        Biome oceanBiome = (Biome)((Registry)registryOptional.get()).m_6246_(Biomes.f_48174_);
        if (oceanBiome == null) {
            return 0;
        }
        return oceanBiome.m_47560_();
    }, () -> DoTBBlocksRegistry.INSTANCE.STONE_BRICKS_FAUCET.get().m_5456_(), () -> DoTBBlocksRegistry.INSTANCE.WATER_SOURCE_TRICKLE.get().m_5456_(), () -> DoTBBlocksRegistry.INSTANCE.STONE_BRICKS_WATER_JET.get().m_5456_());
    public static final BlockColor LEAVES_BLOCK_COLOR = DoTBColorsRegistry.register((blockState, blockAndTintGetter, blockPos, tintIndexIn) -> BiomeColors.m_108804_((BlockAndTintGetter)blockAndTintGetter, (BlockPos)blockPos), DoTBBlocksRegistry.INSTANCE.ACACIA_LEAVES_EDGE, DoTBBlocksRegistry.INSTANCE.ACACIA_LEAVES_PLATE, DoTBBlocksRegistry.INSTANCE.BIRCH_LEAVES_EDGE, DoTBBlocksRegistry.INSTANCE.BIRCH_LEAVES_PLATE, DoTBBlocksRegistry.INSTANCE.DARK_OAK_LEAVES_EDGE, DoTBBlocksRegistry.INSTANCE.DARK_OAK_LEAVES_PLATE, DoTBBlocksRegistry.INSTANCE.JUNGLE_LEAVES_EDGE, DoTBBlocksRegistry.INSTANCE.JUNGLE_LEAVES_PLATE, DoTBBlocksRegistry.INSTANCE.MANGROVE_LEAVES_EDGE, DoTBBlocksRegistry.INSTANCE.MANGROVE_LEAVES_PLATE, DoTBBlocksRegistry.INSTANCE.OAK_LEAVES_EDGE, DoTBBlocksRegistry.INSTANCE.OAK_LEAVES_PLATE, DoTBBlocksRegistry.INSTANCE.SPRUCE_LEAVES_EDGE, DoTBBlocksRegistry.INSTANCE.SPRUCE_LEAVES_PLATE);
    public static final ItemColor LEAVES_ITEM_COLOR = DoTBColorsRegistry.register((itemStack, i) -> {
        ClientLevel clientLevel = Minecraft.m_91087_().f_91073_;
        if (clientLevel == null) {
            return 0;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return 0;
        }
        return BiomeColors.m_108804_((BlockAndTintGetter)clientLevel, (BlockPos)player.m_20183_());
    }, () -> DoTBBlocksRegistry.INSTANCE.ACACIA_LEAVES_EDGE.get().m_5456_(), () -> DoTBBlocksRegistry.INSTANCE.ACACIA_LEAVES_PLATE.get().m_5456_(), () -> DoTBBlocksRegistry.INSTANCE.BIRCH_LEAVES_EDGE.get().m_5456_(), () -> DoTBBlocksRegistry.INSTANCE.BIRCH_LEAVES_PLATE.get().m_5456_(), () -> DoTBBlocksRegistry.INSTANCE.DARK_OAK_LEAVES_EDGE.get().m_5456_(), () -> DoTBBlocksRegistry.INSTANCE.DARK_OAK_LEAVES_PLATE.get().m_5456_(), () -> DoTBBlocksRegistry.INSTANCE.JUNGLE_LEAVES_EDGE.get().m_5456_(), () -> DoTBBlocksRegistry.INSTANCE.JUNGLE_LEAVES_PLATE.get().m_5456_(), () -> DoTBBlocksRegistry.INSTANCE.MANGROVE_LEAVES_EDGE.get().m_5456_(), () -> DoTBBlocksRegistry.INSTANCE.MANGROVE_LEAVES_PLATE.get().m_5456_(), () -> DoTBBlocksRegistry.INSTANCE.OAK_LEAVES_EDGE.get().m_5456_(), () -> DoTBBlocksRegistry.INSTANCE.OAK_LEAVES_PLATE.get().m_5456_(), () -> DoTBBlocksRegistry.INSTANCE.SPRUCE_LEAVES_EDGE.get().m_5456_(), () -> DoTBBlocksRegistry.INSTANCE.SPRUCE_LEAVES_PLATE.get().m_5456_());

    public static Map<BlockColor, List<Supplier<Block>>> getBlocksColorRegistry() {
        return BLOCKS_COLOR_REGISTRY;
    }

    public static Map<ItemColor, List<Supplier<Item>>> getItemsColorRegistry() {
        return ITEMS_COLOR_REGISTRY;
    }

    @SafeVarargs
    private static ItemColor register(ItemColor itemColorIn, Supplier<Item> ... itemsIn) {
        List<Supplier<Item>> items = DoTBColorsRegistry.getItems(itemColorIn);
        if (items == null) {
            items = new ArrayList<Supplier<Item>>();
            ITEMS_COLOR_REGISTRY.put(itemColorIn, items);
        }
        Collections.addAll(items, itemsIn);
        return itemColorIn;
    }

    private static List<Supplier<Item>> getItems(ItemColor blockColorIn) {
        for (Map.Entry<ItemColor, List<Supplier<Item>>> entry : ITEMS_COLOR_REGISTRY.entrySet()) {
            if (entry.getKey().getClass() != blockColorIn.getClass()) continue;
            return entry.getValue();
        }
        return null;
    }

    @SafeVarargs
    private static BlockColor register(BlockColor blockColorIn, Supplier<Block> ... blocksIn) {
        List<Supplier<Block>> blocks = DoTBColorsRegistry.getBlocks(blockColorIn);
        if (blocks == null) {
            blocks = new ArrayList<Supplier<Block>>();
            BLOCKS_COLOR_REGISTRY.put(blockColorIn, blocks);
        }
        Collections.addAll(blocks, blocksIn);
        return blockColorIn;
    }

    private static List<Supplier<Block>> getBlocks(BlockColor blockColorIn) {
        for (Map.Entry<BlockColor, List<Supplier<Block>>> entry : BLOCKS_COLOR_REGISTRY.entrySet()) {
            if (entry.getKey().getClass() != blockColorIn.getClass()) continue;
            return entry.getValue();
        }
        return null;
    }

    public static void initialize() {
    }
}

