/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.templates;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftime.dawnoftime.block.templates.WaterloggedHorizontalBlock;
import org.jetbrains.annotations.NotNull;

public class SidedWindowBlock
extends WaterloggedHorizontalBlock {
    private static final BooleanProperty UP = BlockStateProperties.f_61366_;
    private static final BooleanProperty ATTACHED = BlockStateProperties.f_61386_;

    public SidedWindowBlock(BlockBehaviour.Properties properties, VoxelShape[] shapes) {
        super(properties, shapes);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ATTACHED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{UP, ATTACHED});
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        Level worldIn = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = super.m_5573_(context);
        if (state == null) {
            return this.m_49966_();
        }
        return (BlockState)((BlockState)state.m_61124_((Property)UP, (Comparable)Boolean.valueOf(this.canConnectVertical(state, worldIn, pos)))).m_61124_((Property)ATTACHED, (Comparable)Boolean.valueOf(this.canConnectHorizontal(state, worldIn, pos)));
    }

    public void m_6861_(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull Block blockIn, @NotNull BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, worldIn, pos, blockIn, fromPos, isMoving);
        boolean changeTOP = this.canConnectVertical(state, worldIn, pos);
        boolean changeSIDE = this.canConnectHorizontal(state, worldIn, pos);
        BlockState newState = state;
        if (changeTOP != (Boolean)state.m_61143_((Property)UP)) {
            newState = (BlockState)newState.m_61124_((Property)UP, (Comparable)Boolean.valueOf(changeTOP));
        }
        if (changeSIDE != (Boolean)state.m_61143_((Property)ATTACHED)) {
            newState = (BlockState)newState.m_61124_((Property)ATTACHED, (Comparable)Boolean.valueOf(changeSIDE));
        }
        if (changeTOP != (Boolean)state.m_61143_((Property)UP) || changeSIDE != (Boolean)state.m_61143_((Property)ATTACHED)) {
            worldIn.m_7731_(pos, newState, 10);
        }
    }

    private boolean canConnectVertical(BlockState state, Level worldIn, BlockPos pos) {
        if (this.isSameWindowAndSide(state, worldIn, pos.m_7495_())) {
            return !this.isSameWindowAndSide(state, worldIn, pos.m_7494_());
        }
        return false;
    }

    private boolean canConnectHorizontal(BlockState state, Level worldIn, BlockPos pos) {
        return this.isSameWindowAndSide(state, worldIn, pos.m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122428_()));
    }

    private boolean isSameWindowAndSide(BlockState state, Level worldIn, BlockPos pos) {
        BlockState otherState = worldIn.m_8055_(pos);
        if (otherState.m_60734_() != this) {
            return false;
        }
        return otherState.m_61143_((Property)FACING) == state.m_61143_((Property)FACING);
    }
}

