/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.templates;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftime.dawnoftime.block.templates.ChairBlock;
import org.jetbrains.annotations.NotNull;

public class DoubleChairBlock
extends ChairBlock {
    public static final EnumProperty<Half> HALF = BlockStateProperties.f_61402_;

    public DoubleChairBlock(BlockBehaviour.Properties properties, float offsetY, VoxelShape[] shapes) {
        super(properties, offsetY, shapes);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(HALF, (Comparable)Half.BOTTOM));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HALF});
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        if (!context.m_43725_().m_8055_(context.m_8083_().m_7494_()).m_60629_(context)) {
            return null;
        }
        return (BlockState)super.m_5573_(context).m_61124_((Property)ChairBlock.FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        worldIn.m_7731_(pos.m_7494_(), (BlockState)state.m_61124_(HALF, (Comparable)Half.TOP), 10);
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (state.m_61143_(HALF) == Half.TOP) {
            return InteractionResult.PASS;
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    @Override
    @NotNull
    public BlockState m_7417_(BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        Direction halfDirection;
        Direction direction = halfDirection = stateIn.m_61143_(HALF) == Half.TOP ? Direction.DOWN : Direction.UP;
        if (facing == halfDirection && (facingState.m_60734_() != this || facingState.m_61143_(HALF) == stateIn.m_61143_(HALF) || facingState.m_61143_((Property)ChairBlock.FACING) != stateIn.m_61143_((Property)ChairBlock.FACING))) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        if (state.m_61143_(HALF) != Half.TOP) {
            return true;
        }
        BlockState bottomState = worldIn.m_8055_(pos.m_7495_());
        if (bottomState.m_60734_() == this) {
            return bottomState.m_61143_(HALF) == Half.BOTTOM && bottomState.m_61143_((Property)ChairBlock.FACING) == state.m_61143_((Property)ChairBlock.FACING);
        }
        return false;
    }

    public void m_5707_(Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        BlockPos adjacentPos;
        BlockState adjacentState;
        if (!level.m_5776_() && player.m_7500_() && state.m_61143_(HALF) == Half.TOP && (adjacentState = level.m_8055_(adjacentPos = pos.m_7495_())).m_60713_((Block)this) && adjacentState.m_61143_(HALF) == Half.BOTTOM) {
            level.m_7731_(adjacentPos, Blocks.f_50016_.m_49966_(), 35);
            level.m_5898_(player, 2001, adjacentPos, Block.m_49956_((BlockState)state));
        }
        super.m_5707_(level, pos, state, player);
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        int index = state.m_61143_(HALF) == Half.TOP ? 1 : 0;
        return ((Direction)state.m_61143_((Property)FACING)).m_122416_() * 2 + index;
    }
}

