/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.templates;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftime.dawnoftime.block.templates.WaterloggedBlock;
import org.dawnoftime.dawnoftime.util.BlockStatePropertiesAA;
import org.dawnoftime.dawnoftime.util.Utils;
import org.jetbrains.annotations.NotNull;

public class ConnectedVerticalBlock
extends WaterloggedBlock {
    public static final EnumProperty<BlockStatePropertiesAA.VerticalConnection> VERTICAL_CONNECTION = BlockStatePropertiesAA.VERTICAL_CONNECTION;

    public ConnectedVerticalBlock(BlockBehaviour.Properties properties, VoxelShape[] shapes) {
        super(properties, shapes);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(VERTICAL_CONNECTION, (Comparable)((Object)BlockStatePropertiesAA.VerticalConnection.NONE)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{VERTICAL_CONNECTION});
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return ((BlockStatePropertiesAA.VerticalConnection)((Object)state.m_61143_(VERTICAL_CONNECTION))).getIndex();
    }

    @Override
    @NotNull
    public BlockState m_7417_(BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        stateIn = super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        return facing.m_122434_().m_122478_() ? (BlockState)stateIn.m_61124_(VERTICAL_CONNECTION, (Comparable)((Object)this.getColumnState(worldIn, currentPos, stateIn))) : stateIn;
    }

    public BlockStatePropertiesAA.VerticalConnection getColumnState(LevelAccessor worldIn, BlockPos pos, BlockState stateIn) {
        if (this.isConnectible(stateIn, worldIn, pos.m_7494_(), Direction.DOWN)) {
            return this.isConnectible(stateIn, worldIn, pos.m_7495_(), Direction.UP) ? BlockStatePropertiesAA.VerticalConnection.BOTH : BlockStatePropertiesAA.VerticalConnection.ABOVE;
        }
        return this.isConnectible(stateIn, worldIn, pos.m_7495_(), Direction.UP) ? BlockStatePropertiesAA.VerticalConnection.UNDER : BlockStatePropertiesAA.VerticalConnection.NONE;
    }

    public boolean isConnectible(BlockState stateIn, LevelAccessor worldIn, BlockPos pos, Direction faceToConnect) {
        return worldIn.m_8055_(pos).m_60734_() == this;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockPos topPos;
        ItemStack heldItemStack = player.m_21120_(handIn);
        if (player.m_6047_()) {
            if (state.m_61143_(VERTICAL_CONNECTION) == BlockStatePropertiesAA.VerticalConnection.NONE) {
                return super.m_6227_(state, worldIn, pos, player, handIn, hit);
            }
            BlockPos topPos2 = this.getHighestColumnPos(worldIn, pos);
            if (topPos2 != pos) {
                if (!worldIn.m_5776_()) {
                    worldIn.m_7731_(topPos2, Blocks.f_50016_.m_49966_(), 35);
                    if (!player.m_7500_()) {
                        Block.m_49881_((BlockState)state, (Level)worldIn, (BlockPos)pos, null, (Entity)player, (ItemStack)heldItemStack);
                    }
                }
                return InteractionResult.SUCCESS;
            }
        } else if (!heldItemStack.m_41619_() && heldItemStack.m_41720_() == this.m_5456_() && (topPos = this.getHighestColumnPos(worldIn, pos).m_7494_()).m_123342_() <= 255 && worldIn.m_8055_(topPos).m_60795_()) {
            if (!worldIn.m_5776_()) {
                worldIn.m_7731_(topPos, state, 11);
                if (!player.m_7500_()) {
                    heldItemStack.m_41774_(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    private BlockPos getHighestColumnPos(Level worldIn, BlockPos pos) {
        int yOffset = 0;
        while (yOffset + pos.m_123342_() <= 255 && worldIn.m_8055_(pos.m_6630_(yOffset)).m_60734_() == this) {
            ++yOffset;
        }
        return pos.m_6630_(yOffset - 1);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_5871_(stack, worldIn, tooltip, flagIn);
        Utils.addTooltip(tooltip, "column");
    }
}

