/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.templates;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftime.dawnoftime.DoTBCommon;
import org.dawnoftime.dawnoftime.block.IFlammable;
import org.dawnoftime.dawnoftime.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;

public class BlockDoT
extends Block
implements IFlammable {
    private int fireSpreadSpeed = 0;
    private int fireDestructionSpeed = 0;
    private final VoxelShape[] shapes;

    public BlockDoT(BlockBehaviour.Properties properties, VoxelShape[] shapes) {
        super(properties);
        this.shapes = shapes;
    }

    public BlockDoT(BlockBehaviour.Properties properties) {
        this(properties, VoxelShapes.FULL_SHAPE);
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        try {
            return this.getShape(this.getShapeIndex(state, level, pos, context));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            DoTBCommon.LOG.error("dawnoftimebuilder : Error in the VoxelShape of the block : {}", (Object)state.m_60734_().m_49954_().getString());
            throw e;
        }
    }

    @NotNull
    public VoxelShape getShape(int index) {
        return this.shapes[index];
    }

    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return 0;
    }

    public Block setBurnable() {
        return this.setBurnable(5, 20);
    }

    public Block setBurnable(int fireSpreadSpeed, int fireDestructionSpeed) {
        this.fireSpreadSpeed = fireSpreadSpeed;
        this.fireDestructionSpeed = fireDestructionSpeed;
        return this;
    }

    @Override
    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return state.m_61138_((Property)BlockStateProperties.f_61362_) && (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? 0 : this.fireSpreadSpeed;
    }

    @Override
    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return state.m_61138_((Property)BlockStateProperties.f_61362_) && (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? 0 : this.fireDestructionSpeed;
    }
}

