/*
 * Decompiled with CFR 0.152.
 */
package com.yesman.epicskills.world.capability;

import com.yesman.epicskills.network.NetworkManager;
import com.yesman.epicskills.network.client.ClientBoundSetAbilityPoints;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbilityPoints {
    public static final Capability<AbilityPoints> ABILITY_POINTS = CapabilityManager.get((CapabilityToken)new CapabilityToken<AbilityPoints>(){});
    public static final int INIT_EXP_REQUIREMENT = 7;
    private int abilityPoint = 0;
    private int requiredExp = 7;
    private int requiredExpLevel = 0;
    private boolean dirty = false;
    private final Player player;
    private static final ResourceLocation ABILITY_POINTS_CAPABILITY_KEY = ResourceLocation.fromNamespaceAndPath((String)"epicskills", (String)"ability_points");

    public static int getXpNeededForNextLevel(int expLevel) {
        if (expLevel >= 30) {
            return 112 + (expLevel - 30) * 9;
        }
        return expLevel >= 15 ? 37 + (expLevel - 15) * 5 : 7 + expLevel * 2;
    }

    public AbilityPoints(Player player) {
        this.player = player;
    }

    public boolean hasEnoughExp() {
        return this.player.f_36079_ >= this.requiredExp;
    }

    public boolean convertExpToAbilityPoints() {
        if (!this.hasEnoughExp()) {
            return false;
        }
        this.player.m_6756_(-this.requiredExp);
        ++this.abilityPoint;
        this.requiredExp = this.requiredExpLevel < 15 ? (this.requiredExp += 2) : (this.requiredExpLevel < 30 ? (this.requiredExp += 4) : (this.requiredExp += 6));
        while (this.requiredExp > AbilityPoints.getXpNeededForNextLevel(this.requiredExpLevel)) {
            ++this.requiredExpLevel;
        }
        return true;
    }

    public void setRequiredExp(int requiredExp) {
        this.requiredExp = Mth.m_14045_((int)requiredExp, (int)0, (int)Integer.MAX_VALUE);
        this.requiredExpLevel = 0;
        int requiredExpForNextLevel = AbilityPoints.getXpNeededForNextLevel(this.requiredExpLevel);
        for (int totalExp = this.requiredExp; totalExp >= requiredExpForNextLevel; totalExp -= requiredExpForNextLevel) {
            requiredExpForNextLevel = AbilityPoints.getXpNeededForNextLevel(++this.requiredExpLevel);
        }
    }

    public int getRequiredExp() {
        return this.requiredExp;
    }

    public void setAbilityPoints(int abilityPoint) {
        this.abilityPoint = Mth.m_14045_((int)abilityPoint, (int)0, (int)Integer.MAX_VALUE);
    }

    public int getAbilityPoints() {
        return this.abilityPoint;
    }

    public void markDirty() {
        this.dirty = true;
    }

    public void sendChanges() {
        if (this.player.m_9236_().m_5776_()) {
            return;
        }
        ServerPlayer serverplayer = (ServerPlayer)this.player;
        if (this.dirty) {
            NetworkManager.sendToPlayer(new ClientBoundSetAbilityPoints(false, this.abilityPoint, this.requiredExp), serverplayer);
            this.dirty = false;
        }
    }

    public void serializeTo(CompoundTag compound) {
        compound.m_128405_("abilityPoint", this.abilityPoint);
        compound.m_128405_("requiredExp", this.requiredExp);
        compound.m_128405_("requiredExpLevel", this.requiredExpLevel);
    }

    public void deserializeFrom(CompoundTag nbt) {
        if (nbt.m_128425_("abilityPoint", 3)) {
            this.abilityPoint = nbt.m_128451_("abilityPoint");
        }
        if (nbt.m_128425_("requiredExp", 3)) {
            this.requiredExp = nbt.m_128451_("requiredExp");
        }
        if (nbt.m_128425_("requiredExpLevel", 3)) {
            this.requiredExpLevel = nbt.m_128451_("requiredExpLevel");
        }
    }

    public static void epicskills$attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (((Entity)event.getObject()).m_6095_() == EntityType.f_20532_ && !event.getCapabilities().containsKey(ABILITY_POINTS_CAPABILITY_KEY)) {
            event.addCapability(ABILITY_POINTS_CAPABILITY_KEY, (ICapabilityProvider)new Provider(new AbilityPoints((Player)event.getObject())));
        }
    }

    public static class Provider
    implements ICapabilityProvider,
    ICapabilitySerializable<CompoundTag> {
        private final LazyOptional<AbilityPoints> lazyOptional = LazyOptional.of(() -> abilityPoints);
        private final AbilityPoints abilityPoints;

        public Provider(@NonNull AbilityPoints abilityPoints) {
            this.abilityPoints = abilityPoints;
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            return cap == ABILITY_POINTS ? this.lazyOptional.cast() : LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            CompoundTag compound = new CompoundTag();
            this.abilityPoints.serializeTo(compound);
            return compound;
        }

        public void deserializeNBT(CompoundTag compound) {
            this.abilityPoints.deserializeFrom(compound);
        }
    }
}

